MODULE mod_const_mpi

  INTEGER :: COMM_LMDZ
  INTEGER :: MPI_REAL_LMDZ
 

CONTAINS 

  SUBROUTINE Init_const_mpi
    USE IOIPSL

    IMPLICIT NONE
    INCLUDE 'mpif.h'
    INTEGER             :: ierr
    INTEGER             :: comp_id
    CHARACTER(len = 6)  :: ocean

!$OMP MASTER
    ocean = 'force '
    CALL getin('OCEAN', ocean)
!$OMP END

    IF (ocean=='couple') THEN
#ifdef CPP_COUPLE
       CALL prism_init_comp_proto (comp_id, 'lmdz.x', ierr)
       CALL prism_get_localcomm_proto(COMM_LMDZ,ierr)
#endif
    ELSE
       CALL MPI_INIT(ierr)
       COMM_LMDZ=MPI_COMM_WORLD
    END IF

    MPI_REAL_LMDZ=MPI_REAL8
  END SUBROUTINE Init_const_mpi

END MODULE mod_const_mpi
