module mod_phys_openmp

  integer,save :: omp_size
  integer,save :: omp_rank
  
  INTEGER,SAVE,dimension(:),allocatable :: klon_omp_nb
  INTEGER,SAVE,dimension(:),allocatable :: klon_omp_begin
  INTEGER,SAVE,dimension(:),allocatable :: klon_omp_end    
  INTEGER,SAVE :: klon_omp
!$OMP  THREADPRIVATE(omp_rank,klon_omp)

  REAL,save,allocatable,dimension(:) :: zmasq
!$OMP THREADPRIVATE(zmasq)   

contains
  
  subroutine init_phys_openmp
  USE mod_phys_mpi, only : klon_mpi,kfdia,kidia,kdlon
    implicit none
    integer :: i
#ifdef _OPENMP    
    integer :: OMP_GET_NUM_THREADS
    external OMP_GET_NUM_THREADS
    integer :: OMP_GET_THREAD_NUM
    external OMP_GET_THREAD_NUM
#endif  

#ifdef _OPENMP
!$OMP MASTER
        omp_size=OMP_GET_NUM_THREADS()
!$OMP END MASTER
        omp_rank=OMP_GET_THREAD_NUM()    
#else    
    omp_size=1
    omp_rank=0
#endif
!$OMP MASTER 
     print *,'MASTER :omp_rank',omp_rank
    allocate(klon_omp_nb(0:omp_size-1))
    allocate(klon_omp_begin(0:omp_size-1))
    allocate(klon_omp_end(0:omp_size-1))
    
    do i=0,omp_size-1
      klon_omp_nb(i)=klon_mpi/omp_size
      if (i<MOD(klon_mpi,omp_size)) klon_omp_nb(i)=klon_omp_nb(i)+1
    enddo
    
    klon_omp_begin(0)=1
    klon_omp_end(0)=klon_omp_nb(0)
    
    do i=1,omp_size-1
      klon_omp_begin(i)=klon_omp_end(i-1)+1
      klon_omp_end(i)=klon_omp_begin(i)+klon_omp_nb(i)-1
    enddo
!$OMP END MASTER
!$OMP BARRIER
   
    klon_omp=klon_omp_nb(omp_rank) 
    allocate(zmasq(klon_omp))  
 
    kidia=1
    kfdia=klon_omp
    kdlon=klon_omp
    print *,omp_rank,' : klon_omp_nb',klon_omp_nb
  end subroutine init_phys_openmp
  

  subroutine ScatterField_omp(Fields,Fieldr,ll)
  USE mod_phys_mpi, only : klon_mpi
  implicit none
    INTEGER :: ll
    REAL, dimension(klon_mpi,ll) :: Fields
    REAL, dimension(klon_omp,ll) :: Fieldr     
    REAL, dimension(:,:),ALLOCATABLE,SAVE :: Field_tmp     
    
    INTEGER :: i,l,offset
    
!$OMP BARRIER
!$OMP MASTER 
    ALLOCATE(Field_tmp(klon_mpi,ll))

    DO l=1,ll
      DO i=1,klon_mpi
        Field_tmp(i,l)=fields(i,l)
      ENDDO
    ENDDO
    
!$OMP END MASTER

!$OMP BARRIER    
    offset=klon_omp_begin(omp_rank)-1
    do l=1,ll
      do i=1,klon_omp
        Fieldr(i,l)=Field_tmp(offset+i,l)
      enddo
    enddo
!$OMP BARRIER

!$OMP MASTER 
    DEALLOCATE(Field_tmp)
!$OMP END MASTER

  end subroutine ScatterField_omp

  subroutine GatherField_omp(Fields,Fieldr,ll)
  USE mod_phys_mpi, only : klon_mpi
  implicit none
    INTEGER :: ll
    REAL, dimension(klon_omp,ll) :: Fields
    REAL, dimension(klon_mpi,ll) :: Fieldr     
    REAL, dimension(klon_omp,ll) :: Field_tmp
    
    INTEGER :: i,l,offset

    Field_tmp(:,:)=Fields(:,:)
!$OMP BARRIER      
    offset=klon_omp_begin(omp_rank)-1
    do l=1,ll
      do i=1,klon_omp
        Fieldr(offset+i,l)=Field_tmp(i,l)
      enddo
    enddo
!$OMP BARRIER  
  end subroutine GatherField_omp
    
end module mod_phys_openmp
