!
! $Header$
!
c
c
#ifdef INCA
            SUBROUTINE caladvtrac(q,pbaru,pbarv ,
     *                   p ,masse, dq ,  teta,
     *                   flxw,
     *                   pk)
#else
            SUBROUTINE caladvtrac(q,pbaru,pbarv ,
     *                   p ,masse, dq ,  teta,
     *                   pk)
#endif

c
      IMPLICIT NONE
c
c     Auteurs:   F.Hourdin , P.Le Van, F.Forget, F.Codron  
c
c     F.Codron (10/99) : ajout humidite specifique pour eau vapeur
c=======================================================================
c
c       Shema de  Van Leer
c
c=======================================================================


#include "dimensions.h"
#include "paramet.h"
#include "comconst.h"
#include "control.h"
#include "advtrac.h"

c   Arguments:
c   ----------
      REAL pbaru( ip1jmp1,llm ),pbarv( ip1jm,llm),masse(ip1jmp1,llm)
      REAL p( ip1jmp1,llmp1),q( ip1jmp1,llm,nqmx),dq( ip1jmp1,llm,2 )
      REAL teta( ip1jmp1,llm),pk( ip1jmp1,llm)
#ifdef INCA
      REAL               :: flxw(ip1jmp1,llm)
#endif

c  ..................................................................
c
c  .. dq n'est utilise et dimensionne que pour l'eau  vapeur et liqu.
c
c  ..................................................................
c
c   Local:
c   ------

      EXTERNAL  advtrac,minmaxq, qminimum
      INTEGER ij,l, iq, iapptrac
      REAL finmasse(ip1jmp1,llm), dtvrtrac

cc
c
C initialisation
        dq = 0.

        CALL SCOPY( 2 * ijp1llm, q, 1, dq, 1 )

c  test des valeurs minmax
cc        CALL minmaxq(q(1,1,1),1.e33,-1.e33,'Eau vapeur (a) ')
cc        CALL minmaxq(q(1,1,2),1.e33,-1.e33,'Eau liquide(a) ')

c   advection

#ifdef INCA
      CALL advtrac( pbaru,pbarv, 
     *             p,  masse,q,iapptrac, teta,
     .             flxw,
     .             pk)
#else
      CALL advtrac( pbaru,pbarv, 
     *             p,  masse,q,iapptrac, teta,
     .             pk)
#endif
c

         IF( iapptrac.EQ.iapp_tracvl ) THEN
c
cc          CALL minmaxq(q(1,1,1),1.e33,-1.e33,'Eau vapeur     ')
cc          CALL minmaxq(q(1,1,2),1.e33,-1.e33,'Eau liquide    ')

cc     ....  Calcul  de deltap  qu'on stocke dans finmasse   ...
c
          DO l = 1, llm
           DO ij = 1, ip1jmp1
             finmasse(ij,l) =  p(ij,l) - p(ij,l+1) 
           ENDDO
          ENDDO

          CALL qminimum( q, 2, finmasse )

          CALL SCOPY   ( ip1jmp1*llm, masse, 1, finmasse,       1 )
          CALL filtreg ( finmasse ,  jjp1,  llm, -2, 2, .TRUE., 1 )
c
c   *****  Calcul de dq pour l'eau , pour le passer a la physique ******
c   ********************************************************************
c
          dtvrtrac = iapp_tracvl * dtvr
c
           DO iq = 1 , 2
            DO l = 1 , llm
             DO ij = 1,ip1jmp1
             dq(ij,l,iq) = ( q(ij,l,iq) - dq(ij,l,iq) ) * finmasse(ij,l)
     *                               /  dtvrtrac
             ENDDO
            ENDDO
           ENDDO
c
         ELSE
           DO iq = 1 , 2
           DO l  = 1, llm
             DO ij = 1,ip1jmp1
              dq(ij,l,iq)  = 0.
             ENDDO
           ENDDO
           ENDDO


         ENDIF

c

c  ... On appelle  qminimum uniquement  pour l'eau vapeur et liquide  ..

 
      RETURN
      END


