!
! $Header$
!
c
c

      subroutine q_sat(np,temp,pres,qsat)
c
      IMPLICIT none
c======================================================================
c Autheur(s): Z.X. Li (LMD/CNRS)
c  reecriture vectorisee par F. Hourdin.
c Objet: calculer la vapeur d'eau saturante (formule Centre Euro.)
c======================================================================
c Arguments:
c kelvin---input-R: temperature en Kelvin
c millibar--input-R: pression en mb
c
c q_sat----output-R: vapeur d'eau saturante en kg/kg
c======================================================================
c
      integer np
      REAL temp(np),pres(np),qsat(np)
c
      REAL r2es
      PARAMETER (r2es=611.14 *18.0153/28.9644)
c
      REAL r3les, r3ies, r3es
      PARAMETER (R3LES=17.269)
      PARAMETER (R3IES=21.875)
c
      REAL r4les, r4ies, r4es
      PARAMETER (R4LES=35.86)
      PARAMETER (R4IES=7.66)
c
      REAL rtt
      PARAMETER (rtt=273.16)
c
      REAL retv
      PARAMETER (retv=28.9644/18.0153 - 1.0)

      real zqsat
      integer ip
c
C     ------------------------------------------------------------------
c
c

      do ip=1,np

c      write(*,*)'kelvin,millibar=',kelvin,millibar
c       write(*,*)'temp,pres=',temp(ip),pres(ip)
c
         IF (temp(ip) .LE. rtt) THEN
            r3es = r3ies
            r4es = r4ies
         ELSE
            r3es = r3les
            r4es = r4les
         ENDIF
c
         zqsat=r2es/pres(ip)*EXP(r3es*(temp(ip)-rtt)/(temp(ip)-r4es))
         zqsat=MIN(0.5,ZQSAT)
         zqsat=zqsat/(1.-retv *zqsat)
c
         qsat(ip)= zqsat
c      write(*,*)'qsat=',qsat(ip)

      enddo
c
      RETURN
      END
