      subroutine groupe_p(pext,pbaru,pbarv,pbarum,pbarvm,wm)
      USE parallel
      implicit none

c   sous-programme servant a fitlrer les champs de flux de masse aux
c   poles en "regroupant" les mailles 2 par 2 puis 4 par 4 etc. au fur
c   et a mesure qu'on se rapproche du pole.
c
c   en entree: pext, pbaru et pbarv
c
c   en sortie:  pbarum,pbarvm et wm.
c
c   remarque, le wm est recalcule a partir des pbaru pbarv et on n'a donc
c   pas besoin de w en entree.

#include "dimensions.h"
#include "paramet.h"
#include "comconst.h"
#include "comgeom2.h"
#include "comvert.h"

      integer ngroup
      parameter (ngroup=3)


      real pbaru(iip1,jjp1,llm),pbarv(iip1,jjm,llm)
      real pext(iip1,jjp1,llm)

      real pbarum(iip1,jjp1,llm),pbarvm(iip1,jjm,llm)
      real wm(iip1,jjp1,llm)

      real zconvm(iip1,jjp1,llm),zconvmm(iip1,jjp1,llm)

      real uu

      integer i,j,l

      logical firstcall
      save firstcall

      data firstcall/.true./
      integer ijb,ije,jjb,jje
      
      if (firstcall) then
         if(mod(iim,2**ngroup).ne.0) stop'probleme du nombre ede point'
         firstcall=.false.
      endif

c   Champs 1D

      call convflu_p(pbaru,pbarv,llm,zconvm)

c
c      call scopy(ijp1llm,zconvm,1,zconvmm,1)
c      call scopy(ijmllm,pbarv,1,pbarvm,1)
      
      jjb=jj_begin
      jje=jj_end
      zconvmm(:,jjb:jje,:)=zconvm(:,jjb:jje,:)
      call groupeun_p(jjp1,llm,jjb,jje,zconvmm)
      
      jjb=jj_begin-1
      jje=jj_end
      if (pole_nord) jjb=jj_begin
      if (pole_sud)  jje=jj_end-1
      pbarvm(:,jjb:jje,:)=pbarv(:,jjb:jje,:)
      call groupeun_p(jjm,llm,jjb,jje,pbarvm)

c   Champs 3D
   
      jjb=jj_begin
      jje=jj_end
      if (pole_nord) jjb=jj_begin+1
      if (pole_sud)  jje=jj_end-1
      
      do l=1,llm
         do j=jjb,jje
            uu=pbaru(iim,j,l)
            do i=1,iim
               uu=uu+pbarvm(i,j,l)-pbarvm(i,j-1,l)-zconvmm(i,j,l)
               pbarum(i,j,l)=uu
c     zconvm(i,j,l ) =  xflu(i-1,j,l)-xflu(i,j,l)+
c    *                      yflu(i,j,l)-yflu(i,j-1,l)
            enddo
            pbarum(iip1,j,l)=pbarum(1,j,l)
         enddo
      enddo

c    integration de la convergence de masse de haut  en bas ......
   
      jjb=jj_begin
      jje=jj_end
      
      do l=1,llm
         do j=jjb,jje
            do i=1,iip1
               zconvmm(i,j,l)=zconvmm(i,j,l)
            enddo
         enddo
      enddo
      
      do  l = llm-1,1,-1
          do j=jjb,jje
             do i=1,iip1
                zconvmm(i,j,l)=zconvmm(i,j,l)+zconvmm(i,j,l+1)
             enddo
          enddo
      enddo
      
      if (.not. pole_sud) then
        zconvmm(:,jj_end+1,:)=0
	wm(:,jj_end+1,:)=0
      endif
      CALL vitvert_p(zconvmm(1,1,1),wm(1,1,1))

      return
      end

