      SUBROUTINE divgrad2_p ( klevel, h, deltapres, lh, divgra )
c
c     P. Le Van
c
c   ***************************************************************
c
c     .....   calcul de  (div( grad ))   de (  pext * h ) .....
c   ****************************************************************
c   h ,klevel,lh et pext  sont des arguments  d'entree pour le s-prg
c         divgra     est  un argument  de sortie pour le s-prg
c
      USE parallel
      USE times
      IMPLICIT NONE
c
#include "dimensions.h"
#include "paramet.h"
#include "comgeom2.h"
#include "comdissipn.h"

c    .......    variables en arguments   .......
c
      INTEGER klevel
      REAL h( ip1jmp1,klevel ), deltapres( ip1jmp1,klevel )
      REAL divgra( ip1jmp1,klevel)
c
c    .......    variables  locales    ..........
c
      REAL     signe, nudivgrs, sqrtps( ip1jmp1,llm )
      INTEGER  l,ij,iter,lh
c    ...................................................................

      EXTERNAL  filtreg
      EXTERNAL  SCOPY,  laplacien_gam
      INTEGER ijb,ije
c
      signe    = (-1.)**lh
      nudivgrs = signe * cdivh

c      CALL SCOPY ( ip1jmp1 * klevel, h, 1, divgra, 1 )
      ijb=ij_begin
      ije=ij_end
      divgra(ijb:ije,1:klevel)=h(ijb:ije,1:klevel)

c
      call suspend_timer(timer_dissip)
      call exchange_Hallo(divgra,ip1jmp1,llm,1,1)
      call resume_timer(timer_dissip)
      CALL laplacien_p( klevel, divgra, divgra )
     
      DO l = 1, klevel
       DO ij = ijb, ije
        sqrtps( ij,l ) = SQRT( deltapres(ij,l) )
       ENDDO
      ENDDO
c
      DO l = 1, klevel
        DO ij = ijb, ije
         divgra(ij,l) = divgra(ij,l) * sqrtps(ij,l)
        ENDDO
      ENDDO
   
c    ........    Iteration de l'operateur  laplacien_gam    ........
c
      DO  iter = 1, lh - 2
       call suspend_timer(timer_dissip)
       call exchange_Hallo(divgra,ip1jmp1,llm,1,1)
       call resume_timer(timer_dissip)
       CALL laplacien_gam_p ( klevel,cuvscvgam2,cvuscugam2,unsair_gam2,
     *                     unsapolnga2, unsapolsga2,  divgra, divgra )
      ENDDO
c
c    ...............................................................
 
      DO l = 1, klevel
        DO ij = ijb, ije
          divgra(ij,l) = divgra(ij,l) * sqrtps(ij,l)
        ENDDO
      ENDDO
c
      call suspend_timer(timer_dissip)
      call exchange_Hallo(divgra,ip1jmp1,llm,1,1)
      call resume_timer(timer_dissip)
      CALL laplacien_p ( klevel, divgra, divgra )
c
      DO l  = 1,klevel
      DO ij = ijb,ije
      divgra(ij,l) =  nudivgrs * divgra(ij,l) / deltapres(ij,l)
      ENDDO
      ENDDO

      RETURN
      END
