!
! $Header$
!
c
c
#undef DEBUG_IO
c#define DEBUG_IO

      SUBROUTINE caldyn_p
     $ (itau,ucov,vcov,teta,ps,masse,pk,pkf,phis ,
     $  phi,conser,du,dv,dteta,dp,w,pbaru,pbarv,time )
      USE parallel
      USE Write_Field_p
      
      IMPLICIT NONE

c=======================================================================
c
c  Auteur :  P. Le Van
c
c   Objet:
c   ------
c
c   Calcul des tendances dynamiques.
c
c Modif 04/93 F.Forget
c=======================================================================

c-----------------------------------------------------------------------
c   0. Declarations:
c   ----------------

#include "dimensions.h"
#include "paramet.h"
#include "comconst.h"
#include "comvert.h"
#include "comgeom.h"

c   Arguments:
c   ----------

      LOGICAL conser

      INTEGER itau
      REAL vcov(ip1jm,llm),ucov(ip1jmp1,llm),teta(ip1jmp1,llm)
      REAL ps(ip1jmp1),phis(ip1jmp1)
      REAL pk(iip1,jjp1,llm),pkf(ip1jmp1,llm)
      REAL vcont(ip1jm,llm),ucont(ip1jmp1,llm)
      REAL phi(ip1jmp1,llm),masse(ip1jmp1,llm)
      REAL dv(ip1jm,llm),du(ip1jmp1,llm)
      REAL dteta(ip1jmp1,llm),dp(ip1jmp1)
      REAL pbaru(ip1jmp1,llm),pbarv(ip1jm,llm)
      REAL time

c   Local:
c   ------

      REAL ang(ip1jmp1,llm),p(ip1jmp1,llmp1)
      REAL massebx(ip1jmp1,llm),masseby(ip1jm,llm),psexbarxy(ip1jm)
      REAL vorpot(ip1jm,llm)
      REAL w(ip1jmp1,llm),ecin(ip1jmp1,llm),convm(ip1jmp1,llm)
      REAL bern(ip1jmp1,llm)
      REAL massebxy(ip1jm,llm)
    

      INTEGER   ij,l,ijb,ije,ierr

c-----------------------------------------------------------------------
c   Calcul des tendances dynamiques:
c   --------------------------------
      CALL covcont_p  ( llm    , ucov    , vcov , ucont, vcont        )
      CALL pression_p ( ip1jmp1, ap      , bp   ,  ps  , p            )
cym      CALL psextbar (   ps   , psexbarxy                          )
      CALL massdair_p (    p   , masse                                )
      CALL massbar_p  (   masse, massebx , masseby                    )
      call massbarxy_p(   masse, massebxy                             )
      CALL flumass_p  ( massebx, masseby , vcont, ucont ,pbaru, pbarv )
      CALL dteta1_p   (   teta , pbaru   , pbarv, dteta               )
      CALL convmas_p  (   pbaru, pbarv   , convm                      )

#ifdef DEBUG_IO
      call WriteField_p('ucont',reshape(ucont,(/iip1,jmp1,llm/)))
      call WriteField_p('vcont',reshape(vcont,(/iip1,jjm,llm/)))
      call WriteField_p('p',reshape(p,(/iip1,jmp1,llmp1/)))
      call WriteField_p('masse',reshape(masse,(/iip1,jmp1,llm/)))
      call WriteField_p('massebx',reshape(massebx,(/iip1,jmp1,llm/)))
      call WriteField_p('masseby',reshape(masseby,(/iip1,jjm,llm/)))
      call WriteField_p('massebxy',reshape(massebxy,(/iip1,jjm,llm/)))
      call WriteField_p('pbaru',reshape(pbaru,(/iip1,jmp1,llm/)))
      call WriteField_p('pbarv',reshape(pbarv,(/iip1,jjm,llm/)))
      call WriteField_p('dteta',reshape(dteta,(/iip1,jmp1,llm/)))
      call WriteField_p('convm',reshape(convm,(/iip1,jmp1,llm/)))
#endif      

      ijb=ij_begin
      ije=ij_end
            
      DO ij =ijb, ije
         dp( ij ) = convm( ij,1 ) / airesurg( ij )
      ENDDO

      CALL vitvert_p ( convm  , w                                  )
      CALL tourpot_p ( vcov   , ucov  , massebxy  , vorpot         )
      CALL dudv1_p   ( vorpot , pbaru , pbarv     , du     , dv    )

#ifdef DEBUG_IO      
      call WriteField_p('w',reshape(w,(/iip1,jmp1,llm/)))
      call WriteField_p('vorpot',reshape(vorpot,(/iip1,jjm,llm/)))
      call WriteField_p('du',reshape(du,(/iip1,jmp1,llm/)))
      call WriteField_p('dv',reshape(dv,(/iip1,jjm,llm/)))
#endif      
      CALL enercin_p ( vcov   , ucov  , vcont     , ucont  , ecin  )
      CALL bernoui_p ( ip1jmp1, llm   , phi       , ecin   , bern  )
      CALL dudv2_p   ( teta   , pkf   , bern      , du     , dv    )

#ifdef DEBUG_IO
      call WriteField_p('ecin',reshape(ecin,(/iip1,jmp1,llm/)))
      call WriteField_p('bern',reshape(bern,(/iip1,jmp1,llm/)))
      call WriteField_p('du',reshape(du,(/iip1,jmp1,llm/)))
      call WriteField_p('dv',reshape(dv,(/iip1,jjm,llm/)))
#endif
      
      ijb=ij_begin-iip1
      ije=ij_end+iip1
      
      if (pole_nord) ijb=ij_begin
      if (pole_sud) ije=ij_end
      
      DO l=1,llm
         DO ij=ijb,ije
            ang(ij,l) = ucov(ij,l) + constang(ij)
        ENDDO
      ENDDO


      CALL advect_p( ang, vcov, teta, w, massebx, masseby,du,dv,dteta) 

C  WARNING probleme de peridocite de dv sur les PC/linux. Pb d'arrondi 
C          probablement. Observe sur le code compile avec pgf90 3.0-1 
      ijb=ij_begin
      ije=ij_end
      if (pole_sud) ije=ij_end-iip1

      DO l = 1, llm
         DO ij = ijb, ije, iip1
           IF( dv(ij,l).NE.dv(ij+iim,l) )  THEN
c         PRINT *,'!!!ATTENTION!!! probleme de periodicite sur vcov',  
c    ,   ' dans caldyn'
c         PRINT *,' l,  ij = ', l, ij, ij+iim,dv(ij+iim,l),dv(ij,l)
          dv(ij+iim,l) = dv(ij,l)
          endif
         enddo
      enddo
c-----------------------------------------------------------------------
c   Sorties eventuelles des variables de controle:
c   ----------------------------------------------

      IF( conser )  THEN
c ym ---> exige communication collective ( aussi dans advect)
        CALL sortvarc
     $ ( itau,ucov,teta,ps,masse,pk,phis,vorpot,phi,bern,dp,time,vcov )

      ENDIF

      RETURN
      END
