#!/bin/bash
for x in $* ; do
    # indent source file using emacs in batch mode
    # following standard settings of emacs f90-mode
    emacs -batch $x --eval '(f90-mode)' --eval '(indent-region (point-min) (point-max) nil)' --eval '(delete-trailing-whitespace)' -f save-buffer 2>/dev/null
    # remove blank lines at end of file
    sed -i '' -e :a -e '/^\n*$/{$d;N;};/\n$/ba' $x 
done
