MODULE icosa_phyparam_mod
  IMPLICIT NONE
  SAVE

  CONTAINS

    SUBROUTINE init_physics
      ! DYNAMICO
      USE mpipara,   ONLY : is_mpi_master
      USE icosa,     ONLY : llm, g, radius, cpp, kappa 
      USE time_mod,  ONLY : dt, itau_physics
      USE getin_mod, ONLY : getin
      USE physics_interface_mod
      ! phyparam
      USE comgeomfi
      USE iniphyparam_mod
      INTEGER, PARAMETER :: dayref=0
      INTEGER :: ngrid
      REAL    :: unjours ! solar day in seconds

      IF(is_mpi_master) WRITE(*,*) 'phyparam/init_physics called'
      
      ngrid = physics_inout%ngrid
      unjours = 86400.
      CALL getin('unjours', unjours)

      CALL init_comgeomfi(ngrid, llm, &
           &              physics_inout%lon, physics_inout%lat)
      CALL iniphyparam(ngrid, llm,                &
           &           unjours, dayref, dt*itau_physics, & 
           &           radius, g, cpp*kappa, cpp)

    END SUBROUTINE init_physics

    SUBROUTINE physics
      USE mpipara, ONLY : is_mpi_master
      IF(is_mpi_master) PRINT *, 'phyparam/physics called'
    END SUBROUTINE physics

END MODULE icosa_phyparam_mod
