MODULE comgeomfi
  IMPLICIT NONE
  SAVE

  REAL, ALLOCATABLE :: long(:), lati(:), sinlon(:), coslon(:), sinlat(:), coslat(:)
  INTEGER :: ngridmax, nlayermx, nsoilmx
  !$OMP THREADPRIVATE(long,lati,sinlon,coslon,sinlat,coslat,totarea)
  !$OMP THREADPRIVATE(ngridmax,nlayermx,nsoilmx)

CONTAINS

  SUBROUTINE init_comgeomfi(klon, klev, longitude, latitude)
    INTEGER, INTENT(IN) :: klon, klev
    REAL, INTENT(IN) :: longitude(klon), latitude(klon) ! in radians
    ngridmax=klon
    nlayermx=klev
    nsoilmx=10
    allocate(long(klon))
    allocate(lati(klon))
    allocate(sinlon(klon))
    allocate(coslon(klon))
    allocate(sinlat(klon))
    allocate(coslat(klon))
    long(:) = longitude(:)
    lati(:) = latitude(:)
    sinlat(:)=sin(lati(:))
    coslat(:)=cos(lati(:))
    sinlon(:)=sin(long(:))
    coslon(:)=cos(long(:))
  END SUBROUTINE init_comgeomfi

END MODULE comgeomfi
