MODULE read_param_mod
  USE logging, ONLY : missing_plugin
  IMPLICIT NONE
  PRIVATE
  SAVE

  INTERFACE

     ! each of these plugins reads a parameter of a certain type and stores the value in 'val'
     ! a typical implementation reads from a configuration file containing 'name = value' statements
     ! if 'name' is not present in the config file, defval is used as default value
     ! 'comment' can be used for logging purposes

     SUBROUTINE plugin_read_paramr(name, defval, val, comment)
       CHARACTER(*), INTENT(IN) :: name, comment
       REAL, INTENT(IN)         :: defval
       REAL, INTENT(OUT)        :: val
     END SUBROUTINE plugin_read_paramr

     SUBROUTINE plugin_read_parami(name, defval, val, comment)
       CHARACTER(*), INTENT(IN) :: name, comment
       INTEGER, INTENT(IN)      :: defval
       INTEGER, INTENT(OUT)     :: val
     END SUBROUTINE plugin_read_parami

     SUBROUTINE plugin_read_paramb(name, defval, val, comment)
       CHARACTER(*), INTENT(IN) :: name, comment
       LOGICAL, INTENT(IN)      :: defval
       LOGICAL, INTENT(OUT)     :: val
     END SUBROUTINE plugin_read_paramb

  END INTERFACE

#ifndef XCODEML
  ! Note compiler compatibility : see logging.F90

  PROCEDURE(plugin_read_paramr), POINTER, PUBLIC :: read_paramr_plugin => NULL()
  PROCEDURE(plugin_read_parami), POINTER, PUBLIC :: read_parami_plugin => NULL()
  PROCEDURE(plugin_read_paramb), POINTER, PUBLIC :: read_paramb_plugin => NULL()

#endif

  INTERFACE read_param
     PROCEDURE read_paramr, read_parami, read_paramb
  END INTERFACE

  PUBLIC :: read_param

CONTAINS

  SUBROUTINE read_paramr(name, defval, val, comment)
    CHARACTER(*), INTENT(IN) :: name, comment
    REAL, INTENT(IN)         :: defval
    REAL, INTENT(OUT)        :: val
#ifndef XCODEML
    IF(.NOT.ASSOCIATED(read_paramr_plugin)) CALL missing_plugin('read_paramr','read_param_mod')
    CALL read_paramr_plugin(name, defval, val, comment)
#endif
  END SUBROUTINE read_paramr

  SUBROUTINE read_parami(name, defval, val, comment)
    CHARACTER(*), INTENT(IN) :: name, comment
    INTEGER, INTENT(IN)      :: defval
    INTEGER, INTENT(OUT)     :: val
#ifndef XCODEML
    IF(.NOT.ASSOCIATED(read_parami_plugin)) CALL missing_plugin('read_parami','read_param_mod')
    CALL read_parami_plugin(name, defval, val, comment)
#endif
  END SUBROUTINE read_parami

  SUBROUTINE read_paramb(name, defval, val, comment)
    CHARACTER(*), INTENT(IN) :: name, comment
    LOGICAL, INTENT(IN)      :: defval
    LOGICAL, INTENT(OUT)     :: val
#ifndef XCODEML
    IF(.NOT.ASSOCIATED(read_paramr_plugin)) CALL missing_plugin('read_paramb','read_param_mod')
    CALL read_paramb_plugin(name, defval, val, comment)
#endif
  END SUBROUTINE read_paramb

END MODULE read_param_mod
