MODULE writefield_mod
  IMPLICIT NONE
  PRIVATE
  SAVE

  INTERFACE
     SUBROUTINE plugin_writefield1(name,longname,unit, var)
       CHARACTER(*), INTENT(IN) :: name, longname, unit
       REAL, INTENT(IN)         :: var(:)
     END SUBROUTINE plugin_writefield1
     SUBROUTINE plugin_writefield2(name,longname,unit, var)
       CHARACTER(*), INTENT(IN) :: name, longname, unit
       REAL, INTENT(IN)         :: var(:,:)
     END SUBROUTINE plugin_writefield2
  END INTERFACE

  PROCEDURE(plugin_writefield1), POINTER :: writefield1_plugin => writefield1_unset
  PROCEDURE(plugin_writefield2), POINTER :: writefield2_plugin => writefield2_unset

  INTERFACE writefield
     PROCEDURE writefield1_plugin, writefield2_plugin
  END INTERFACE writefield

  PUBLIC :: writefield, writefield1_plugin, writefield2_plugin

CONTAINS

  SUBROUTINE writefield2_unset(name, longname, unit, var)
    CHARACTER(*), INTENT(IN) :: name, longname, unit
    REAL, INTENT(IN)         :: var(:,:)
    PRINT *, 'FATAL : plugin writefield2 not provided by the driver program'
    PRINT *, '        see writefield.F90'
    STOP
  END SUBROUTINE writefield2_unset

  SUBROUTINE writefield1_unset(name, longname, unit, var)
    CHARACTER(*), INTENT(IN) :: name, longname, unit
    REAL, INTENT(IN)         :: var(:)
    PRINT *, 'FATAL : plugin writefield1 not provided by the driver program'
    PRINT *, '        see writefield.F90'
    STOP
  END SUBROUTINE writefield1_unset
  
END MODULE writefield_mod
