MODULE read_param_mod
  IMPLICIT NONE
  PRIVATE
  SAVE

  INTERFACE 

     ! each of these plugins reads a parameter of a certain type and stores the value in 'val'
     ! a typical implementation reads from a configuration file containing 'name = value' statements
     ! if 'name' is not present in the config file, defval is used as default value
     ! 'comment' can be used for logging purposes

     SUBROUTINE plugin_read_paramr(name, defval, val, comment)
       CHARACTER(*), INTENT(IN) :: name, comment
       REAL, INTENT(IN)         :: defval
       REAL, INTENT(OUT)        :: val
     END SUBROUTINE plugin_read_paramr

     SUBROUTINE plugin_read_parami(name, defval, val, comment)
       CHARACTER(*), INTENT(IN) :: name, comment
       INTEGER, INTENT(IN)      :: defval
       INTEGER, INTENT(OUT)     :: val
     END SUBROUTINE plugin_read_parami

     SUBROUTINE plugin_read_paramb(name, defval, val, comment)
       CHARACTER(*), INTENT(IN) :: name, comment
       LOGICAL, INTENT(IN)      :: defval
       LOGICAL, INTENT(OUT)     :: val
     END SUBROUTINE plugin_read_paramb

  END INTERFACE

  PROCEDURE(plugin_read_paramr), POINTER :: read_paramr_plugin => read_paramr_unset
  PROCEDURE(plugin_read_parami), POINTER :: read_parami_plugin => read_parami_unset
  PROCEDURE(plugin_read_paramb), POINTER :: read_paramb_plugin => read_paramb_unset

  INTERFACE read_param
     PROCEDURE read_paramr_plugin, read_parami_plugin, read_paramb_plugin
  END INTERFACE read_param

  PUBLIC :: read_param, read_paramr_plugin, read_parami_plugin, read_paramb_plugin

CONTAINS

  SUBROUTINE abort_unset(name)
    CHARACTER(*), INTENT(IN) :: name
    PRINT *, 'FATAL : plugin ', name, ' not provided by the driver program'
    PRINT *, '        see read_param_mod'
    STOP
  END SUBROUTINE abort_unset

  SUBROUTINE read_paramr_unset(name, defval, val, comment)
    CHARACTER(*), INTENT(IN) :: name, comment
    REAL, INTENT(IN)         :: defval
    REAL, INTENT(OUT)        :: val
    CALL abort_unset('read_paramr')
  END SUBROUTINE read_paramr_unset

  SUBROUTINE read_parami_unset(name, defval, val, comment)
    CHARACTER(*), INTENT(IN) :: name, comment
    INTEGER, INTENT(IN)      :: defval
    INTEGER, INTENT(OUT)     :: val
    CALL abort_unset('read_parami')
  END SUBROUTINE read_parami_unset
  
  SUBROUTINE read_paramb_unset(name, defval, val, comment)
    CHARACTER(*), INTENT(IN) :: name, comment
    LOGICAL, INTENT(IN)      :: defval
    LOGICAL, INTENT(OUT)     :: val
    CALL abort_unset('read_paramb')
  END SUBROUTINE read_paramb_unset
  
END MODULE read_param_mod
