      SUBROUTINE iniphyparam(ngrid,nlayer,
     $           punjours,
     $           pdayref,ptimestep,
     $           prad,pg,pr,pcpp)
      use IOIPSL
      use getparam
      use dimphy
      USE mod_grid_phy_lmdz
      USE mod_phys_lmdz_para
      USE callkeys
      use comgeomfi
      USE geometry_mod, ONLY : longitude,latitude,cell_area
      USE phys_const, ONLY : planet_rad,g,r,cpp,rcp,dtphys,unjours,mugaz
      USE planet, ONLY : coefir, coefvis
      USE astronomy
      USE turbulence, ONLY : lmixmin, emin_turb 
      USE surface
      IMPLICIT NONE

c
c=======================================================================
c
c   subject:
c   --------
c
c   Initialisation for the physical parametrisations of the LMD 
c   martian atmospheric general circulation modele.
c
c   author: Frederic Hourdin 15 / 10 /93
c   -------
c
c   arguments:
c   ----------
c
c   input:
c   ------
c
c    ngrid                 Size of the horizontal grid.
c                          All internal loops are performed on that grid.
c    nlayer                Number of vertical layers.
c    pdayref               Day of reference for the simulation
c    firstcall             True at the first call
c    lastcall              True at the last call
c    pday                  Number of days counted from the North. Spring
c                          equinoxe.
c
c=======================================================================
c
c-----------------------------------------------------------------------
c   declarations:
c   -------------

 
#include "iniprint.h"


      REAL prad,pg,pr,pcpp,punjours
 
      INTEGER ngrid,nlayer
      REAL pdayref
 
      REAL ptimestep
 
      EXTERNAL inifrict
 
      print*,'INIPHYPARAM'

      CALL init_comgeomfi(klon_omp, klev, longitude, latitude)

      IF (klon.NE.klon_omp) THEN
         PRINT*,'STOP in iniphyparam'
         PRINT*,'Probleme de dimensions :'
         PRINT*,'klon     = ',klon
         PRINT*,'klon_omp   = ',klon_omp
         STOP
      ENDIF

      IF (nlayer.NE.nlayermx) THEN
         PRINT*,'STOP in iniphyparam'
         PRINT*,'Probleme de dimensions :'
         PRINT*,'nlayer     = ',nlayer
         PRINT*,'nlayermx   = ',nlayermx
         STOP
      ENDIF

      IF (ngrid.NE.klon_glo) THEN
         PRINT*,'STOP in iniphyparam'
         PRINT*,'Probleme de dimensions :'
         PRINT*,'ngrid     = ',ngrid
         PRINT*,'ngridmax   = ',klon_glo
        STOP
      ENDIF

      print*,'Avant les getpar '
      CALL getpar('unjours',86400.  ,unjours,'unjours')
      CALL getpar('planet_rad',6.4e6,planet_rad,'planet_rad')
      CALL getpar('g',9.8           ,g,'g')
      CALL getpar('cpp',1004.       ,cpp,'cpp')
      CALL getpar('mugaz',28.       ,mugaz,'mugaz')
      CALL getpar('year_day',360.   ,year_day,'year_day')
      CALL getpar('periheli',150.   ,periheli,'periheli')
      CALL getpar('aphelie',150.    ,aphelie,'aphelie')
      CALL getpar('peri_day',0.     ,peri_day,'peri_day')
      CALL getpar('obliquit',23.    ,obliquit,'obliquit')
      CALL getpar('Cd_mer',.01      ,Cd_mer,'Cd_mer')
      CALL getpar('Cd_ter',.01      ,Cd_ter,'Cd_ter')
      CALL getpar('I_mer',30000.    ,I_mer,'I_mer')
      CALL getpar('I_ter',30000.    ,I_ter,'I_ter')
      CALL getpar('alb_ter',.112    ,alb_ter,'alb_ter')
      CALL getpar('alb_mer',.112    ,alb_mer,'alb_mer')
      CALL getpar('emi_mer',1.      ,emi_mer,'emi_mer')
      CALL getpar('emi_mer',1.      ,emi_mer,'emi_mer')
      CALL getpar('emin_turb',1.e-16 ,emin_turb,'emin_turb')
      CALL getpar('lmixmin',100.    ,lmixmin,'lmixmin')
      CALL getpar('coefvis',.99     ,coefvis,'coefvis')
      CALL getpar('coefir',.08      ,coefir,'coefir')


      CALL getpar('callrad',.true.,callrad,'appel rayonnemen')
      CALL getpar('calldifv',.true.,calldifv,'appel difv')
      CALL getpar('calladj',.true.,calladj,'appel adj')
      CALL getpar('callcond',.true.,callcond,'appel cond')
      CALL getpar('callsoil',.true.,callsoil,'appel soil')
      CALL getpar('season',.true.,season,'appel soil')
      CALL getpar('diurnal',.false.,diurnal,'appel soil')
      CALL getpar('lverbose',.true.,lverbose,'appel soil')
      CALL getpar('period_sort',1.,period_sort,'period sorties en jour')

      write(lunout,*) 'unjours=',unjours
      write(lunout,*) 'planet_rad=',planet_rad
      write(lunout,*) 'g=',g
      write(lunout,*) 'cpp=',cpp
      write(lunout,*) 'mugaz=',mugaz
      write(lunout,*) 'year_day=',year_day
      write(lunout,*) 'periheli=',periheli
      write(lunout,*) 'aphelie=',aphelie
      write(lunout,*) 'peri_day=',peri_day
      write(lunout,*) 'obliquit=',obliquit
      write(lunout,*) 'Cd_mer=',Cd_mer
      write(lunout,*) 'Cd_ter=',Cd_ter
      write(lunout,*) 'I_mer=',I_mer
      write(lunout,*) 'I_ter=',I_ter
      write(lunout,*) 'alb_ter=',alb_ter
      write(lunout,*) 'alb_mer=',alb_mer
      write(lunout,*) 'emi_mer=',emi_mer
      write(lunout,*) 'emi_mer=',emi_mer
      write(lunout,*) 'emin_turb=',emin_turb
      write(lunout,*) 'lmixmin=',lmixmin
      write(lunout,*) 'coefvis=',coefvis
      write(lunout,*) 'coefir=',coefir
      write(lunout,*) 'callrad=',callrad
      write(lunout,*) 'calldifv=',calldifv
      write(lunout,*) 'calladj=',calladj
      write(lunout,*) 'callcond=',callcond
      write(lunout,*) 'callsoil=',callsoil
      write(lunout,*) 'season=',season
      write(lunout,*) 'diurnal=',diurnal
      write(lunout,*) 'lverbose=',lverbose
      write(lunout,*) 'period_sort=',period_sort

      print*,'Activation de la physique:'
      print*,' Rayonnement ',callrad
      print*,' Diffusion verticale turbulente ', calldifv
      print*,' Ajustement convectif ',calladj
      print*,' Sol ',callsoil
      print*,' Cycle diurne ',diurnal

c   choice of the frequency of the computation of radiations
      IF(diurnal) THEN
         iradia=NINT(punjours/(20.*ptimestep))
      ELSE
         iradia=NINT(punjours/(4.*ptimestep))
      ENDIF
      iradia=1
      PRINT*,'unjours',punjours
      PRINT*,'The radiative transfer is computed each ',
     s   iradia,' physical time-step or each ',
     s   iradia*ptimestep,' seconds'
c-----------------------------------------------------------------------

      print*,'latitude0  ohe',latitude(1:3),latitude(klon_omp)
      print*,'OK17 AAA'

      prad=planet_rad
      pg=g
      r=8.134/(mugaz*0.001)
      print*,'R=',r
      pr=r
      pcpp=cpp
      rcp=r/cpp
      dtphys=ptimestep
      punjours=unjours

      RETURN
9999  STOP'Cette version demande les fichier rnatur.dat et surf.def'
      END
