!
! $Id: iniphysiq.F 1403 2010-07-01 09:02:53Z fairhead $                 
!
!                                                                       
!

SUBROUTINE iniphysiq_param(ngrid,nlayer,  &
     &           punjours,                &
     &           pdayref,ptimestep,       &
     &           prad,pg,pr,pcpp)
  USE dimphy,             ONLY : klev
  USE mod_phys_lmdz_para, ONLY : klon_omp
  
  INTEGER, INTENT(IN) :: &                                                                       
       ngrid,   & ! Size of the horizontal grid.                 
       nlayer,  & ! Number of vertical layers.                   
       pdayref    ! Day of reference for the simulation
  REAL, INTENT(IN) :: ptimestep, prad, pg, pr, pcpp, punjours
  
  CHARACTER(LEN=20), PARAMETER :: modname='iniphysiq' 
  CHARACTER(LEN=80) :: abort_message 
  
  print*,'INInnn ENTREE DANS INIPHYSIQ' 
  IF (nlayer.NE.klev) THEN 
     PRINT*,'STOP in inifis' 
     PRINT*,'Probleme de dimensions :' 
     PRINT*,'nlayer     = ',nlayer 
     PRINT*,'klev   = ',klev 
     abort_message = '' 
     CALL abort_gcm (modname,abort_message,1) 
  ENDIF
  
  IF (ngrid.NE.klon_omp) THEN 
     PRINT*,'STOP in inifis' 
     PRINT*,'Probleme de dimensions :' 
     PRINT*,'ngrid     = ',ngrid 
     PRINT*,'klon   = ',klon_omp 
     abort_message = '' 
     CALL abort_gcm (modname,abort_message,1) 
  ENDIF
  
  !$OMP PARALLEL    
  print*,'Dans iniphysiq ' 
  
  CALL iniphyparam(ngrid,nlayer,        &
       &           punjours,            &
       &           pdayref,ptimestep,   &
       &           prad,pg,pr,pcpp)                                       
  
  
  print*,'OK iniphyparam '    
  !$OMP END PARALLEL                                                      
  
  print*,'ATTENTION !!! TRAVAILLER SUR INIPHYSIQ' 
  print*,'CONTROLE DES LATITUDES, LONGITUDES, PARAMETRES ...' 
  
END SUBROUTINE iniphysiq_param
