MODULE logging

  ! see also use_logging.h
  ! macro LOGBUF accumulates log output into logging_buffer

  IMPLICIT NONE
  SAVE
  PRIVATE

  INTERFACE  ! Explicit interfaces for plugins

     ! Plugin that typically prints all lines in the loggin buffer 'buf' and prepends tags (log level, timestamp, ...)
     SUBROUTINE plugin(lev, tag, buf)
       INTEGER, INTENT(IN) :: lev
       CHARACTER(*), INTENT(IN) :: tag, buf(:)
     END SUBROUTINE plugin

     ! Plugin that writes into string 'line' information about the gridpoint of index 'index' 
     SUBROUTINE plugin_log_gridpoint(index, line)
       INTEGER, INTENT(IN) :: index ! index of gridpoint
       CHARACTER(*), INTENT(OUT) :: line
     END SUBROUTINE plugin_log_gridpoint

  END INTERFACE

  ! This module provides a default implementation of flush_plugin but the top-level driver is welcome to override it.  
  PROCEDURE(plugin), POINTER :: flush_plugin => default_flush

  ! The top-level driver MUST provide an implementation for log_gridpoint_plugin
  PROCEDURE(plugin_log_gridpoint), POINTER :: log_gridpoint_plugin => NULL()

  INTEGER, PARAMETER :: bufsize=10000
  CHARACTER(bufsize) :: logging_buf(100)

  INTEGER :: logging_lineno=0

  INTEGER, PARAMETER, PUBLIC :: log_level_fatal=0, log_level_error=1, log_level_warn=2, log_level_info=3, log_level_dbg=4

  PUBLIC :: logging_buf, logging_lineno, flush_log, log_gridpoint, &
       flush_plugin, log_gridpoint_plugin

CONTAINS

  SUBROUTINE flush_log(lev,tag)
    INTEGER, INTENT(IN) :: lev
    CHARACTER(*), INTENT(IN) :: tag
    CALL flush_plugin(lev, TRIM(tag), logging_buf(1:logging_lineno))
    logging_lineno=0
  END SUBROUTINE flush_log

  SUBROUTINE default_flush(lev, tag, buf)
    INTEGER, INTENT(IN) :: lev
    CHARACTER(*), INTENT(IN) :: tag, buf(:)
    INTEGER :: i
    DO i=1, SIZE(buf)
       PRINT *, '[INFO ',tag,']', TRIM(buf(i))
    END DO
  END SUBROUTINE default_flush

  SUBROUTINE log_gridpoint(index)
    INTEGER, INTENT(IN) :: index
    logging_lineno = logging_lineno+1
    CALL log_gridpoint_plugin(index, logging_buf(logging_lineno))
  END SUBROUTINE log_gridpoint

END MODULE logging
