MODULE solar
  IMPLICIT NONE

CONTAINS

  subroutine solang ( kgrid,psilon,pcolon,psilat,pcolat, &
       ptim1,ptim2,ptim3,pmu0,pfract )

!
!**** *LW*   - ORGANIZES THE LONGWAVE CALCULATIONS
!
!     PURPOSE.
!     --------
!          CALCULATES THE SOLAR ANGLE FOR ALL THE POINTS OF THE GRID
!
!**   INTERFACE.
!     ----------
!      SUBROUTINE SOLANG ( KGRID )
!
!        EXPLICIT ARGUMENTS :
!        --------------------
!     ==== INPUTS  ===
!
! PSILON(KGRID)   : SINUS OF THE LONGITUDE
! PCOLON(KGRID)   : COSINUS OF THE LONGITUDE
! PSILAT(KGRID)   : SINUS OF THE LATITUDE
! PCOLAT(KGRID)   : COSINUS OF THE LATITUDE
! PTIM1           : SIN(DECLI)
! PTIM2           : COS(DECLI)*COS(TIME)
! PTIM3           : SIN(DECLI)*SIN(TIME)
!
!     ==== OUTPUTS ===
!
! PMU0 (KGRID)    : SOLAR ANGLE
! PFRACT(KGRID)   : DAY FRACTION OF THE TIME INTERVAL
!
!        IMPLICIT ARGUMENTS :   NONE
!        --------------------
!
!     METHOD.
!     -------
!
!     EXTERNALS.
!     ----------
!
!         NONE
!
!     REFERENCE.
!     ----------
!
!         RADIATIVE PROCESSES IN METEOROLOGIE AND CLIMATOLOGIE
!         PALTRIDGE AND PLATT
!
!     AUTHOR.
!     -------
!        FREDERIC HOURDIN
!
!     MODIFICATIONS.
!     --------------
!        ORIGINAL :90-01-14
!                  92-02-14 CALCULATIONS DONE THE ENTIER GRID (J.Polcher)
!-----------------------------------------------------------------------
!
!     ------------------------------------------------------------------
!-----------------------------------------------------------------------
!
!*      0.1   ARGUMENTS
!             ---------
!
      INTEGER kgrid
      REAL ptim1,ptim2,ptim3
      REAL psilon(kgrid),pcolon(kgrid),pmu0(kgrid),pfract(kgrid)
      REAL psilat(kgrid), pcolat(kgrid)

      INTEGER jl
      REAL ztim1,ztim2,ztim3
!------------------------------------------------------------------------
!------------------------------------------------------------------------
!------------------------------------------------------------------------
!
!------------------------------------------------------------------------
!
!*     1.     INITIALISATION
!             --------------
!
 100  CONTINUE
!
      DO jl=1,kgrid
        pmu0(jl)=0.
        pfract(jl)=0.
      ENDDO
!
!*     1.1     COMPUTATION OF THE SOLAR ANGLE
!              ------------------------------
!
      DO jl=1,kgrid
        ztim1=psilat(jl)*ptim1
        ztim2=pcolat(jl)*ptim2
        ztim3=pcolat(jl)*ptim3
        pmu0(jl)=ztim1+ztim2*pcolon(jl)+ztim3*psilon(jl)
      ENDDO
!
!*     1.2      DISTINCTION BETWEEN DAY AND NIGHT
!               ---------------------------------
!
      DO jl=1,kgrid
        IF (pmu0(jl).gt.0.) THEN
          pfract(jl)=1.
	ELSE
	  pmu0(jl)=0.
	  pfract(jl)=0.
        ENDIF
      ENDDO
!

    END subroutine solang
  END MODULE solar
