MODULE radiative
  IMPLICIT NONE
  SAVE

CONTAINS

  SUBROUTINE mucorr(npts,pdeclin, plat, pmu, pfract,phaut,prad)

!=======================================================================
!
!   Calcul of equivalent solar angle and and fraction of day whithout 
!   diurnal cycle.
!
!   parmeters :
!   -----------
!
!      Input :
!      -------
!         npts             number of points
!         pdeclin          solar declinaison
!         plat(npts)        latitude
!         phaut            hauteur typique de l'atmosphere
!         prad             rayon planetaire
!
!      Output :
!      --------
!         pmu(npts)          equivalent cosinus of the solar angle
!         pfract(npts)       fractionnal day
!
!=======================================================================

!-----------------------------------------------------------------------
!
!    0. Declarations :
!    -----------------

!     Arguments :
!     -----------
      INTEGER npts
      REAL plat(npts),pmu(npts), pfract(npts)
      REAL phaut,prad,pdeclin
!
!     Local variables :
!     -----------------
      INTEGER j
      REAL pi
      REAL z,cz,sz,tz,phi,cphi,sphi,tphi
      REAL ap,a,t,b
      REAL alph

!-----------------------------------------------------------------------

      print*,'npts,pdeclin'
      print*,npts,pdeclin
      pi = 4. * atan(1.0)
      print*,'PI=',pi
      pi=2.*asin(1.)
      print*,'PI=B',pi
      z = pdeclin
      cz = cos (z)
      sz = sin (z)
       print*,'cz,sz',cz,sz

      DO j = 1, npts

         phi = plat(j)
         cphi = cos(phi)
         if (cphi.le.1.e-9) cphi=1.e-9
         sphi = sin(phi)
         tphi = sphi / cphi
         b = cphi * cz
         t = -tphi * sz / cz
         a = 1.0 - t*t
         ap = a
   
         IF(t.eq.0.) then
            t=0.5*pi
         ELSE
            IF (a.lt.0.) a = 0.
            t = sqrt(a) / t
            IF (t.lt.0.) then
               t = -atan (-t) + pi
            ELSE
               t = atan(t)
            ENDIF
         ENDIF
   
         pmu(j) = (sphi*sz*t) / pi + b*sin(t)/pi
         pfract(j) = t / pi
         IF (ap .lt.0.) then
            pmu(j) = sphi * sz
            pfract(j) = 1.0
         ENDIF
         IF (pmu(j).le.0.0) pmu(j) = 0.0
         pmu(j) = pmu(j) / pfract(j)
         IF (pmu(j).eq.0.) pfract(j) = 0.

      END DO

!-----------------------------------------------------------------------
!   correction de rotondite:
!   ------------------------

      alph=phaut/prad
      DO j=1,npts
! !!!!!!
         pmu(j)=sqrt(1224.*pmu(j)*pmu(j)+1.)/35.
!    $          (sqrt(alph*alph*pmu(j)*pmu(j)+2.*alph+1.)-alph*pmu(j))
      END DO

    END SUBROUTINE mucorr

  END MODULE radiative
