      SUBROUTINE paramdef(ngrid,rnatur,albedo,inertie,emissiv,z0)
      USE comgeomfi, ONLY : lati,sinlat,coslat
      USE vdif_mod, ONLY : lmixmin, emin_turb
      USE planet, ONLY : coefir, coefvis
      USE planet, ONLY : aphelie, periheli, obliquit, peri_day, year_day
      IMPLICIT NONE
c-----------------------------------------------------------------------
c   declarations:
c   -------------


      INTEGER ngrid
      REAL rnatur(ngrid)
      REAL albedo(ngrid),inertie(ngrid),emissiv(ngrid)
      REAL z0(ngrid)

c   local:
c   ------

      character str1*1
      INTEGER ig,ierr
      real zz,z1,z2,pi

      REAL I_mer,I_ter,z0_mer,z0_ter
      REAL alb_mer,alb_ter,emi_mer,emi_ter

c-----------------------------------------------------------------------
c  Caracteristiques orbitales:
c-----------------------------------------------------------------------

      pi=2.*asin(1.)
      year_day=360.
      periheli=173.
      aphelie=173.
      peri_day=0.
      obliquit=24.
      z0_mer=0.1
      z0_ter=10
      I_mer=30000.
      I_ter=2000.
      alb_ter=.112
      alb_mer=.112
      emi_ter=1.
      emi_mer=1.
      emin_turb=1.e-6
      lmixmin=30.
      coefvis=.99
      coefir=.08
      
      print*,'Do you want to change the default values for the'
      print*,'physical paremetrisations (y,n)'
      read(*,'(a)',iostat=ierr) str1
      do while (ierr.eq.0.and.str1.eq.'y')
         print*,'Do you want to change the following parameters?'
         print*,'For each parameter enter a new value or RETURN'
         print*,'At the end, you will have another chance'

         print*
         print*,'ASTRONOMY:'

         print*,'Length of year: ',year_day,' (sideral days)'
         read(*,*,iostat=ierr) zz
         if(ierr.eq.0)  year_day=zz

         print*,'Distance to Sun at perihelion: ',periheli,' (Mkm)'
         read(*,*,iostat=ierr) zz
         if(ierr.eq.0)  periheli=zz

         print*,'Distance to Sun at aphelion: ',aphelie,' (Mkm)'
         read(*,*,iostat=ierr) zz
         if(ierr.eq.0)  aphelie=zz

         print*,'Date of the perihelion: ',peri_day,' (days)'
         read(*,*,iostat=ierr) zz
         if(ierr.eq.0)  peri_day=zz

         print*,'Obliquity: ',obliquit,' (degrees)'
         read(*,*,iostat=ierr) zz
         if(ierr.eq.0)  obliquit=zz

         print*
         print*,'SURFACE:'

         print*,'roughness for 1. oceans and 2. solid surfaces: ',
     s   z0_mer,z0_ter,' (m)'
         read(*,*,iostat=ierr) z1,z2
         if(ierr.eq.0)  then
            z0_mer=z1
            z0_ter=z2
         endif

         print*,'Thermal inertia for 1. oceans and 2. solid surfaces: ',
     s   I_mer,I_ter,' (SI)'
         read(*,*,iostat=ierr) z1,z2
         if(ierr.eq.0)  then
            I_mer=z1
            I_ter=z2
         endif

         print*,'Visible albedo for 1. oceans and 2. solid surfaces: ',
     s   alb_mer,alb_ter
         read(*,*,iostat=ierr) z1,z2
         if(ierr.eq.0)  then
            alb_mer=z1
            alb_ter=z2
         endif

         print*,'thermal emissivity for 1. oceans and 2. solid surf.: ',
     s   emi_mer,emi_ter
         read(*,*,iostat=ierr) z1,z2
         if(ierr.eq.0)  then
            emi_mer=z1
            emi_ter=z2
         endif

         print*
         print*,'PLANETARY BOUNDARY LAYER:'

         print*,'Minimum turbulent kinetic energie: ',emin_turb,
     s    ' (m2s-2)'
         read(*,*,iostat=ierr) zz
         if(ierr.eq.0)  emin_turb=zz

         print*,'Mixing length: ',lmixmin,' (m)'
         read(*,*,iostat=ierr) zz
         if(ierr.eq.0)  lmixmin=zz

         print*
         print*,'RADIATION:'

         print*,'Fraction of the incoming solar radiation ',
     s    'reaching the surface directly: ',coefvis
         read(*,*,iostat=ierr) zz
         if(ierr.eq.0)  coefvis=zz

         print*,'Fraction of the surface thermal emission ',
     s    'reaching space directly: ',coefir
         read(*,*,iostat=ierr) zz
         if(ierr.eq.0)  coefir=zz

         print*,'Do you want to change something once again?'
         read(*,'(a)',iostat=ierr) str1
      enddo

c-----------------------------------------------------------------------

      DO ig=1,ngrid
c        inertie(ig)=(1.-rnatur(ig))*I_mer+rnatur(ig)*I_ter
c        albedo(ig)=(1.-rnatur(ig))*alb_mer+rnatur(ig)*alb_ter
              if (rnatur(ig).gt.0.5) then
                   if (lati(ig).lt.-pi/3.) then
c   antartique
                       inertie(ig)=100000.
                       albedo(ig)=0.6
                   else
c   continents normaux
                       inertie(ig)=2000.
                       albedo(ig)=0.112
                   endif
              else
c   oceans
                 inertie(ig)=100000.
                 albedo(ig)=0.112
              endif

         z0(ig)=(1.-rnatur(ig))*z0_mer+rnatur(ig)*z0_ter
         emissiv(ig)=(1.-rnatur(ig))*emi_mer+rnatur(ig)*emi_ter
         if(rnatur(ig).ge..5.and.coslat(ig).lt..5.and.sinlat(ig).lt.0.)
     .   albedo(ig)=.5
      ENDDO

      RETURN

9000  FORMAT(3(/,a72))
9001  FORMAT(/,a72,/,a8)
      END
