#!/bin/bash


function cmd_install_lmdz()
{
# Installation du modele en mode de parallelisation mixte MIPxOpenMP
    echo "cmd_install_lmdz"
    NETCDF_ROOT=$(nc-config --prefix)
    echo "NETCDF root : $NETCDF_ROOT"
    wget http://www.lmd.jussieu.fr/~lmdz/pub/install_lmdz.sh
    export LANG=C # fixes issue with sed on MaxOSX
    sed -e 's/veget=1/veget=0/g' install_lmdz.sh > install_lmdz_patched.sh
    sed -i -e bak 's/makelmdz_fcm/echo makelmdz/g'  install_lmdz_patched.sh
    chmod +x install_lmdz_patched.sh
    ./install_lmdz_patched.sh -parallel none -v $version
}

function cmd_get_phyparam()
{
    echo "cmd_get_phyparam"
    wget http://www.lmd.jussieu.fr/~hourdin/PARAM/phyparam.20191009.tar
    tar xvf phyparam.20191009.tar 
}

function cmd_patch_lmdz()
{
# Modification du code source pour prendre en compte la physique
# a 20 parametres
    echo "cmd_patch_lmdz"
    cd $LMDZ/libf
    rm -rf phyparam dynphy_lonlat/phyparam
    mkdir phyparam dynphy_lonlat/phyparam
    cd phyparam
    ln -s ../phydev/* .
    ln -sf $ROOT/phyparam/* .
    ln -sf $ROOT/phyparam/param/* .
    cd ../dynphy_lonlat/phyparam
    ln -s ../phydev/* .
    ln -sf $ROOT/dynphy_lonlat/phyparam/* .
    cd $LMDZ
    ./makelmdz_fcm -rrtm false  -v false -arch local -j 8 -p param -d 32x32x39 gcm
}


function cmd_get_param()
{
# Recupération des parametres d'entree
    echo "cmd_get_param"
    cd $LMDZ
    wget http://www.lmd.jussieu.fr/~hourdin/PARAM/test_param.tar
    tar xvf test_param.tar
}

function cmd_()
{
#    cmd_get_phyparam
    cmd_install_lmdz
    cmd_patch_lmdz
    cmd_get_param
    echo puis lancer gcm.e sur TEST_PARAM
}

# On peut choisir la version de LMDZ a insitaller
version=20191106.trunk
ROOT=$(pwd)
LMDZ=$ROOT/LMDZ$version/modipsl/modeles/LMDZ

cmd_$1
