group()
{
    echo
    ATTR=$1 ; shift
    for name in $* ; do
	echo "                <field field_ref=\"${name}\" $ATTR > @${name} </field> "
    done
}

cmd_histday()
{
    cat <<EOF

<file_definition >
  <file_group output_freq="1d" sync_freq="1d" output_level="2" timeseries="none" time_counter="none">

    <!-- attribute operation="..." is set in field_def_XX.xml
	 <field id="XX_day" field_ref=XX> @XX </field> triggers the computation of the average/min/max on the native mesh
	 <field field_ref="XX_day" grid_ref="..."/> then interpolates on the regular mesh -->

    <!-- NATIVE grid, XIOS performs averaging/min/max --> 
    <file id="histday_native"  enabled="false" >

	<field_group id="field_day" freq_op="1d">
           $(group 'level="1"' "phis" "contfracOR" "flat" "slp" "tsol" "tas" "gusts" "wind10m" "sicf" "q2m" "ustar" "u10m" "v10m" "psol" "precip" "plul" "pluc" "snow" "evap" "tops" "topl" "SWup200clr" "SWdn200clr" "sols" "soll" "SWdnSFC" "sens" "cldl" "cldm" "cldh" "cldt" "cldq" "prw" "slab_bils_oce" "ale_bl" "alp_bl" "ale_wk" "alp_wk" "ale" "alp" "cin" "wape" "n2" "s2" "proba_notrig" "random_notrig" "ale_bl_stat" "ale_bl_trig" "alp_bl_det" "alp_bl_fluct_m" "alp_bl_fluct_tke" "alp_bl_conv" "alp_bl_stat" "weakinv" "dthmin" "snowl" "solldown" "wdtrainA" "wdtrainM" )
           $(group 'level="1" operation="maximum"' "tasmax" "wind10max" "cape_max")
           $(group 'level="1" operation="minimum"' "tasmin" )
           $(group 'level="2"' "bils" "bils_tke" "bils_diss" "bils_ec" "bils_kinetic" "bils_enthalp" "bils_latent" "fder" "OD550_STRAT")
           $(group 'level="3"' "temp" "theta" "ovap" "oliq" "geop" "vitu" "vitv" "vitw" "pres" "paprs" "mass" "zfull" "zhalf")
           $(group 'level="4"' "SWupTOA" "SWupTOAclr" "SWdnTOA" "SWdnTOAclr" "nettop" "SWupSFC" "SWupSFCclr" "SWdnSFCclr" "LWupSFC" "LWupSFCclr" "LWdnSFC" "LWdnSFCclr" "u10_ter" "u10_lic" "u10_oce" "u10_sic" "v10_ter" "v10_lic" "v10_oce" "v10_sic" "tke_ter" "tke_lic" "tke_oce" "tke_sic" "tke_max_ter" "tke_max_lic" "tke_max_oce" "tke_max_sic" "zmax_th")
           $(group 'level="5"' "wstar" "tops0" "topl0" "sols0" "soll0" "lwp" "iwp" "pbase" "ptop" "rh2m" "rh2m_min" "rh2m_max" "qsat2m" "tpot" "tpote" "wake_h" "wake_s" "cldtau" "cldemi" "lwcon" "iwcon" "rneb" "rnebcon" "rnebls" "rhum" "mc" "dtwak" "dqwak" "wake_deltat" "wake_deltaq" "wake_omg" "ftd" "fqd")
           $(group 'level="6"' "t2m_ter" "t2m_lic" "t2m_oce" "t2m_sic" "ustar_ter" "ustar_lic" "ustar_oce" "ustar_sic" "wstar_ter" "wstar_lic" "wstar_oce" "wstar_sic" "u10m_ter" "u10m_lic" "u10m_oce" "u10m_sic" "v10m_ter" "v10m_lic" "v10m_oce" "v10m_sic" "evap_ter" "evap_lic" "evap_oce" "evap_sic" "taux_ter" "taux_lic" "taux_oce" "taux_sic" "tauy_ter" "tauy_lic" "tauy_oce" "tauy_sic" "fract_ter" "fract_lic" "fract_oce" "fract_sic" "tsol_ter" "tsol_lic" "tsol_oce" "tsol_sic" "evappot_ter" "evappot_lic" "evappot_oce" "evappot_sic" "sens_ter" "sens_lic" "sens_oce" "sens_sic" "lat_ter" "lat_lic" "lat_oce" "lat_sic" "OD550_ASBCM" "OD550_ASPOMM" "OD550_ASSO4M" "OD550_CSSO4M" "OD550_SSSSM" "OD550_ASSSM" "OD550_CSSSM" "OD550_CIDUSTM" "OD550_AIBCM" "OD550_AIPOMM" "od550aer" "od865aer" "absvisaer" "od550lt1aer" "sconcso4" "sconcoa" "sconcbc" "sconcss" "sconcdust" "loadso4" "loadoa" "loadbc" "loadss" "loaddust" "swtoaas_nat" "swsrfas_nat" "swtoacs_nat" "swsrfcs_nat" "swtoaas_ant" "swsrfas_ant" "swtoacs_ant" "swsrfcs_ant" "swtoacf_nat" "swsrfcf_nat" "swtoacf_ant" "swsrfcf_ant" "swtoacf_zero" "swsrfcf_zero" "cldncl" "reffclwtop" "cldnvi" "lcc" "rugs_ter" "rugs_lic" "rugs_oce" "rugs_sic" "z0m_ter" "z0m_lic" "z0m_oce" "z0m_sic" "z0h_ter" "z0h_lic" "z0h_oce" "z0h_sic" "concso4" "concoa" "concbc" "concss" "concdust" "ec550aer" "scdnc" "reffclws" "reffclwc" "lcc3d" "lcc3dcon" "lcc3dstra")
           $(group 'level="7" ' "radsol" "pourc_ter" "pourc_lic" "pourc_oce" "pourc_sic" "albe_ter" "albe_lic" "albe_oce" "albe_sic")           
           <field_group detect_missing_value=".true.">
             $(group 'level="7"' "u850" "u700" "u500" "u200" "u100" "u50" "u10" "v850" "v700" "v500" "v200" "v100" "v50" "v10" "w850" "w700" "w500" "w200" "w100" "w50" "w10" "t850" "t700" "t500" "t200" "t100" "t50" "t10" "q850" "q700" "q500" "q200" "q100" "q50" "q10" "z850" "z700" "z500" "z200" "z100" "z50" "z10")
           </field_group>
	</field_group>

    </file>

    <!-- INTERPOLATED grid, XIOS performs remapping ; output level inherited --> 
    <file id="histday" enabled="true" >
      <field_group group_ref="field_day" domain_ref="dom_out" />
    </file>
    
  </file_group>
</file_definition>

EOF
}

cmd_histmth_icosa()
{

FIELD_DYN="ps phis geopot p theta ulon ulat omega temp"
FIELD_Q="q qmass_t qflux_lon qflux_lat"
FIELD_DIAG="dulon_phys dulat_phys"
for name in mass ulon theta epot ekin enthalpy ; do
    FIELD_DIAG="$FIELD_DIAG ${name}_t ${name}flux_lon ${name}flux_lat"
done

cat <<EOF

<file_definition >
    <file_group type="one_file" output_freq="1mo" sync_freq="1mo" output_level="10" timeseries="none" time_counter="none"> 

        <file id="histmth_icosa_native" enabled="false"> 

            <field_group operation="average" ts_enabled="true" freq_op="1mo" level="1">

	      <field_group id="field_mth_icosa" >

		<!-- Basics -->
                $(group '' $FIELD_DYN)

		<!-- Physics tendencies and transport diagnostics-->
                $(group '' $FIELD_DIAG)

              </field_group>

	      <field_group id="field_mth_icosa_Q" >
                $(group '' $FIELD_Q)
              </field_group>

            </field_group>
	  
        </file>
	  
        <file id="histmth_icosa" enabled="true"> 
	  <field_group group_ref="field_mth_icosa" domain_ref="dom_out"  />
	  <field_group group_ref="field_mth_icosa_Q" grid_ref="grid_q_out" />	  
        </file>

    </file_group>

</file_definition>
EOF
}


CMD=$1 ; shift
cmd_$CMD $*

# echo $(grep field_ref file_def_histday_lmdz.xml | grep 'level="3"'| awk '{print $2}' | cut -c 11- )
