#!/bin/bash
# How to use this script :
# 1    Create a directory EXP for your experiment ; ALL commands below must be run from EXP
# 2    Create a directory STORE to store the outputs of your experiment ; run "ln -s STORE storedir"
# 3    run "BASE/example.sh init" where BASE is the directory containing this script
# 4    (optional) Edit EXP/config.sh, EXP/run_icosa.def, EXP/*.xml
# 5    run "./example.sh create" (NB : ./example.sh, NOT ../example.sh)
# 6    run "./example.sh submit"

function fullpath() 
{ 
    echo "$(cd -P $1 ; pwd)"
}

function years()
{
    for ((i="$1";i<="$2";i++)) ; do
	echo $i
    done
}

function yeardirs()
{
    for ((i="$1";i<="$2";i++)) ; do
	echo $(printf 'year%02d' $i)
    done
}

function cmd_create()
{
    source ./config.sh
    env | grep YEARS
    ls -l $PWD/storedir || (echo "$PWD/storedir is missing, please create it and retry." ; exit -1) || exit
    STORE_ROOT=$( fullpath $PWD/storedir )
    YEARDIRS=$(yeardirs 1 $NB_YEARS)
    for DIR in ce0l $YEARDIRS ; do
	rm -rf $DIR $STORE_ROOT/$DIR
    done
    STORE0L="$STORE_ROOT/ce0l"
    $BASEDIR/prepare.sh ce0l ce0l "$STORE0L" 1980
    $BASEDIR/prepare.sh first $STORE0L year01 "$STORE_ROOT/year01" 1980
    PREV=year01
    for YEAR in $(years 2 $NB_YEARS) ; do
	YEARDIR=$(printf 'year%02d' $YEAR)
#	ANNEEREF=$((1979 + YEAR))
	ANNEEREF=1980
	$BASEDIR/prepare.sh next  $STORE0L "$STORE_ROOT/$PREV" $YEARDIR "$STORE_ROOT/$YEARDIR" $ANNEEREF
	PREV=$YEARDIR
    done
}

function submit_X64_CURIE()
{
    EXP=$1 ; shift
    CMD="ccc_msub $* $EXP/job.sh"
    MSG=$($CMD)
    echo "$CMD : $MSG"
    JOBID=$( echo "$MSG" | awk '{print $NF}' )
    DEP="-a $JOBID"
}

function cmd_submit()
{
    source ./config.sh
    DEP=""
    submit_$ARCH ce0l
    for YEARDIR in $(yeardirs 1 $NB_YEARS) ; do
	submit_$ARCH $YEARDIR $DEP
    done
}

function init_all()
{
    cat >> config.sh <<EOF
ARCH=X64_CURIE
BASEDIR=$BASEDIR
ESM_ROOT=$ESM_ROOT
NB_YEARS=2
NB_MPI_DYNAMICO=160
NB_MPI_XIOS=16
WALLTIME_JOB=7200
WALLTIME_CE0L=120
EOF
    cp -fp $BASEDIR/*.sh $BASEDIR/*.xml $BASEDIR/*.def .
    rm gcm.def # LMDZ-only, remove to avoid confusion
    rm -rf orig
    mkdir orig
    cp -p *.sh *.xml *.def orig/ # keep original config files in orig
    ls -lrh
    echo
    echo "$PWD/config.sh :"
    cat config.sh
    echo "If not done already, please create $PWD/storedir." 
    echo 'You may edit config.sh, *.def, *.xml then run ./example.sh create'
}

function cmd_init_aqua()
{
    cat > config.sh <<EOF
READ_CLIMOZ=-1
VEGET=n
SOLARLONG0=1000.
ETAT0=held_suarez
IFLAG_PHYS0=103
EXPERIMENT=aqua
EOF
    init_all
}

function cmd_init_betaclim()
{
    cat > config.sh <<EOF
READ_CLIMOZ=2
VEGET=betaclim
SOLARLONG0=-9999.999
ETAT0=database
IFLAG_PHYS0=1
EXPERIMENT=betaclim
EOF
    init_all
    echo "Decompressing FILES_LMDZ.tar.bz2"
    tar xjf /ccc/store/cont003/gen7548/dubosth/Lluis/FILES_LMDZ.tar.bz2
}

function cmd_diff()
{
    for x in orig/*.sh orig/*.xml orig/*.def ; do
	diff -u $x $(basename $x)
    done
}

function cmd_patch()
{
    patch -p0 < $2
}

BASEDIR=$(dirname ${BASH_SOURCE[0]})
BASEDIR=$( fullpath $BASEDIR )
ESM_ROOT=$( fullpath $BASEDIR/../../ )
echo "Your command : $0 $*"
echo "Script base dir : $BASEDIR"
echo "Run from : $(fullpath $PWD)"
echo "Usage : $0 [init_aqua|init_betaclim|diff|create|submit]"
cmd_$1 $*
