MODULE geometry_mod


  REAL,SAVE,ALLOCATABLE :: longitude(:) ! longitude of the cell (rad)
!$OMP THREADPRIVATE(longitude)

  REAL,SAVE,ALLOCATABLE :: latitude(:)! latitude of the cell (rad)
!$OMP THREADPRIVATE(latitude)

  REAL,SAVE,ALLOCATABLE :: lon_degrees(:) ! longitude of the cell (degree)
!$OMP THREADPRIVATE(lon_degrees)

  REAL,SAVE,ALLOCATABLE :: lat_degrees(:)! latitude of the cell (degree)
!$OMP THREADPRIVATE(lat_degrees)

  REAL,SAVE,ALLOCATABLE :: boundslon(:,:)  ! boundaries of the cell (rad)
!$OMP THREADPRIVATE(boundslon)

  REAL,SAVE,ALLOCATABLE :: boundslat(:,:) ! boundaries of the cell (rad)
!$OMP THREADPRIVATE(boundslat)

  REAL,SAVE,ALLOCATABLE :: dx(:)      ! resolution of longitude cell (valid only for 2D grid)
!$OMP THREADPRIVATE(dx)
  
  REAL,SAVE,ALLOCATABLE :: dy(:)      ! resolution of latitude cell (valid only for 2D grid)
!$OMP THREADPRIVATE(dy)

  REAL,SAVE,ALLOCATABLE :: cell_area(:)      ! area of the cell
!$OMP THREADPRIVATE(cell_area)

  INTEGER,SAVE,ALLOCATABLE :: ind_cell_glo(:)      ! global indice of a local cell
!$OMP THREADPRIVATE(ind_cell_glo)

CONTAINS

  SUBROUTINE init_geometry(longitude_, latitude_, boundslon_, boundslat_, cell_area_,ind_cell_glo_, dx_, dy_)
  USE dimphy, ONLY: klon
  USE mod_grid_phy_lmdz, ONLY: nvertex
  USE nrtype, ONLY : PI
  IMPLICIT NONE
    REAL :: longitude_(klon)
    REAL :: latitude_(klon)
    REAL :: boundslon_(klon,nvertex)
    REAL :: boundslat_(klon,nvertex)
    REAL :: cell_area_(klon)
    INTEGER :: ind_cell_glo_(klon) 
    REAL,OPTIONAL :: dx_(klon)
    REAL,OPTIONAL :: dy_(klon)
    
    ALLOCATE(longitude(klon))
    ALLOCATE(latitude(klon))
    ALLOCATE(lon_degrees(klon))
    ALLOCATE(lat_degrees(klon))
    ALLOCATE(boundslon(klon,nvertex))
    ALLOCATE(boundslat(klon,nvertex))
    ALLOCATE(cell_area(klon))
    ALLOCATE(ind_cell_glo(klon))
    IF (PRESENT(dx_)) ALLOCATE(dx(klon))
    IF (PRESENT(dy_))ALLOCATE(dy(klon))
    
    longitude(:) = longitude_(:)
    latitude(:) = latitude_(:)
    lon_degrees(:) = longitude(:)*180./PI
    lat_degrees(:) = latitude(:)*180./PI
    boundslon(:,:) = boundslon_(:,:)
    boundslat(:,:) = boundslat_(:,:)
    cell_area(:) = cell_area_(:)
    ind_cell_glo(:) = ind_cell_glo_(:)
    IF (PRESENT(dx_)) dx(:) = dx_(:)
    IF (PRESENT(dy_)) dy(:) = dy_(:)
    
  END SUBROUTINE init_geometry


END MODULE geometry_mod
