MODULE etat0_limit_unstruct_mod

  LOGICAL, SAVE  :: create_etat0_limit
!$OMP THREADPRIVATE(create_etat0_limit) 




CONTAINS
  
  SUBROUTINE init_etat0_limit_unstruct
  USE xios
  USE mod_phys_lmdz_para
  USE mod_grid_phy_lmdz
  USE ioipsl, ONLY : getin, ioget_year_len
  USE time_phylmdz_mod, ONLY : annee_ref
  IMPLICIT NONE
  
    INTEGER :: iflag_phys,i
    INTEGER :: ndays
    REAL,ALLOCATABLE :: value(:)
    
      IF (grid_type==unstructured) THEN
        IF (is_master) CALL getin("iflag_phys",iflag_phys)
        CALL bcast(iflag_phys)
        
        IF (is_master) CALL getin('create_etat0_limit',create_etat0_limit) 
        CALL bcast(create_etat0_limit)
        
        ndays=ioget_year_len(annee_ref)
        ALLOCATE(value(ndays))
        DO i=1,ndays
          value(i)=i-1
        ENDDO
        
        IF (is_omp_master) CALL xios_set_axis_attr("time_year",n_glo=ndays,value=value) 
        
        IF (iflag_phys<100) THEN

          IF (create_etat0_limit) THEN
            IF (is_omp_master) CALL xios_set_fieldgroup_attr("etat0_limit_read",read_access=.TRUE.,enabled=.TRUE.)
            IF (is_omp_master) CALL xios_set_filegroup_attr("etat0_limit_read",enabled=.TRUE.)
            IF (is_omp_master) CALL xios_set_file_attr("limit_write",enabled=.TRUE.)
          ENDIF
      
        ENDIF
      
      ENDIF  

  END SUBROUTINE init_etat0_limit_unstruct
  
  SUBROUTINE create_etat0_limit_unstruct
  USE mod_grid_phy_lmdz
  USE create_etat0_unstruct_mod
  USE create_limit_unstruct_mod
  USE phyaqua_mod
  USE mod_phys_lmdz_para
  USE ioipsl, ONLY : getin
  USE dimphy
  USE xios
  IMPLICIT NONE
      INTEGER :: iflag_phys
  
      IF (grid_type==unstructured) THEN
  
        IF (is_master) CALL getin("iflag_phys",iflag_phys)
        CALL bcast(iflag_phys)

        IF (iflag_phys<100) THEN
          IF ( create_etat0_limit) THEN
              CALL create_etat0_unstruct
              CALL create_limit_unstruct
              IF (is_omp_master) CALL xios_context_finalize()
!$OMP BARRIER
              CALL abort_physic ('create_etat0_limit_unstruct','Initial state file are created, all is fine' ,1)
          ENDIF 
        ELSE
          IF (create_etat0_limit) THEN 
            CALL iniaqua(klon,iflag_phys)
            IF (is_omp_master) CALL xios_context_finalize()
!$OMP BARRIER
            CALL abort_physic ('create_etat0_limit_unstruct','Initial state file are created, all is fine' ,1)
          ENDIF
        ENDIF
      ENDIF
        
  END SUBROUTINE create_etat0_limit_unstruct
  
END MODULE etat0_limit_unstruct_mod
