MODULE write_etat0_mod



CONTAINS

  SUBROUTINE write_etat0(it,f_ps,f_phis,f_theta_rhodz,f_u, f_q)
  USE icosa
  USE restart_mod
  USE wind_mod
  USE write_field_mod
  IMPLICIT NONE
    INTEGER,INTENT(IN)    :: it
    TYPE(t_field),POINTER :: f_ps(:)
    TYPE(t_field),POINTER :: f_phis(:)
    TYPE(t_field),POINTER :: f_theta_rhodz(:)
    TYPE(t_field),POINTER :: f_u(:)
    TYPE(t_field),POINTER :: f_q(:)
  
    TYPE(t_field),POINTER,SAVE :: f_ulon(:)
    TYPE(t_field),POINTER,SAVE :: f_ulat(:)
    
    
    CALL allocate_field(f_ulon,field_t,type_real,llm,name='ulon')
    CALL allocate_field(f_ulat,field_t,type_real,llm,name='ulat')

    CALL transfert_request(f_u,req_e1_vect)
    CALL un2ulonlat(f_u, f_ulon, f_ulat)
    
    CALL write_restart(it,f_ps,f_phis,f_theta_rhodz,f_u, f_ulon, f_ulat, f_q)

    CALL deallocate_field(f_ulon)
    CALL deallocate_field(f_ulat)
    
  END SUBROUTINE write_etat0
    
END MODULE write_etat0_mod
