MODULE physics_external_mod
  USE field_mod
  
  INTEGER,SAVE :: it
!$OMP THREADPRIVATE(it)

  TYPE(t_field),POINTER,SAVE :: f_phis(:)
  TYPE(t_field),POINTER,SAVE :: f_ps(:)
  TYPE(t_field),POINTER,SAVE :: f_theta_rhodz(:)
  TYPE(t_field),POINTER,SAVE :: f_u(:)
  TYPE(t_field),POINTER,SAVE :: f_wflux(:)
  TYPE(t_field),POINTER,SAVE :: f_q(:)
  
  
  
CONTAINS

  SUBROUTINE init_physics

    CALL initialize_external_physics
        
  END SUBROUTINE init_physics
  
  SUBROUTINE physics(it_,f_phis_, f_ps_, f_theta_rhodz_, f_u_, f_wflux_, f_q_)
  USE field_mod
  IMPLICIT NONE
    INTEGER,INTENT(IN)    :: it_
    TYPE(t_field),POINTER :: f_phis_(:)
    TYPE(t_field),POINTER :: f_ps_(:)
    TYPE(t_field),POINTER :: f_theta_rhodz_(:)
    TYPE(t_field),POINTER :: f_u_(:)
    TYPE(t_field),POINTER :: f_wflux_(:)
    TYPE(t_field),POINTER :: f_q_(:)

    it=it_
    
!$OMP BARRIER
!$OMP MASTER
    f_phis=>f_phis_
    f_ps=>f_ps_
    f_theta_rhodz=>f_theta_rhodz_
    f_u=>f_u_
    f_wflux=>f_wflux_
    f_q=>f_q_
!$OMP END MASTER
!$OMP BARRIER

    CALL external_physics
    
  END SUBROUTINE physics
  
  
END MODULE physics_external_mod
    
  
