MODULE output_field_mod
USE genmod
  PRIVATE
  LOGICAL,SAVE :: xios_output 
!$OMP THREADPRIVATE(xios_output)     
  LOGICAL,SAVE :: enable_io    
!$OMP THREADPRIVATE(enable_io)     

  PUBLIC enable_io,xios_output,output_field_init,output_field,output_field_finalize

CONTAINS 
  
  SUBROUTINE output_field_init
  USE getin_mod
  USE xios_mod
  USE write_field_mod
  IMPLICIT NONE

    enable_io=.TRUE.
    CALL getin('enable_io',enable_io)

    IF (using_xios) THEN
      xios_output=.TRUE.
      CALL getin('xios_output',xios_output)
    ELSE
      xios_output=.FALSE.
    ENDIF
    
    IF (xios_output) THEN
      CALL xios_init_write_field
    ENDIF

    
  END SUBROUTINE output_field_init

  SUBROUTINE output_field(name_in,field)
    USE field_mod
    USE xios_mod
    USE write_field_mod
    IMPLICIT NONE  
     CHARACTER(LEN=*),INTENT(IN) :: name_in
      TYPE(t_field),POINTER :: field(:)

      IF (xios_output) THEN
        CALL xios_write_field(name_in,field)
      ELSE
       CALL writeField(name_in,field)
      ENDIF

  END SUBROUTINE output_field

  SUBROUTINE output_field_finalize
  USE IOIPSL
  USE xios_mod
  IMPLICIT NONE
    
    IF (xios_output) THEN
      CALL xios_write_field_finalize
    ENDIF
    
  END SUBROUTINE output_field_finalize

END MODULE output_field_mod
  
