  SUBROUTINE initialize_physic(nbp,nlayer, communicator,                        &
                               day_length,start_day,timestep,                   &
                               nvertex,latfi,lonfi,airefi,bounds_lonfi,bounds_latfi,  &
                               radius,g, R, cpp,                        &
                               preff, ap, bp)                   
    USE mod_grid_phy_lmdz
    INTEGER :: nbp_glo
    REAL    :: pseudoalt(nlayer)
    
    pseudoalt(:)=0 
    
    CALL MPI_ALLREDUCE(nbp,nbp_glo,1,MPI_INTEGER,MPI_SUM,communicator,ierr)
    
    CALL init_physics_distribution(unstructured, 6, nbp, 1, nbp_glo, llm, communicator)
    CALL init_geometry(lonfi, latfi, boundslonfi, boundslatfi, airefi)
    CALL init_vertical_layers(nlayer,preff,ap,bp,presnivs,pseudoalt)
  
    CALL init_infotrac_phy(nqtot,nqo,nbtr,tname,ttext,type_trac,&
                         niadv,conv_flg,pbl_flg,solsym)
  
    
    punjour=day_length
    prad=radius
    pg=g
    pr=R
    pcpp=cpp
    ptimestep=timestep
    day_step=day_length/timestep
    
    CALL inifis(punjours,prad,pg,pr,pcpp,ptimestep,&
              day_step,dayref,anneeref,nday,&
              annee_ref,day_ini,day_end,&
              itau_phy,itaufin,&
              start_time,day_ref,jD_ref, &
              offline,raz_date,config_inca, &
              lunout,prt_level,debug)
