
! $Id: $
MODULE inifis_mod

  IMPLICIT NONE
  ! for now constants and flags transmitted from dyn to phys are stored here
  REAL,SAVE :: daysec ! length of reference day (s)
  REAL,SAVE :: dtphys ! physics time step (s)
  INTEGER,SAVE :: day_step ! number of dynamical steps per day
  INTEGER,SAVE :: iphysiq ! physics called every iphysiq dynamical step
  INTEGER,SAVE :: dayref
  INTEGER,SAVE :: anneeref ! reference year, ase deifined in run.def
  INTEGER,SAVE :: nday ! number of days to run
!$OMP THREADPRIVATE(daysec,dtphys,day_step,iphysiq,dayref,anneeref,nday)
  INTEGER,SAVE :: annee_ref ! reference year as read from start file
  INTEGER,SAVE :: day_ini
  INTEGER,SAVE :: day_end
!$OMP THREADPRIVATE(annee_ref,day_ini,day_end)
  INTEGER,SAVE :: itau_phy
  INTEGER,SAVE :: itaufin
  REAL,SAVE :: start_time
  INTEGER,SAVE :: day_ref
  REAL,SAVE :: jD_ref
!$OMP THREADPRIVATE(itau_phy,itaufin,start_time,day_ref,JD_ref)
  LOGICAL,SAVE :: offline
  INTEGER,SAVE :: raz_date
  CHARACTER(len=4),SAVE :: config_inca
  INTEGER,SAVE :: lunout=6 ! default output file identifier (6==screen)
  INTEGER,SAVE :: prt_level ! Output level
  LOGICAL,SAVE :: debug ! flag to specify if in "debug mode"
!$OMP THREADPRIVATE(offline,raz_date,config_inca,lunout,prt_level,debug)

CONTAINS

  SUBROUTINE inifis(punjours,prad,pg,pr,pcpp,ptimestep,&
                    day_step_dyn,iphysiq_dyn,&
                    dayref_dyn,anneeref_dyn,nday_dyn,&
                    annee_ref_dyn,day_ini_dyn,day_end_dyn,&
                    itau_phy_dyn,itaufin_dyn,&
                    start_time_dyn,day_ref_dyn,jD_ref_dyn,&
                    offline_dyn,raz_date_dyn,config_inca_dyn, &
                    lunout_dyn,prt_level_dyn,debug_dyn)
  ! Initialize physics constant and flags from dynamics
  IMPLICIT NONE

  include "YOMCST.h"
  REAL,INTENT(IN) :: punjours,prad, pg, pr, pcpp
  REAL,INTENT(IN) :: ptimestep ! physics time step (s)
  INTEGER,INTENT(IN) :: day_step_dyn
  INTEGER,INTENT(IN) :: iphysiq_dyn
  INTEGER,INTENT(IN) :: dayref_dyn
  INTEGER,INTENT(IN) :: anneeref_dyn
  INTEGER,INTENT(IN) :: nday_dyn
  INTEGER,INTENT(IN) :: annee_ref_dyn
  INTEGER,INTENT(IN) :: day_ini_dyn
  INTEGER,INTENT(IN) :: day_end_dyn
  INTEGER,INTENT(IN) :: itau_phy_dyn
  INTEGER,INTENT(IN) :: itaufin_dyn
  REAL,INTENT(IN) :: start_time_dyn
  INTEGER,INTENT(IN) :: day_ref_dyn
  REAL,INTENT(IN) :: jD_ref_dyn
  LOGICAL,INTENT(IN) :: offline_dyn
  INTEGER,INTENT(IN) :: raz_date_dyn
  CHARACTER(len=4),INTENT(IN) :: config_inca_dyn
  INTEGER,INTENT(IN) :: lunout_dyn
  INTEGER,INTENT(IN) :: prt_level_dyn
  LOGICAL,INTENT(IN) :: debug_dyn
  CHARACTER (LEN=20) :: modname = 'inifis'
  CHARACTER (LEN=80) :: abort_message

  ! Some general settings and associated flags
  daysec=punjours
  dtphys=ptimestep
  day_step=day_step_dyn
  iphysiq=iphysiq_dyn
  dayref=dayref_dyn
  anneeref=anneeref_dyn
  nday=nday_dyn
  annee_ref=annee_ref_dyn
  day_ini=day_ini_dyn
  day_end=day_end_dyn
  itau_phy=itau_phy_dyn
  itaufin=itaufin_dyn
  start_time=start_time_dyn
  day_ref=day_ref_dyn
  jD_ref= jD_ref_dyn
  offline=offline_dyn
  raz_date=raz_date_dyn
  config_inca=config_inca_dyn
  lunout=lunout_dyn
  prt_level=prt_level_dyn
  debug=debug_dyn

  ! suphel => initialize some physical constants (orbital parameters,
  !           geoid, gravity, thermodynamical constants, etc.) in the
  !           physics
  CALL suphel

  ! check that physical constants set in 'suphel' are coherent
  ! with values set in the dynamics:
  IF (rday/=punjours) THEN
    WRITE (lunout, *) 'inifis: length of day discrepancy!!!'
    WRITE (lunout, *) '  in the dynamics punjours=', punjours
    WRITE (lunout, *) '   but in the physics RDAY=', rday
    IF (abs(rday-punjours)>0.01*punjours) THEN
        ! stop here if the relative difference is more than 1%
      abort_message = 'length of day discrepancy'
      CALL abort_physic(modname, abort_message, 1)
    END IF
  END IF
  IF (rg/=pg) THEN
    WRITE (lunout, *) 'inifis: gravity discrepancy !!!'
    WRITE (lunout, *) '     in the dynamics pg=', pg
    WRITE (lunout, *) '  but in the physics RG=', rg
    IF (abs(rg-pg)>0.01*pg) THEN
        ! stop here if the relative difference is more than 1%
      abort_message = 'gravity discrepancy'
      CALL abort_physic(modname, abort_message, 1)
    END IF
  END IF
  IF (ra/=prad) THEN
    WRITE (lunout, *) 'inifis: planet radius discrepancy !!!'
    WRITE (lunout, *) '   in the dynamics prad=', prad
    WRITE (lunout, *) '  but in the physics RA=', ra
    IF (abs(ra-prad)>0.01*prad) THEN
        ! stop here if the relative difference is more than 1%
      abort_message = 'planet radius discrepancy'
      CALL abort_physic(modname, abort_message, 1)
    END IF
  END IF
  IF (rd/=pr) THEN
    WRITE (lunout, *) 'inifis: reduced gas constant discrepancy !!!'
    WRITE (lunout, *) '     in the dynamics pr=', pr
    WRITE (lunout, *) '  but in the physics RD=', rd
    IF (abs(rd-pr)>0.01*pr) THEN
        ! stop here if the relative difference is more than 1%
      abort_message = 'reduced gas constant discrepancy'
      CALL abort_physic(modname, abort_message, 1)
    END IF
  END IF
  IF (rcpd/=pcpp) THEN
    WRITE (lunout, *) 'inifis: specific heat discrepancy !!!'
    WRITE (lunout, *) '     in the dynamics pcpp=', pcpp
    WRITE (lunout, *) '  but in the physics RCPD=', rcpd
    IF (abs(rcpd-pcpp)>0.01*pcpp) THEN
        ! stop here if the relative difference is more than 1%
      abort_message = 'specific heat discrepancy'
      CALL abort_physic(modname, abort_message, 1)
    END IF
  END IF

  END SUBROUTINE inifis

END MODULE inifis_mod
