!
! $Id: surface_data.F90 3792 2021-01-04 17:01:25Z evignon $
!
MODULE surface_data

  IMPLICIT NONE

  REAL, PARAMETER        :: calice=1.0/(5.1444e+06*0.15)
  REAL, PARAMETER        :: calsno=1./(2.3867e+06*.15)
  
  LOGICAL, SAVE          :: ok_veget      ! true for use of vegetation model ORCHIDEE
  !$OMP THREADPRIVATE(ok_veget)

  CHARACTER(len=10), SAVE :: type_veget   ! orchidee/y/bucket/n/betaclim
  !$OMP THREADPRIVATE(type_veget)

  CHARACTER(len=6), SAVE :: type_ocean    ! force/slab/couple
  !$OMP THREADPRIVATE(type_ocean)

  ! if type_ocean=couple : version_ocean=opa8 ou nemo
  ! if type_ocean=slab   : version_ocean=sicOBS or sicINT or sicNO
  CHARACTER(len=6), SAVE :: version_ocean 
  !$OMP THREADPRIVATE(version_ocean)

  ! Pas de temps couplage atm/oce (en secondes)
  REAL, SAVE             :: t_coupl
  !$OMP THREADPRIVATE(t_coupl)

  ! FOR INLANDSIS:
  !===============

   INTEGER, SAVE          :: landice_opt       ! 1 for coupling with SISVAT, 2 for coupling with INLANDSIS
  !$OMP THREADPRIVATE(landice_opt)

   INTEGER, SAVE          :: iflag_tsurf_inlandsis ! 0 SISVAT method, 1 LMDZ method
  !$OMP THREADPRIVATE(iflag_tsurf_inlandsis)

   INTEGER, SAVE          :: iflag_albzenith ! dependency of albedo to zenith angle
  !$OMP THREADPRIVATE(iflag_albzenith)  

   INTEGER, SAVE          :: n_dtis           ! number of subtimesteps for INLANDSIS
  !$OMP THREADPRIVATE(n_dtis)

  ! with or without snow module/ blowing snow, ascii outfile
   LOGICAL, SAVE           :: SnoMod,BloMod,ok_outfor 
  !$OMP THREADPRIVATE(SnoMod,BloMod,ok_outfor)    

END MODULE surface_data
