MODULE VARphy


IMPLICIT NONE



! Etienne, 08112020: merging YOMCST_SISVAT,  PHY_SV and VARphy
! but redundancies remain
!
!  ATTENTION!!!!: ce fichier include est compatible format fixe/format libre
!                 veillez à n'utiliser que des ! pour les commentaires
!                 et à bien positionner les & des lignes de continuation
!                 (les placer en colonne 6 et en colonne 73)
!
!
! A1.0 Fundamental constants
!----------------------------
! Constants
                                                                              
      CHARACTER(LEN=1), PARAMETER :: labnum(0:9) =                            &
              (/'0','1','2','3','4','5','6','7','8','9'/)             
!C +...                labnum: Alphanumeric Character      
     
                                                                               
      INTEGER, PARAMETER ::  iun=1                                             
      REAL, PARAMETER    ::  zer0 = 0.0e+0, half = 0.5e+0, un_1 = 1.0e+0,     &
     &                       eps6 = 1.0e-6, R_1000=1.e3       
      REAL, PARAMETER    ::  zero = 0.0e+0, demi = 0.5e+0, unun = 1.0e+0,     &
     &                       epsi = 1.0e-6, eps9 = 1.0e-9         
      REAL               ::  ea_MAX,ea_MIN                                                                               
      REAL, PARAMETER    ::  pi = 3.141592653589793238462643e0
     
! A1.2 Geoide
!-------------
      REAL, PARAMETER    ::  Grav_F = 9.81e0, Grav_I = 1./Grav_F                       
!C +                   Grav_F:  Gravitational  Force         =  9.81    m/s2           
!C +                   Grav_I: 1 / Grav_F                    = 1 /9.81    s2/m    

                                                                               
      REAL, PARAMETER    ::  gravit = 9.81e0,      gravi2 = gravit**2 ,       &
     &                       grvinv = 1./gravit                       
!C +                   gravit: Earth Gravity Acceleration    = 9.81    m/s2    
!C +                   gravi2: idem (squared)                                  
!C +                   grvinv: idem (inverse)                 
! A1.3 Radiation
!----------------
      REAL,PARAMETER :: StefBo=5.67e-8  
!C +                   StefBo: Stefan-Boltzman Constant       =    5.67d-8 W/m2/K4

! A1.4 Thermodynamic 
!-----------------------------
     
      REAL, PARAMETER    ::  cp=1004.708845
                                                       
      REAL, PARAMETER    ::  RVapor=461.e0, Lv_H2O=2.5008e+6,&
     &                       Ls_H2O=2.8345e+6, r_LvCp=2490.04,r_LcCp=332.27,  &
     &                       r_LsCp=2822.31            
!C +                   cp    : dry air specific heat at constant p (1004 J/kg/K) 

      REAL, PARAMETER    ::  LhfH2O=3.34e+5, LhvH2O=2.5008e+6,&
     &                       LhsH2O=2.8345e+6     
      REAL, PARAMETER    ::  rhoWat=1000.00e0    
!C +                   rhoWat: Water Specific Mass            = 1000.00d+0 kg/m3 

      REAL, PARAMETER    ::  rhoIce=920.e0, BSnoRo=3.30e+2, frsno=300.0                             
!C +...                rhoIce:  Density      of Pure Ice      =  920.00d+0 kg/m3
!C +                   BSnoRo : Blowed Snow Density           =  255.00d+0 kg/m3 
                                                                                
      REAL, PARAMETER    ::  Tf_Sno=273.16e+0 
!C +...                Tf_Sno: Snow  Melting  Point           =  273.16    K     


      REAL, PARAMETER    ::  ro_Wat=1000.00e0, C__Wat=4186.00e0
!C +                   ro_Wat: Density       of Water         = 1000.00d+0 kg/m3 
!C +                   C__Wat: Heat Capacity of Water         = 4186.00d+0 J/kg/K
                                                                                
      REAL, PARAMETER    ::  ro_Ice=920.e0, cdice=2.10e0                                 
!C +...                ro_Ice:  Density      of Pure Ice       =  920.00d+0 kg/m3
!C +                   cdice :  Conductivity of Pure Ice       =    2.51d+0 W/m/K
                                                                                
      REAL, PARAMETER    ::  TfSnow=273.15e+0,csnow=2105.00e+0,r0sno=3.00e+1, &
     &                       blsno=3.30e+2,   Lf_H2O=3.337e+5                          
!C +...                TfSnow:        Snow melting Temperature=  273.15d+0 K     
!C +                    csnow:Heat Capacity of Snow             2105      J/kg/K 
!C +                         (Loth et al. 1993, JGR 98 D6, 2.2.2 2e para p.10453)
!C +                   r0sno : Fresh  Snow Density                50.00d+0 kg/m3 
!C +                   blsno : Blowed Snow Density               330.00d+0 kg/m3 
!C +                   Lf_H2O: Latent Heat of Fusion of Snow  =    3.34d+5 J/kg  

! A1.6 Turbulent and molecular diffusion
!----------------------------------------
      REAL, PARAMETER    ::  A_MolV = 1.35e-5, vonKrm = 0.40e0
!C +...                A_MolV: Air Viscosity                 = 1.35d-5 m2/s   
!C +                   vonKrm: von Karman constant           = 0.4            
                                                                          

END MODULE VARphy
