!
! $Header$
!

  subroutine conf_phys(ocean, ok_veget, ok_journe, ok_mensuel, ok_instan)

   use IOIPSL
   implicit none

!
! Configuration de la "physique" de LMDZ a l'aide de la fonction
! GETIN de IOIPSL
!
! LF 05/2001
!

!
! ocean:      type d'ocean (force, slab, couple)
! ok_veget:   type de modele de vegetation
! ok_journe:  sorties journalieres
! ok_mensuel: sorties mensuelles
! ok_instan:  sorties instantanees



! Sortie:
  character (len = 6)  :: ocean
  logical              :: ok_veget
  logical              :: ok_journe, ok_mensuel, ok_instan
! Local
  integer              :: numout = 6

!
!
!


!Config Key  = OCEAN 
!Config Desc = Type d'ocean
!Config Def  = force
!Config Help = Type d'ocean utilise: force, slab,couple
!
  ocean = 'force '
  call getin('OCEAN', ocean)
!
!Config Key  = VEGET 
!Config Desc = Type de modele de vegetation
!Config Def  = .false.
!Config Help = Type de modele de vegetation utilise
!
  ok_veget = .false.
  call getin('VEGET', ok_veget)
!
!Config Key  = OK_journe
!Config Desc = Pour des sorties journalieres 
!Config Def  = .false.
!Config Help = Pour creer le fichier histday contenant les sorties
!              journalieres 
!
  ok_journe = .false.
  call getin('OK_journe', ok_journe)
!
!Config Key  = OK_mensuel
!Config Desc = Pour des sorties mensuelles 
!Config Def  = .true.
!Config Help = Pour creer le fichier histmth contenant les sorties
!              mensuelles 
!
  ok_mensuel = .true.
  call getin('OK_mensuel', ok_mensuel)
!
!Config Key  = OK_instan
!Config Desc = Pour des sorties instantanees 
!Config Def  = .false.
!Config Help = Pour creer le fichier histins contenant les sorties
!              instantanees 
!
  ok_instan = .false.
  call getin('OK_instan', ok_instan)

!
!
!

  write(numout,*)' ##############################################'
  write(numout,*)' Configuration des parametres de la physique: '
  write(numout,*)' Config ocean = ', ocean
  write(numout,*)' Config veget = ', ok_veget
  write(numout,*)' Sortie journaliere = ', ok_journe
  write(numout,*)' Sortie mensuelle = ', ok_mensuel
  write(numout,*)' Sortie instantanee = ', ok_instan


  return

  end subroutine conf_phys

