      SUBROUTINE flumass_scal(pbaru,pbarv,w,v)
c%W%%G%
c=======================================================================
c
c   Author:    Frederic Hourdin      original: 17/02/93
c   -------
c
c   Subject:
c   ------
c   On ramene les flux de masse aux points scalaires.
c
c   Method:
c   --------
c
c   Interface:
c   ----------
c
c      Input:
c      ------
c
c      Output:
c      -------
c
c=======================================================================
      IMPLICIT NONE
c-----------------------------------------------------------------------
c   Declararations:
c   ---------------

#include "dimensions.h"
#include "paramet.h"
#include "comgeom.h"

c   Arguments:
c   ----------

      REAL pbaru(ip1jmp1,llm),pbarv(ip1jm,llm),w(ip1jmp1,llm)
      REAL v(ip1jmp1,llm,3)

c   Local:
c   ------

      INTEGER ij,l

c-----------------------------------------------------------------------

c   transport zonal:
c   ----------------
      DO l=1,llm
	 DO ij=2,ip1jmp1
            v(ij,l,1)=.5*(pbaru(ij,l)+pbaru(ij-1,l))
	 ENDDO
      ENDDO
      CALL SCOPY(jjp1*llm,v(iip1,1,1),iip1,v(1,1,1),iip1)

c   Transport meridien:
c   -------------------
      DO l=1,llm
         DO ij=iip2,ip1jm
	    v(ij,l,2)=.5*(pbarv(ij,l)+pbarv(ij-iip1,l))
	 ENDDO
	 DO ij=1,iip1
	    v(ij,l,2)=0.
	    v(ip1jm+ij,l,2)=0.
	 ENDDO
      ENDDO

c   Transport vertical:
c   -------------------
      DO l=1,llm-1
	 DO ij=1,ip1jmp1
	    v(ij,l,3)=.5*(w(ij,l)+w(ij,l+1))
	 ENDDO
      ENDDO
      DO ij=1,ip1jmp1
	 v(ij,llm,3)=.5*w(ij,llm)
      ENDDO

      RETURN
      END
