!
! $Id: aeropt_6bands_rrtm.F90 3425 2018-12-13 12:07:06Z fairhead $
!
SUBROUTINE AEROPT_6BANDS_RRTM ( &
     pdel, m_allaer, RHcl, &
     tau_allaer, piz_allaer, &
     cg_allaer, m_allaer_pi, &
     flag_aerosol, flag_bc_internal_mixture, zrho, ok_volcan )

  USE dimphy
  USE aero_mod
  USE YOMCST, ONLY: RG

  !    Yves Balkanski le 12 avril 2006
  !    Celine Deandreis
  !    Anne Cozic Avril 2009
  !    a partir d'une sous-routine de Johannes Quaas pour les sulfates
  !    Olivier Boucher fvrier 2014 pour passage  RRTM
  !    a partir des proprits optiques fournies par Yves Balkanski
  !
  IMPLICIT NONE
  ! 
  INCLUDE "clesphys.h"
  !
  ! Input arguments:
  !
  REAL, DIMENSION(klon,klev),     INTENT(IN)  :: pdel
  REAL, DIMENSION(klon,klev,naero_tot),   INTENT(IN)  :: m_allaer
  REAL, DIMENSION(klon,klev,naero_tot),   INTENT(IN)  :: m_allaer_pi
  REAL, DIMENSION(klon,klev),     INTENT(IN)  :: RHcl       ! humidite relative ciel clair
  INTEGER,                        INTENT(IN)  :: flag_aerosol
  LOGICAL,                        INTENT(IN)  :: flag_bc_internal_mixture
  REAL, DIMENSION(klon,klev),     INTENT(IN)  :: zrho
  LOGICAL,                        INTENT(IN)  :: ok_volcan ! volcanic diags
  !
  ! Output arguments:
  ! 2= total aerosols 
  ! 1= natural aerosols
  !
  REAL, DIMENSION(klon,klev,2,nbands_sw_rrtm), INTENT(OUT) :: tau_allaer ! epaisseur optique aerosol
  REAL, DIMENSION(klon,klev,2,nbands_sw_rrtm), INTENT(OUT) :: piz_allaer ! single scattering albedo aerosol
  REAL, DIMENSION(klon,klev,2,nbands_sw_rrtm), INTENT(OUT) :: cg_allaer  ! asymmetry parameter aerosol
  !
  ! Local
  !
  LOGICAL :: soluble
  INTEGER :: i, k,n, inu, m
  INTEGER :: spsol, spinsol
  INTEGER :: RH_num(klon,klev)

  INTEGER, PARAMETER :: nb_level=19 ! number of vertical levels in DATA

  INTEGER, PARAMETER :: naero_soluble=9    ! 1- BC soluble; 2- POM soluble; 3- SO4. acc. 4- SO4 coarse
                                           ! 5- seasalt super coarse  6- seasalt
                                           ! coarse  7- seasalt acc.
                                           ! 8- NO3 coarse 9- NO3 acc.
  INTEGER, PARAMETER :: naero_insoluble=4  ! 1- Dust; 2- BC insoluble; 3- POM insoluble; 4- NO3 insoluble

  INTEGER, PARAMETER :: nbre_RH=12
  REAL,PARAMETER :: RH_tab(nbre_RH)=(/0.,10.,20.,30.,40.,50.,60.,70.,80.,85.,90.,95./)
  REAL, PARAMETER :: RH_MAX=95.
  REAL :: delta(klon,klev), rh(klon,klev)
  REAL :: tau_ae2b_int   ! Intermediate computation of epaisseur optique aerosol
  REAL :: piz_ae2b_int   ! Intermediate computation of Single scattering albedo
  REAL :: cg_ae2b_int    ! Intermediate computation of Assymetry parameter
  REAL :: Fact_RH(nbre_RH)
  REAL :: fac
  REAL :: zdh(klon,klev) 
  INTEGER, ALLOCATABLE, DIMENSION(:) :: aerosol_name
  INTEGER :: nb_aer

  REAL, DIMENSION(klon,klev,naero_tot,nbands_sw_rrtm) :: tau_ae
  REAL, DIMENSION(klon,klev,naero_tot,nbands_sw_rrtm) :: piz_ae
  REAL, DIMENSION(klon,klev,naero_tot,nbands_sw_rrtm) :: cg_ae

  REAL, DIMENSION(klon,klev,naero_tot,nbands_sw_rrtm) :: tau_ae_pi
  REAL, DIMENSION(klon,klev,id_ASBCM_phy:id_ASBCM_phy,nbands_sw_rrtm) :: piz_ae_pi
  REAL, DIMENSION(klon,klev,id_ASBCM_phy:id_ASBCM_phy,nbands_sw_rrtm) :: cg_ae_pi
  !
  ! Proprietes optiques
  !
  REAL:: alpha_aers_6bands(nbre_RH,nbands_sw_rrtm,naero_soluble)   !--unit m2/g
  REAL:: alpha_aeri_6bands(nbands_sw_rrtm,naero_insoluble)         !--unit m2/g
  REAL:: cg_aers_6bands(nbre_RH,nbands_sw_rrtm,naero_soluble)      !--unitless
  REAL:: cg_aeri_6bands(nbands_sw_rrtm,naero_insoluble)            !--unitless
  REAL:: piz_aers_6bands(nbre_RH,nbands_sw_rrtm,naero_soluble)     !--unitless
  REAL:: piz_aeri_6bands(nbands_sw_rrtm,naero_insoluble)           !--unitless
  ! 
  ! BC internal mixture
  !
  INTEGER, PARAMETER ::  nbclassbc = 6  ! Added by Rong Wang/OB for the 5 fractions
                                        ! of BC in the soluble mode:
                                        ! bc_content/0.001, 0.01, 0.02, 0.05, 0.1, 0.2/
  ! for Maxwell-Garnet internal mixture
  ! Detailed theory can be found in R. Wang Estimation of global black carbon direct
  ! radiative forcing and its uncertainty constrained by observations. J.
  ! Geophys. Res. Atmos. Added by R. Wang and OB
  REAL :: alpha_MG_6bands(nbre_RH,nbands_sw_rrtm,nbclassbc)
  REAL :: cg_MG_6bands(nbre_RH,nbands_sw_rrtm,nbclassbc)
  REAL :: piz_MG_6bands(nbre_RH,nbands_sw_rrtm,nbclassbc)
  !
  INTEGER :: aerindex, classbc, classbc_pi
  REAL :: tmp_var, tmp_var_pi, BC_massfra, BC_massfra_pi
  CHARACTER*20 :: modname
  !
  REAL, PARAMETER :: tau_min = 1.e-7

!***************************************************************************
!--the order of the soluble   species has to follow the spsol   index below
!--the order of the insoluble species has to follow the spinsol index below

  DATA alpha_aers_6bands/  & 
   ! BC Accumulation Soluble (AS)     
  5.276, 5.276, 5.276, 5.276, 5.276, 5.797, 6.353, 7.568, 8.779, 8.920, 9.062,10.403, &
  5.371, 5.371, 5.371, 5.371, 5.371, 5.870, 6.401, 7.559, 8.720, 8.857, 8.994,10.298, &
  5.126, 5.126, 5.126, 5.126, 5.126, 5.572, 6.043, 7.073, 8.113, 8.235, 8.359, 9.544, &
  4.225, 4.225, 4.225, 4.225, 4.225, 4.549, 4.887, 5.624, 6.370, 6.459, 6.548, 7.412, &
  2.667, 2.667, 2.667, 2.667, 2.667, 2.840, 3.015, 3.382, 3.745, 3.788, 3.832, 4.251, &
  1.113, 1.113, 1.113, 1.113, 1.113, 1.210, 1.307, 1.506, 1.699, 1.721, 1.744, 1.961, &
   ! POM Accumulation Soluble (AS)    
  5.962, 5.962, 5.962, 5.962, 5.962, 6.544, 7.153, 8.460, 9.732, 9.877,10.026,11.398, &
  5.609, 5.609, 5.609, 5.609, 5.609, 6.163, 6.752, 8.041, 9.324, 9.473, 9.624,11.044, &
  4.527, 4.527, 4.527, 4.527, 4.527, 4.982, 5.476, 6.586, 7.726, 7.861, 7.998, 9.306, &
  2.697, 2.697, 2.697, 2.697, 2.697, 2.980, 3.293, 4.017, 4.790, 4.884, 4.979, 5.902, &
  0.918, 0.918, 0.918, 0.918, 0.918, 1.025, 1.146, 1.435, 1.754, 1.794, 1.834, 2.232, &
  0.105, 0.105, 0.105, 0.105, 0.105, 0.154, 0.211, 0.344, 0.491, 0.509, 0.528, 0.710, &
  ! Sulfate Coarse Soluble (CS)      
  0.670, 0.670, 0.670, 0.670, 0.905, 0.981, 1.081, 1.217, 1.434, 1.615, 1.940, 2.773, &
  0.689, 0.689, 0.689, 0.689, 0.930, 1.009, 1.110, 1.247, 1.469, 1.655, 1.980, 2.825, &
  0.726, 0.726, 0.726, 0.726, 0.978, 1.060, 1.164, 1.306, 1.533, 1.723, 2.056, 2.915, &
  0.785, 0.785, 0.785, 0.785, 1.056, 1.144, 1.254, 1.406, 1.650, 1.852, 2.203, 3.103, &
  0.795, 0.795, 0.795, 0.795, 1.064, 1.160, 1.282, 1.449, 1.720, 1.945, 2.340, 3.348, &
  0.502, 0.502, 0.502, 0.502, 0.656, 0.728, 0.820, 0.950, 1.170, 1.360, 1.706, 2.666, &
   !-- Sulfate Accumulation (BC content=0)
  5.246, 5.246, 5.246, 5.246, 7.041, 7.658, 8.437, 9.503,11.204,12.608,15.030,21.080, &
  4.924, 4.924, 4.924, 4.924, 6.619, 7.258, 8.067, 9.186,10.998,12.507,15.142,21.822, &
  3.925, 3.925, 3.925, 3.925, 5.304, 5.888, 6.635, 7.686, 9.433,10.921,13.587,20.659, &
  2.248, 2.248, 2.248, 2.248, 3.079, 3.477, 3.993, 4.738, 6.022, 7.153, 9.261,15.301, &
  0.720, 0.720, 0.720, 0.720, 1.014, 1.169, 1.374, 1.678, 2.225, 2.726, 3.703, 6.779, &
  0.069, 0.069, 0.069, 0.069, 0.102, 0.121, 0.146, 0.185, 0.258, 0.328, 0.472, 0.974, &
   ! Seasalt Super Coarse Soluble (SS)
  0.189, 0.232, 0.249, 0.270, 0.293, 0.322, 0.361, 0.425, 0.536, 0.634, 0.813, 1.250, &
  0.192, 0.235, 0.252, 0.274, 0.296, 0.325, 0.365, 0.429, 0.542, 0.639, 0.821, 1.259, &
  0.196, 0.240, 0.257, 0.279, 0.302, 0.331, 0.371, 0.437, 0.550, 0.649, 0.832, 1.274, &
  0.204, 0.249, 0.267, 0.289, 0.313, 0.342, 0.384, 0.450, 0.565, 0.666, 0.851, 1.300, &
  0.222, 0.270, 0.289, 0.313, 0.338, 0.369, 0.413, 0.482, 0.602, 0.705, 0.896, 1.355, &
  0.244, 0.293, 0.313, 0.338, 0.364, 0.397, 0.443, 0.517, 0.646, 0.757, 0.960, 1.443, &
   ! Seasalt Coarse Soluble (CS)      
  0.547, 0.657, 0.705, 0.754, 0.817, 0.896, 1.008, 1.169, 1.456, 1.724, 2.199, 3.358, &
  0.566, 0.679, 0.727, 0.776, 0.840, 0.920, 1.032, 1.196, 1.492, 1.760, 2.238, 3.416, &
  0.596, 0.714, 0.764, 0.816, 0.882, 0.965, 1.081, 1.250, 1.552, 1.828, 2.310, 3.509, &
  0.644, 0.771, 0.825, 0.880, 0.951, 1.040, 1.164, 1.345, 1.666, 1.957, 2.462, 3.700, &
  0.640, 0.772, 0.829, 0.887, 0.965, 1.061, 1.198, 1.398, 1.758, 2.085, 2.658, 4.031, &
  0.452, 0.562, 0.609, 0.659, 0.728, 0.813, 0.938, 1.125, 1.471, 1.797, 2.384, 3.855, &
   ! Seasalt Accumulation Soluble (AS)
  4.270, 5.032, 5.395, 5.772, 6.158, 6.768, 7.510, 8.634,10.695,12.512,15.740,23.122, &
  3.952, 4.673, 5.030, 5.403, 5.781, 6.399, 7.156, 8.328,10.533,12.524,16.091,24.329, &
  3.090, 3.676, 3.979, 4.301, 4.622, 5.172, 5.853, 6.941, 9.077,11.083,14.830,23.951, &
  1.710, 2.069, 2.262, 2.471, 2.678, 3.048, 3.513, 4.285, 5.882, 7.467,10.618,19.102, &
  0.529, 0.663, 0.737, 0.819, 0.901, 1.050, 1.244, 1.575, 2.301, 3.067, 4.704, 9.712, &
  0.073, 0.142, 0.177, 0.215, 0.259, 0.328, 0.422, 0.579, 0.913, 1.263, 2.011, 4.358, &
   ! Nitrate Coarse Soluble (CS)      
  0.688, 0.688, 0.688, 0.755, 0.826, 0.900, 0.994, 1.190, 1.501, 1.804, 2.251, 2.374, &
  0.712, 0.712, 0.712, 0.781, 0.853, 0.929, 1.023, 1.225, 1.540, 1.846, 2.299, 2.421, &
  0.754, 0.754, 0.754, 0.826, 0.902, 0.980, 1.077, 1.286, 1.612, 1.925, 2.388, 2.509, &
  0.809, 0.809, 0.809, 0.887, 0.969, 1.053, 1.160, 1.384, 1.732, 2.069, 2.557, 2.685, &
  0.786, 0.786, 0.786, 0.867, 0.952, 1.043, 1.157, 1.403, 1.793, 2.171, 2.725, 2.871, &
  0.703, 0.703, 0.703, 0.767, 0.836, 0.909, 1.002, 1.210, 1.552, 1.901, 2.434, 2.579, &
   ! Nitrate Accumulation Soluble (AS)
  5.251, 5.251, 5.251, 5.779, 6.336, 6.920, 7.655, 9.230,11.678,14.026,17.391,18.279, &
  4.643, 4.643, 4.643, 5.152, 5.696, 6.276, 7.016, 8.640,11.238,13.787,17.511,18.494, &
  3.373, 3.373, 3.373, 3.790, 4.245, 4.739, 5.383, 6.842, 9.289,11.804,15.637,16.675, &
  1.779, 1.779, 1.779, 2.029, 2.309, 2.619, 3.033, 4.008, 5.746, 7.645,10.730,11.601, &
  0.549, 0.549, 0.549, 0.639, 0.742, 0.859, 1.019, 1.412, 2.157, 3.029, 4.552, 5.002, &
  0.367, 0.367, 0.367, 0.416, 0.471, 0.532, 0.614, 0.808, 1.166, 1.575, 2.281, 2.489  /

  DATA piz_aers_6bands/&
   ! BC Accumulation Soluble (AS)     
  0.480, 0.480, 0.480, 0.480, 0.480, 0.487, 0.495, 0.513, 0.530, 0.532, 0.534, 0.553, &
  0.469, 0.469, 0.469, 0.469, 0.469, 0.474, 0.480, 0.497, 0.514, 0.517, 0.519, 0.538, &
  0.456, 0.456, 0.456, 0.456, 0.456, 0.464, 0.473, 0.495, 0.519, 0.522, 0.524, 0.550, &
  0.427, 0.427, 0.427, 0.427, 0.427, 0.437, 0.448, 0.476, 0.505, 0.509, 0.512, 0.543, &
  0.349, 0.349, 0.349, 0.349, 0.349, 0.358, 0.369, 0.396, 0.425, 0.429, 0.432, 0.465, &
  0.196, 0.196, 0.196, 0.196, 0.196, 0.198, 0.202, 0.213, 0.226, 0.227, 0.229, 0.243, &
   ! POM Accumulation Soluble (AS)    
  0.956, 0.956, 0.956, 0.956, 0.956, 0.961, 0.964, 0.970, 0.974, 0.975, 0.975, 0.978, &
  0.965, 0.965, 0.965, 0.965, 0.965, 0.969, 0.972, 0.977, 0.980, 0.980, 0.981, 0.983, &
  0.969, 0.969, 0.969, 0.969, 0.969, 0.972, 0.975, 0.979, 0.983, 0.983, 0.983, 0.986, &
  0.953, 0.953, 0.953, 0.953, 0.953, 0.958, 0.962, 0.969, 0.974, 0.975, 0.975, 0.979, &
  0.892, 0.892, 0.892, 0.892, 0.892, 0.902, 0.912, 0.928, 0.940, 0.942, 0.943, 0.952, &
  0.826, 0.826, 0.826, 0.826, 0.826, 0.658, 0.568, 0.479, 0.444, 0.442, 0.439, 0.426, &
   ! Sulfate Coarse Soluble (CS)      
  1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, &
  1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, &
  1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, &
  1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, &
  1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, &
  1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, &
   !-- Sulfate Accumulation (BC content=0)
  1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, &
  1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, &
  1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, &
  1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, &
  1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, &
  1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, &
   ! Seasalt Super Coarse Soluble (SS)
  1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, &
  1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, &
  1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, &
  0.999, 0.999, 0.999, 0.999, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, &
  0.983, 0.985, 0.986, 0.987, 0.987, 0.988, 0.988, 0.989, 0.989, 0.989, 0.989, 0.989, &
  0.957, 0.792, 0.765, 0.740, 0.721, 0.704, 0.687, 0.670, 0.652, 0.643, 0.631, 0.617, &
   ! Seasalt Coarse Soluble (CS)      
  1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.001, 1.000, &
  1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, &
  1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, &
  1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, &
  0.994, 0.994, 0.995, 0.995, 0.995, 0.995, 0.996, 0.996, 0.996, 0.996, 0.996, 0.996, &
  0.976, 0.867, 0.837, 0.814, 0.796, 0.774, 0.754, 0.735, 0.713, 0.702, 0.690, 0.675, &
   ! Seasalt Accumulation Soluble (AS)
  1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, &
  1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, &
  1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, &
  1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, &
  0.995, 0.996, 0.996, 0.996, 0.997, 0.997, 0.997, 0.998, 0.998, 0.998, 0.998, 0.999, &
  0.919, 0.607, 0.553, 0.515, 0.480, 0.455, 0.434, 0.421, 0.421, 0.429, 0.449, 0.492, &
   ! Nitrate Coarse Soluble (CS)      
  1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, &
  1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, &
  1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, &
  1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, &
  0.999, 0.999, 0.999, 0.999, 0.999, 0.999, 0.998, 0.998, 0.998, 0.998, 0.998, 0.998, &
  0.707, 0.707, 0.707, 0.705, 0.702, 0.699, 0.697, 0.692, 0.686, 0.683, 0.679, 0.678, &
   ! Nitrate Accumulation Soluble (AS)
  1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, &
  1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, &
  1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, &
  1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000, &
  0.999, 0.999, 0.999, 0.999, 0.999, 0.999, 0.999, 0.999, 0.999, 0.999, 0.999, 0.999, &
  0.362, 0.362, 0.362, 0.362, 0.363, 0.365, 0.367, 0.375, 0.390, 0.406, 0.428, 0.434  /

  DATA cg_aers_6bands/ &
   ! BC Accumulation Soluble (AS)     
  0.820, 0.820, 0.820, 0.820, 0.820, 0.831, 0.840, 0.852, 0.859, 0.860, 0.860, 0.864, &
  0.760, 0.760, 0.760, 0.760, 0.760, 0.777, 0.791, 0.812, 0.826, 0.827, 0.828, 0.837, &
  0.695, 0.695, 0.695, 0.695, 0.695, 0.716, 0.734, 0.762, 0.780, 0.782, 0.784, 0.797, &
  0.603, 0.603, 0.603, 0.603, 0.603, 0.628, 0.649, 0.685, 0.710, 0.712, 0.715, 0.734, &
  0.469, 0.469, 0.469, 0.469, 0.469, 0.494, 0.518, 0.559, 0.590, 0.593, 0.597, 0.622, &
  0.276, 0.276, 0.276, 0.276, 0.276, 0.292, 0.308, 0.337, 0.361, 0.364, 0.367, 0.389, &
   ! POM Accumulation Soluble (AS)    
  0.687, 0.687, 0.687, 0.687, 0.687, 0.700, 0.711, 0.729, 0.740, 0.741, 0.742, 0.750, &
  0.685, 0.685, 0.685, 0.685, 0.685, 0.699, 0.712, 0.731, 0.744, 0.745, 0.747, 0.756, &
  0.673, 0.673, 0.673, 0.673, 0.673, 0.689, 0.702, 0.724, 0.739, 0.741, 0.742, 0.754, &
  0.637, 0.637, 0.637, 0.637, 0.637, 0.653, 0.667, 0.691, 0.709, 0.711, 0.712, 0.726, &
  0.553, 0.553, 0.553, 0.553, 0.553, 0.568, 0.582, 0.607, 0.628, 0.630, 0.632, 0.649, &
  0.340, 0.340, 0.340, 0.340, 0.340, 0.350, 0.361, 0.382, 0.400, 0.402, 0.404, 0.422, &
   ! Sulfate Coarse Soluble (CS)      
  0.746, 0.746, 0.746, 0.746, 0.779, 0.785, 0.790, 0.796, 0.804, 0.810, 0.816, 0.830, &
  0.730, 0.730, 0.730, 0.730, 0.764, 0.770, 0.775, 0.782, 0.791, 0.797, 0.806, 0.819, &
  0.707, 0.707, 0.707, 0.707, 0.746, 0.752, 0.758, 0.765, 0.775, 0.781, 0.790, 0.805, &
  0.691, 0.691, 0.691, 0.691, 0.736, 0.741, 0.747, 0.754, 0.763, 0.769, 0.778, 0.791, &
  0.696, 0.696, 0.696, 0.696, 0.748, 0.753, 0.759, 0.767, 0.776, 0.781, 0.789, 0.800, &
  0.711, 0.711, 0.711, 0.711, 0.766, 0.773, 0.782, 0.791, 0.803, 0.811, 0.822, 0.838, &
   !-- Sulfate Accumulation (BC content=0)
  0.674, 0.674, 0.674, 0.674, 0.724, 0.729, 0.735, 0.741, 0.749, 0.753, 0.760, 0.769, &
  0.677, 0.677, 0.677, 0.677, 0.729, 0.734, 0.740, 0.747, 0.756, 0.761, 0.768, 0.777, &
  0.671, 0.671, 0.671, 0.671, 0.723, 0.730, 0.737, 0.746, 0.757, 0.764, 0.773, 0.786, &
  0.638, 0.638, 0.638, 0.638, 0.691, 0.700, 0.710, 0.721, 0.736, 0.746, 0.760, 0.781, &
  0.553, 0.553, 0.553, 0.553, 0.604, 0.616, 0.629, 0.644, 0.665, 0.680, 0.700, 0.736, &
  0.344, 0.344, 0.344, 0.344, 0.388, 0.401, 0.416, 0.435, 0.462, 0.482, 0.512, 0.571, &
   ! Seasalt Super Coarse Soluble (SS)
  0.795, 0.810, 0.814, 0.819, 0.824, 0.829, 0.832, 0.840, 0.846, 0.849, 0.854, 0.860, &
  0.788, 0.804, 0.808, 0.813, 0.818, 0.823, 0.828, 0.834, 0.842, 0.847, 0.851, 0.858, &
  0.775, 0.792, 0.797, 0.803, 0.808, 0.813, 0.820, 0.826, 0.835, 0.840, 0.846, 0.854, &
  0.754, 0.773, 0.779, 0.785, 0.791, 0.796, 0.803, 0.811, 0.821, 0.827, 0.834, 0.844, &
  0.735, 0.755, 0.761, 0.768, 0.774, 0.779, 0.786, 0.794, 0.804, 0.810, 0.817, 0.829, &
  0.712, 0.782, 0.795, 0.808, 0.819, 0.829, 0.840, 0.852, 0.865, 0.873, 0.882, 0.895, &
   ! Seasalt Coarse Soluble (CS)      
  0.754, 0.770, 0.776, 0.781, 0.784, 0.791, 0.797, 0.805, 0.815, 0.822, 0.828, 0.840, &
  0.736, 0.753, 0.759, 0.765, 0.771, 0.778, 0.785, 0.793, 0.804, 0.811, 0.820, 0.831, &
  0.716, 0.735, 0.742, 0.748, 0.754, 0.762, 0.769, 0.778, 0.789, 0.796, 0.807, 0.819, &
  0.704, 0.725, 0.733, 0.739, 0.745, 0.752, 0.759, 0.768, 0.778, 0.784, 0.792, 0.803, &
  0.716, 0.737, 0.744, 0.751, 0.756, 0.763, 0.770, 0.777, 0.786, 0.790, 0.795, 0.800, &
  0.688, 0.730, 0.741, 0.751, 0.761, 0.771, 0.782, 0.795, 0.810, 0.820, 0.833, 0.849, &
   ! Seasalt Accumulation Soluble (AS)
  0.686, 0.711, 0.719, 0.726, 0.733, 0.740, 0.748, 0.755, 0.763, 0.767, 0.770, 0.774, &
  0.690, 0.716, 0.724, 0.731, 0.739, 0.747, 0.756, 0.764, 0.774, 0.778, 0.782, 0.784, &
  0.683, 0.710, 0.719, 0.727, 0.735, 0.744, 0.754, 0.765, 0.777, 0.784, 0.791, 0.797, &
  0.649, 0.676, 0.686, 0.695, 0.704, 0.714, 0.726, 0.739, 0.757, 0.768, 0.781, 0.797, &
  0.559, 0.586, 0.596, 0.606, 0.616, 0.629, 0.643, 0.661, 0.686, 0.703, 0.726, 0.758, &
  0.341, 0.358, 0.366, 0.375, 0.382, 0.395, 0.408, 0.428, 0.459, 0.484, 0.520, 0.581, &
   ! Nitrate Coarse Soluble (CS)      
  0.765, 0.765, 0.765, 0.773, 0.779, 0.785, 0.791, 0.803, 0.813, 0.819, 0.827, 0.828, &
  0.754, 0.754, 0.754, 0.762, 0.769, 0.774, 0.781, 0.790, 0.802, 0.810, 0.817, 0.818, &
  0.743, 0.743, 0.743, 0.751, 0.758, 0.763, 0.770, 0.779, 0.789, 0.797, 0.804, 0.806, &
  0.737, 0.737, 0.737, 0.745, 0.752, 0.758, 0.764, 0.773, 0.781, 0.786, 0.792, 0.793, &
  0.739, 0.739, 0.739, 0.749, 0.757, 0.763, 0.770, 0.779, 0.788, 0.793, 0.797, 0.798, &
  0.651, 0.651, 0.651, 0.672, 0.690, 0.707, 0.724, 0.751, 0.779, 0.796, 0.813, 0.817, &
   ! Nitrate Accumulation Soluble (AS)
  0.713, 0.713, 0.713, 0.723, 0.732, 0.739, 0.746, 0.756, 0.765, 0.769, 0.772, 0.772, &
  0.724, 0.724, 0.724, 0.734, 0.742, 0.750, 0.757, 0.767, 0.777, 0.782, 0.785, 0.785, &
  0.719, 0.719, 0.719, 0.729, 0.738, 0.746, 0.754, 0.767, 0.780, 0.787, 0.793, 0.794, &
  0.673, 0.673, 0.673, 0.685, 0.696, 0.706, 0.717, 0.734, 0.753, 0.766, 0.778, 0.781, &
  0.565, 0.565, 0.565, 0.580, 0.593, 0.605, 0.619, 0.644, 0.673, 0.693, 0.716, 0.720, &
  0.328, 0.328, 0.328, 0.338, 0.348, 0.359, 0.371, 0.396, 0.431, 0.459, 0.494, 0.502  /

  DATA alpha_aeri_6bands/  & 
   ! Dust insoluble
  0.735, 0.765, 0.817, 0.846, 0.718, 0.414, &
   ! BC insoluble 
  5.276, 5.371, 5.126, 4.225, 2.667, 1.113, &
   ! POM insoluble
  5.962, 5.609, 4.527, 2.697, 0.918, 0.105, &
   ! Nitrate insoluble
  0.688, 0.712, 0.754, 0.809, 0.786, 0.703 /

  DATA piz_aeri_6bands/ &
   ! Dust insoluble
  0.894, 0.902, 0.937, 0.980, 0.993, 0.967, &
   ! BC insoluble 
  0.820, 0.760, 0.695, 0.603, 0.469, 0.276, &
   ! POM insoluble
  0.687, 0.685, 0.673, 0.637, 0.553, 0.340, &
   ! Nitrate insoluble
  1.000, 1.000, 1.000, 1.000, 0.999, 0.707 /

  DATA cg_aeri_6bands/ &
   ! Dust insoluble
  0.756, 0.737, 0.713, 0.701, 0.696, 0.672, &
   ! BC insoluble 
  0.480, 0.469, 0.456, 0.427, 0.349, 0.196, &
   ! POM insoluble
  0.956, 0.965, 0.969, 0.953, 0.892, 0.826, &
   ! Nitrate insoluble
  0.765, 0.754, 0.743, 0.737, 0.739, 0.651 /

! Added by R. Wang (July 31 2016)
! properties for BC assuming Maxwell-Garnett rule and internal mixture

   DATA alpha_MG_6bands/ &
 !--BC content=0.001
   3.546,  3.546,  3.546,  3.546,  3.640,  3.891,  3.883,  4.354,  4.967,  5.424,  6.412,  9.049, &
   3.995,  3.995,  3.995,  3.995,  4.073,  4.091,  4.111,  4.209,  4.502,  4.878,  5.591,  8.029, &
   4.650,  4.650,  4.650,  4.650,  4.661,  4.561,  4.472,  4.386,  4.373,  4.451,  4.726,  6.248, &
   4.445,  4.445,  4.445,  4.445,  4.393,  4.291,  4.171,  4.017,  3.812,  3.682,  3.514,  3.593, &
   2.837,  2.837,  2.837,  2.837,  2.824,  2.798,  2.760,  2.696,  2.579,  2.471,  2.265,  1.735, &
   1.087,  1.087,  1.087,  1.087,  1.095,  1.101,  1.107,  1.110,  1.109,  1.101,  1.074,  0.944, &
 !--BC content=0.010
   3.550,  3.550,  3.550,  3.550,  3.623,  3.852,  4.006,  4.342,  4.945,  5.381,  6.394,  8.972, &
   3.995,  3.995,  3.995,  3.995,  4.082,  4.094,  4.133,  4.235,  4.517,  4.871,  5.601,  8.001, &
   4.653,  4.653,  4.653,  4.653,  4.662,  4.564,  4.475,  4.393,  4.376,  4.447,  4.736,  6.221, &
   4.434,  4.434,  4.434,  4.434,  4.386,  4.286,  4.170,  4.021,  3.815,  3.680,  3.524,  3.583, &
   2.831,  2.831,  2.831,  2.831,  2.820,  2.795,  2.757,  2.695,  2.579,  2.472,  2.270,  1.734, &
   1.086,  1.086,  1.086,  1.086,  1.095,  1.101,  1.106,  1.110,  1.108,  1.101,  1.075,  0.944, &
 !--BC content=0.020
   3.549,  3.549,  3.549,  3.549,  3.630,  3.842,  4.016,  4.335,  4.928,  5.383,  6.369,  8.937, &
   4.004,  4.004,  4.004,  4.004,  4.096,  4.100,  4.145,  4.243,  4.529,  4.870,  5.595,  7.973, &
   4.650,  4.650,  4.650,  4.650,  4.662,  4.564,  4.478,  4.397,  4.379,  4.449,  4.734,  6.207, &
   4.422,  4.422,  4.422,  4.422,  4.378,  4.280,  4.167,  4.020,  3.817,  3.683,  3.527,  3.583, &
   2.824,  2.824,  2.824,  2.824,  2.815,  2.791,  2.754,  2.693,  2.579,  2.472,  2.272,  1.740, &
   1.085,  1.085,  1.085,  1.085,  1.094,  1.100,  1.105,  1.109,  1.108,  1.100,  1.075,  0.945, &
 !--BC content=0.050
   3.563,  3.563,  3.563,  3.563,  3.662,  3.834,  4.019,  4.318,  4.889,  5.360,  6.305,  8.842, &
   4.039,  4.039,  4.039,  4.039,  4.130,  4.126,  4.166,  4.261,  4.544,  4.863,  5.573,  7.895, &
   4.641,  4.641,  4.641,  4.641,  4.659,  4.565,  4.483,  4.407,  4.389,  4.455,  4.731,  6.161, &
   4.388,  4.388,  4.388,  4.388,  4.356,  4.264,  4.157,  4.017,  3.821,  3.691,  3.537,  3.582, &
   2.805,  2.805,  2.805,  2.805,  2.801,  2.779,  2.744,  2.687,  2.577,  2.474,  2.279,  1.757, &
   1.081,  1.081,  1.081,  1.081,  1.091,  1.098,  1.103,  1.107,  1.106,  1.099,  1.074,  0.949, &
 !--BC content=0.100
   3.607,  3.607,  3.607,  3.607,  3.701,  3.843,  4.021,  4.302,  4.841,  5.306,  6.214,  8.689, &
   4.098,  4.098,  4.098,  4.098,  4.175,  4.168,  4.201,  4.291,  4.554,  4.854,  5.529,  7.763, &
   4.627,  4.627,  4.627,  4.627,  4.651,  4.567,  4.490,  4.421,  4.403,  4.464,  4.723,  6.082, &
   4.333,  4.333,  4.333,  4.333,  4.319,  4.236,  4.139,  4.011,  3.828,  3.704,  3.554,  3.580, &
   2.773,  2.773,  2.773,  2.773,  2.778,  2.758,  2.727,  2.675,  2.573,  2.476,  2.291,  1.786, &
   1.076,  1.076,  1.076,  1.076,  1.087,  1.094,  1.099,  1.103,  1.103,  1.097,  1.073,  0.954, &
 !--BC content=0.200
   3.702,  3.702,  3.702,  3.702,  3.768,  3.878,  4.030,  4.278,  4.757,  5.190,  6.032,  8.370, &
   4.204,  4.204,  4.204,  4.204,  4.255,  4.246,  4.270,  4.345,  4.571,  4.837,  5.440,  7.494, &
   4.598,  4.598,  4.598,  4.598,  4.633,  4.565,  4.502,  4.445,  4.428,  4.481,  4.706,  5.923, &
   4.230,  4.230,  4.230,  4.230,  4.244,  4.179,  4.101,  3.996,  3.838,  3.728,  3.588,  3.581, &
   2.710,  2.710,  2.710,  2.710,  2.730,  2.716,  2.693,  2.651,  2.564,  2.480,  2.314,  1.846, &
   1.064,  1.064,  1.064,  1.064,  1.078,  1.085,  1.091,  1.096,  1.097,  1.091,  1.072,  0.965  /
   
   DATA piz_MG_6bands/ &
 !--BC content=0.001
  -3.984, -3.984, -3.984, -3.984, -3.395, -3.075, -3.051, -2.567, -2.053, -1.807, -1.308, -0.592, &
  -3.014, -3.014, -3.014, -3.014, -2.520, -2.473, -2.411, -2.294, -2.027, -1.771, -1.368, -0.613, &
  -1.142, -1.142, -1.142, -1.142, -0.930, -0.961, -0.981, -1.001, -0.981, -0.934, -0.798, -0.337, &
  -0.202, -0.202, -0.202, -0.202, -0.129, -0.154, -0.183, -0.224, -0.284, -0.326, -0.383, -0.347, &
   0.133,  0.133,  0.133,  0.133,  0.158,  0.146,  0.131,  0.107,  0.061,  0.015, -0.081, -0.433, &
   0.137,  0.137,  0.137,  0.137,  0.148,  0.149,  0.149,  0.147,  0.139,  0.128,  0.098, -0.048, &
 !--BC content=0.010
  -3.640, -3.640, -3.640, -3.640, -3.219, -2.942, -2.761, -2.445, -1.983, -1.731, -1.262, -0.576, &
  -2.791, -2.791, -2.791, -2.791, -2.383, -2.352, -2.290, -2.180, -1.943, -1.707, -1.321, -0.595, &
  -1.069, -1.069, -1.069, -1.069, -0.889, -0.920, -0.945, -0.966, -0.954, -0.910, -0.775, -0.333, &
  -0.185, -0.185, -0.185, -0.185, -0.119, -0.144, -0.173, -0.213, -0.275, -0.318, -0.372, -0.346, &
   0.138,  0.138,  0.138,  0.138,  0.160,  0.149,  0.134,  0.110,  0.063,  0.018, -0.076, -0.430, &
   0.137,  0.137,  0.137,  0.137,  0.148,  0.149,  0.150,  0.148,  0.140,  0.129,  0.099, -0.046, &
 !--BC content=0.020
  -3.369, -3.369, -3.369, -3.369, -3.033, -2.799, -2.619, -2.339, -1.913, -1.657, -1.223, -0.558, &
  -2.592, -2.592, -2.592, -2.592, -2.254, -2.239, -2.185, -2.091, -1.869, -1.652, -1.284, -0.580, &
  -1.004, -1.004, -1.004, -1.004, -0.849, -0.882, -0.909, -0.932, -0.926, -0.885, -0.758, -0.326, &
  -0.168, -0.168, -0.168, -0.168, -0.108, -0.133, -0.163, -0.203, -0.265, -0.309, -0.364, -0.341, &
   0.142,  0.142,  0.142,  0.142,  0.163,  0.152,  0.137,  0.113,  0.066,  0.022, -0.072, -0.422, &
   0.138,  0.138,  0.138,  0.138,  0.149,  0.150,  0.150,  0.148,  0.140,  0.129,  0.100, -0.044, &
 !--BC content=0.050
  -2.743, -2.743, -2.743, -2.743, -2.582, -2.438, -2.292, -2.078, -1.729, -1.495, -1.123, -0.512, &
  -2.121, -2.121, -2.121, -2.121, -1.939, -1.951, -1.926, -1.865, -1.688, -1.511, -1.188, -0.541, &
  -0.839, -0.839, -0.839, -0.839, -0.742, -0.780, -0.812, -0.842, -0.848, -0.818, -0.707, -0.307, &
  -0.121, -0.121, -0.121, -0.121, -0.078, -0.103, -0.133, -0.174, -0.236, -0.281, -0.337, -0.325, &
   0.154,  0.154,  0.154,  0.154,  0.171,  0.160,  0.145,  0.121,  0.075,  0.032, -0.060, -0.399, &
   0.141,  0.141,  0.141,  0.141,  0.150,  0.151,  0.152,  0.150,  0.142,  0.131,  0.103, -0.038, &
 !--BC content=0.100
  -2.025, -2.025, -2.025, -2.025, -2.035, -1.965, -1.875, -1.731, -1.475, -1.285, -0.980, -0.447, &
  -1.569, -1.569, -1.569, -1.569, -1.540, -1.572, -1.580, -1.557, -1.444, -1.312, -1.052, -0.485, &
  -0.628, -0.628, -0.628, -0.628, -0.593, -0.634, -0.672, -0.710, -0.732, -0.716, -0.631, -0.279, &
  -0.054, -0.054, -0.054, -0.054, -0.032, -0.058, -0.088, -0.129, -0.191, -0.236, -0.295, -0.299, &
   0.173,  0.173,  0.173,  0.173,  0.184,  0.173,  0.158,  0.135,  0.090,  0.048, -0.039, -0.361, &
   0.145,  0.145,  0.145,  0.145,  0.153,  0.154,  0.154,  0.152,  0.144,  0.134,  0.107, -0.027, &
 !--BC content=0.200
  -1.155, -1.155, -1.155, -1.155, -1.300, -1.295, -1.272, -1.213, -1.077, -0.957, -0.747, -0.336, &
  -0.884, -0.884, -0.884, -0.884, -0.979, -1.028, -1.065, -1.086, -1.054, -0.986, -0.820, -0.388, &
  -0.332, -0.332, -0.332, -0.332, -0.360, -0.402, -0.444, -0.490, -0.531, -0.536, -0.492, -0.225, &
   0.050,  0.050,  0.050,  0.050,  0.048,  0.022, -0.007, -0.047, -0.107, -0.152, -0.213, -0.245, &
   0.204,  0.204,  0.204,  0.204,  0.208,  0.197,  0.182,  0.161,  0.120,  0.081,  0.002, -0.285, &
   0.153,  0.153,  0.153,  0.153,  0.159,  0.159,  0.159,  0.157,  0.150,  0.140,  0.115, -0.005  /
   
   DATA cg_MG_6bands/ &
 !--BC content=0.001
   0.290,  0.290,  0.290,  0.290,  0.378,  0.381,  0.377,  0.378,  0.373,  0.344,  0.317,  0.118, &
   0.374,  0.374,  0.374,  0.374,  0.469,  0.474,  0.480,  0.480,  0.475,  0.462,  0.438,  0.242, &
   0.375,  0.375,  0.375,  0.375,  0.491,  0.502,  0.517,  0.527,  0.534,  0.529,  0.508,  0.255, &
   0.242,  0.242,  0.242,  0.242,  0.455,  0.516,  0.577,  0.631,  0.687,  0.715,  0.748,  0.772, &
   0.559,  0.559,  0.559,  0.559,  0.487,  0.461,  0.410,  0.303, -0.181, -3.594,  1.814,  1.164, &
   0.323,  0.323,  0.323,  0.323,  0.339,  0.339,  0.337,  0.328,  0.295,  0.243,  0.045,  2.778, &
 !--BC content=0.010
   0.300,  0.300,  0.300,  0.300,  0.385,  0.389,  0.390,  0.386,  0.377,  0.353,  0.319,  0.116, &
   0.384,  0.384,  0.384,  0.384,  0.478,  0.482,  0.488,  0.488,  0.483,  0.471,  0.442,  0.246, &
   0.380,  0.380,  0.380,  0.380,  0.496,  0.507,  0.520,  0.531,  0.538,  0.534,  0.512,  0.259, &
   0.233,  0.233,  0.233,  0.233,  0.454,  0.520,  0.581,  0.636,  0.691,  0.719,  0.752,  0.778, &
   0.553,  0.553,  0.553,  0.553,  0.487,  0.461,  0.414,  0.308, -0.144, -2.858,  1.889,  1.165, &
   0.323,  0.323,  0.323,  0.323,  0.338,  0.339,  0.337,  0.328,  0.295,  0.244,  0.051,  2.847, &
 !--BC content=0.020
   0.305,  0.305,  0.305,  0.305,  0.391,  0.394,  0.395,  0.390,  0.380,  0.358,  0.321,  0.112, &
   0.391,  0.391,  0.391,  0.391,  0.484,  0.488,  0.493,  0.493,  0.488,  0.476,  0.445,  0.246, &
   0.384,  0.384,  0.384,  0.384,  0.499,  0.511,  0.524,  0.534,  0.541,  0.537,  0.514,  0.260, &
   0.219,  0.219,  0.219,  0.219,  0.451,  0.523,  0.586,  0.642,  0.696,  0.724,  0.756,  0.783, &
   0.547,  0.547,  0.547,  0.547,  0.487,  0.461,  0.416,  0.315, -0.108, -2.308,  1.954,  1.170, &
   0.322,  0.322,  0.322,  0.322,  0.338,  0.339,  0.337,  0.328,  0.296,  0.245,  0.056,  2.949, &
 !--BC content=0.050
   0.312,  0.312,  0.312,  0.312,  0.400,  0.402,  0.403,  0.398,  0.385,  0.364,  0.321,  0.094, &
   0.402,  0.402,  0.402,  0.402,  0.495,  0.498,  0.503,  0.503,  0.496,  0.484,  0.451,  0.242, &
   0.388,  0.388,  0.388,  0.388,  0.506,  0.518,  0.530,  0.541,  0.548,  0.544,  0.521,  0.259, &
   0.152,  0.152,  0.152,  0.152,  0.434,  0.527,  0.599,  0.658,  0.711,  0.738,  0.768,  0.794, &
   0.534,  0.534,  0.534,  0.534,  0.486,  0.463,  0.423,  0.332, -0.018, -1.355,  2.203,  1.188, &
   0.321,  0.321,  0.321,  0.321,  0.337,  0.338,  0.336,  0.328,  0.297,  0.249,  0.071,  3.311, &
 !--BC content=0.100
   0.309,  0.309,  0.309,  0.309,  0.404,  0.405,  0.406,  0.401,  0.385,  0.364,  0.316,  0.057, &
   0.406,  0.406,  0.406,  0.406,  0.503,  0.507,  0.511,  0.512,  0.504,  0.491,  0.456,  0.232, &
   0.382,  0.382,  0.382,  0.382,  0.510,  0.523,  0.537,  0.548,  0.555,  0.551,  0.528,  0.255, &
  -0.178, -0.178, -0.178, -0.178,  0.312,  0.524,  0.626,  0.692,  0.741,  0.765,  0.791,  0.816, &
   0.519,  0.519,  0.519,  0.519,  0.486,  0.466,  0.432,  0.357,  0.091, -0.650,  2.968,  1.221, &
   0.319,  0.319,  0.319,  0.319,  0.336,  0.337,  0.335,  0.328,  0.300,  0.255,  0.094,  4.314, &
 !--BC content=0.200
   0.267,  0.267,  0.267,  0.267,  0.388,  0.391,  0.392,  0.387,  0.370,  0.345,  0.287, -0.053, &
   0.381,  0.381,  0.381,  0.381,  0.499,  0.506,  0.512,  0.514,  0.507,  0.494,  0.455,  0.198, &
   0.318,  0.318,  0.318,  0.318,  0.494,  0.515,  0.535,  0.551,  0.561,  0.559,  0.535,  0.237, &
   1.151,  1.151,  1.151,  1.151,  0.703,  0.643,  1.248,  0.874,  0.846,  0.846,  0.853,  0.868, &
   0.502,  0.502,  0.502,  0.502,  0.486,  0.472,  0.447,  0.393,  0.226, -0.108,-43.753,  1.313, &
   0.315,  0.315,  0.315,  0.315,  0.332,  0.334,  0.333,  0.327,  0.304,  0.266,  0.135, 21.079  /

!----BEGINNING OF CALCULATIONS

  modname='aeropt_6bands_rrtm'

  spsol = 0
  spinsol = 0 

  IF (NSW.NE.nbands_sw_rrtm) THEN
    CALL abort_physic(modname,'Erreur NSW doit etre egal a 6 pour cette routine',1)
  ENDIF

  zdh(:,:)=pdel(:,:)/(RG*zrho(:,:))      ! m

  IF (flag_aerosol .EQ. 1) THEN 
     nb_aer = 2
     ALLOCATE (aerosol_name(nb_aer)) 
     aerosol_name(1) = id_ASSO4M_phy
     aerosol_name(2) = id_CSSO4M_phy
  ELSEIF (flag_aerosol .EQ. 2) THEN
     nb_aer = 2
     ALLOCATE (aerosol_name(nb_aer)) 
     aerosol_name(1) = id_ASBCM_phy
     aerosol_name(2) = id_AIBCM_phy
  ELSEIF (flag_aerosol .EQ. 3) THEN 
     nb_aer = 2
     ALLOCATE (aerosol_name(nb_aer)) 
     aerosol_name(1) = id_ASPOMM_phy
     aerosol_name(2) = id_AIPOMM_phy
  ELSEIF (flag_aerosol .EQ. 4) THEN 
     nb_aer = 3
     ALLOCATE (aerosol_name(nb_aer)) 
     aerosol_name(1) = id_CSSSM_phy
     aerosol_name(2) = id_SSSSM_phy
     aerosol_name(3) = id_ASSSM_phy
  ELSEIF (flag_aerosol .EQ. 5) THEN 
     nb_aer = 1
     ALLOCATE (aerosol_name(nb_aer)) 
     aerosol_name(1) = id_CIDUSTM_phy
  ELSEIF (flag_aerosol .EQ. 6 .OR. flag_aerosol .EQ. 7 ) THEN 
     nb_aer = 13
     ALLOCATE (aerosol_name(nb_aer)) 
     aerosol_name(1) = id_ASSO4M_phy      
     aerosol_name(2) = id_ASBCM_phy
     aerosol_name(3) = id_AIBCM_phy
     aerosol_name(4) = id_ASPOMM_phy
     aerosol_name(5) = id_AIPOMM_phy
     aerosol_name(6) = id_CSSSM_phy
     aerosol_name(7) = id_SSSSM_phy
     aerosol_name(8) = id_ASSSM_phy
     aerosol_name(9) = id_CIDUSTM_phy
     aerosol_name(10)= id_CSSO4M_phy
     aerosol_name(11)= id_CSNO3M_phy
     aerosol_name(12)= id_ASNO3M_phy
     aerosol_name(13)= id_CINO3M_phy
  ENDIF

  !
  ! loop over modes, use of precalculated nmd and corresponding sigma
  !    loop over wavelengths
  !    for each mass species in mode
  !      interpolate from Sext to retrieve Sext_at_gridpoint_per_species
  !      compute optical_thickness_at_gridpoint_per_species

  DO n=1,nbre_RH-1
    fact_RH(n)=1./(RH_tab(n+1)-RH_tab(n))
  ENDDO
   
  DO k=1, klev
    DO i=1, klon
      rh(i,k)=MIN(RHcl(i,k)*100.,RH_MAX)
      RH_num(i,k) = INT(rh(i,k)/10. + 1.)
      IF (rh(i,k).GT.85.) RH_num(i,k)=10
      IF (rh(i,k).GT.90.) RH_num(i,k)=11
      delta(i,k)=(rh(i,k)-RH_tab(RH_num(i,k)))*fact_RH(RH_num(i,k))
    ENDDO
  ENDDO

  tau_ae(:,:,:,:)=0.
  piz_ae(:,:,:,:)=0.
  cg_ae(:,:,:,:)=0.

  tau_ae_pi(:,:,:,:)=0.
  piz_ae_pi(:,:,:,:)=0.
  cg_ae_pi(:,:,:,:)=0.
    
  DO m=1,nb_aer   ! tau is only computed for each mass
     fac=1.0
     IF (aerosol_name(m).EQ.id_ASBCM_phy) THEN
        soluble=.TRUE.
        spsol=1
     ELSEIF (aerosol_name(m).EQ.id_ASPOMM_phy) THEN 
        soluble=.TRUE.
        spsol=2 
     ELSEIF (aerosol_name(m).EQ.id_CSSO4M_phy) THEN 
        soluble=.TRUE.
        spsol=3
        !fac=1.375    ! (NH4)2-SO4/SO4 132/96 mass conversion factor for AOD
        fac=0.0      !--6 March 2017 - OB as Didier H said CSSO4 should not be used
     ELSEIF  (aerosol_name(m).EQ.id_ASSO4M_phy) THEN
        soluble=.TRUE.
        spsol=4
        fac=1.375    ! (NH4)2-SO4/SO4 132/96 mass conversion factor for AOD
     ELSEIF (aerosol_name(m).EQ.id_SSSSM_phy) THEN 
         soluble=.TRUE.
         spsol=5
     ELSEIF (aerosol_name(m).EQ.id_CSSSM_phy) THEN 
         soluble=.TRUE.
         spsol=6
     ELSEIF (aerosol_name(m).EQ.id_ASSSM_phy) THEN
         soluble=.TRUE.
         spsol=7
     ELSEIF (aerosol_name(m).EQ.id_CSNO3M_phy) THEN
         soluble=.TRUE.
         spsol=8
         fac=1.2903    ! NO3NH4/NO3 / mass conversion factor for AOD
     ELSEIF (aerosol_name(m).EQ.id_ASNO3M_phy) THEN
         soluble=.TRUE.
         spsol=9
         fac=1.2903    ! NO3NH4/NO3 / mass conversion factor for AOD
     ELSEIF (aerosol_name(m).EQ.id_CIDUSTM_phy) THEN 
         soluble=.FALSE.
         spinsol=1
     ELSEIF  (aerosol_name(m).EQ.id_AIBCM_phy) THEN 
         soluble=.FALSE.
         spinsol=2
     ELSEIF (aerosol_name(m).EQ.id_AIPOMM_phy) THEN 
         soluble=.FALSE.
         spinsol=3
     ELSEIF (aerosol_name(m).EQ.id_CINO3M_phy) THEN
         soluble=.FALSE.
         spinsol=4
         fac=1.2903    ! NO3NH4/NO3 / mass conversion factor for AOD
     ELSE 
         CYCLE
     ENDIF

    !--shortname for aerosol index
    aerindex=aerosol_name(m)

    IF (soluble) THEN

       !--here we treat the special case of soluble BC internal mixture with Maxwell-Garnett rule
       IF (spsol.EQ.1 .AND. flag_bc_internal_mixture) THEN

         DO k=1, klev
           DO i=1, klon

             tmp_var=m_allaer(i,k,aerindex)/1.e6*zdh(i,k)*fac
             tmp_var_pi=m_allaer_pi(i,k,aerindex)/1.e6*zdh(i,k)*fac

             ! Calculate the dry BC/(BC+SUL) mass ratio for all (natural+anthropogenic) aerosols
             BC_massfra = m_allaer(i,k,id_ASBCM_phy)/(m_allaer(i,k,id_ASBCM_phy)+m_allaer(i,k,id_ASSO4M_phy))

             IF (BC_massfra.GE.0.20) THEN
               classbc = 6
             ELSEIF (BC_massfra.GE.0.10) THEN
               classbc = 5
             ELSEIF  (BC_massfra.GE.0.05) THEN
               classbc = 4
             ELSEIF  (BC_massfra.GE.0.02) THEN
               classbc = 3
             ELSEIF  (BC_massfra.GE.0.01) THEN
               classbc = 2
             ELSE
               classbc = 1
             ENDIF

             ! Calculate the dry BC/(BC+SUL) mass ratio for natural aerosols
             BC_massfra_pi = m_allaer_pi(i,k,id_ASBCM_phy)/(m_allaer_pi(i,k,id_ASBCM_phy)+m_allaer_pi(i,k,id_ASSO4M_phy))

             IF (BC_massfra_pi.GE.0.20) THEN
               classbc_pi = 6
             ELSEIF (BC_massfra_pi.GE.0.10) THEN
               classbc_pi = 5
             ELSEIF  (BC_massfra_pi.GE.0.05) THEN
               classbc_pi = 4
             ELSEIF  (BC_massfra_pi.GE.0.02) THEN
               classbc_pi = 3
             ELSEIF  (BC_massfra_pi.GE.0.01) THEN
               classbc_pi = 2
             ELSE
               classbc_pi = 1
             ENDIF

             DO inu=1, NSW

               !--all aerosols
               tau_ae2b_int= alpha_MG_6bands(RH_num(i,k),inu,classbc)+                 &
                             delta(i,k)* (alpha_MG_6bands(RH_num(i,k)+1,inu,classbc) - & 
                             alpha_MG_6bands(RH_num(i,k),inu,classbc))
                   
               piz_ae2b_int = piz_MG_6bands(RH_num(i,k),inu,classbc) +                 &
                              delta(i,k)* (piz_MG_6bands(RH_num(i,k)+1,inu,classbc) -  &
                              piz_MG_6bands(RH_num(i,k),inu,classbc))
                   
               cg_ae2b_int = cg_MG_6bands(RH_num(i,k),inu,classbc) +                   & 
                             delta(i,k)* (cg_MG_6bands(RH_num(i,k)+1,inu,classbc) -    &
                             cg_MG_6bands(RH_num(i,k),inu,classbc))

               tau_ae(i,k,aerindex,inu)    = tmp_var*tau_ae2b_int
               piz_ae(i,k,aerindex,inu)    = piz_ae2b_int
               cg_ae(i,k,aerindex,inu)     = cg_ae2b_int

               !--natural aerosols
               tau_ae2b_int= alpha_MG_6bands(RH_num(i,k),inu,classbc_pi)+                 &
                             delta(i,k)* (alpha_MG_6bands(RH_num(i,k)+1,inu,classbc_pi) - & 
                             alpha_MG_6bands(RH_num(i,k),inu,classbc_pi))
                   
               piz_ae2b_int = piz_MG_6bands(RH_num(i,k),inu,classbc_pi) +                 &
                              delta(i,k)* (piz_MG_6bands(RH_num(i,k)+1,inu,classbc_pi) -  &
                              piz_MG_6bands(RH_num(i,k),inu,classbc_pi))
                   
               cg_ae2b_int = cg_MG_6bands(RH_num(i,k),inu,classbc_pi) +                   &
                             delta(i,k)* (cg_MG_6bands(RH_num(i,k)+1,inu,classbc_pi) -    &
                             cg_MG_6bands(RH_num(i,k),inu,classbc_pi))

               tau_ae_pi(i,k,aerindex,inu) = tmp_var_pi* tau_ae2b_int
               piz_ae_pi(i,k,aerindex,inu) = piz_ae2b_int
               cg_ae_pi(i,k,aerindex,inu)  = cg_ae2b_int
                        
             ENDDO
           ENDDO
         ENDDO

       !--else treat all other cases of soluble aerosols
       ELSE

         DO k=1, klev
           DO i=1, klon
             tmp_var=m_allaer(i,k,aerindex)/1.e6*zdh(i,k)*fac
             tmp_var_pi=m_allaer_pi(i,k,aerindex)/1.e6*zdh(i,k)*fac

             DO inu=1, NSW

               tau_ae2b_int= alpha_aers_6bands(RH_num(i,k),inu,spsol)+ & 
                             delta(i,k)* (alpha_aers_6bands(RH_num(i,k)+1,inu,spsol) - & 
                             alpha_aers_6bands(RH_num(i,k),inu,spsol))
                   
               piz_ae2b_int = piz_aers_6bands(RH_num(i,k),inu,spsol) + & 
                            delta(i,k)* (piz_aers_6bands(RH_num(i,k)+1,inu,spsol) - & 
                              piz_aers_6bands(RH_num(i,k),inu,spsol))
                   
               cg_ae2b_int = cg_aers_6bands(RH_num(i,k),inu,spsol) + & 
                             delta(i,k)* (cg_aers_6bands(RH_num(i,k)+1,inu,spsol) - & 
                             cg_aers_6bands(RH_num(i,k),inu,spsol))

               tau_ae(i,k,aerindex,inu)    = tmp_var*tau_ae2b_int
               tau_ae_pi(i,k,aerindex,inu) = tmp_var_pi* tau_ae2b_int
               piz_ae(i,k,aerindex,inu)    = piz_ae2b_int
               cg_ae(i,k,aerindex,inu)     = cg_ae2b_int
                        
             ENDDO
           ENDDO
         ENDDO

         !--external mixture case for soluble BC
         IF (spsol.EQ.1) THEN
           piz_ae_pi(:,:,aerindex,:) = piz_ae(:,:,aerindex,:)
           cg_ae_pi(:,:,aerindex,:)  = cg_ae(:,:,aerindex,:)
         ENDIF

       ENDIF
        
     ELSE    ! For all aerosol insoluble components

       DO k=1, klev
         DO i=1, klon
           tmp_var=m_allaer(i,k,aerindex)/1.e6*zdh(i,k)*fac
           tmp_var_pi=m_allaer_pi(i,k,aerindex)/1.e6*zdh(i,k)*fac

           DO inu=1, NSW
             tau_ae2b_int = alpha_aeri_6bands(inu,spinsol)
             piz_ae2b_int = piz_aeri_6bands(inu,spinsol)
             cg_ae2b_int = cg_aeri_6bands(inu,spinsol) 

             tau_ae(i,k,aerindex,inu) = tmp_var*tau_ae2b_int
             tau_ae_pi(i,k,aerindex,inu) = tmp_var_pi*tau_ae2b_int
             piz_ae(i,k,aerindex,inu) = piz_ae2b_int
             cg_ae(i,k,aerindex,inu)= cg_ae2b_int
           ENDDO
         ENDDO
       ENDDO

     ENDIF ! soluble / insoluble

  ENDDO  ! nb_aer  

  DO inu=1, NSW 
     DO k=1, klev
       DO i=1, klon
!--all (natural + anthropogenic) aerosol
         tau_allaer(i,k,2,inu)=tau_ae(i,k,id_ASSO4M_phy,inu)+tau_ae(i,k,id_CSSO4M_phy,inu)+ &
                               tau_ae(i,k,id_ASBCM_phy,inu)+tau_ae(i,k,id_AIBCM_phy,inu)+   &
                               tau_ae(i,k,id_ASPOMM_phy,inu)+tau_ae(i,k,id_AIPOMM_phy,inu)+ &
                               tau_ae(i,k,id_ASSSM_phy,inu)+tau_ae(i,k,id_CSSSM_phy,inu)+   &
                               tau_ae(i,k,id_SSSSM_phy,inu)+ tau_ae(i,k,id_CIDUSTM_phy,inu)
         tau_allaer(i,k,2,inu)=MAX(tau_allaer(i,k,2,inu),tau_min)

         piz_allaer(i,k,2,inu)=(tau_ae(i,k,id_ASSO4M_phy,inu)*piz_ae(i,k,id_ASSO4M_phy,inu)+   &
                                tau_ae(i,k,id_CSSO4M_phy,inu)*piz_ae(i,k,id_CSSO4M_phy,inu)+   &
                                tau_ae(i,k,id_ASBCM_phy,inu)*piz_ae(i,k,id_ASBCM_phy,inu)+     &
                                tau_ae(i,k,id_AIBCM_phy,inu)*piz_ae(i,k,id_AIBCM_phy,inu)+     &
                                tau_ae(i,k,id_ASPOMM_phy,inu)*piz_ae(i,k,id_ASPOMM_phy,inu)+   &
                                tau_ae(i,k,id_AIPOMM_phy,inu)*piz_ae(i,k,id_AIPOMM_phy,inu)+   &
                                tau_ae(i,k,id_ASSSM_phy,inu)*piz_ae(i,k,id_ASSSM_phy,inu)+     &
                                tau_ae(i,k,id_CSSSM_phy,inu)*piz_ae(i,k,id_CSSSM_phy,inu)+     &
                                tau_ae(i,k,id_SSSSM_phy,inu)*piz_ae(i,k,id_SSSSM_phy,inu)+     &
                                tau_ae(i,k,id_CIDUSTM_phy,inu)*piz_ae(i,k,id_CIDUSTM_phy,inu)) &
                                /tau_allaer(i,k,2,inu)
         piz_allaer(i,k,2,inu)=MIN(MAX(piz_allaer(i,k,2,inu),0.01),1.0)
         IF (tau_allaer(i,k,2,inu).LE.tau_min) piz_allaer(i,k,2,inu)=1.0

         cg_allaer(i,k,2,inu)=(tau_ae(i,k,id_ASSO4M_phy,inu)*piz_ae(i,k,id_ASSO4M_phy,inu)*cg_ae(i,k,id_ASSO4M_phy,inu)+ &
                               tau_ae(i,k,id_CSSO4M_phy,inu)*piz_ae(i,k,id_CSSO4M_phy,inu)*cg_ae(i,k,id_CSSO4M_phy,inu)+ &
                               tau_ae(i,k,id_ASBCM_phy,inu)*piz_ae(i,k,id_ASBCM_phy,inu)*cg_ae(i,k,id_ASBCM_phy,inu)+    &
                               tau_ae(i,k,id_AIBCM_phy,inu)*piz_ae(i,k,id_AIBCM_phy,inu)*cg_ae(i,k,id_AIBCM_phy,inu)+    &
                               tau_ae(i,k,id_ASPOMM_phy,inu)*piz_ae(i,k,id_ASPOMM_phy,inu)*cg_ae(i,k,id_ASPOMM_phy,inu)+ &
                               tau_ae(i,k,id_AIPOMM_phy,inu)*piz_ae(i,k,id_AIPOMM_phy,inu)*cg_ae(i,k,id_AIPOMM_phy,inu)+ &
                               tau_ae(i,k,id_ASSSM_phy,inu)*piz_ae(i,k,id_ASSSM_phy,inu)*cg_ae(i,k,id_ASSSM_phy,inu)+    &
                               tau_ae(i,k,id_CSSSM_phy,inu)*piz_ae(i,k,id_CSSSM_phy,inu)*cg_ae(i,k,id_CSSSM_phy,inu)+    &
                               tau_ae(i,k,id_SSSSM_phy,inu)*piz_ae(i,k,id_SSSSM_phy,inu)*cg_ae(i,k,id_SSSSM_phy,inu)+    &
                               tau_ae(i,k,id_CIDUSTM_phy,inu)*piz_ae(i,k,id_CIDUSTM_phy,inu)*cg_ae(i,k,id_CIDUSTM_phy,inu))/ &
                               (tau_allaer(i,k,2,inu)*piz_allaer(i,k,2,inu))
         cg_allaer(i,k,2,inu)=MIN(MAX(cg_allaer(i,k,2,inu),0.0),1.0)

!--natural aerosol
!--ASBCM aerosols take _pi value because of internal mixture option
         IF(.not. ok_volcan) THEN
         tau_allaer(i,k,1,inu)=tau_ae_pi(i,k,id_ASSO4M_phy,inu)+tau_ae_pi(i,k,id_CSSO4M_phy,inu)+ &
                               tau_ae_pi(i,k,id_ASBCM_phy,inu)+tau_ae_pi(i,k,id_AIBCM_phy,inu)+   &
                               tau_ae_pi(i,k,id_ASPOMM_phy,inu)+tau_ae_pi(i,k,id_AIPOMM_phy,inu)+ &
                               tau_ae_pi(i,k,id_ASSSM_phy,inu)+tau_ae_pi(i,k,id_CSSSM_phy,inu)+   &
                               tau_ae_pi(i,k,id_SSSSM_phy,inu)+ tau_ae_pi(i,k,id_CIDUSTM_phy,inu)
         tau_allaer(i,k,1,inu)=MAX(tau_allaer(i,k,1,inu),tau_min)
         
         piz_allaer(i,k,1,inu)=(tau_ae_pi(i,k,id_ASSO4M_phy,inu)*piz_ae(i,k,id_ASSO4M_phy,inu)+   &
                                tau_ae_pi(i,k,id_CSSO4M_phy,inu)*piz_ae(i,k,id_CSSO4M_phy,inu)+   &
                                tau_ae_pi(i,k,id_ASBCM_phy,inu)*piz_ae_pi(i,k,id_ASBCM_phy,inu)+  &
                                tau_ae_pi(i,k,id_AIBCM_phy,inu)*piz_ae(i,k,id_AIBCM_phy,inu)+     &
                                tau_ae_pi(i,k,id_ASPOMM_phy,inu)*piz_ae(i,k,id_ASPOMM_phy,inu)+   &
                                tau_ae_pi(i,k,id_AIPOMM_phy,inu)*piz_ae(i,k,id_AIPOMM_phy,inu)+   &
                                tau_ae_pi(i,k,id_ASSSM_phy,inu)*piz_ae(i,k,id_ASSSM_phy,inu)+     &
                                tau_ae_pi(i,k,id_CSSSM_phy,inu)*piz_ae(i,k,id_CSSSM_phy,inu)+     &
                                tau_ae_pi(i,k,id_SSSSM_phy,inu)*piz_ae(i,k,id_SSSSM_phy,inu)+     &
                                tau_ae_pi(i,k,id_CIDUSTM_phy,inu)*piz_ae(i,k,id_CIDUSTM_phy,inu)) &
                                /tau_allaer(i,k,1,inu)
         piz_allaer(i,k,1,inu)=MIN(MAX(piz_allaer(i,k,1,inu),0.01),1.0)
         IF (tau_allaer(i,k,1,inu).LE.tau_min) piz_allaer(i,k,1,inu)=1.0
         
         cg_allaer(i,k,1,inu)=(tau_ae_pi(i,k,id_ASSO4M_phy,inu)*piz_ae(i,k,id_ASSO4M_phy,inu)*cg_ae(i,k,id_ASSO4M_phy,inu)+    &
                               tau_ae_pi(i,k,id_CSSO4M_phy,inu)*piz_ae(i,k,id_CSSO4M_phy,inu)*cg_ae(i,k,id_CSSO4M_phy,inu)+    &
                               tau_ae_pi(i,k,id_ASBCM_phy,inu)*piz_ae_pi(i,k,id_ASBCM_phy,inu)*cg_ae_pi(i,k,id_ASBCM_phy,inu)+ &
                               tau_ae_pi(i,k,id_AIBCM_phy,inu)*piz_ae(i,k,id_AIBCM_phy,inu)*cg_ae(i,k,id_AIBCM_phy,inu)+       &
                               tau_ae_pi(i,k,id_ASPOMM_phy,inu)*piz_ae(i,k,id_ASPOMM_phy,inu)*cg_ae(i,k,id_ASPOMM_phy,inu)+    &
                               tau_ae_pi(i,k,id_AIPOMM_phy,inu)*piz_ae(i,k,id_AIPOMM_phy,inu)*cg_ae(i,k,id_AIPOMM_phy,inu)+    &
                               tau_ae_pi(i,k,id_ASSSM_phy,inu)*piz_ae(i,k,id_ASSSM_phy,inu)*cg_ae(i,k,id_ASSSM_phy,inu)+       &
                               tau_ae_pi(i,k,id_CSSSM_phy,inu)*piz_ae(i,k,id_CSSSM_phy,inu)*cg_ae(i,k,id_CSSSM_phy,inu)+       &
                               tau_ae_pi(i,k,id_SSSSM_phy,inu)*piz_ae(i,k,id_SSSSM_phy,inu)*cg_ae(i,k,id_SSSSM_phy,inu)+       &
                               tau_ae_pi(i,k,id_CIDUSTM_phy,inu)*piz_ae(i,k,id_CIDUSTM_phy,inu)*cg_ae(i,k,id_CIDUSTM_phy,inu))/ &
                               (tau_allaer(i,k,1,inu)*piz_allaer(i,k,1,inu))
         cg_allaer(i,k,1,inu)=MIN(MAX(cg_allaer(i,k,1,inu),0.0),1.0)
         ELSE
! (same as upper but no volc aer in strat)
            tau_allaer(i,k,1,inu)=tau_ae(i,k,id_ASSO4M_phy,inu)+tau_ae(i,k,id_CSSO4M_phy,inu)+ &
                               tau_ae(i,k,id_ASBCM_phy,inu)+tau_ae(i,k,id_AIBCM_phy,inu)+   &
                               tau_ae(i,k,id_ASPOMM_phy,inu)+tau_ae(i,k,id_AIPOMM_phy,inu)+ &
                               tau_ae(i,k,id_ASSSM_phy,inu)+tau_ae(i,k,id_CSSSM_phy,inu)+   &
                               tau_ae(i,k,id_SSSSM_phy,inu)+ tau_ae(i,k,id_CIDUSTM_phy,inu)
            tau_allaer(i,k,1,inu)=MAX(tau_allaer(i,k,1,inu),tau_min)
            
            piz_allaer(i,k,1,inu)=(tau_ae(i,k,id_ASSO4M_phy,inu)*piz_ae(i,k,id_ASSO4M_phy,inu)+   &
                                tau_ae(i,k,id_CSSO4M_phy,inu)*piz_ae(i,k,id_CSSO4M_phy,inu)+   &
                                tau_ae(i,k,id_ASBCM_phy,inu)*piz_ae(i,k,id_ASBCM_phy,inu)+     &
                                tau_ae(i,k,id_AIBCM_phy,inu)*piz_ae(i,k,id_AIBCM_phy,inu)+     &
                                tau_ae(i,k,id_ASPOMM_phy,inu)*piz_ae(i,k,id_ASPOMM_phy,inu)+   &
                                tau_ae(i,k,id_AIPOMM_phy,inu)*piz_ae(i,k,id_AIPOMM_phy,inu)+   &
                                tau_ae(i,k,id_ASSSM_phy,inu)*piz_ae(i,k,id_ASSSM_phy,inu)+     &
                                tau_ae(i,k,id_CSSSM_phy,inu)*piz_ae(i,k,id_CSSSM_phy,inu)+     &
                                tau_ae(i,k,id_SSSSM_phy,inu)*piz_ae(i,k,id_SSSSM_phy,inu)+     &
                                tau_ae(i,k,id_CIDUSTM_phy,inu)*piz_ae(i,k,id_CIDUSTM_phy,inu)) &
                                /tau_allaer(i,k,1,inu)
            piz_allaer(i,k,1,inu)=MIN(MAX(piz_allaer(i,k,1,inu),0.01),1.0)
            IF (tau_allaer(i,k,1,inu).LE.tau_min) piz_allaer(i,k,1,inu)=1.0
            
            cg_allaer(i,k,1,inu)=(tau_ae(i,k,id_ASSO4M_phy,inu)*piz_ae(i,k,id_ASSO4M_phy,inu)*cg_ae(i,k,id_ASSO4M_phy,inu)+ &
                               tau_ae(i,k,id_CSSO4M_phy,inu)*piz_ae(i,k,id_CSSO4M_phy,inu)*cg_ae(i,k,id_CSSO4M_phy,inu)+ &
                               tau_ae(i,k,id_ASBCM_phy,inu)*piz_ae(i,k,id_ASBCM_phy,inu)*cg_ae(i,k,id_ASBCM_phy,inu)+    &
                               tau_ae(i,k,id_AIBCM_phy,inu)*piz_ae(i,k,id_AIBCM_phy,inu)*cg_ae(i,k,id_AIBCM_phy,inu)+    &
                               tau_ae(i,k,id_ASPOMM_phy,inu)*piz_ae(i,k,id_ASPOMM_phy,inu)*cg_ae(i,k,id_ASPOMM_phy,inu)+ &
                               tau_ae(i,k,id_AIPOMM_phy,inu)*piz_ae(i,k,id_AIPOMM_phy,inu)*cg_ae(i,k,id_AIPOMM_phy,inu)+ &
                               tau_ae(i,k,id_ASSSM_phy,inu)*piz_ae(i,k,id_ASSSM_phy,inu)*cg_ae(i,k,id_ASSSM_phy,inu)+    &
                               tau_ae(i,k,id_CSSSM_phy,inu)*piz_ae(i,k,id_CSSSM_phy,inu)*cg_ae(i,k,id_CSSSM_phy,inu)+    &
                               tau_ae(i,k,id_SSSSM_phy,inu)*piz_ae(i,k,id_SSSSM_phy,inu)*cg_ae(i,k,id_SSSSM_phy,inu)+    &
                               tau_ae(i,k,id_CIDUSTM_phy,inu)*piz_ae(i,k,id_CIDUSTM_phy,inu)*cg_ae(i,k,id_CIDUSTM_phy,inu))/ &
                               (tau_allaer(i,k,1,inu)*piz_allaer(i,k,1,inu))
            cg_allaer(i,k,1,inu)=MIN(MAX(cg_allaer(i,k,1,inu),0.0),1.0)
         ENDIF
        ENDDO
      ENDDO
    ENDDO
   
  DEALLOCATE(aerosol_name) 

END SUBROUTINE AEROPT_6BANDS_RRTM
