      SUBROUTINE cal_br_st(nx,im,jm,px,paire,pxav,pxst)
      IMPLICIT NONE

c=======================================================================
c
c   Auteur:    Frederic Hourdin         01/01/91
c   -------
c
c   Objet:     Decomposition d'un champ meteorologique  sous 
c   ------         x   =  < x >  +   x'
c              ou < x > est la moyenne zonale du champ
c
c              en fait pour un champ x(nlong,nlat) on n'effectue la
c              moyenne que sur les nomg-1 premiere longitude
c
c   Interface:
c   ----------
c
c   Input:
c   ------
c
c      nlong              nombre de longitude
c      nlat               nombre de latitudes a decomposer
c      px(nlong,nlat)     champ d'entre
c
c   Output:
c   -------
c
c      pxav(nlong,nlat)   champ moyen
c      pxst(nlong,nlat)   ecart a la moyenne
c
c=======================================================================

c-----------------------------------------------------------------------
c   0.Declarations:
c   ---------------

c   Arguments:
c   ----------

#include "dimensions.h"
      INTEGER im,jm,nx
      REAL paire(im+1,jm)
      REAL px(im+1,jm,nx),pxav(jm,nx),pxst(im+1,jm,nx)

c   Local:
c   ------

      REAL znorm(jjm+1)
      INTEGER i,j,ix
      EXTERNAL SSUM
      REAL SSUM

c-----------------------------------------------------------------------
c   1. Initialisations:
c   -------------------

c-----------------------------------------------------------------------
c   2. Calcul du champ moyen:
c   -------------------------

      DO j=1,jm
         znorm(j)=1./SSUM(iim,paire(1,j),1)
      ENDDO
      DO ix=1,nx
         DO j=1,jm
            pxav(j,ix)=0.
            DO i=1,im
               pxav(j,ix)=pxav(j,ix)+paire(i,j)*px(i,j,ix)
            ENDDO
            pxav(j,ix)=pxav(j,ix)*znorm(j)
         ENDDO
      ENDDO

c-----------------------------------------------------------------------
c   3. Ecart a la moyenne:
c   ----------------------

      DO ix=1,nx
         DO j=1,jm
            DO i=1,im
               pxst(i,j,ix)=px(i,j,ix)-pxav(j,ix)
            ENDDO
         ENDDO
      ENDDO

c-----------------------------------------------------------------------

      RETURN
      END
