      SUBROUTINE advection
     $ (ucov,vcov,h,pext,pks,pksf,phis,phi,conser,du,dv,dh,dp)
      IMPLICIT NONE

c=======================================================================
c
c  P. Le Van
c
c   Objet:
c   ------
c
c   Calcul des tendances dynamiques.
c
c=======================================================================

c-----------------------------------------------------------------------
c   0. Declarations:
c   ----------------

#include "dimensions.h"
#include "paramet.h"
#include "comconst.h"
#include "comvert.h"
#include "comgeom.h"

c   Arguments:
c   ----------

      LOGICAL conser

      REAL vcov(ip1jm,llm),ucov(ip1jmp1,llm),h(ip1jmp1,llm)
      REAL pext(ip1jmp1),pks(ip1jmp1),pksf(ip1jmp1),phis(ip1jmp1)
      REAL vcont(ip1jm,llm),ucont(ip1jmp1,llm)
      REAL phi(ip1jmp1,llm)
      REAL dv(ip1jm,llm),du(ip1jmp1,llm)
      REAL dh(ip1jmp1,llm),dp(ip1jmp1)

c   Local:
c   ------

      REAL pbarx(ip1jmp1),pbary(ip1jm),pbarxy(ip1jm)
      REAL pbaru(ip1jmp1,llm),pbarv(ip1jm,llm),vorpot(ip1jm,llm)
      REAL w(ip1jmp1,llm),ecin(ip1jmp1,llm),convm(ip1jmp1,llm)
      REAL bern(ip1jmp1,llm)

      INTEGER ij
      EXTERNAL  advect,bernoui,convmas,covcont,dhdq1,dudv1,dudv2,
     *          enercin,flumass,pbar,tourpot,vitvert,sortvarc

c-----------------------------------------------------------------------
c   calcul des tendances dynamiques:
c   --------------------------------

      CALL covcont (llm,ucov , vcov , ucont, vcont               )
      CALL pbar    ( pext ,pbarx , pbary, pbarxy              )
      CALL flumass ( pbarx, pbary, vcont, ucont ,pbaru, pbarv )
      CALL dhdq1   (   h  , pbaru, pbarv,  dh                 )
      CALL convmas ( pbaru, pbarv, convm                      )

      DO 10  ij = 1, ip1jmp1
      dp( ij ) = convm( ij,1 )
  10  CONTINUE

      CALL vitvert ( convm , w                              )
      CALL tourpot ( vcov  , ucov  , pbarxy  , vorpot       )
      CALL dudv1   ( vorpot, pbaru , pbarv   , du    , dv   )
      CALL enercin ( vcov  , ucov  , vcont   , ucont , ecin )
      CALL bernoui ( ip1jmp1,llm,phi   , ecin  , bern       )
      CALL dudv2   ( h     , pksf  , bern    , du    , dv   )

      CALL advect  ( ucov,vcov,h,w,pbarx,pbary,du,dv,dh     )

c-----------------------------------------------------------------------
c   sorties eventuelles des variables de controle:
c   ----------------------------------------------

      IF (conser) CALL sortvarc
     $   (ucov,h,pext,pks,phis,pbarx,pbarxy,vorpot,phi,bern,dp)

      RETURN
      END
