!!!! Abderrahmane Idelkadi aout 2013 !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Module pour definir (au 1er appel) et ecrire les variables dans les fichiers de sortie cosp
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   MODULE cosp_output_write_mod
  
   USE cosp_output_mod
  
   INTEGER, SAVE  :: itau_iocosp
!$OMP THREADPRIVATE(itau_iocosp)
   INTEGER, save        :: Nlevout, Ncolout
!$OMP THREADPRIVATE(Nlevout, Ncolout)

!  INTERFACE histwrite_cosp
!    MODULE PROCEDURE histwrite2d_cosp,histwrite3d_cosp
!  END INTERFACE

   CONTAINS

  SUBROUTINE cosp_output_write(Nlevlmdz, Npoints, Ncolumns, itap, dtime, freq_COSP, missing_cosp, &
                               cfg, gbx, vgrid, sglidar, sgradar, stlidar, stradar, &
                               isccp, misr, modis)

    USE ioipsl
    USE time_phylmdz_mod, ONLY: itau_phy, start_time, day_step_phy
    USE print_control_mod, ONLY: lunout,prt_level

#ifdef CPP_XIOS
    USE wxios, only: wxios_closedef
    USE xios, only: xios_update_calendar
#endif

!!! Variables d'entree
  integer               :: itap, Nlevlmdz, Ncolumns, Npoints
  real                  :: freq_COSP, dtime, missing_val, missing_cosp
  type(cosp_config)     :: cfg     ! Control outputs
  type(cosp_gridbox)    :: gbx     ! Gridbox information. Input for COSP
  type(cosp_sglidar)    :: sglidar ! Output from lidar simulator
  type(cosp_sgradar)    :: sgradar ! Output from radar simulator
  type(cosp_isccp)      :: isccp   ! Output from ISCCP simulator
  type(cosp_lidarstats) :: stlidar ! Summary statistics from lidar simulator
  type(cosp_radarstats) :: stradar
  type(cosp_misr)       :: misr    ! Output from MISR
  type(cosp_modis)      :: modis   ! Outputs from Modis
  type(cosp_vgrid)      :: vgrid   ! Information on vertical grid of stats

!!! Variables locales
  integer               :: icl
  logical               :: ok_sync
  integer               :: itau_wcosp
  real, dimension(Npoints,PARASOL_NREFL) :: parasolcrefl, Ncref


#ifdef CPP_XIOS
  missing_val=missing_cosp
#else
  missing_val=0.
#endif

  Nlevout = vgrid%Nlvgrid
  Ncolout = Ncolumns

! A refaire
       itau_wcosp = itau_phy + itap + start_time * day_step_phy
        if (prt_level >= 10) then
             WRITE(lunout,*)'itau_wcosp, itap, start_time, day_step_phy =', & 
                             itau_wcosp, itap, start_time, day_step_phy
        endif

! On le donne a  cosp_output_write_mod pour que les histwrite y aient acces:
       CALL set_itau_iocosp(itau_wcosp)
        if (prt_level >= 10) then
              WRITE(lunout,*)'itau_iocosp =',itau_iocosp
        endif

    ok_sync = .TRUE.
    
!DO iinit=1, iinitend
! AI sept 2014 cette boucle supprimee
! On n'ecrit pas quand itap=1 (cosp)

   if (prt_level >= 10) then
         WRITE(lunout,*)'DO iinit=1, iinitend ',iinitend
   endif

!#ifdef CPP_XIOS
! !$OMP MASTER
!IF (cosp_varsdefined) THEN
!   if (prt_level >= 10) then
!         WRITE(lunout,*)'Apell xios_update_calendar cosp_varsdefined iinitend ', &
!                         cosp_varsdefined,iinitend
!   endif 
!    CALL xios_update_calendar(itau_wcosp)
!ENDIF
!  !$OMP END MASTER
!  !$OMP BARRIER
!#endif

 if (cfg%Llidar_sim) then
! Pb des valeurs indefinies, on les met a 0
! A refaire proprement
  do k = 1,Nlevout
     do ip = 1,Npoints
     if(stlidar%lidarcld(ip,k).eq.R_UNDEF)then
      stlidar%lidarcld(ip,k)=missing_val
     endif
     if(stlidar%proftemp(ip,k).eq.R_UNDEF)then !TIBO
      stlidar%proftemp(ip,k)=missing_val       !TIBO
     endif                                     !TIBO
     enddo

     do ii= 1,SR_BINS
      do ip = 1,Npoints
       if(stlidar%cfad_sr(ip,ii,k).eq.R_UNDEF)then
        stlidar%cfad_sr(ip,ii,k)=missing_val
       endif
      enddo
     enddo

     do ii= 1,Ncolumns                               !TIBO
      do ip = 1,Npoints                              !TIBO
!       if(stlidar%profSR(ip,ii,k).eq.R_UNDEF)then    !TIBO
!        stlidar%profSR(ip,ii,k)=missing_val          !TIBO
       if(stlidar%profSR(ip,k,ii).eq.R_UNDEF)then    !TIBO2
        stlidar%profSR(ip,k,ii)=missing_val          !TIBO2
       endif                                         !TIBO
      enddo                                          !TIBO
     enddo                                           !TIBO
  enddo

  do ip = 1,Npoints
   do k = 1,Nlevlmdz
     if(sglidar%beta_mol(ip,k).eq.R_UNDEF)then
      sglidar%beta_mol(ip,k)=missing_val
     endif

     do ii= 1,Ncolumns
       if(sglidar%beta_tot(ip,ii,k).eq.R_UNDEF)then
        sglidar%beta_tot(ip,ii,k)=missing_val
       endif
     enddo

    enddo    !k = 1,Nlevlmdz
   enddo     !ip = 1,Npoints

   do k = 1,LIDAR_NCAT
    do ip = 1,Npoints
     if(stlidar%cldlayer(ip,k).eq.R_UNDEF)then
       stlidar%cldlayer(ip,k)=missing_val
     endif
    enddo
   enddo

   do k = 1,LIDAR_NTYPE                       !OPAQ
    do ip = 1,Npoints                         !OPAQ
     if(stlidar%cldtype(ip,k).eq.R_UNDEF)then !OPAQ
       stlidar%cldtype(ip,k)=missing_val      !OPAQ
     endif                                    !OPAQ
    enddo                                     !OPAQ
   enddo                                      !OPAQ

! AI 11 / 2015

   where(stlidar%parasolrefl == R_UNDEF) stlidar%parasolrefl = missing_val
   where(stlidar%lidarcldtmp == R_UNDEF) stlidar%lidarcldtmp = missing_val
   where(stlidar%cldlayerphase == R_UNDEF) stlidar%cldlayerphase = missing_val
   where(stlidar%lidarcldphase == R_UNDEF) stlidar%lidarcldphase = missing_val
   where(stlidar%lidarcldtype == R_UNDEF) stlidar%lidarcldtype = missing_val   !OPAQ
   where(stlidar%lidarcldtmp == R_UNDEF) stlidar%lidarcldtmp = missing_val
   

   print*,'Appel histwrite2d_cosp'
   CALL histwrite2d_cosp(o_cllcalipso,stlidar%cldlayer(:,1))
   CALL histwrite2d_cosp(o_clhcalipso,stlidar%cldlayer(:,3))
   CALL histwrite2d_cosp(o_clmcalipso,stlidar%cldlayer(:,2)) 
   CALL histwrite2d_cosp(o_cltcalipso,stlidar%cldlayer(:,4))
   CALL histwrite3d_cosp(o_clcalipso,stlidar%lidarcld,nvert)
   CALL histwrite3d_cosp(o_clcalipsotmp,stlidar%lidarcldtmp(:,:,1),nverttemp)

   CALL histwrite2d_cosp(o_cllcalipsoice,stlidar%cldlayerphase(:,1,1))
   CALL histwrite2d_cosp(o_clhcalipsoice,stlidar%cldlayerphase(:,3,1))
   CALL histwrite2d_cosp(o_clmcalipsoice,stlidar%cldlayerphase(:,2,1))
   CALL histwrite2d_cosp(o_cltcalipsoice,stlidar%cldlayerphase(:,4,1))
   CALL histwrite3d_cosp(o_clcalipsoice,stlidar%lidarcldphase(:,:,1),nvert)
   CALL histwrite3d_cosp(o_clcalipsotmpice,stlidar%lidarcldtmp(:,:,2),nverttemp)

   CALL histwrite2d_cosp(o_cllcalipsoliq,stlidar%cldlayerphase(:,1,2))
   CALL histwrite2d_cosp(o_clhcalipsoliq,stlidar%cldlayerphase(:,3,2))
   CALL histwrite2d_cosp(o_clmcalipsoliq,stlidar%cldlayerphase(:,2,2))
   CALL histwrite2d_cosp(o_cltcalipsoliq,stlidar%cldlayerphase(:,4,2))
   CALL histwrite3d_cosp(o_clcalipsoliq,stlidar%lidarcldphase(:,:,2),nvert)
   CALL histwrite3d_cosp(o_clcalipsotmpliq,stlidar%lidarcldtmp(:,:,3),nverttemp)

   CALL histwrite2d_cosp(o_cllcalipsoun,stlidar%cldlayerphase(:,1,3))
   CALL histwrite2d_cosp(o_clhcalipsoun,stlidar%cldlayerphase(:,3,3))
   CALL histwrite2d_cosp(o_clmcalipsoun,stlidar%cldlayerphase(:,2,3))
   CALL histwrite2d_cosp(o_cltcalipsoun,stlidar%cldlayerphase(:,4,3))
   CALL histwrite3d_cosp(o_clcalipsoun,stlidar%lidarcldphase(:,:,3),nvert)
   CALL histwrite3d_cosp(o_clcalipsotmpun,stlidar%lidarcldtmp(:,:,4),nverttemp)

   CALL histwrite2d_cosp(o_clopaquecalipso,stlidar%cldtype(:,1))               !OPAQ
   CALL histwrite2d_cosp(o_clthincalipso,stlidar%cldtype(:,2))                 !OPAQ
   CALL histwrite2d_cosp(o_clzopaquecalipso,stlidar%cldtype(:,3))              !OPAQ

   CALL histwrite3d_cosp(o_clcalipsoopaque,stlidar%lidarcldtype(:,:,1),nvert)  !OPAQ
   CALL histwrite3d_cosp(o_clcalipsothin,stlidar%lidarcldtype(:,:,2),nvert)    !OPAQ
   CALL histwrite3d_cosp(o_clcalipsozopaque,stlidar%lidarcldtype(:,:,3),nvert) !OPAQ
   CALL histwrite3d_cosp(o_clcalipsoopacity,stlidar%lidarcldtype(:,:,4),nvert) !OPAQ

   CALL histwrite3d_cosp(o_proftemp,stlidar%proftemp,nvert)                    !TIBO

#ifdef CPP_XIOS
   CALL histwrite4d_cosp(o_cfad_lidarsr532,stlidar%cfad_sr)
   CALL histwrite4d_cosp(o_profSR,stlidar%profSR)                              !TIBO
#else
   do icl=1,SR_BINS
      CALL histwrite3d_cosp(o_cfad_lidarsr532,stlidar%cfad_sr(:,icl,:),nvert,icl)
   enddo
   do icl=1,Ncolumns                                                              !TIBO
      CALL histwrite3d_cosp(o_profSR,stlidar%profSR(:,icl,:),nvert,icl)           !TIBO
   enddo                                                                          !TIBO
     CALL histwrite3d_cosp(o_parasol_refl,stlidar%parasolrefl,nvertp)
#endif

   do k=1,PARASOL_NREFL
    do ip=1, Npoints
     if (stlidar%cldlayer(ip,4).gt.0.01.and.stlidar%parasolrefl(ip,k).ne.missing_val) then
       parasolcrefl(ip,k)=(stlidar%parasolrefl(ip,k)-0.03*(1.-stlidar%cldlayer(ip,4)))/ &
                            stlidar%cldlayer(ip,4)
        Ncref(ip,k) = 1.
     else
        parasolcrefl(ip,k)=missing_val
        Ncref(ip,k) = 0.
     endif
    enddo
   
   enddo
   CALL histwrite3d_cosp(o_Ncrefl,Ncref,nvertp)
   CALL histwrite3d_cosp(o_parasol_crefl,parasolcrefl,nvertp)

#ifdef CPP_XIOS
   CALL histwrite4d_cosp(o_atb532,sglidar%beta_tot)
#else
   do icl=1,Ncolumns 
      CALL histwrite3d_cosp(o_atb532,sglidar%beta_tot(:,icl,:),nvertmcosp,icl)
   enddo
#endif

   CALL histwrite3d_cosp(o_beta_mol532,sglidar%beta_mol,nvertmcosp) 
 endif !Lidar

 if (cfg%Lradar_sim) then

#ifdef CPP_XIOS
   CALL histwrite4d_cosp(o_dbze94,sgradar%Ze_tot)
   CALL histwrite4d_cosp(o_cfadDbze94,stradar%cfad_ze)
#else
   do icl=1,Ncolumns
      CALL histwrite3d_cosp(o_dbze94,sgradar%Ze_tot(:,icl,:),nvertmcosp,icl)
   enddo
   do icl=1,DBZE_BINS
    CALL histwrite3d_cosp(o_cfadDbze94,stradar%cfad_ze(:,icl,:),nvert,icl)
   enddo
#endif
 endif

 if (cfg%Llidar_sim .and. cfg%Lradar_sim) then
   where(stradar%lidar_only_freq_cloud == R_UNDEF) &
                           stradar%lidar_only_freq_cloud = missing_val
   CALL histwrite3d_cosp(o_clcalipso2,stradar%lidar_only_freq_cloud,nvert)
   where(stradar%radar_lidar_tcc == R_UNDEF) &
                           stradar%radar_lidar_tcc = missing_val
   CALL histwrite2d_cosp(o_cltlidarradar,stradar%radar_lidar_tcc)
 endif

 if (cfg%Lisccp_sim) then

! Traitement des valeurs indefinies
   do ip = 1,Npoints
    if(isccp%totalcldarea(ip).eq.R_UNDEF)then
      isccp%totalcldarea(ip)=missing_val
    endif
    if(isccp%meanptop(ip).eq.R_UNDEF)then
      isccp%meanptop(ip)=missing_val
    endif
    if(isccp%meantaucld(ip).eq.R_UNDEF)then
      isccp%meantaucld(ip)=missing_val
    endif
    if(isccp%meanalbedocld(ip).eq.R_UNDEF)then
     isccp%meanalbedocld(ip)=missing_val
    endif
    if(isccp%meantb(ip).eq.R_UNDEF)then
     isccp%meantb(ip)=missing_val
    endif
    if(isccp%meantbclr(ip).eq.R_UNDEF)then
       isccp%meantbclr(ip)=missing_val
    endif

    do k=1,7
     do ii=1,7
     if(isccp%fq_isccp(ip,ii,k).eq.R_UNDEF)then
      isccp%fq_isccp(ip,ii,k)=missing_val
     endif
     enddo
    enddo

    do ii=1,Ncolumns
     if(isccp%boxtau(ip,ii).eq.R_UNDEF)then
       isccp%boxtau(ip,ii)=missing_val
     endif
    enddo

    do ii=1,Ncolumns
     if(isccp%boxptop(ip,ii).eq.R_UNDEF)then
      isccp%boxptop(ip,ii)=missing_val
     endif
    enddo
   enddo

   CALL histwrite2d_cosp(o_sunlit,gbx%sunlit)
#ifdef CPP_XIOS
   CALL histwrite4d_cosp(o_clisccp2,isccp%fq_isccp)
#else
   do icl=1,7
   CALL histwrite3d_cosp(o_clisccp2,isccp%fq_isccp(:,icl,:),nvertisccp,icl) 
   enddo
#endif
   CALL histwrite3d_cosp(o_boxtauisccp,isccp%boxtau,nvertcol)
   CALL histwrite3d_cosp(o_boxptopisccp,isccp%boxptop,nvertcol) 
   CALL histwrite2d_cosp(o_tclisccp,isccp%totalcldarea) 
   CALL histwrite2d_cosp(o_ctpisccp,isccp%meanptop) 
   CALL histwrite2d_cosp(o_tauisccp,isccp%meantaucld) 
   CALL histwrite2d_cosp(o_albisccp,isccp%meanalbedocld) 
   CALL histwrite2d_cosp(o_meantbisccp,isccp%meantb) 
   CALL histwrite2d_cosp(o_meantbclrisccp,isccp%meantbclr)
 endif ! Isccp

! MISR simulator
 if (cfg%Lmisr_sim) then
   do ip=1,Npoints
     do ii=1,7
       do k=1,MISR_N_CTH
        if(misr%fq_MISR(ip,ii,k).eq.R_UNDEF)then
            misr%fq_MISR(ip,ii,k)=missing_val
        endif
       enddo
     enddo
   enddo

#ifdef CPP_XIOS
   CALL histwrite4d_cosp(o_clMISR,misr%fq_MISR)
#else
   do icl=1,7 
      CALL histwrite3d_cosp(o_clMISR,misr%fq_MISR(:,icl,:),nvertmisr,icl)
   enddo
#endif
 endif

! Modis simulator
 if (cfg%Lmodis_sim) then

  do ip=1,Npoints
    if(modis%Cloud_Fraction_Low_Mean(ip).eq.R_UNDEF)then
      modis%Cloud_Fraction_Low_Mean(ip)=missing_val
    endif
    if(modis%Cloud_Fraction_High_Mean(ip).eq.R_UNDEF)then
       modis%Cloud_Fraction_High_Mean(ip)=missing_val 
    endif
    if(modis%Cloud_Fraction_Mid_Mean(ip).eq.R_UNDEF)then
       modis%Cloud_Fraction_Mid_Mean(ip)=missing_val
    endif
    if(modis%Cloud_Fraction_Total_Mean(ip).eq.R_UNDEF)then
       modis%Cloud_Fraction_Total_Mean(ip)=missing_val
    endif
    if(modis%Cloud_Fraction_Water_Mean(ip).eq.R_UNDEF)then
       modis%Cloud_Fraction_Water_Mean(ip)=missing_val
    endif
    if(modis%Cloud_Fraction_Ice_Mean(ip).eq.R_UNDEF)then
       modis%Cloud_Fraction_Ice_Mean(ip)=missing_val
    endif
    if(modis%Optical_Thickness_Total_Mean(ip).eq.R_UNDEF)then
       modis%Optical_Thickness_Total_Mean(ip)=missing_val
    endif
    if(modis%Optical_Thickness_Water_Mean(ip).eq.R_UNDEF)then
       modis%Optical_Thickness_Water_Mean(ip)=missing_val
    endif
    if(modis%Optical_Thickness_Ice_Mean(ip).eq.R_UNDEF)then
       modis%Optical_Thickness_Ice_Mean(ip)=missing_val
    endif
    if(modis%Cloud_Particle_Size_Water_Mean(ip).eq.R_UNDEF)then
       modis%Cloud_Particle_Size_Water_Mean(ip)=missing_val
    endif
    if(modis%Cloud_Particle_Size_Ice_Mean(ip).eq.R_UNDEF)then
       modis%Cloud_Particle_Size_Ice_Mean(ip)=missing_val
    endif
    if(modis%Cloud_Top_Pressure_Total_Mean(ip).eq.R_UNDEF)then
       modis%Cloud_Top_Pressure_Total_Mean(ip)=missing_val
    endif
    if(modis%Liquid_Water_Path_Mean(ip).eq.R_UNDEF)then
       modis%Liquid_Water_Path_Mean(ip)=missing_val
    endif
    if(modis%Ice_Water_Path_Mean(ip).eq.R_UNDEF)then
       modis%Ice_Water_Path_Mean(ip)=missing_val
    endif

  enddo

    where(modis%Optical_Thickness_Total_LogMean == R_UNDEF) &
          modis%Optical_Thickness_Total_LogMean = missing_val
           
 
    where(modis%Optical_Thickness_Water_LogMean == R_UNDEF) &
          modis%Optical_Thickness_Water_LogMean = missing_val

    where(modis%Optical_Thickness_Ice_LogMean == R_UNDEF) &
          modis%Optical_Thickness_Ice_LogMean = missing_val
    
   CALL histwrite2d_cosp(o_cllmodis,modis%Cloud_Fraction_Low_Mean)
   CALL histwrite2d_cosp(o_clhmodis,modis%Cloud_Fraction_High_Mean)
   CALL histwrite2d_cosp(o_clmmodis,modis%Cloud_Fraction_Mid_Mean)
   CALL histwrite2d_cosp(o_cltmodis,modis%Cloud_Fraction_Total_Mean)
   CALL histwrite2d_cosp(o_clwmodis,modis%Cloud_Fraction_Water_Mean)
   CALL histwrite2d_cosp(o_climodis,modis%Cloud_Fraction_Ice_Mean)
   CALL histwrite2d_cosp(o_tautmodis,modis%Optical_Thickness_Total_Mean)
   CALL histwrite2d_cosp(o_tauwmodis,modis%Optical_Thickness_Water_Mean)
   CALL histwrite2d_cosp(o_tauimodis,modis%Optical_Thickness_Ice_Mean)
   CALL histwrite2d_cosp(o_tautlogmodis,modis%Optical_Thickness_Total_LogMean)  
   CALL histwrite2d_cosp(o_tauwlogmodis,modis%Optical_Thickness_Water_LogMean)
   CALL histwrite2d_cosp(o_tauilogmodis,modis%Optical_Thickness_Ice_LogMean)
   CALL histwrite2d_cosp(o_reffclwmodis,modis%Cloud_Particle_Size_Water_Mean)
   CALL histwrite2d_cosp(o_reffclimodis,modis%Cloud_Particle_Size_Ice_Mean)
   CALL histwrite2d_cosp(o_pctmodis,modis%Cloud_Top_Pressure_Total_Mean)
   CALL histwrite2d_cosp(o_lwpmodis,modis%Liquid_Water_Path_Mean)
   CALL histwrite2d_cosp(o_iwpmodis,modis%Ice_Water_Path_Mean)

   do ip=1,Npoints
     do ii=1,7
       do k=1,7
       if(modis%Optical_Thickness_vs_Cloud_Top_Pressure(ip,ii,k).eq.R_UNDEF)then
          modis%Optical_Thickness_vs_Cloud_Top_Pressure(ip,ii,k)=missing_val
        endif
       enddo
     enddo
    enddo 

#ifdef CPP_XIOS
   CALL histwrite4d_cosp(o_clmodis,modis%Optical_Thickness_vs_Cloud_Top_Pressure)
#else
   do icl=1,7
   CALL histwrite3d_cosp(o_clmodis, &
     modis%Optical_Thickness_vs_Cloud_Top_Pressure(:,icl,:),nvertisccp,icl)           
   enddo
#endif

    where(modis%Optical_Thickness_vs_ReffIce == R_UNDEF) &
          modis%Optical_Thickness_vs_ReffIce = missing_val

    where(modis%Optical_Thickness_vs_ReffLiq == R_UNDEF) &
          modis%Optical_Thickness_vs_ReffLiq = missing_val

#ifdef CPP_XIOS
!    print*,'dimension de crimodis=',size(modis%Optical_Thickness_vs_ReffIce,2),&
!                                    size(modis%Optical_Thickness_vs_ReffIce,3)
    CALL histwrite4d_cosp(o_crimodis,modis%Optical_Thickness_vs_ReffIce)
    CALL histwrite4d_cosp(o_crlmodis,modis%Optical_Thickness_vs_ReffLiq)
#else
    do icl=1,7
   CALL histwrite3d_cosp(o_crimodis, &
     modis%Optical_Thickness_vs_ReffIce(:,icl,:),nvertReffIce,icl)
   CALL histwrite3d_cosp(o_crlmodis, &
     modis%Optical_Thickness_vs_ReffLiq(:,icl,:),nvertReffLiq,icl)
    enddo
#endif
 endif

 IF(.NOT.cosp_varsdefined) THEN
!$OMP MASTER
#ifndef CPP_IOIPSL_NO_OUTPUT
            DO iff=1,3
                IF (cosp_outfilekeys(iff)) THEN
                  CALL histend(cosp_nidfiles(iff))
                ENDIF ! cosp_outfilekeys
            ENDDO !  iff
#endif
! Fermeture dans phys_output_write
!#ifdef CPP_XIOS
            !On finalise l'initialisation:
            !CALL wxios_closedef()
!#endif

!$OMP END MASTER
!$OMP BARRIER
            cosp_varsdefined = .TRUE.
 END IF

    IF(cosp_varsdefined) THEN
! On synchronise les fichiers pour IOIPSL
#ifndef CPP_IOIPSL_NO_OUTPUT 
!$OMP MASTER
     DO iff=1,3
         IF (ok_sync .AND. cosp_outfilekeys(iff)) THEN
             CALL histsync(cosp_nidfiles(iff))
         ENDIF
     END DO
!$OMP END MASTER
#endif
    ENDIF  !cosp_varsdefined

    END SUBROUTINE cosp_output_write

! ug Routine pour definir itau_iocosp depuis cosp_output_write_mod:
  SUBROUTINE set_itau_iocosp(ito)
      IMPLICIT NONE
      INTEGER, INTENT(IN) :: ito
      itau_iocosp = ito
  END SUBROUTINE

  SUBROUTINE histdef2d_cosp (iff,var)

    USE ioipsl
    USE dimphy
    use iophy
    USE mod_phys_lmdz_para
    USE mod_grid_phy_lmdz, ONLY: nbp_lon
    USE print_control_mod, ONLY: lunout,prt_level
#ifdef CPP_XIOS
  USE wxios
#endif

    IMPLICIT NONE

    INCLUDE "clesphys.h"

    INTEGER                          :: iff
    TYPE(ctrl_outcosp)               :: var

    REAL zstophym
    CHARACTER(LEN=20) :: typeecrit

    ! ug On récupère le type écrit de la structure:
    !       Assez moche, |  refaire si meilleure méthode...
    IF (INDEX(var%cosp_typeecrit(iff), "once") > 0) THEN
       typeecrit = 'once'
    ELSE IF(INDEX(var%cosp_typeecrit(iff), "t_min") > 0) THEN
       typeecrit = 't_min(X)'
    ELSE IF(INDEX(var%cosp_typeecrit(iff), "t_max") > 0) THEN
       typeecrit = 't_max(X)'
    ELSE IF(INDEX(var%cosp_typeecrit(iff), "inst") > 0) THEN
       typeecrit = 'inst(X)'
    ELSE
       typeecrit = cosp_outfiletypes(iff)
    ENDIF

    IF (typeecrit=='inst(X)'.OR.typeecrit=='once') THEN
       zstophym=zoutm_cosp(iff)
    ELSE
       zstophym=zdtimemoy_cosp
    ENDIF

#ifdef CPP_XIOS
     IF (.not. ok_all_xml) then
       IF ( var%cles(iff) ) THEN
         if (prt_level >= 10) then
              WRITE(lunout,*)'Appel wxios_add_field_to_file var%name =',var%name 
         endif
        CALL wxios_add_field_to_file(var%name, 2, cosp_nidfiles(iff), cosp_outfilenames(iff), &
                                     var%description, var%unit, 1, typeecrit)
       ENDIF
     ENDIF
#endif

#ifndef CPP_IOIPSL_NO_OUTPUT 
       IF ( var%cles(iff) ) THEN
          CALL histdef (cosp_nidfiles(iff), var%name, var%description, var%unit, &
               nbp_lon,jj_nb,nhoricosp(iff), 1,1,1, -99, 32, &
               typeecrit, zstophym,zoutm_cosp(iff))
       ENDIF
#endif

  END SUBROUTINE histdef2d_cosp

 SUBROUTINE histdef3d_cosp (iff,var,nvertsave,ncols)
    USE ioipsl
    USE dimphy
    use iophy
    USE mod_phys_lmdz_para
    USE mod_grid_phy_lmdz, ONLY: nbp_lon
    USE print_control_mod, ONLY: lunout,prt_level

#ifdef CPP_XIOS
  USE wxios
#endif


    IMPLICIT NONE

    INCLUDE "clesphys.h"

    INTEGER                        :: iff, klevs
    INTEGER, INTENT(IN), OPTIONAL  :: ncols ! ug RUSTINE POUR LES variables 4D
    INTEGER, INTENT(IN)           :: nvertsave
    TYPE(ctrl_outcosp)             :: var

    REAL zstophym
    CHARACTER(LEN=20) :: typeecrit, nomi
    CHARACTER(LEN=20) :: nom
    character(len=2) :: str2
    CHARACTER(len=20) :: nam_axvert

! Axe vertical
      IF (nvertsave.eq.nvertp(iff)) THEN
          klevs=PARASOL_NREFL
          nam_axvert="sza"
      ELSE IF (nvertsave.eq.nvertisccp(iff)) THEN
          klevs=7
          nam_axvert="pressure2"
      ELSE IF (nvertsave.eq.nvertcol(iff)) THEN
          klevs=Ncolout
          nam_axvert="column"
      ELSE IF (nvertsave.eq.nverttemp(iff)) THEN
          klevs=LIDAR_NTEMP
          nam_axvert="temp"
      ELSE IF (nvertsave.eq.nvertmisr(iff)) THEN
          klevs=MISR_N_CTH
          nam_axvert="cth16"
      ELSE IF (nvertsave.eq.nvertReffIce(iff)) THEN
          klevs= numMODISReffIceBins
          nam_axvert="ReffIce"
      ELSE IF (nvertsave.eq.nvertReffLiq(iff)) THEN
          klevs= numMODISReffLiqBins
          nam_axvert="ReffLiq"
      ELSE
           klevs=Nlevout
           nam_axvert="presnivs"
      ENDIF

! ug RUSTINE POUR LES Champs 4D
      IF (PRESENT(ncols)) THEN
               write(str2,'(i2.2)')ncols
               nomi=var%name
               nom="c"//str2//"_"//nomi
      ELSE
               nom=var%name
      END IF

    ! ug On récupère le type écrit de la structure:
    !       Assez moche, |  refaire si meilleure méthode...
    IF (INDEX(var%cosp_typeecrit(iff), "once") > 0) THEN
       typeecrit = 'once'
    ELSE IF(INDEX(var%cosp_typeecrit(iff), "t_min") > 0) THEN
       typeecrit = 't_min(X)'
    ELSE IF(INDEX(var%cosp_typeecrit(iff), "t_max") > 0) THEN
       typeecrit = 't_max(X)'
    ELSE IF(INDEX(var%cosp_typeecrit(iff), "inst") > 0) THEN
       typeecrit = 'inst(X)'
    ELSE
       typeecrit = cosp_outfiletypes(iff)
    ENDIF

    IF (typeecrit=='inst(X)'.OR.typeecrit=='once') THEN
       zstophym=zoutm_cosp(iff)
    ELSE
       zstophym=zdtimemoy_cosp
    ENDIF

#ifdef CPP_XIOS
      IF (.not. ok_all_xml) then
        IF ( var%cles(iff) ) THEN
          if (prt_level >= 10) then
              WRITE(lunout,*)'Appel wxios_add_field_to_file 3d nom variable nam_axvert = ',nom, nam_axvert 
          endif
          CALL wxios_add_field_to_file(nom, 3, cosp_nidfiles(iff), cosp_outfilenames(iff), &
                                       var%description, var%unit, 1, typeecrit, nam_axvert)
        ENDIF
      ENDIF
#endif

#ifndef CPP_IOIPSL_NO_OUTPUT
       IF ( var%cles(iff) ) THEN
          CALL histdef (cosp_nidfiles(iff), nom, var%description, var%unit, &
               nbp_lon, jj_nb, nhoricosp(iff), klevs, 1, &
               klevs, nvertsave, 32, typeecrit, &
               zstophym, zoutm_cosp(iff))
       ENDIF
#endif

  END SUBROUTINE histdef3d_cosp

 SUBROUTINE histwrite2d_cosp(var,field)
  USE dimphy
  USE mod_phys_lmdz_para
  USE ioipsl
  use iophy
  USE mod_grid_phy_lmdz, ONLY: nbp_lon
  USE print_control_mod, ONLY: lunout,prt_level

#ifdef CPP_XIOS
  USE xios, only: xios_send_field
#endif

  IMPLICIT NONE
  INCLUDE 'clesphys.h'

    TYPE(ctrl_outcosp), INTENT(IN) :: var
    REAL, DIMENSION(:), INTENT(IN) :: field

    INTEGER :: iff

    REAL,DIMENSION(klon_mpi) :: buffer_omp
    INTEGER, allocatable, DIMENSION(:) :: index2d
    REAL :: Field2d(nbp_lon,jj_nb)
    CHARACTER(LEN=20) ::  nomi, nom
    character(len=2) :: str2
    LOGICAL, SAVE  :: firstx
!$OMP THREADPRIVATE(firstx)

    IF (prt_level >= 9) WRITE(lunout,*)'Begin histrwrite2d ',var%name

  ! On regarde si on est dans la phase de définition ou d'écriture:
  IF(.NOT.cosp_varsdefined) THEN
!$OMP MASTER
      !Si phase de définition.... on définit
      CALL conf_cospoutputs(var%name,var%cles)
      DO iff=1, 3
         IF (cosp_outfilekeys(iff)) THEN
            CALL histdef2d_cosp(iff, var)
         ENDIF
      ENDDO
!$OMP END MASTER
  ELSE
    !Et sinon on.... écrit
    IF (SIZE(field)/=klon) &
  CALL abort_physic('iophy::histwrite2d_cosp','Field first DIMENSION not equal to klon',1) 

    CALL Gather_omp(field,buffer_omp)
!$OMP MASTER
    CALL grid1Dto2D_mpi(buffer_omp,Field2d)

! La boucle sur les fichiers:
      firstx=.true.
      DO iff=1, 3
           IF (var%cles(iff) .AND. cosp_outfilekeys(iff)) THEN
                ALLOCATE(index2d(nbp_lon*jj_nb))
#ifndef CPP_IOIPSL_NO_OUTPUT
        CALL histwrite(cosp_nidfiles(iff),var%name,itau_iocosp,Field2d,nbp_lon*jj_nb,index2d) 
#endif
                deallocate(index2d)
#ifdef CPP_XIOS
              IF (.not. ok_all_xml) then
                 if (firstx) then
                  if (prt_level >= 10) then
                    WRITE(lunout,*)'xios_send_field variable ',var%name
                  endif
                  CALL xios_send_field(var%name, Field2d)
                   firstx=.false.
                 endif
              ENDIF
#endif
           ENDIF
      ENDDO 

#ifdef CPP_XIOS
      IF (ok_all_xml) THEN
        if (prt_level >= 1) then
              WRITE(lunout,*)'xios_send_field variable ',var%name
        endif
       CALL xios_send_field(var%name, Field2d)
      ENDIF
#endif

!$OMP END MASTER   
  ENDIF ! vars_defined
  IF (prt_level >= 9) WRITE(lunout,*)'End histrwrite2d_cosp ',var%name
  END SUBROUTINE histwrite2d_cosp

! ug NOUVELLE VERSION DES WRITE AVEC LA BOUCLE DO RENTREE
! AI sept 2013
  SUBROUTINE histwrite3d_cosp(var, field, nverts, ncols)
  USE dimphy
  USE mod_phys_lmdz_para
  USE ioipsl
  use iophy
  USE mod_grid_phy_lmdz, ONLY: nbp_lon
  USE print_control_mod, ONLY: lunout,prt_level

#ifdef CPP_XIOS
  USE xios, only: xios_send_field
#endif


  IMPLICIT NONE
  INCLUDE 'clesphys.h'

    TYPE(ctrl_outcosp), INTENT(IN)    :: var
    REAL, DIMENSION(:,:), INTENT(IN)  :: field ! --> field(klon,:)
    INTEGER, INTENT(IN), OPTIONAL     :: ncols ! ug RUSTINE POUR LES Champs 4D.....
    INTEGER, DIMENSION(3), INTENT(IN) :: nverts

    INTEGER :: iff, k

    REAL,DIMENSION(klon_mpi,SIZE(field,2)) :: buffer_omp
    REAL :: Field3d(nbp_lon,jj_nb,SIZE(field,2))
    INTEGER :: ip, n, nlev
    INTEGER, ALLOCATABLE, DIMENSION(:) :: index3d
    CHARACTER(LEN=20) ::  nomi, nom
    character(len=2) :: str2
    LOGICAL, SAVE  :: firstx
!$OMP THREADPRIVATE(firstx)

  IF (prt_level >= 9) write(lunout,*)'Begin histrwrite3d ',var%name

! ug RUSTINE POUR LES STD LEVS.....
      IF (PRESENT(ncols)) THEN
              write(str2,'(i2.2)')ncols
              nomi=var%name
              nom="c"//str2//"_"//nomi
      ELSE
               nom=var%name
      END IF
  ! On regarde si on est dans la phase de définition ou d'écriture:
  IF(.NOT.cosp_varsdefined) THEN
      !Si phase de définition.... on définit
!$OMP MASTER
      CALL conf_cospoutputs(var%name,var%cles)
      DO iff=1, 3
        IF (cosp_outfilekeys(iff)) THEN
          CALL histdef3d_cosp(iff, var, nverts(iff), ncols)
        ENDIF
      ENDDO
!$OMP END MASTER
  ELSE
    !Et sinon on.... écrit
    IF (SIZE(field,1)/=klon) &
   CALL abort_physic('iophy::histwrite3d','Field first DIMENSION not equal to klon',1)                                  
    nlev=SIZE(field,2)


    CALL Gather_omp(field,buffer_omp)
!$OMP MASTER
    CALL grid1Dto2D_mpi(buffer_omp,field3d)

! BOUCLE SUR LES FICHIERS
     firstx=.true.
     DO iff=1, 3
        IF (var%cles(iff) .AND. cosp_outfilekeys(iff)) THEN
           ALLOCATE(index3d(nbp_lon*jj_nb*nlev))
#ifndef CPP_IOIPSL_NO_OUTPUT
    CALL histwrite(cosp_nidfiles(iff),nom,itau_iocosp,Field3d,nbp_lon*jj_nb*nlev,index3d) 
#endif

#ifdef CPP_XIOS
          IF (.not. ok_all_xml) then
           IF (firstx) THEN
               CALL xios_send_field(nom, Field3d(:,:,1:nlev))
               IF (prt_level >= 9) WRITE(lunout,*)'xios_send_field ',var%name
               firstx=.FALSE.
           ENDIF
          ENDIF
#endif
         deallocate(index3d)
        ENDIF
      ENDDO
#ifdef CPP_XIOS
    IF (ok_all_xml) THEN
     CALL xios_send_field(nom, Field3d(:,:,1:nlev))
     IF (prt_level >= 1) WRITE(lunout,*)'xios_send_field ',var%name
    ENDIF
#endif

!$OMP END MASTER   
  ENDIF ! vars_defined
  IF (prt_level >= 9) write(lunout,*)'End histrwrite3d_cosp ',nom
  END SUBROUTINE histwrite3d_cosp

! ug NOUVELLE VERSION DES WRITE AVEC LA BOUCLE DO RENTREE
! AI sept 2013
  SUBROUTINE histwrite4d_cosp(var, field)
  USE dimphy
  USE mod_phys_lmdz_para
  USE ioipsl
  use iophy
  USE mod_grid_phy_lmdz, ONLY: nbp_lon
  USE print_control_mod, ONLY: lunout,prt_level

#ifdef CPP_XIOS
  USE xios, only: xios_send_field
#endif


  IMPLICIT NONE
  INCLUDE 'clesphys.h'

    TYPE(ctrl_outcosp), INTENT(IN)    :: var
    REAL, DIMENSION(:,:,:), INTENT(IN)  :: field ! --> field(klon,:)

    INTEGER :: iff, k

    REAL,DIMENSION(klon_mpi,SIZE(field,2),SIZE(field,3)) :: buffer_omp
    REAL :: field4d(nbp_lon,jj_nb,SIZE(field,2),SIZE(field,3))
    INTEGER :: ip, n, nlev, nlev2
    INTEGER, ALLOCATABLE, DIMENSION(:) :: index4d
    CHARACTER(LEN=20) ::  nomi, nom

  IF (prt_level >= 9) write(lunout,*)'Begin histrwrite4d ',var%name

  IF(cosp_varsdefined) THEN
    !Et sinon on.... écrit
    IF (SIZE(field,1)/=klon) &
   CALL abort_physic('iophy::histwrite3d','Field first DIMENSION not equal to klon',1)            

    nlev=SIZE(field,2)
    nlev2=SIZE(field,3)
    CALL Gather_omp(field,buffer_omp)
!$OMP MASTER
    CALL grid1Dto2D_mpi(buffer_omp,field4d)

#ifdef CPP_XIOS
    IF (ok_all_xml) THEN
     CALL xios_send_field(var%name, Field4d(:,:,1:nlev,1:nlev2))
     IF (prt_level >= 1) WRITE(lunout,*)'xios_send_field ',var%name
    ENDIF
#endif

!$OMP END MASTER   
  ENDIF ! vars_defined
  IF (prt_level >= 9) write(lunout,*)'End histrwrite4d_cosp ',nom
  END SUBROUTINE histwrite4d_cosp

  SUBROUTINE conf_cospoutputs(nam_var,cles_var)
!!! Lecture des noms et cles de sortie des variables dans config.def
    !   en utilisant les routines getin de IOIPSL  
    use ioipsl
    USE print_control_mod, ONLY: lunout,prt_level

    IMPLICIT NONE

   CHARACTER(LEN=20)               :: nam_var, nnam_var
   LOGICAL, DIMENSION(3)           :: cles_var

! Lecture dans config.def ou output.def de cles_var et name_var
    CALL getin('cles_'//nam_var,cles_var)
    CALL getin('name_'//nam_var,nam_var)
    IF(prt_level>10) WRITE(lunout,*)'nam_var cles_var ',nam_var,cles_var(:)

  END SUBROUTINE conf_cospoutputs

 END MODULE cosp_output_write_mod
