SUBROUTINE interp_sulf_input(debutphy,pdtphys,paprs,tr_seri,SO2_backgr_tend, &
                            & OCS_backgr_tend,SO2_lifetime,OCS_lifetime)

  USE netcdf95, ONLY: nf95_close, nf95_gw_var, nf95_inq_dimid, & 
                      nf95_inq_varid, nf95_inquire_dimension, nf95_open
  USE netcdf, ONLY: nf90_get_var, nf90_noerr, nf90_nowrite

  USE mod_grid_phy_lmdz
  USE mod_phys_lmdz_mpi_data, ONLY :  is_mpi_root
  USE mod_phys_lmdz_para 
  USE dimphy
  USE phys_cal_mod
  USE infotrac
  USE aerophys

  IMPLICIT NONE

  include "YOMCST.h"
  include "dimensions.h"

! Variable input
  REAL paprs(klon,klev+1)
  REAL tr_seri(klon,klev,nbtr)
  REAL, INTENT(IN)    :: pdtphys    ! Pas d'integration pour la physique (seconde)
  LOGICAL, INTENT(IN) :: debutphy   ! le flag de l'initialisation de la physique

! Variables locales
  INTEGER nmth
  INTEGER n_lat   ! number of latitudes in the input data
  INTEGER n_lon   ! number of longitudes in the input data
  INTEGER, SAVE :: n_lev   ! number of levels in the input data
  INTEGER n_mth   ! number of months in the input data
  REAL OCS_tmp
  REAL SO2_tmp

! Champs reconstitues
  REAL paprs_glo(klon_glo,klev+1)
  REAL tr_seri_glo(klon_glo,klev,nbtr)

  REAL, POINTER:: latitude(:)
! (of input data sorted in strictly ascending order)

  REAL, POINTER:: longitude(:)
! (of input data sorted in strictly ascending order)

  REAL, POINTER:: time(:)
! (of input data sorted in strictly ascending order)

  REAL, POINTER:: lev(:)
! levels of input data

  REAL, ALLOCATABLE :: OCS_input(:, :, :, :)
  REAL, ALLOCATABLE :: SO2_input(:, :, :, :)
  REAL, ALLOCATABLE :: OCS_input_mth(:, :, :)
  REAL, ALLOCATABLE :: SO2_input_mth(:, :, :)
  REAL, SAVE, ALLOCATABLE :: OCS_input_tmp(:, :)
  REAL, SAVE, ALLOCATABLE :: SO2_input_tmp(:, :)
  REAL, ALLOCATABLE :: OCS_lifetime_in(:, :, :, :)
  REAL, ALLOCATABLE :: SO2_lifetime_in(:, :, :, :)
  REAL, ALLOCATABLE :: OCS_lifetime_mth(:, :, :)
  REAL, ALLOCATABLE :: SO2_lifetime_mth(:, :, :)
  REAL, SAVE, ALLOCATABLE :: OCS_lifetime_tmp(:, :)
  REAL, SAVE, ALLOCATABLE :: SO2_lifetime_tmp(:, :)
!
  INTEGER i, k, kk, ilon, ilev, j
  REAL p_bound

! For NetCDF:
  INTEGER ncid_in  ! IDs for input files
  INTEGER varid, ncerr

! variable output
  REAL OCS_backgr_tend_glo(klon_glo,klev)
  REAL SO2_backgr_tend_glo(klon_glo,klev)
  REAL OCS_backgr_tend(klon,klev)
  REAL SO2_backgr_tend(klon,klev)
  REAL OCS_lifetime_glo(klon_glo,klev)
  REAL SO2_lifetime_glo(klon_glo,klev)
  REAL OCS_lifetime(klon,klev)
  REAL SO2_lifetime(klon,klev)
    
  INTEGER, PARAMETER :: lev_input=17
!--pressure at interfaces of input data (in Pa)
  REAL, DIMENSION(lev_input+1), PARAMETER ::          & 
                    paprs_input=(/                    &
  1.00000002e+05,   6.06530673e+04,   3.67879449e+04, &
  2.23130165e+04,   1.35335286e+04,   8.20850004e+03, &
  4.97870695e+03,   3.01973841e+03,   1.83156393e+03, &
  1.11089968e+03,   6.73794715e+02,   4.08677153e+02, &
  2.47875223e+02,   1.50343923e+02,   9.11881985e+01, &
  5.53084382e+01,   3.35462635e+01,   0.0           /)
!
  REAL, PARAMETER :: epsilon_OCS=1.0e-20     ! minimum OCS concentration [kg/kgA] for weighting of lifetime
  REAL, PARAMETER :: epsilon_SO2=1.0e-20     ! minimum SO2 concentration [kg/kgA] for weighting of lifetime
  REAL, PARAMETER :: min_OCS_lifetime= 3600. !minimum OCS lifetime [sec]
  REAL, PARAMETER :: min_SO2_lifetime=86400. !minimum SO2 lifetime [sec]

!--preparation of fields
  CALL gather(paprs, paprs_glo)
  CALL gather(tr_seri, tr_seri_glo)

  IF (debutphy.AND.is_mpi_root) THEN

!--reading emission files
    CALL nf95_open("ocs_so2_annual_lmdz.nc", nf90_nowrite, ncid_in)

    CALL nf95_inq_varid(ncid_in, "LEV", varid)
    CALL nf95_gw_var(ncid_in, varid, lev)
    n_lev = size(lev)

    CALL nf95_inq_varid(ncid_in, "lat", varid)
    CALL nf95_gw_var(ncid_in, varid, latitude)
    n_lat = size(latitude)

    CALL nf95_inq_varid(ncid_in, "lon", varid)
    CALL nf95_gw_var(ncid_in, varid, longitude)
    n_lon = size(longitude)

    CALL nf95_inq_varid(ncid_in, "TIME", varid)
    CALL nf95_gw_var(ncid_in, varid, time)
    n_mth = size(time)

    IF (.NOT.allocated(OCS_input))  allocate(OCS_input(n_lon, n_lat, n_lev, n_mth))
    IF (.NOT.allocated(SO2_input))  allocate(SO2_input(n_lon, n_lat, n_lev, n_mth))
    IF (.NOT.allocated(OCS_lifetime_in))  allocate(OCS_lifetime_in(n_lon, n_lat, n_lev, n_mth))
    IF (.NOT.allocated(SO2_lifetime_in))  allocate(SO2_lifetime_in(n_lon, n_lat, n_lev, n_mth))

    CALL nf95_inq_varid(ncid_in, "OCS", varid)
    ncerr = nf90_get_var(ncid_in, varid, OCS_input)
    print *,'code erreur OCS=', ncerr, varid

    CALL nf95_inq_varid(ncid_in, "SO2", varid)
    ncerr = nf90_get_var(ncid_in, varid, SO2_input)
    print *,'code erreur SO2=', ncerr, varid

    CALL nf95_inq_varid(ncid_in, "OCS_LIFET", varid)
    ncerr = nf90_get_var(ncid_in, varid, OCS_lifetime_in)
    print *,'code erreur OCS_lifetime_in=', ncerr, varid

    CALL nf95_inq_varid(ncid_in, "SO2_LIFET", varid)
    ncerr = nf90_get_var(ncid_in, varid, SO2_lifetime_in)
    print *,'code erreur SO2_lifetime_in=', ncerr, varid

    CALL nf95_close(ncid_in)

    IF (.NOT.allocated(OCS_input_mth)) allocate(OCS_input_mth(n_lon, n_lat, n_lev))
    IF (.NOT.allocated(SO2_input_mth)) allocate(SO2_input_mth(n_lon, n_lat, n_lev))
    IF (.NOT.allocated(OCS_input_tmp)) allocate(OCS_input_tmp(klon_glo, n_lev))
    IF (.NOT.allocated(SO2_input_tmp)) allocate(SO2_input_tmp(klon_glo, n_lev))
    IF (.NOT.allocated(OCS_lifetime_mth)) allocate(OCS_lifetime_mth(n_lon, n_lat, n_lev))
    IF (.NOT.allocated(SO2_lifetime_mth)) allocate(SO2_lifetime_mth(n_lon, n_lat, n_lev))
    IF (.NOT.allocated(OCS_lifetime_tmp)) allocate(OCS_lifetime_tmp(klon_glo, n_lev))
    IF (.NOT.allocated(SO2_lifetime_tmp)) allocate(SO2_lifetime_tmp(klon_glo, n_lev))

!---select the correct month, undo multiplication with 1.e12 (precision reasons)
!---correct latitudinal order and convert input from volume mixing ratio to mass mixing ratio
    nmth=mth_cur
    DO j=1,n_lat
      SO2_input_mth(:,j,:) = 1.e-12*SO2_input(:,n_lat+1-j,:,nmth)*mSO2mol/mAIRmol
      OCS_input_mth(:,j,:) = 1.e-12*OCS_input(:,n_lat+1-j,:,nmth)*mOCSmol/mAIRmol
      SO2_lifetime_mth(:,j,:) = SO2_lifetime_in(:,n_lat+1-j,:,nmth)
      OCS_lifetime_mth(:,j,:) = OCS_lifetime_in(:,n_lat+1-j,:,nmth)
    ENDDO

!---reduce to a klon_glo grid but keep the levels
    CALL grid2dTo1d_glo(OCS_input_mth,OCS_input_tmp)
    CALL grid2dTo1d_glo(SO2_input_mth,SO2_input_tmp)
    CALL grid2dTo1d_glo(OCS_lifetime_mth,OCS_lifetime_tmp)
    CALL grid2dTo1d_glo(SO2_lifetime_mth,SO2_lifetime_tmp)

!--set lifetime to very high value in uninsolated areas
    DO i=1, klon_glo
      DO kk=1, n_lev
        IF (OCS_lifetime_tmp(i,kk)==0.0) THEN
          OCS_lifetime_tmp(i,kk)=1.0e12
        ENDIF
        IF (SO2_lifetime_tmp(i,kk)==0.0) THEN
          SO2_lifetime_tmp(i,kk)=1.0e12
        ENDIF
      ENDDO
    ENDDO

  ENDIF !(debutphy.AND.is_mpi_root)

  IF (is_mpi_root) THEN

!--set to background value everywhere in the very beginning, later only in the troposphere
      IF (debutphy.AND.MAXVAL(tr_seri_glo).LT.1.e-30) THEN
        p_bound=0.0
      ELSE
        p_bound=50000.
      ENDIF

!--regridding tracer concentration on the vertical
      DO i=1, klon_glo
        DO k=1, klev
          !
          OCS_tmp=tr_seri_glo(i,k,id_OCS_strat)
          SO2_tmp=tr_seri_glo(i,k,id_SO2_strat)
          !--OCS and SO2 prescribed below p_bound
          IF (paprs_glo(i,k).GT.p_bound) THEN
            tr_seri_glo(i,k,id_OCS_strat)=0.0
            tr_seri_glo(i,k,id_SO2_strat)=0.0
            DO kk=1, n_lev
            tr_seri_glo(i,k,id_OCS_strat)=tr_seri_glo(i,k,id_OCS_strat)+ &
               MAX(0.0,MIN(paprs_glo(i,k),paprs_input(kk))-MAX(paprs_glo(i,k+1),paprs_input(kk+1))) &
               *OCS_input_tmp(i,kk)/(paprs_glo(i,k)-paprs_glo(i,k+1))
            tr_seri_glo(i,k,id_SO2_strat)=tr_seri_glo(i,k,id_SO2_strat)+ &
               MAX(0.0,MIN(paprs_glo(i,k),paprs_input(kk))-MAX(paprs_glo(i,k+1),paprs_input(kk+1))) &
               *SO2_input_tmp(i,kk)/(paprs_glo(i,k)-paprs_glo(i,k+1))
            ENDDO
          ENDIF
          OCS_backgr_tend_glo(i,k)=tr_seri_glo(i,k,id_OCS_strat)-OCS_tmp
          SO2_backgr_tend_glo(i,k)=tr_seri_glo(i,k,id_SO2_strat)-SO2_tmp
          !---regrid weighted lifetime
          OCS_lifetime_glo(i,k)=0.0
          SO2_lifetime_glo(i,k)=0.0
          DO kk=1, n_lev
          OCS_lifetime_glo(i,k)=OCS_lifetime_glo(i,k)+ &
               MAX(0.0,MIN(paprs_glo(i,k),paprs_input(kk))-MAX(paprs_glo(i,k+1),paprs_input(kk+1))) &
               *OCS_lifetime_tmp(i,kk)/(paprs_glo(i,k)-paprs_glo(i,k+1))
          SO2_lifetime_glo(i,k)=SO2_lifetime_glo(i,k)+ &
               MAX(0.0,MIN(paprs_glo(i,k),paprs_input(kk))-MAX(paprs_glo(i,k+1),paprs_input(kk+1))) &
               *SO2_lifetime_tmp(i,kk)/(paprs_glo(i,k)-paprs_glo(i,k+1))
          ENDDO
        ENDDO
      ENDDO

  ENDIF !--is_mpi_root

  CALL scatter(tr_seri_glo, tr_seri)
  CALL scatter(OCS_backgr_tend_glo, OCS_backgr_tend)
  CALL scatter(SO2_backgr_tend_glo, SO2_backgr_tend)
  CALL scatter(OCS_lifetime_glo, OCS_lifetime)
  CALL scatter(SO2_lifetime_glo, SO2_lifetime)

  !convert SO2_backgr_tend from kg(SO2)/kgA to kg(S)/m2/layer/s for saving as diagnostic
  DO ilon=1, klon
    DO ilev=1, klev
      SO2_backgr_tend(ilon,ilev)=SO2_backgr_tend(ilon,ilev)*mSatom/mSO2mol*(paprs(ilon,ilev)-paprs(ilon,ilev+1))/RG/pdtphys
      OCS_backgr_tend(ilon,ilev)=OCS_backgr_tend(ilon,ilev)*mSatom/mOCSmol*(paprs(ilon,ilev)-paprs(ilon,ilev+1))/RG/pdtphys
    ENDDO
  ENDDO
 
  RETURN

END SUBROUTINE interp_sulf_input
