!
! $Id: readaerosolstrato2_rrtm.F90 2526 2016-05-26 22:13:40Z oboucher $
!
subroutine readaerosolstrato2_rrtm(debut)

    use netcdf95, only: nf95_close, nf95_gw_var, nf95_inq_dimid, & 
                        nf95_inq_varid, nf95_open
    use netcdf, only: nf90_get_var, nf90_noerr, nf90_nowrite

    USE phys_cal_mod, ONLY : mth_cur
    USE mod_grid_phy_lmdz, ONLY: nbp_lon, nbp_lat, klon_glo, grid2dTo1d_glo
    USE mod_phys_lmdz_mpi_data, ONLY :  is_mpi_root
    USE mod_phys_lmdz_omp_data, ONLY :  is_omp_root
    USE mod_phys_lmdz_para 
    USE phys_state_var_mod
    USE phys_local_var_mod
    USE aero_mod
    USE dimphy
    USE YOERAD   , ONLY : NLW

    implicit none

    include "YOMCST.h"

    CHARACTER (len = 80) :: abort_message
    CHARACTER (LEN=20) :: modname = 'readaerosolstrato2'

! Variable input
    logical, intent(in) ::  debut

! Variables locales
    integer n_lat   ! number of latitudes in the input data
    integer n_lon   ! number of longitudes
    integer n_lev   ! number of levels in the input data
    integer n_month ! number of months in the input data
    integer n_wav   ! number of wavelengths in the input data
    real, pointer:: latitude(:)
    real, pointer:: longitude(:)
    real, pointer:: time(:)
    real, pointer:: lev(:)
    real, pointer:: wav(:)
    integer i,k,wave,band
    integer, save :: mth_pre

    real, allocatable, dimension(:,:,:), save :: tau_aer_strat
    real, allocatable, dimension(:,:,:), save :: piz_aer_strat
    real, allocatable, dimension(:,:,:), save :: cg_aer_strat
    real, allocatable, dimension(:,:,:), save :: taulw_aer_strat
!$OMP THREADPRIVATE(tau_aer_strat,piz_aer_strat,cg_aer_strat,taulw_aer_strat)

! Champs reconstitues
    real, allocatable:: tauaerstrat(:, :, :, :)
    real, allocatable:: pizaerstrat(:, :, :, :)
    real, allocatable:: cgaerstrat(:, :, :, :)
    real, allocatable:: taulwaerstrat(:, :, :, :)

    real, allocatable:: tauaerstrat_mois(:, :, :, :)
    real, allocatable:: pizaerstrat_mois(:, :, :, :)
    real, allocatable:: cgaerstrat_mois(:, :, :, :)
    real, allocatable:: taulwaerstrat_mois(:, :, :, :)

    real, allocatable:: tauaerstrat_mois_glo(:, :, :)
    real, allocatable:: pizaerstrat_mois_glo(:, :, :)
    real, allocatable:: cgaerstrat_mois_glo(:, :, :)
    real, allocatable:: taulwaerstrat_mois_glo(:, :, :)

! For NetCDF:
    integer ncid_in  ! IDs for input files
    integer varid, ncerr

!--------------------------------------------------------

    IF (.not.ALLOCATED(tau_aer_strat)) ALLOCATE(tau_aer_strat(klon,klev,nbands_sw_rrtm))
    IF (.not.ALLOCATED(piz_aer_strat)) ALLOCATE(piz_aer_strat(klon,klev,nbands_sw_rrtm))
    IF (.not.ALLOCATED(cg_aer_strat))  ALLOCATE(cg_aer_strat(klon,klev,nbands_sw_rrtm))

    IF (.not.ALLOCATED(taulw_aer_strat)) ALLOCATE(taulw_aer_strat(klon,klev,nbands_lw_rrtm))

!--we only read monthly strat aerosol data
    IF (debut.OR.mth_cur.NE.mth_pre) THEN

!--only root reads the data
    IF (is_mpi_root.AND.is_omp_root) THEN

!--check mth_cur
    IF (mth_cur.LT.1.OR.mth_cur.GT.12) THEN
      print *,'probleme avec le mois dans readaerosolstrat =', mth_cur
    ENDIF

!--initialize n_lon as input data is 2D (lat-alt) only
    n_lon = nbp_lon

!--Starts with SW optical properties
    IF (nbands_sw_rrtm.NE.6) THEN 
       abort_message='nbands_sw_rrtm doit etre egal a 6 dans readaerosolstrat_rrtm'
       CALL abort_physic(modname,abort_message,1)
    ENDIF

    CALL nf95_open("tauswstrat.2D.nc", nf90_nowrite, ncid_in)

    CALL nf95_inq_varid(ncid_in, "LEV", varid)
    CALL nf95_gw_var(ncid_in, varid, lev)
    n_lev = size(lev)
    IF (n_lev.NE.klev) THEN 
       abort_message='Le nombre de niveaux n est pas egal a klev'
       CALL abort_physic(modname,abort_message,1)
    ENDIF

    CALL nf95_inq_varid(ncid_in, "LAT", varid)
    CALL nf95_gw_var(ncid_in, varid, latitude)
    n_lat = size(latitude)
    IF (n_lat.NE.nbp_lat) THEN 
       print *, 'latitude=', n_lat, nbp_lat
       abort_message='Le nombre de lat n est pas egal a nbp_lat'
       CALL abort_physic(modname,abort_message,1)
    ENDIF

    CALL nf95_inq_varid(ncid_in, "TIME", varid)
    CALL nf95_gw_var(ncid_in, varid, time)
    n_month = size(time)
    IF (n_month.NE.12) THEN 
       abort_message='Le nombre de month n est pas egal a 12'
       CALL abort_physic(modname,abort_message,1)
    ENDIF

    CALL nf95_inq_varid(ncid_in, "WAV", varid)
    CALL nf95_gw_var(ncid_in, varid, wav)
    n_wav = size(wav)
    print *, 'WAV aerosol strato=', n_wav, wav
    IF (n_wav.NE.nbands_sw_rrtm) THEN 
       abort_message='Le nombre de wav n est pas egal a NSW'
       CALL abort_physic(modname,abort_message,1)
    ENDIF

    ALLOCATE(tauaerstrat(n_lat, n_lev, n_wav, n_month))
    ALLOCATE(pizaerstrat(n_lat, n_lev, n_wav, n_month))
    ALLOCATE(cgaerstrat(n_lat, n_lev, n_wav, n_month))

    ALLOCATE(tauaerstrat_mois(n_lon, n_lat, n_lev, n_wav))
    ALLOCATE(pizaerstrat_mois(n_lon, n_lat, n_lev, n_wav))
    ALLOCATE(cgaerstrat_mois(n_lon, n_lat, n_lev, n_wav))

    ALLOCATE(tauaerstrat_mois_glo(klon_glo, n_lev, n_wav))
    ALLOCATE(pizaerstrat_mois_glo(klon_glo, n_lev, n_wav))
    ALLOCATE(cgaerstrat_mois_glo(klon_glo, n_lev, n_wav))

!--reading stratospheric aerosol tau per layer
    CALL nf95_inq_varid(ncid_in, "TAU_SUN", varid)
    ncerr = nf90_get_var(ncid_in, varid, tauaerstrat)
    print *,'code erreur readaerosolstrato=', ncerr, varid

!--reading stratospheric aerosol omega per layer
    CALL nf95_inq_varid(ncid_in, "OME_SUN", varid)
    ncerr = nf90_get_var(ncid_in, varid, pizaerstrat)
    print *,'code erreur readaerosolstrato=', ncerr, varid

!--reading stratospheric aerosol g per layer
    CALL nf95_inq_varid(ncid_in, "GGG_SUN", varid)
    ncerr = nf90_get_var(ncid_in, varid, cgaerstrat)
    print *,'code erreur readaerosolstrato sw=', ncerr, varid

    CALL nf95_close(ncid_in)

!--select the correct month
!--and copy into 1st longitude
    tauaerstrat_mois(1,:,:,:) = tauaerstrat(:,:,:,mth_cur)
    pizaerstrat_mois(1,:,:,:) = pizaerstrat(:,:,:,mth_cur)
    cgaerstrat_mois(1,:,:,:)  = cgaerstrat(:,:,:,mth_cur)

!--copy longitudes
    DO i=2, n_lon
     tauaerstrat_mois(i,:,:,:) = tauaerstrat_mois(1,:,:,:)
     pizaerstrat_mois(i,:,:,:) = pizaerstrat_mois(1,:,:,:)
      cgaerstrat_mois(i,:,:,:)  = cgaerstrat_mois(1,:,:,:)
    ENDDO

!---reduce to a klon_glo grid 
    DO band=1, nbands_sw_rrtm
      CALL grid2dTo1d_glo(tauaerstrat_mois(:,:,:,band),tauaerstrat_mois_glo(:,:,band))
      CALL grid2dTo1d_glo(pizaerstrat_mois(:,:,:,band),pizaerstrat_mois_glo(:,:,band))
      CALL grid2dTo1d_glo(cgaerstrat_mois(:,:,:,band),cgaerstrat_mois_glo(:,:,band))
    ENDDO

!--Now LW optical properties
!
    IF (nbands_lw_rrtm .NE. NLW) then
      abort_message='different values for NLW and nbands_lw_rrtm'
      CALL abort_physic(modname,abort_message,1)
    ENDIF 

    CALL nf95_open("taulwstrat.2D.nc", nf90_nowrite, ncid_in)

    CALL nf95_inq_varid(ncid_in, "LEV", varid)
    CALL nf95_gw_var(ncid_in, varid, lev)
    n_lev = size(lev)
    IF (n_lev.NE.klev) THEN 
       abort_message='Le nombre de niveaux n est pas egal a klev'
       CALL abort_physic(modname,abort_message,1)
    ENDIF

    CALL nf95_inq_varid(ncid_in, "LAT", varid)
    CALL nf95_gw_var(ncid_in, varid, latitude)
    n_lat = size(latitude)
    IF (n_lat.NE.nbp_lat) THEN 
       abort_message='Le nombre de lat n est pas egal a nbp_lat'
       CALL abort_physic(modname,abort_message,1)
    ENDIF

    CALL nf95_inq_varid(ncid_in, "TIME", varid)
    CALL nf95_gw_var(ncid_in, varid, time)
    n_month = size(time)
    IF (n_month.NE.12) THEN 
       abort_message='Le nombre de month n est pas egal a 12'
       CALL abort_physic(modname,abort_message,1)
    ENDIF

    CALL nf95_inq_varid(ncid_in, "WAV", varid)
    CALL nf95_gw_var(ncid_in, varid, wav)
    n_wav = size(wav)
    print *, 'WAV aerosol strato=', n_wav, wav
    IF (n_wav.NE.nbands_lw_rrtm) THEN 
       abort_message='Le nombre de wav n est pas egal a NLW'
       CALL abort_physic(modname,abort_message,1)
    ENDIF

    ALLOCATE(taulwaerstrat(n_lat, n_lev, n_wav, n_month))
    ALLOCATE(taulwaerstrat_mois(n_lon, n_lat, n_lev, n_wav))
    ALLOCATE(taulwaerstrat_mois_glo(klon_glo, n_lev, n_wav))

!--reading stratospheric aerosol lw tau per layer
    CALL nf95_inq_varid(ncid_in, "TAU_EAR", varid)
    ncerr = nf90_get_var(ncid_in, varid, taulwaerstrat)
    print *,'code erreur readaerosolstrato lw=', ncerr, varid

    CALL nf95_close(ncid_in)

!--select the correct month
!--and copy into 1st longitude
    taulwaerstrat_mois(1,:,:,:) = taulwaerstrat(:,:,:,mth_cur)
!--copy longitudes
    DO i=2, n_lon
      taulwaerstrat_mois(i,:,:,:) = taulwaerstrat_mois(1,:,:,:)
    ENDDO

!---reduce to a klon_glo grid 
    DO band=1, nbands_lw_rrtm
      CALL grid2dTo1d_glo(taulwaerstrat_mois(:,:,:,band),taulwaerstrat_mois_glo(:,:,band))
    ENDDO

    ENDIF !--is_mpi_root and is_omp_root

!$OMP BARRIER

!--keep memory of previous month
    mth_pre=mth_cur

!--scatter on all proc
    CALL scatter(tauaerstrat_mois_glo,tau_aer_strat)
    CALL scatter(pizaerstrat_mois_glo,piz_aer_strat)
    CALL scatter(cgaerstrat_mois_glo,cg_aer_strat)
    CALL scatter(taulwaerstrat_mois_glo,taulw_aer_strat)

    IF (is_mpi_root.AND.is_omp_root) THEN
!
    DEALLOCATE(tauaerstrat, pizaerstrat, cgaerstrat)
    DEALLOCATE(tauaerstrat_mois, pizaerstrat_mois, cgaerstrat_mois)
    DEALLOCATE(tauaerstrat_mois_glo,pizaerstrat_mois_glo,cgaerstrat_mois_glo)

    DEALLOCATE(taulwaerstrat,taulwaerstrat_mois,taulwaerstrat_mois_glo)
!
    ENDIF !--is_mpi_root and is_omp_root

!$OMP BARRIER

    ENDIF !--debut ou nouveau mois

!--total vertical aod at the 5 SW wavelengths
!--for now use band 3 AOD into all 5 wavelengths
    band=3
    DO i=1, klon
    DO k=1, klev
      IF (stratomask(i,k).GT.0.999999) THEN
        DO wave=1, nwave
          tausum_aero(:,wave,id_STRAT_phy)=tausum_aero(:,wave,id_STRAT_phy)+tau_aer_strat(:,k,band)
        ENDDO
      ENDIF
    ENDDO
    ENDDO

!--weighted average for cg, piz and tau, adding strat aerosols on top of tropospheric ones
    DO band=1, nbands_sw_rrtm
    WHERE (stratomask.GT.0.999999)
!--anthropogenic aerosols bands 1 to nbands_sw_rrtm 
    cg_aero_sw_rrtm(:,:,2,band)  = ( cg_aero_sw_rrtm(:,:,2,band)*piz_aero_sw_rrtm(:,:,2,band)*tau_aero_sw_rrtm(:,:,2,band) + &
                                     cg_aer_strat(:,:,band)*piz_aer_strat(:,:,band)*tau_aer_strat(:,:,band) ) /              &
                                MAX( piz_aero_sw_rrtm(:,:,2,band)*tau_aero_sw_rrtm(:,:,2,band) +                             &
                                     piz_aer_strat(:,:,band)*tau_aer_strat(:,:,band), 1.e-15 )
    piz_aero_sw_rrtm(:,:,2,band) = ( piz_aero_sw_rrtm(:,:,2,band)*tau_aero_sw_rrtm(:,:,2,band) +                             &
                                     piz_aer_strat(:,:,band)*tau_aer_strat(:,:,band) ) /                                     &
                                MAX( tau_aero_sw_rrtm(:,:,2,band) + tau_aer_strat(:,:,band), 1.e-15 )
    tau_aero_sw_rrtm(:,:,2,band)  = tau_aero_sw_rrtm(:,:,2,band) + tau_aer_strat(:,:,band)
!--natural aerosols bands 1 to nbands_sw_rrtm
    cg_aero_sw_rrtm(:,:,1,band)  = ( cg_aero_sw_rrtm(:,:,1,band)*piz_aero_sw_rrtm(:,:,1,band)*tau_aero_sw_rrtm(:,:,1,band) + &
                                     cg_aer_strat(:,:,band)*piz_aer_strat(:,:,band)*tau_aer_strat(:,:,band) ) /              &
                                MAX( piz_aero_sw_rrtm(:,:,1,band)*tau_aero_sw_rrtm(:,:,1,band) +                             &
                                     piz_aer_strat(:,:,band)*tau_aer_strat(:,:,band), 1.e-15 )
    piz_aero_sw_rrtm(:,:,1,band) = ( piz_aero_sw_rrtm(:,:,1,band)*tau_aero_sw_rrtm(:,:,1,band) +                             &
                                     piz_aer_strat(:,:,band)*tau_aer_strat(:,:,band) ) /                                     &
                                MAX( tau_aero_sw_rrtm(:,:,1,band) + tau_aer_strat(:,:,band), 1.e-15 )
    tau_aero_sw_rrtm(:,:,1,band)  = tau_aero_sw_rrtm(:,:,1,band) + tau_aer_strat(:,:,band)
!--no stratospheric aerosol in index 1 for these tests
!    cg_aero_sw_rrtm(:,:,1,band)  =  cg_aero_sw_rrtm(:,:,1,band)
!    piz_aero_sw_rrtm(:,:,1,band)  = piz_aero_sw_rrtm(:,:,1,band)
!    tau_aero_sw_rrtm(:,:,1,band)  = tau_aero_sw_rrtm(:,:,1,band)
    ENDWHERE
    ENDDO

    DO band=1, nbands_lw_rrtm
    WHERE (stratomask.GT.0.999999)
    tau_aero_lw_rrtm(:,:,2,band)  = tau_aero_lw_rrtm(:,:,2,band) + taulw_aer_strat(:,:,band)
    tau_aero_lw_rrtm(:,:,1,band)  = tau_aero_lw_rrtm(:,:,1,band) + taulw_aer_strat(:,:,band)
!--no stratospheric aerosols in index 1 for these tests
!    tau_aero_lw_rrtm(:,:,1,band)  = tau_aero_lw_rrtm(:,:,1,band) 
    ENDWHERE
    ENDDO

!--default SSA value if there is no aerosol
!--to avoid 0 values that seems to cause some problem to RRTM
    WHERE (tau_aero_sw_rrtm.LT.1.e-14)
      piz_aero_sw_rrtm = 1.0
    ENDWHERE

!--in principle this should not be necessary 
!--as these variables have min values already but just in case
!--put 1e-15 min value to both SW and LW AOD
    tau_aero_sw_rrtm = MAX(tau_aero_sw_rrtm,1.e-15)
    tau_aero_lw_rrtm = MAX(tau_aero_lw_rrtm,1.e-15)

end subroutine readaerosolstrato2_rrtm
