subroutine water_int(klon,klev,field3d,mass,field2d)

!=============================================================
! Compute the 2D burden from 3D mixing ratios
!  OB (obolmd@lmd.jussieu.fr)
!=============================================================

USE phys_local_var_mod, ONLY : d_u_vdf,d_v_vdf,d_t_vdf,d_u_ajs,d_v_ajs,d_t_ajs,d_u_con,d_v_con,d_t_con,d_t_diss
USE phys_local_var_mod, ONLY : d_t_eva,d_t_lsc,d_q_eva,d_q_lsc
USE phys_output_var_mod, ONLY : bils_ec,bils_ech,bils_tke,bils_kinetic,bils_enthalp,bils_latent,bils_diss

IMPLICIT none

! Arguments
INTEGER, INTENT(IN) :: klon,klev
REAL, DIMENSION(klon,klev),INTENT(IN)  :: field3d, mass 
REAL, DIMENSION(klon),     INTENT(OUT) :: field2d

INTEGER k

field2d(:)=0.0
DO k=1, klev
field2d(:)=field2d(:)+field3d(:,k)*mass(:,k)
ENDDO

RETURN
END
