!
! $Id: conf_phys.F90 1668 2012-10-12 10:47:37Z idelkadi $
!
!
!
module conf_phys_m

  implicit none

contains

  subroutine conf_phys(ok_journe, ok_mensuel, ok_instan, ok_hf, &
       ok_LES,&
       callstats,&
       solarlong0,seuil_inversion, &
       fact_cldcon, facttemps,ok_newmicro,iflag_radia,&
       iflag_cld_th, &
       iflag_ratqs,ratqsbas,ratqshaut,tau_ratqs, &
       ok_ade, ok_aie, ok_cdnc, aerosol_couple, &
       flag_aerosol, flag_aerosol_strat, new_aod, &
       bl95_b0, bl95_b1,&
       read_climoz, &
       alp_offset)

    use IOIPSL
    USE surface_data
    USE phys_cal_mod
    USE carbon_cycle_mod, ONLY : carbon_cycle_tr, carbon_cycle_cpl
    USE mod_grid_phy_lmdz, only: klon_glo
    USE print_control_mod, ONLY: lunout


    include "conema3.h"
    include "fisrtilp.h"
    include "nuage.h"
    include "YOMCST.h"
    include "YOMCST2.h"

    include "thermcell.h"


    !IM : on inclut/initialise les taux de CH4, N2O, CFC11 et CFC12
    include "clesphys.h"
    include "compbl.h"
    include "comsoil.h"
    include "YOEGWD.h"
    !
    ! Configuration de la "physique" de LMDZ a l'aide de la fonction
    ! GETIN de IOIPSL
    !
    ! LF 05/2001
    !

    !
    ! type_ocean:      type d'ocean (force, slab, couple)
    ! version_ocean:   version d'ocean (opa8/nemo pour type_ocean=couple ou 
    !                                   sicOBS,sicINT,sicNO pour type_ocean=slab)
    ! ok_veget:   type de modele de vegetation
    ! ok_journe:  sorties journalieres
    ! ok_hf:  sorties haute frequence
    ! ok_mensuel: sorties mensuelles
    ! ok_instan:  sorties instantanees
    ! ok_ade, ok_aie: apply or not aerosol direct and indirect effects
    ! ok_cdnc, ok cloud droplet number concentration
    ! flag_aerosol_strat : flag pour les aerosols stratos
    ! bl95_b*: parameters in the formula to link CDNC to aerosol mass conc 
    !


    ! Sortie:
    logical              :: ok_newmicro
    integer              :: iflag_radia
    logical              :: ok_journe, ok_mensuel, ok_instan, ok_hf
    logical              :: ok_LES
    LOGICAL              :: callstats
    LOGICAL              :: ok_ade, ok_aie, ok_cdnc, aerosol_couple
    INTEGER              :: flag_aerosol
    LOGICAL              :: flag_aerosol_strat
    LOGICAL              :: new_aod
    REAL                 :: bl95_b0, bl95_b1
    real                 :: fact_cldcon, facttemps,ratqsbas,ratqshaut,tau_ratqs
    integer              :: iflag_cld_th
    integer              :: iflag_ratqs

    character (len = 6),SAVE  :: type_ocean_omp, version_ocean_omp, ocean_omp
    character (len = 10),SAVE  :: type_veget_omp
    CHARACTER(len = 8),SAVE   :: aer_type_omp
    logical,SAVE              :: ok_snow_omp
    logical,SAVE              :: ok_newmicro_omp
    logical,SAVE              :: ok_all_xml_omp
    logical,SAVE        :: ok_journe_omp, ok_mensuel_omp, ok_instan_omp, ok_hf_omp        
    logical,SAVE        :: ok_LES_omp   
    LOGICAL,SAVE        :: callstats_omp
    LOGICAL,SAVE        :: ok_ade_omp, ok_aie_omp, ok_cdnc_omp, aerosol_couple_omp
    INTEGER, SAVE       :: flag_aerosol_omp
    LOGICAL, SAVE       :: flag_aerosol_strat_omp
    LOGICAL, SAVE       :: new_aod_omp
    REAL,SAVE           :: bl95_b0_omp, bl95_b1_omp
    REAL,SAVE           :: freq_ISCCP_omp, ecrit_ISCCP_omp
    REAL,SAVE           :: freq_COSP_omp
    real,SAVE           :: fact_cldcon_omp, facttemps_omp,ratqsbas_omp
    real,SAVE           :: tau_cld_cv_omp, coefw_cld_cv_omp
    integer,SAVE        :: iflag_cld_cv_omp


    real,SAVE           :: ratqshaut_omp
    real,SAVE           :: tau_ratqs_omp
    REAL, SAVE          :: t_coupl_omp
    integer,SAVE        :: iflag_radia_omp
    integer,SAVE        :: iflag_rrtm_omp
    integer,SAVE        :: iflag_albedo_omp !albedo SB
    logical,save        :: ok_chlorophyll_omp ! albedo SB  
    integer,SAVE        :: NSW_omp
    integer,SAVE        :: iflag_cld_th_omp, ip_ebil_phy_omp
    integer,SAVE        :: iflag_ratqs_omp

    Real,SAVE           :: f_cdrag_ter_omp,f_cdrag_oce_omp
    Real,SAVE           :: f_rugoro_omp   , z0min_omp
    Real,SAVE           :: z0m_seaice_omp,z0h_seaice_omp
    REAL,SAVE           :: min_wind_speed_omp,f_gust_wk_omp,f_gust_bl_omp,f_qsat_oce_omp, f_z0qh_oce_omp
    INTEGER,SAVE        :: iflag_gusts_omp,iflag_z0_oce_omp

    ! Local
    real                 :: zzz

    real :: seuil_inversion
    real,save :: seuil_inversion_omp

    integer,SAVE :: iflag_thermals_ed_omp,iflag_thermals_optflux_omp,iflag_thermals_closure_omp
    real, SAVE :: fact_thermals_ed_dz_omp
    integer,SAVE :: iflag_thermals_omp,nsplit_thermals_omp
    real,save :: tau_thermals_omp,alp_bl_k_omp
    ! nrlmd le 10/04/2012
    integer,SAVE :: iflag_trig_bl_omp,iflag_clos_bl_omp
    integer,SAVE :: tau_trig_shallow_omp,tau_trig_deep_omp
    real,SAVE    :: s_trig_omp
    ! fin nrlmd le 10/04/2012
    real :: alp_offset
    REAL, SAVE :: alp_offset_omp
    integer,SAVE :: iflag_coupl_omp,iflag_clos_omp,iflag_wake_omp
    integer,SAVE :: iflag_cvl_sigd_omp
    REAL, SAVE :: coef_clos_ls_omp
    REAL, SAVE :: supcrit1_omp, supcrit2_omp
    INTEGER, SAVE :: iflag_mix_omp
    INTEGER, SAVE :: iflag_mix_adiab_omp
    real, save :: scut_omp, qqa1_omp, qqa2_omp, gammas_omp, Fmax_omp, alphas_omp
    REAL, SAVE :: tmax_fonte_cv_omp

    REAL,SAVE :: R_ecc_omp,R_peri_omp,R_incl_omp,solaire_omp
    REAL,SAVE :: co2_ppm_omp, RCO2_omp, co2_ppm_per_omp, RCO2_per_omp
    REAL,SAVE :: CH4_ppb_omp, RCH4_omp, CH4_ppb_per_omp, RCH4_per_omp
    REAL,SAVE :: N2O_ppb_omp, RN2O_omp, N2O_ppb_per_omp, RN2O_per_omp
    REAL,SAVE :: CFC11_ppt_omp,RCFC11_omp,CFC11_ppt_per_omp,RCFC11_per_omp
    REAL,SAVE :: CFC12_ppt_omp,RCFC12_omp,CFC12_ppt_per_omp,RCFC12_per_omp
    LOGICAL,SAVE :: ok_4xCO2atm_omp
    REAL,SAVE :: epmax_omp
    REAL,SAVE :: coef_epmax_cape_omp
    LOGICAL,SAVE :: ok_adj_ema_omp
    INTEGER,SAVE :: iflag_clw_omp
    REAL,SAVE :: cld_lc_lsc_omp,cld_lc_con_omp,cld_tau_lsc_omp,cld_tau_con_omp
    REAL,SAVE :: ffallv_lsc_omp, ffallv_con_omp,coef_eva_omp
    LOGICAL,SAVE :: reevap_ice_omp
    INTEGER,SAVE :: iflag_pdf_omp
    INTEGER,SAVE :: iflag_ice_thermo_omp
    INTEGER,SAVE :: iflag_t_glace_omp
    REAL,SAVE :: rad_froid_omp, rad_chau1_omp, rad_chau2_omp
    REAL,SAVE :: t_glace_min_omp, t_glace_max_omp
    REAL,SAVE :: exposant_glace_omp
    REAL,SAVE :: rei_min_omp, rei_max_omp
    REAL,SAVE :: inertie_sol_omp,inertie_sno_omp,inertie_ice_omp
    REAL,SAVE :: qsol0_omp
    REAL,SAVE :: evap0_omp
    REAL,SAVE :: albsno0_omp
    REAL      :: solarlong0
    REAL,SAVE :: solarlong0_omp
    INTEGER,SAVE :: top_height_omp,overlap_omp
    REAL,SAVE :: cdmmax_omp,cdhmax_omp,ksta_omp,ksta_ter_omp,f_ri_cd_min_omp
    LOGICAL,SAVE :: ok_kzmin_omp
    REAL, SAVE ::  fmagic_omp, pmagic_omp
    INTEGER,SAVE :: iflag_pbl_omp,lev_histhf_omp,lev_histday_omp,lev_histmth_omp
    INTEGER,SAVE :: iflag_pbl_split_omp
    INTEGER,SAVE :: iflag_order2_sollw_omp
    Integer, save :: lev_histins_omp, lev_histLES_omp 
    INTEGER, SAVE :: lev_histdayNMC_omp
    INTEGER, SAVE :: levout_histNMC_omp(3)
    LOGICAL, SAVE :: ok_histNMC_omp(3)
    REAL, SAVE :: freq_outNMC_omp(3), freq_calNMC_omp(3)
    CHARACTER*4, SAVE :: type_run_omp
    LOGICAL,SAVE :: ok_cosp_omp
    LOGICAL,SAVE :: ok_mensuelCOSP_omp,ok_journeCOSP_omp,ok_hfCOSP_omp
    REAL,SAVE :: lonmin_ins_omp, lonmax_ins_omp, latmin_ins_omp, latmax_ins_omp
    REAL,SAVE :: ecrit_hf_omp, ecrit_day_omp, ecrit_mth_omp, ecrit_reg_omp
    REAL,SAVE :: ecrit_ins_omp
    REAL,SAVE :: ecrit_LES_omp
    REAL,SAVE :: ecrit_tra_omp
    REAL,SAVE :: cvl_comp_threshold_omp
    REAL,SAVE :: cvl_sig2feed_omp
    REAL,SAVE :: cvl_corr_omp
    LOGICAL,SAVE :: ok_lic_melt_omp
    !
    LOGICAL,SAVE :: cycle_diurne_omp,soil_model_omp,new_oliq_omp
    LOGICAL,SAVE :: ok_orodr_omp, ok_orolf_omp, ok_limitvrai_omp
    INTEGER, SAVE :: nbapp_rad_omp, iflag_con_omp
    INTEGER, SAVE :: iflag_ener_conserv_omp
    LOGICAL, SAVE :: ok_conserv_q_omp
    INTEGER, SAVE :: iflag_fisrtilp_qsat_omp
    INTEGER, SAVE :: iflag_bergeron_omp
    LOGICAL,SAVE :: ok_strato_omp
    LOGICAL,SAVE :: ok_hines_omp, ok_gwd_rando_omp
    real, SAVE:: gwd_rando_ruwmax_omp, gwd_rando_sat_omp
    real, SAVE:: gwd_front_ruwmax_omp, gwd_front_sat_omp
    real, save:: sso_gkdrag_omp,sso_grahil_omp,sso_grcrit_omp
    real, save:: sso_gfrcri_omp,sso_gkwake_omp,sso_gklift_omp
    LOGICAL,SAVE :: ok_qch4_omp
    LOGICAL,SAVE      :: carbon_cycle_tr_omp
    LOGICAL,SAVE      :: carbon_cycle_cpl_omp

    integer, intent(out):: read_climoz ! read ozone climatology, OpenMP shared
    ! Allowed values are 0, 1 and 2
    ! 0: do not read an ozone climatology
    ! 1: read a single ozone climatology that will be used day and night
    ! 2: read two ozone climatologies, the average day and night
    ! climatology and the daylight climatology

    !-----------------------------------------------------------------

    print*,'CONFPHYS ENTREE'
    !$OMP MASTER 
    !Config Key  = type_ocean 
    !Config Desc = Type d'ocean
    !Config Def  = force
    !Config Help = Type d'ocean utilise: force, slab,couple
    !
    type_ocean_omp = 'force '
    call getin('type_ocean', type_ocean_omp)
    !
    !Config Key  = version_ocean 
    !Config Desc = Version d'ocean
    !Config Def  = xxxxxx
    !Config Help = Version d'ocean utilise: opa8/nemo/sicOBS/xxxxxx
    !
    version_ocean_omp = 'xxxxxx'
    call getin('version_ocean', version_ocean_omp)

    !Config Key  = OCEAN
    !Config Desc = Old parameter name for type_ocean
    !Config Def  = yyyyyy
    !Config Help = This is only for testing purpose
    !
    ocean_omp = 'yyyyyy'
    call getin('OCEAN', ocean_omp)
    IF (ocean_omp /= 'yyyyyy') THEN
       WRITE(lunout,*)'ERROR! Old variable name OCEAN used in parmeter file.'
       WRITE(lunout,*)'Variable OCEAN has been replaced by the variable type_ocean.'
       WRITE(lunout,*)'You have to update your parameter file physiq.def to succed running'
       CALL abort_physic('conf_phys','Variable OCEAN no longer existing, use variable name type_ocean',1)
    END IF

    !Config Key  = t_coupl
    !Config Desc = Pas de temps du couplage atm/oce en sec.
    !Config Def  = 86400
    !Config Help = This is only for testing purpose
    !
    t_coupl_omp = 86400.
    call getin('t_coupl', t_coupl_omp)
    IF (t_coupl_omp == 0) THEN
       WRITE(lunout,*)'ERROR! Timestep of coupling between atmosphere and ocean'
       WRITE(lunout,*)'cannot be zero.'
       CALL abort_physic('conf_phys','t_coupl = 0.',1)
    END IF

    !
    !Config Key  = ok_all_xml 
    !Config Desc = utiliser les xml pourles dfinitions des champs pour xios
    !Config Def  = .false.
    !Config Help = 
    !
    ok_all_xml_omp = .false.
    call getin('ok_all_xml', ok_all_xml_omp)
    !

    !
    !Config Key  = VEGET 
    !Config Desc = Type de modele de vegetation
    !Config Def  = .false.
    !Config Help = Type de modele de vegetation utilise
    !
    type_veget_omp ='orchidee'
    call getin('VEGET', type_veget_omp)
    !

    ! Martin
    !Config Key  = ok_snow
    !Config Desc = Flag to activate snow model SISVAT
    !Config Def  = .false.
    ok_snow_omp = .false.
    call getin('ok_snow', ok_snow_omp)
    ! Martin

    !Config Key  = OK_journe
    !Config Desc = Pour des sorties journalieres 
    !Config Def  = .false.
    !Config Help = Pour creer le fichier histday contenant les sorties
    !              journalieres 
    !
    ok_journe_omp = .false.
    call getin('OK_journe', ok_journe_omp)
    !
    !Config Key  = ok_hf
    !Config Desc = Pour des sorties haute frequence
    !Config Def  = .false.
    !Config Help = Pour creer le fichier histhf contenant les sorties
    !              haute frequence ( 3h ou 6h)
    !
    ok_hf_omp = .false.
    call getin('ok_hf', ok_hf_omp)
    !
    !Config Key  = OK_mensuel
    !Config Desc = Pour des sorties mensuelles 
    !Config Def  = .true.
    !Config Help = Pour creer le fichier histmth contenant les sorties
    !              mensuelles 
    !
    ok_mensuel_omp = .true.
    call getin('OK_mensuel', ok_mensuel_omp)
    !
    !Config Key  = OK_instan
    !Config Desc = Pour des sorties instantanees 
    !Config Def  = .false.
    !Config Help = Pour creer le fichier histins contenant les sorties
    !              instantanees 
    !
    ok_instan_omp = .false.
    call getin('OK_instan', ok_instan_omp)
    !
    !Config Key  = ok_ade
    !Config Desc = Aerosol direct effect or not?
    !Config Def  = .false.
    !Config Help = Used in radlwsw.F
    !
    ok_ade_omp = .false.
    call getin('ok_ade', ok_ade_omp)

    !
    !Config Key  = ok_aie
    !Config Desc = Aerosol indirect effect or not?
    !Config Def  = .false.
    !Config Help = Used in nuage.F and radlwsw.F
    !
    ok_aie_omp = .false.
    call getin('ok_aie', ok_aie_omp)

    !
    !Config Key  = ok_cdnc
    !Config Desc = ok cloud droplet number concentration
    !Config Def  = .false.
    !Config Help = Used in newmicro.F
    !
    ok_cdnc_omp = .false.
    call getin('ok_cdnc', ok_cdnc_omp)
    !
    !Config Key  = aerosol_couple
    !Config Desc = read aerosol in file or calcul by inca
    !Config Def  = .false.
    !Config Help = Used in physiq.F
    !
    aerosol_couple_omp = .false.
    CALL getin('aerosol_couple',aerosol_couple_omp)
    !
    !Config Key  = flag_aerosol
    !Config Desc = which aerosol is use for coupled model
    !Config Def  = 1
    !Config Help = Used in physiq.F
    !
    ! - flag_aerosol=0 => no aerosol
    ! - flag_aerosol=1 => so4 only (defaut) 
    ! - flag_aerosol=2 => bc  only 
    ! - flag_aerosol=3 => pom only
    ! - flag_aerosol=4 => seasalt only 
    ! - flag_aerosol=5 => dust only
    ! - flag_aerosol=6 => all aerosol

    flag_aerosol_omp = 0
    CALL getin('flag_aerosol',flag_aerosol_omp)
    !
    !Config Key  = flag_aerosol_strat
    !Config Desc = use stratospheric aerosols T/F
    !Config Def  = false
    !Config Help = Used in physiq.F
    !
    !
    flag_aerosol_strat_omp = .false.
    CALL getin('flag_aerosol_strat',flag_aerosol_strat_omp)

    ! Temporary variable for testing purpose!
    !Config Key  = new_aod
    !Config Desc = which calcul of aeropt
    !Config Def  = false
    !Config Help = Used in physiq.F
    !
    new_aod_omp = .true.
    CALL getin('new_aod',new_aod_omp)

    ! 
    !Config Key  = aer_type 
    !Config Desc = Use a constant field for the aerosols 
    !Config Def  = scenario 
    !Config Help = Used in readaerosol.F90 
    ! 
    aer_type_omp = 'scenario' 
    call getin('aer_type', aer_type_omp) 

    !
    !Config Key  = bl95_b0
    !Config Desc = Parameter in CDNC-maer link (Boucher&Lohmann 1995)
    !Config Def  = .false.
    !Config Help = Used in nuage.F
    !
    bl95_b0_omp = 2.
    call getin('bl95_b0', bl95_b0_omp)

    !Config Key  = bl95_b1
    !Config Desc = Parameter in CDNC-maer link (Boucher&Lohmann 1995)
    !Config Def  = .false.
    !Config Help = Used in nuage.F
    !
    bl95_b1_omp = 0.2
    call getin('bl95_b1', bl95_b1_omp)

    !Config Key  = freq_ISCCP
    !Config Desc = Frequence d'appel du simulateur ISCCP en secondes;
    !              par defaut 10800, i.e. 3 heures 
    !Config Def  = 10800.
    !Config Help = Used in ini_histISCCP.h
    !
    freq_ISCCP_omp = 10800.
    call getin('freq_ISCCP', freq_ISCCP_omp)
    !
    !Config Key  = ecrit_ISCCP
    !Config Desc = Frequence d'ecriture des resultats du simulateur ISCCP en nombre de jours;
    !              par defaut 1., i.e. 1 jour
    !Config Def  = 1.
    !Config Help = Used in ini_histISCCP.h
    !
    !
    ecrit_ISCCP_omp = 1.
    call getin('ecrit_ISCCP', ecrit_ISCCP_omp)

    !Config Key  = freq_COSP
    !Config Desc = Frequence d'appel du simulateur COSP en secondes;
    !              par defaut 10800, i.e. 3 heures
    !Config Def  = 10800.
    !Config Help = Used in ini_histdayCOSP.h
    !
    freq_COSP_omp = 10800.
    call getin('freq_COSP', freq_COSP_omp)

    !
    !Config Key  = ip_ebil_phy
    !Config Desc = Niveau de sortie pour les diags bilan d'energie 
    !Config Def  = 0
    !Config Help = 
    !               
    ip_ebil_phy_omp = 0
    call getin('ip_ebil_phy', ip_ebil_phy_omp)
    !
    !Config Key  = seuil_inversion
    !Config Desc = Seuil ur dTh pour le choix entre les schemas de CL
    !Config Def  = -0.1
    !Config Help = 
    !               
    seuil_inversion_omp = -0.1
    call getin('seuil_inversion', seuil_inversion_omp)

    !
    ! Constante solaire & Parametres orbitaux & taux gaz effet de serre BEG
    !
    !Config Key  = R_ecc
    !Config Desc = Excentricite
    !Config Def  = 0.016715
    !Config Help = 
    !               
    !valeur AMIP II
    R_ecc_omp = 0.016715
    call getin('R_ecc', R_ecc_omp)
    !
    !Config Key  = R_peri
    !Config Desc = Equinoxe
    !Config Def  = 
    !Config Help = 
    !               
    !
    !valeur AMIP II
    R_peri_omp = 102.7
    call getin('R_peri', R_peri_omp)
    !
    !Config Key  = R_incl
    !Config Desc = Inclinaison
    !Config Def  = 
    !Config Help = 
    !               
    !
    !valeur AMIP II
    R_incl_omp = 23.441
    call getin('R_incl', R_incl_omp)
    !
    !Config Key  = solaire
    !Config Desc = Constante solaire en W/m2
    !Config Def  = 1365.
    !Config Help = 
    !               
    !
    !valeur AMIP II
    solaire_omp = 1365.
    call getin('solaire', solaire_omp)
    !
    !Config Key  = co2_ppm
    !Config Desc = concentration du gaz carbonique en ppmv
    !Config Def  = 348.
    !Config Help = 
    !               
    !
    !valeur AMIP II
    co2_ppm_omp = 348.
    call getin('co2_ppm', co2_ppm_omp)
    !
    !Config Key  = RCO2
    !Config Desc = Concentration du CO2
    !Config Def  = co2_ppm * 1.0e-06  * 44.011/28.97
    !Config Def  = 348. * 1.0e-06  * 44.011/28.97
    !Config Help = 
    !               
    ! RCO2 = 5.286789092164308E-04
    !ancienne valeur
    RCO2_omp = co2_ppm_omp * 1.0e-06  * 44.011/28.97 ! pour co2_ppm=348.

    !  call getin('RCO2', RCO2)
    !
    !Config Key  = RCH4
    !Config Desc = Concentration du CH4
    !Config Def  = 1.65E-06* 16.043/28.97
    !Config Help = 
    !               
    !
    !valeur AMIP II
    !OK  RCH4 = 1.65E-06* 16.043/28.97
    ! RCH4 = 9.137366240938903E-07
    !
    !ancienne valeur
    ! RCH4 = 1.72E-06* 16.043/28.97
    !OK call getin('RCH4', RCH4)
    zzz = 1650.
    call getin('CH4_ppb', zzz)
    CH4_ppb_omp = zzz
    RCH4_omp = CH4_ppb_omp * 1.0E-09 * 16.043/28.97
    !
    !Config Key  = RN2O
    !Config Desc = Concentration du N2O
    !Config Def  = 306.E-09* 44.013/28.97
    !Config Help = 
    !               
    !
    !valeur AMIP II
    !OK  RN2O = 306.E-09* 44.013/28.97
    ! RN2O = 4.648939592682085E-07
    !
    !ancienne valeur
    ! RN2O = 310.E-09* 44.013/28.97
    !OK  call getin('RN2O', RN2O)
    zzz=306.
    call getin('N2O_ppb', zzz)
    N2O_ppb_omp = zzz
    RN2O_omp = N2O_ppb_omp * 1.0E-09 * 44.013/28.97
    !
    !Config Key  = RCFC11
    !Config Desc = Concentration du CFC11
    !Config Def  = 280.E-12* 137.3686/28.97
    !Config Help = 
    !               
    !
    !OK RCFC11 = 280.E-12* 137.3686/28.97
    zzz = 280.
    call getin('CFC11_ppt',zzz)
    CFC11_ppt_omp = zzz
    RCFC11_omp=CFC11_ppt_omp* 1.0E-12 * 137.3686/28.97
    ! RCFC11 = 1.327690990680013E-09
    !OK call getin('RCFC11', RCFC11)
    !
    !Config Key  = RCFC12
    !Config Desc = Concentration du CFC12
    !Config Def  = 484.E-12* 120.9140/28.97
    !Config Help = 
    !               
    !
    !OK RCFC12 = 484.E-12* 120.9140/28.97
    zzz = 484.
    call getin('CFC12_ppt',zzz)
    CFC12_ppt_omp = zzz
    RCFC12_omp = CFC12_ppt_omp * 1.0E-12 * 120.9140/28.97
    ! RCFC12 = 2.020102726958923E-09
    !OK call getin('RCFC12', RCFC12)

    !ajout CFMIP begin
    !
    !Config Key  = co2_ppm_per
    !Config Desc = concentration du co2_ppm_per
    !Config Def  = 348.
    !Config Help = 
    !               
    co2_ppm_per_omp = co2_ppm_omp
    call getin('co2_ppm_per', co2_ppm_per_omp)
    !
    !Config Key  = RCO2_per
    !Config Desc = Concentration du CO2_per
    !Config Def  = co2_ppm_per * 1.0e-06  * 44.011/28.97
    !Config Def  = 348. * 1.0e-06  * 44.011/28.97
    !Config Help = 
    !               
    RCO2_per_omp = co2_ppm_per_omp * 1.0e-06  * 44.011/28.97

    !Config Key  = ok_4xCO2atm
    !Config Desc = Calcul ou non effet radiatif 4xco2
    !Config Def  = .false.
    !Config Help = 

    ok_4xCO2atm_omp = .false.
    call getin('ok_4xCO2atm',ok_4xCO2atm_omp)

    !Config Key  = RCH4_per
    !Config Desc = Concentration du CH4_per
    !Config Def  = 1.65E-06* 16.043/28.97
    !Config Help = 
    !               
    zzz = CH4_ppb_omp
    call getin('CH4_ppb_per', zzz)
    CH4_ppb_per_omp = zzz
    RCH4_per_omp = CH4_ppb_per_omp * 1.0E-09 * 16.043/28.97
    !
    !Config Key  = RN2O_per
    !Config Desc = Concentration du N2O_per
    !Config Def  = 306.E-09* 44.013/28.97
    !Config Help = 
    !               
    zzz = N2O_ppb_omp
    call getin('N2O_ppb_per', zzz)
    N2O_ppb_per_omp = zzz
    RN2O_per_omp = N2O_ppb_per_omp * 1.0E-09 * 44.013/28.97
    !
    !Config Key  = RCFC11_per
    !Config Desc = Concentration du CFC11_per
    !Config Def  = 280.E-12* 137.3686/28.97
    !Config Help = 
    !               
    zzz = CFC11_ppt_omp
    call getin('CFC11_ppt_per',zzz)
    CFC11_ppt_per_omp = zzz
    RCFC11_per_omp=CFC11_ppt_per_omp* 1.0E-12 * 137.3686/28.97
    !
    !Config Key  = RCFC12_per
    !Config Desc = Concentration du CFC12_per
    !Config Def  = 484.E-12* 120.9140/28.97
    !Config Help = 
    !               
    zzz = CFC12_ppt_omp
    call getin('CFC12_ppt_per',zzz)
    CFC12_ppt_per_omp = zzz
    RCFC12_per_omp = CFC12_ppt_per_omp * 1.0E-12 * 120.9140/28.97
    !ajout CFMIP end

    !
    ! FH 2008/05/09 On elimine toutes les clefs physiques dans la dynamique
    ! Constantes precedemment dans dyn3d/conf_gcm

    !Config  Key  = cycle_diurne
    !Config  Desc = Cycle ddiurne
    !Config  Def  = y
    !Config  Help = Cette option permet d'eteidre le cycle diurne.
    !Config         Peut etre util pour accelerer le code !
    cycle_diurne_omp = .TRUE.
    CALL getin('cycle_diurne',cycle_diurne_omp)

    !Config  Key  = soil_model
    !Config  Desc = Modele de sol
    !Config  Def  = y
    !Config  Help = Choix du modele de sol (Thermique ?)
    !Config         Option qui pourait un string afin de pouvoir
    !Config         plus de choix ! Ou meme une liste d'options !
    soil_model_omp = .TRUE.
    CALL getin('soil_model',soil_model_omp)

    !Config  Key  = new_oliq
    !Config  Desc = Nouvelle eau liquide
    !Config  Def  = y
    !Config  Help = Permet de mettre en route la
    !Config         nouvelle parametrisation de l'eau liquide !
    new_oliq_omp = .TRUE.
    CALL getin('new_oliq',new_oliq_omp)

    !Config  Key  = ok_orodr
    !Config  Desc = Orodr ???
    !Config  Def  = y
    !Config  Help = Y en a pas comprendre !
    !Config         
    ok_orodr_omp = .TRUE.
    CALL getin('ok_orodr',ok_orodr_omp)

    !Config  Key  =  ok_orolf
    !Config  Desc = Orolf ??
    !Config  Def  = y
    !Config  Help = Connais pas !
    ok_orolf_omp = .TRUE.
    CALL getin('ok_orolf', ok_orolf_omp)

    !Config  Key  = ok_limitvrai
    !Config  Desc = Force la lecture de la bonne annee
    !Config  Def  = n
    !Config  Help = On peut forcer le modele a lire le
    !Config         fichier SST de la bonne annee. C'est une tres bonne
    !Config         idee, pourquoi ne pas mettre toujours a y ???
    ok_limitvrai_omp = .FALSE.
    CALL getin('ok_limitvrai',ok_limitvrai_omp)

    !Config  Key  = nbapp_rad
    !Config  Desc = Frequence d'appel au rayonnement
    !Config  Def  = 12
    !Config  Help = Nombre  d'appels des routines de rayonnements
    !Config         par jour.
    nbapp_rad_omp = 12
    CALL getin('nbapp_rad',nbapp_rad_omp)

    !Config  Key  = iflag_con
    !Config  Desc = Flag de convection
    !Config  Def  = 2
    !Config  Help = Flag  pour la convection les options suivantes existent :
    !Config         1 pour LMD,
    !Config         2 pour Tiedtke,
    !Config         3 pour CCM(NCAR)  
    iflag_con_omp = 2
    CALL getin('iflag_con',iflag_con_omp)

    !Config  Key  = iflag_ener_conserv
    !Config  Desc = Flag de convection
    !Config  Def  = 1
    !Config  Help = Flag  pour la convection les options suivantes existent :
    !Config         -1 pour Kinetic energy correction
    !Config         1  conservation kinetic and enthalpy
    iflag_ener_conserv_omp = -1
    CALL getin('iflag_ener_conserv',iflag_ener_conserv_omp)

    !Config  Key  = ok_conserv_q
    !Config  Desc = Switch des corrections de conservation de l'eau
    !Config  Def  = y
    !Config  Help = Switch des corrections de conservation de l'eau
    !Config         y -> corrections activees
    !Config         n -> conformite avec versions anterieures au 1/4/2014
    ok_conserv_q_omp = .FALSE.
    CALL getin('ok_conserv_q',ok_conserv_q_omp)

    !Config  Key  = iflag_fisrtilp_qsat
    !Config  Desc = Flag de fisrtilp
    !Config  Def  = 0
    !Config  Help = Flag  pour la pluie grande-chelle les options suivantes existent :
    !Config         >1 nb iterations pour converger dans le calcul de qsat
    iflag_fisrtilp_qsat_omp = 0
    CALL getin('iflag_fisrtilp_qsat',iflag_fisrtilp_qsat_omp)

    !Config  Key  = iflag_bergeron
    !Config  Desc = Flag de fisrtilp
    !Config  Def  = 0
    !Config  Help = Flag  pour la pluie grande-chelle les options suivantes existent :
    !Config         0 pas d effet Bergeron
    !Config         1 effet Bergeron pour T<0
    iflag_bergeron_omp = 0
    CALL getin('iflag_bergeron',iflag_bergeron_omp)

    !
    !
    !
    ! Constante solaire & Parametres orbitaux & taux gaz effet de serre END
    !
    ! KE
    !

    !Config key  = cvl_comp_threshold
    !Config Desc = maximum fraction of convective points enabling compression
    !Config Def  = 1.00
    !Config Help = fields are compressed when less than a fraction cvl_comp_threshold
    !Config Help = of the points is convective.
    cvl_comp_threshold_omp = 1.00
    CALL getin('cvl_comp_threshold', cvl_comp_threshold_omp)

    !Config key  = cvl_sig2feed
    !Config Desc = sigma coordinate at top of feeding layer
    !Config Def  = 0.97
    !Config Help = deep convection is fed by the layer extending from the surface (pressure ps)
    !Config Help = and cvl_sig2feed*ps.
    cvl_sig2feed_omp = 0.97
    CALL getin('cvl_sig2feed', cvl_sig2feed_omp)

    !Config key  = cvl_corr
    !Config Desc = Facteur multiplication des precip convectives dans KE
    !Config Def  = 1.00
    !Config Help = 1.02 pour un moderne ou un pre-ind. A ajuster pour un glaciaire
    cvl_corr_omp = 1.00
    CALL getin('cvl_corr', cvl_corr_omp)


    !Config Key  = epmax
    !Config Desc = Efficacite precip
    !Config Def  = 0.993
    !Config Help = 
    !
    epmax_omp = .993
    call getin('epmax', epmax_omp)

    coef_epmax_cape_omp = 0.0   
    call getin('coef_epmax_cape', coef_epmax_cape_omp)        
    !
    !Config Key  = ok_adj_ema
    !Config Desc =  
    !Config Def  = false
    !Config Help = 
    !
    ok_adj_ema_omp = .false.
    call getin('ok_adj_ema',ok_adj_ema_omp)
    !
    !Config Key  = iflag_clw
    !Config Desc =  
    !Config Def  = 0
    !Config Help = 
    !
    iflag_clw_omp = 0
    call getin('iflag_clw',iflag_clw_omp)
    !
    !Config Key  = cld_lc_lsc 
    !Config Desc =  
    !Config Def  = 2.6e-4
    !Config Help = 
    !
    cld_lc_lsc_omp = 2.6e-4
    call getin('cld_lc_lsc',cld_lc_lsc_omp)
    !
    !Config Key  = cld_lc_con
    !Config Desc =  
    !Config Def  = 2.6e-4
    !Config Help = 
    !
    cld_lc_con_omp = 2.6e-4
    call getin('cld_lc_con',cld_lc_con_omp)
    !
    !Config Key  = cld_tau_lsc
    !Config Desc =  
    !Config Def  = 3600.
    !Config Help = 
    !
    cld_tau_lsc_omp = 3600.
    call getin('cld_tau_lsc',cld_tau_lsc_omp)
    !
    !Config Key  = cld_tau_con
    !Config Desc =  
    !Config Def  = 3600.
    !Config Help = 
    !
    cld_tau_con_omp = 3600.
    call getin('cld_tau_con',cld_tau_con_omp)
    !
    !Config Key  = ffallv_lsc
    !Config Desc =  
    !Config Def  = 1.
    !Config Help = 
    !
    ffallv_lsc_omp = 1.
    call getin('ffallv_lsc',ffallv_lsc_omp)
    !
    !Config Key  = ffallv_con
    !Config Desc =  
    !Config Def  = 1.
    !Config Help = 
    !
    ffallv_con_omp = 1.
    call getin('ffallv_con',ffallv_con_omp)
    !
    !Config Key  = coef_eva
    !Config Desc =  
    !Config Def  = 2.e-5
    !Config Help = 
    !
    coef_eva_omp = 2.e-5
    call getin('coef_eva',coef_eva_omp)
    !
    !Config Key  = reevap_ice
    !Config Desc =  
    !Config Def  = .false.
    !Config Help = 
    !
    reevap_ice_omp = .false.
    call getin('reevap_ice',reevap_ice_omp)

    !Config Key  = iflag_ratqs
    !Config Desc =
    !Config Def  = 1
    !Config Help =
    !
    iflag_ratqs_omp = 1
    call getin('iflag_ratqs',iflag_ratqs_omp)

    !
    !Config Key  = iflag_radia 
    !Config Desc =  
    !Config Def  = 1
    !Config Help = 
    !
    iflag_radia_omp = 1
    call getin('iflag_radia',iflag_radia_omp)

    !
    !Config Key  = iflag_rrtm 
    !Config Desc =  
    !Config Def  = 0
    !Config Help = 
    !
    iflag_rrtm_omp = 0
    call getin('iflag_rrtm',iflag_rrtm_omp)

    !
    !Config Key  = NSW 
    !Config Desc =  
    !Config Def  = 0
    !Config Help = 
    !
    NSW_omp = 2
    call getin('NSW',NSW_omp)
    !albedo SB >>>
    iflag_albedo_omp = 0
    call getin('iflag_albedo',iflag_albedo_omp)

    ok_chlorophyll_omp=.false.
    call getin('ok_chlorophyll',ok_chlorophyll_omp)
    !albedo SB <<<

    !
    !Config Key  = iflag_cld_th 
    !Config Desc =  
    !Config Def  = 1
    !Config Help = 
    !
    iflag_cld_th_omp = 1
    ! On lit deux fois avec l'ancien et le nouveau nom 
    ! pour assurer une retrocompatiblite.
    ! A abandonner un jour
    call getin('iflag_cldcon',iflag_cld_th_omp)
    call getin('iflag_cld_th',iflag_cld_th_omp)
    iflag_cld_cv_omp = 0 
    call getin('iflag_cld_cv',iflag_cld_cv_omp)

    !
    !Config Key  = tau_cld_cv
    !Config Desc =
    !Config Def  = 10.
    !Config Help =
    !
    tau_cld_cv_omp = 10.
    call getin('tau_cld_cv',tau_cld_cv_omp)

    !
    !Config Key  = coefw_cld_cv
    !Config Desc =
    !Config Def  = 0.1
    !Config Help =
    !
    coefw_cld_cv_omp = 0.1
    call getin('coefw_cld_cv',coefw_cld_cv_omp)




    !
    !Config Key  = iflag_pdf 
    !Config Desc =  
    !Config Def  = 0
    !Config Help = 
    !
    iflag_pdf_omp = 0
    call getin('iflag_pdf',iflag_pdf_omp)
    !
    !Config Key  = fact_cldcon
    !Config Desc =  
    !Config Def  = 0.375
    !Config Help = 
    !
    fact_cldcon_omp = 0.375
    call getin('fact_cldcon',fact_cldcon_omp)

    !
    !Config Key  = facttemps
    !Config Desc =  
    !Config Def  = 1.e-4
    !Config Help = 
    !
    facttemps_omp = 1.e-4
    call getin('facttemps',facttemps_omp)

    !
    !Config Key  = ok_newmicro
    !Config Desc =  
    !Config Def  = .true.
    !Config Help = 
    !
    ok_newmicro_omp = .true.
    call getin('ok_newmicro',ok_newmicro_omp)
    !
    !Config Key  = ratqsbas
    !Config Desc =  
    !Config Def  = 0.01
    !Config Help = 
    !
    ratqsbas_omp = 0.01
    call getin('ratqsbas',ratqsbas_omp)
    !
    !Config Key  = ratqshaut
    !Config Desc =  
    !Config Def  = 0.3
    !Config Help = 
    !
    ratqshaut_omp = 0.3
    call getin('ratqshaut',ratqshaut_omp)

    !Config Key  = tau_ratqs
    !Config Desc =  
    !Config Def  = 1800.
    !Config Help = 
    !
    tau_ratqs_omp = 1800.
    call getin('tau_ratqs',tau_ratqs_omp)

    !
    !-----------------------------------------------------------------------
    ! Longitude solaire pour le calcul de l'ensoleillement en degre
    ! si on veut imposer la saison. Sinon, solarlong0=-999.999
    !Config Key  = solarlong0
    !Config Desc =  
    !Config Def  = -999.999 
    !Config Help = 
    !
    solarlong0_omp = -999.999
    call getin('solarlong0',solarlong0_omp)
    !
    !-----------------------------------------------------------------------
    !  Valeur imposee pour configuration idealisees
    !Config Key  = qsol0 pour le bucket, evap0 pour aquaplanetes, albsno0
    ! Default value -1 to activate the full computation
    qsol0_omp = -1.
    call getin('qsol0',qsol0_omp)
    evap0_omp = -1.
    call getin('evap0',evap0_omp)
    albsno0_omp = -1.
    call getin('albsno0',albsno0_omp)
    !
    !-----------------------------------------------------------------------
    !
    !Config Key  = inertie_ice
    !Config Desc =  
    !Config Def  = 2000.
    !Config Help = 
    !
    inertie_ice_omp = 2000.
    call getin('inertie_ice',inertie_ice_omp)
    !
    !Config Key  = inertie_sno
    !Config Desc =  
    !Config Def  = 2000.
    !Config Help = 
    !
    inertie_sno_omp = 2000.
    call getin('inertie_sno',inertie_sno_omp)
    !
    !Config Key  = inertie_sol
    !Config Desc =  
    !Config Def  = 2000.
    !Config Help = 
    !
    inertie_sol_omp = 2000.
    call getin('inertie_sol',inertie_sol_omp)

    !
    !Config Key  = rad_froid
    !Config Desc =  
    !Config Def  = 35.0
    !Config Help = 
    !
    rad_froid_omp = 35.0
    call getin('rad_froid',rad_froid_omp)

    !
    !Config Key  = rad_chau1
    !Config Desc =  
    !Config Def  = 13.0
    !Config Help = 
    !
    rad_chau1_omp = 13.0
    call getin('rad_chau1',rad_chau1_omp)

    !
    !Config Key  = rad_chau2
    !Config Desc =  
    !Config Def  = 9.0
    !Config Help = 
    !
    rad_chau2_omp = 9.0
    call getin('rad_chau2',rad_chau2_omp)

    !
    !Config Key  = t_glace_min
    !Config Desc =  
    !Config Def  = 258.
    !Config Help = 
    !
    t_glace_min_omp = 258.
    call getin('t_glace_min',t_glace_min_omp)

    !
    !Config Key  = t_glace_max
    !Config Desc =  
    !Config Def  = 273.13
    !Config Help = 
    !
    t_glace_max_omp = 273.13
    call getin('t_glace_max',t_glace_max_omp)

    !
    !Config Key  = exposant_glace
    !Config Desc =  
    !Config Def  = 2.
    !Config Help = 
    !
    exposant_glace_omp = 1.
    call getin('exposant_glace',exposant_glace_omp)

    !
    !Config Key  = iflag_t_glace
    !Config Desc =  
    !Config Def  = 0
    !Config Help = 
    !
    iflag_t_glace_omp = 0
    call getin('iflag_t_glace',iflag_t_glace_omp)

    !
    !Config Key  = iflag_ice_thermo
    !Config Desc =  
    !Config Def  = 0
    !Config Help = 
    !
    iflag_ice_thermo_omp = 0
    call getin('iflag_ice_thermo',iflag_ice_thermo_omp)

    !Config Key  = rei_min
    !Config Desc =  
    !Config Def  = 3.5
    !Config Help = 
    !
    rei_min_omp = 3.5
    call getin('rei_min',rei_min_omp)

    !
    !Config Key  = rei_max
    !Config Desc =  
    !Config Def  = 61.29
    !Config Help = 
    !
    rei_max_omp = 61.29
    call getin('rei_max',rei_max_omp)

    !
    !Config Key  = top_height
    !Config Desc =
    !Config Def  = 3
    !Config Help =
    !
    top_height_omp = 3
    call getin('top_height',top_height_omp)

    !
    !Config Key  = overlap
    !Config Desc =
    !Config Def  = 3
    !Config Help =
    !
    overlap_omp = 3
    call getin('overlap',overlap_omp)


    !
    !
    !Config Key  = cdmmax
    !Config Desc =
    !Config Def  = 1.3E-3
    !Config Help =
    !
    cdmmax_omp = 1.3E-3
    call getin('cdmmax',cdmmax_omp)

    !
    !Config Key  = cdhmax
    !Config Desc =
    !Config Def  = 1.1E-3
    !Config Help =
    !
    cdhmax_omp = 1.1E-3
    call getin('cdhmax',cdhmax_omp)

    !261103
    !
    !Config Key  = ksta
    !Config Desc =
    !Config Def  = 1.0e-10
    !Config Help =
    !
    ksta_omp = 1.0e-10
    call getin('ksta',ksta_omp)

    !
    !Config Key  = ksta_ter
    !Config Desc =
    !Config Def  = 1.0e-10
    !Config Help =
    !
    ksta_ter_omp = 1.0e-10
    call getin('ksta_ter',ksta_ter_omp)

    !Config Key  = f_ri_cd_min
    !Config Desc =
    !Config Def  = 0.1
    !Config Help =
    !
    f_ri_cd_min_omp = 0.1
    call getin('f_ri_cd_min',f_ri_cd_min_omp)

    !
    !Config Key  = ok_kzmin
    !Config Desc =
    !Config Def  = .true.
    !Config Help =
    !
    ok_kzmin_omp = .true.
    call getin('ok_kzmin',ok_kzmin_omp)

    !
    !Config Key  = fmagic
    !Config Desc = additionnal multiplicator factor used for albedo
    !Config Def  = 1.
    !Config Help = additionnal multiplicator factor used in albedo.F
    !
    fmagic_omp = 1.
    call getin('fmagic',fmagic_omp)

    !
    !Config Key  = pmagic
    !Config Desc = additional factor used for albedo
    !Config Def  = 0.
    !Config Help = additional factor used in albedo.F
    !
    pmagic_omp = 0.
    call getin('pmagic',pmagic_omp)


    !Config Key = ok_lic_melt
    !Config Desc = Prise en compte de la fonte de la calotte dans le bilan d'eau
    !Config Def  = .false.
    !Config Help = mettre a .false. pour assurer la conservation en eau
    ok_lic_melt_omp = .false.
    call getin('ok_lic_melt', ok_lic_melt_omp)

    !
    ! PARAMETER FOR THE PLANETARY BOUNDARY LAYER
    !

    !Config Key  = iflag_pbl
    !Config Desc =
    !Config Def  = 1
    !Config Help =
    !
    iflag_pbl_omp = 1
    call getin('iflag_pbl',iflag_pbl_omp)
    !
    !Config Key  = iflag_pbl_split
    !Config Desc = binary flag: least signif bit = split vdf; next bit = split thermals
    !Config Def  = 0
    !Config Help = 0-> no splitting; 1-> vdf splitting; 2-> thermals splitting; 3-> full splitting
    !
    iflag_pbl_split_omp = 0
    call getin('iflag_pbl_split',iflag_pbl_split_omp)
    !
    !Config Key  = iflag_order2_sollw
    !Config Desc =
    !Config Def  = 0
    !Config Help =
    !
    iflag_order2_sollw_omp = 0
    call getin('iflag_order2_sollw',iflag_order2_sollw_omp)
    !
    !Config Key  = iflag_thermals
    !Config Desc =
    !Config Def  = 0
    !Config Help =
    !
    iflag_thermals_omp = 0
    call getin('iflag_thermals',iflag_thermals_omp)
    !
    !Config Key  = iflag_thermals_ed
    !Config Desc =
    !Config Def  = 0
    !Config Help =
    !
    fact_thermals_ed_dz_omp = 0.1

    call getin('fact_thermals_ed_dz',fact_thermals_ed_dz_omp)
    !
    !
    !Config Key  = iflag_thermals_ed
    !Config Desc =
    !Config Def  = 0
    !Config Help =
    !
    iflag_thermals_ed_omp = 0
    call getin('iflag_thermals_ed',iflag_thermals_ed_omp)
    !
    !
    !Config Key  = iflag_thermals_optflux
    !Config Desc =
    !Config Def  = 0
    !Config Help =
    !
    iflag_thermals_optflux_omp = 0
    call getin('iflag_thermals_optflux',iflag_thermals_optflux_omp)
    !
    !Config Key  = iflag_thermals_closure
    !Config Desc =
    !Config Def  = 0
    !Config Help =
    !
    iflag_thermals_closure_omp = 1
    call getin('iflag_thermals_closure',iflag_thermals_closure_omp)
    !
    !
    !
    !
    !Config Key  = nsplit_thermals
    !Config Desc =
    !Config Def  = 1
    !Config Help =
    !
    nsplit_thermals_omp = 1
    call getin('nsplit_thermals',nsplit_thermals_omp)

    !Config Key  = alp_bl_k
    !Config Desc =
    !Config Def  = 0.
    !Config Help =
    !
    alp_bl_k_omp = 1.
    call getin('alp_bl_k',alp_bl_k_omp)

    ! nrlmd le 10/04/2012

    !Config Key  = iflag_trig_bl
    !Config Desc =  
    !Config Def  = 0
    !Config Help = 
    !
    iflag_trig_bl_omp = 0
    call getin('iflag_trig_bl',iflag_trig_bl_omp)

    !Config Key  = s_trig_bl
    !Config Desc =  
    !Config Def  = 0
    !Config Help = 
    !
    s_trig_omp = 2e7
    call getin('s_trig',s_trig_omp)

    !Config Key  = tau_trig_shallow
    !Config Desc =  
    !Config Def  = 0
    !Config Help = 
    !
    tau_trig_shallow_omp = 600
    call getin('tau_trig_shallow',tau_trig_shallow_omp)

    !Config Key  = tau_trig_deep
    !Config Desc =  
    !Config Def  = 0
    !Config Help = 
    !
    tau_trig_deep_omp = 1800
    call getin('tau_trig_deep',tau_trig_deep_omp)

    !Config Key  = iflag_clos_bl
    !Config Desc =  
    !Config Def  = 0
    !Config Help = 
    !
    iflag_clos_bl_omp = 0
    call getin('iflag_clos_bl',iflag_clos_bl_omp)

    ! fin nrlmd le 10/04/2012

    !
    !Config Key  = tau_thermals
    !Config Desc =
    !Config Def  = 0.
    !Config Help =
    !
    tau_thermals_omp = 0.
    call getin('tau_thermals',tau_thermals_omp)

    !
    !Config Key  = iflag_coupl
    !Config Desc =
    !Config Def  = 0
    !Config Help =
    !
    iflag_coupl_omp = 0
    call getin('iflag_coupl',iflag_coupl_omp)

    !
    !Config Key  = iflag_clos
    !Config Desc =  
    !Config Def  = 0
    !Config Help = 
    !
    iflag_clos_omp = 1
    call getin('iflag_clos',iflag_clos_omp)
    !
    !Config Key  = coef_clos_ls
    !Config Desc =  
    !Config Def  = 0
    !Config Help = 
    !
    coef_clos_ls_omp = 0.
    call getin('coef_clos_ls',coef_clos_ls_omp)

    !
    !Config Key  = iflag_cvl_sigd
    !Config Desc =  
    !Config Def  = 0
    !Config Help = 
    !
    iflag_cvl_sigd_omp = 0
    call getin('iflag_cvl_sigd',iflag_cvl_sigd_omp)

    !Config Key  = iflag_wake
    !Config Desc =  
    !Config Def  = 0
    !Config Help = 
    !
    iflag_wake_omp = 0
    call getin('iflag_wake',iflag_wake_omp)

    !Config Key  = alp_offset
    !Config Desc =  
    !Config Def  = 0
    !Config Help = 
    !
    alp_offset_omp = 0.
    call getin('alp_offset',alp_offset_omp)

    !
    !Config Key  = lev_histhf
    !Config Desc =
    !Config Def  = 1
    !Config Help =
    !
    lev_histhf_omp = 1
    call getin('lev_histhf',lev_histhf_omp)

    !
    !Config Key  = lev_histday
    !Config Desc =
    !Config Def  = 1
    !Config Help =
    !
    lev_histday_omp = 1
    call getin('lev_histday',lev_histday_omp)

    !
    !Config Key  = lev_histmth
    !Config Desc =
    !Config Def  = 2
    !Config Help =
    !
    lev_histmth_omp = 2
    call getin('lev_histmth',lev_histmth_omp)
    !
    !Config Key  = lev_histins
    !Config Desc =
    !Config Def  = 1
    !Config Help =
    !
    lev_histins_omp = 1
    call getin('lev_histins',lev_histins_omp)
    !
    !Config Key  = lev_histLES
    !Config Desc =
    !Config Def  = 1
    !Config Help =
    !
    lev_histLES_omp = 1
    call getin('lev_histLES',lev_histLES_omp)
    ! 
    !Config Key  = lev_histdayNMC
    !Config Desc =
    !Config Def  = 8
    !Config Help =
    !
    lev_histdayNMC_omp = 8
    call getin('lev_histdayNMC',lev_histdayNMC_omp)
    !
    !Config Key  = levout_histNMC
    !Config Desc =
    !Config Def  = 5
    !Config Help =
    !
    levout_histNMC_omp(1) = 5
    levout_histNMC_omp(2) = 5
    levout_histNMC_omp(3) = 5
    call getin('levout_histNMC',levout_histNMC_omp)
    !
    !histNMC BEG
    !Config Key  = ok_histNMC
    !Config Desc = ok_histNMC(1) = frequence de sortie fichiers histmthNMC
    !Config Desc = ok_histNMC(2) = frequence de sortie fichiers histdayNMC
    !Config Desc = ok_histNMC(3) = frequence de sortie fichiers histhfNMC
    !Config Def  = n, n, n
    !Config Help =
    !
    ok_histNMC_omp(1) = .false.
    ok_histNMC_omp(2) = .false.
    ok_histNMC_omp(3) = .false.
    call getin('ok_histNMC',ok_histNMC_omp)
    !
    !Config Key  = freq_outNMC
    !Config Desc = freq_outNMC(1) = frequence de sortie fichiers histmthNMC
    !Config Desc = freq_outNMC(2) = frequence de sortie fichiers histdayNMC
    !Config Desc = freq_outNMC(3) = frequence de sortie fichiers histhfNMC
    !Config Def  = 2592000., 86400., 21600. (1mois, 1jour, 6h) 
    !Config Help =
    !
    freq_outNMC_omp(1) = mth_len
    freq_outNMC_omp(2) = 1.
    freq_outNMC_omp(3) = 1./4.
    call getin('freq_outNMC',freq_outNMC_omp)
    !
    !Config Key  = freq_calNMC
    !Config Desc = freq_calNMC(1) = frequence de calcul fichiers histmthNMC
    !Config Desc = freq_calNMC(2) = frequence de calcul fichiers histdayNMC
    !Config Desc = freq_calNMC(3) = frequence de calcul fichiers histhfNMC
    !Config Def  = pasphys
    !Config Help =
    !
    freq_calNMC_omp(1) = pasphys
    freq_calNMC_omp(2) = pasphys
    freq_calNMC_omp(3) = pasphys
    call getin('freq_calNMC',freq_calNMC_omp)
    !
    !Config Key  = type_run
    !Config Desc =
    !Config Def  = 'AMIP'/'CFMIP'  ou 'CLIM'/'ENSP'
    !Config Help =
    !
    type_run_omp = 'AMIP'
    call getin('type_run',type_run_omp)

    !
    !Config Key  = ok_cosp
    !Config Desc =
    !Config Def  = .false.
    !Config Help =
    !
    ok_cosp_omp = .false.
    call getin('ok_cosp',ok_cosp_omp)

    !
    !Config Key  = ok_mensuelCOSP
    !Config Desc =
    !Config Def  = .true.
    !Config Help =
    !
    ok_mensuelCOSP_omp = .true.
    call getin('ok_mensuelCOSP',ok_mensuelCOSP_omp)

    !
    !Config Key  = ok_journeCOSP
    !Config Desc =
    !Config Def  = .true.
    !Config Help = 
    !
    ok_journeCOSP_omp = .true.
    call getin('ok_journeCOSP',ok_journeCOSP_omp)

    !
    !Config Key  = ok_hfCOSP
    !Config Desc =
    !Config Def  = .false.
    !Config Help =
    !
    ok_hfCOSP_omp = .false.
    call getin('ok_hfCOSP',ok_hfCOSP_omp)

    !
    ! coordonnees (lonmin_ins, lonmax_ins, latmin_ins, latmax_ins) pour la zone 
    ! avec sorties instantannees tous les pas de temps de la physique => "histbilKP_ins.nc"
    !
    !Config Key  = lonmin_ins
    !Config Desc = 100.  
    !Config Def  = longitude minimale sorties "bilKP_ins"
    !Config Help = 
    !
    lonmin_ins_omp = 100.
    call getin('lonmin_ins',lonmin_ins_omp)
    !
    !Config Key  = lonmax_ins
    !Config Desc = 130. 
    !Config Def  = longitude maximale sorties "bilKP_ins"
    !Config Help =
    !
    lonmax_ins_omp = 130.
    call getin('lonmax_ins',lonmax_ins_omp)
    !
    !Config Key  = latmin_ins
    !Config Desc = -20.  
    !Config Def  = latitude minimale sorties "bilKP_ins"
    !Config Help = 
    !
    latmin_ins_omp = -20.
    call getin('latmin_ins',latmin_ins_omp)
    !
    !Config Key  = latmax_ins
    !Config Desc = 20. 
    !Config Def  = latitude maximale sorties "bilKP_ins"
    !Config Help =
    !
    latmax_ins_omp = 20.
    call getin('latmax_ins',latmax_ins_omp)
    !
    !Config Key  = ecrit_hf
    !Config Desc =
    !Config Def  = 1./8. !toutes les 3h
    !Config Help =
    !
    ecrit_hf_omp = 1./8.
    call getin('ecrit_hf',ecrit_hf_omp)
    !
    !Config Key  = ecrit_ins
    !Config Desc =
    !Config Def  = 1./48. ! toutes les 1/2 h
    !Config Help =
    !
    ecrit_ins_omp = 1./48.
    call getin('ecrit_ins',ecrit_ins_omp)
    !
    !Config Key  = ecrit_day
    !Config Desc =
    !Config Def  = 1.0 !tous les jours
    !Config Help = nombre de jours pour ecriture fichier histday.nc
    !
    ecrit_day_omp = 1.0
    call getin('ecrit_day',ecrit_day_omp)
    !
    !Config Key  = ecrit_mth
    !Config Desc =
    !Config Def  = 30. !tous les 30jours (1 fois par mois)
    !Config Help =
    !
    ecrit_mth_omp = 30.
    call getin('ecrit_mth',ecrit_mth_omp)
    !
    !Config Key  = ecrit_tra
    !Config Desc =
    !Config Def  = 30. !tous les 30jours (1 fois par mois)
    !Config Help =
    !
    ecrit_tra_omp = 0.
    call getin('ecrit_tra',ecrit_tra_omp)
    !
    !Config Key  = ecrit_reg
    !Config Desc =
    !Config Def  = 0.25  !4 fois par jour
    !Config Help =
    !
    ecrit_reg_omp = 0.25   !4 fois par jour
    call getin('ecrit_reg',ecrit_reg_omp)
    !
    !
    print*,'CONFPHYS OOK avant drag_ter'
    !
    ! PARAMETRES CDRAG
    !
    f_cdrag_ter_omp = 0.8
    call getin('f_cdrag_ter',f_cdrag_ter_omp)
    !
    f_cdrag_oce_omp = 0.8
    call getin('f_cdrag_oce',f_cdrag_oce_omp)
    !

    ! Gustiness flags
    f_z0qh_oce_omp = 1.
    call getin('f_z0qh_oce',f_z0qh_oce_omp)
    !
    f_qsat_oce_omp = 1.
    call getin('f_qsat_oce',f_qsat_oce_omp)
    !
    f_gust_bl_omp = 0.
    call getin('f_gust_bl',f_gust_bl_omp)
    !
    f_gust_wk_omp = 0.
    call getin('f_gust_wk',f_gust_wk_omp)
    !
    !Config Key  = iflag_z0_oce
    !Config Desc = 0 (z0h=z0m), 1 (diff. equ. for z0h and z0m), -1 (z0m=z0h=z0min)
    !Config Def  = 0   ! z0h = z0m
    !Config Help =
    !
    iflag_z0_oce_omp=0
    call getin('iflag_z0_oce',iflag_z0_oce_omp)
    !
    iflag_gusts_omp=0
    call getin('iflag_gusts',iflag_gusts_omp)
    !
    min_wind_speed_omp = 1.
    call getin('min_wind_speed',min_wind_speed_omp)

    z0m_seaice_omp = 0.002 ; call getin('z0m_seaice',z0m_seaice_omp)
    z0h_seaice_omp = 0.002 ; call getin('z0h_seaice',z0h_seaice_omp)

    f_rugoro_omp = 0.
    call getin('f_rugoro',f_rugoro_omp)

    z0min_omp = 0.000015
    call getin('z0min',z0min_omp)


    ! PARAMETERS FOR CONVECTIVE INHIBITION BY TROPOS. DRYNESS
    !
    !Config Key  = supcrit1
    !Config Desc =
    !Config Def  = .540
    !Config Help =
    !
    supcrit1_omp = .540
    call getin('supcrit1',supcrit1_omp)

    !
    !Config Key  = supcrit2
    !Config Desc =
    !Config Def  = .600
    !Config Help =
    !
    supcrit2_omp = .600
    call getin('supcrit2',supcrit2_omp)

    !
    ! PARAMETERS FOR THE MIXING DISTRIBUTION
    ! iflag_mix: 0=OLD, 
    !            1=NEW (JYG),            
    !            2=NEW + conv. depth inhib. by tropos. dryness
    ! '2' is NOT operationnal and should not be used.
    !
    !Config Key  = iflag_mix
    !Config Desc =
    !Config Def  = 1
    !Config Help =
    !
    iflag_mix_omp = 1
    call getin('iflag_mix',iflag_mix_omp)

!
    ! PARAMETERS FOR THE EROSION OF THE ADIABATIC ASCENTS
    ! iflag_mix_adiab: 0=OLD, 
    !                  1=NEW (CR),            
    !            
    !
    !Config Key  = iflag_mix_adiab
    !Config Desc =
    !Config Def  = 1
    !Config Help =
    !
    iflag_mix_adiab_omp = 0
    call getin('iflag_mix_adiab',iflag_mix_adiab_omp)

    !
    !Config Key  = scut
    !Config Desc =
    !Config Def  = 0.95
    !Config Help =
    !
    scut_omp = 0.95
    call getin('scut',scut_omp)

    !
    !Config Key  = qqa1
    !Config Desc =
    !Config Def  = 1.0
    !Config Help =
    !
    qqa1_omp = 1.0
    call getin('qqa1',qqa1_omp)

    !
    !Config Key  = qqa2
    !Config Desc =
    !Config Def  = 0.0
    !Config Help =
    !
    qqa2_omp = 0.0
    call getin('qqa2',qqa2_omp)

    !
    !Config Key  = gammas
    !Config Desc =
    !Config Def  = 0.05
    !Config Help =
    !
    gammas_omp = 0.05
    call getin('gammas',gammas_omp)

    !
    !Config Key  = Fmax
    !Config Desc =
    !Config Def  = 0.65
    !Config Help =
    !
    Fmax_omp = 0.65
    call getin('Fmax',Fmax_omp)

    !
    !Config Key  = tmax_fonte_cv
    !Config Desc =
    !Config Def  = 275.15
    !Config Help =
    !
    tmax_fonte_cv_omp = 275.15
    call getin('tmax_fonte_cv',tmax_fonte_cv_omp)

    !
    !Config Key  = alphas  
    !Config Desc =
    !Config Def  = -5.
    !Config Help =
    !
    alphas_omp = -5.
    call getin('alphas',alphas_omp)

    !Config key = ok_strato
    !Config  Desc = activation de la version strato
    !Config  Def  = .FALSE.
    !Config  Help = active la version stratosph\'erique de LMDZ de F. Lott
    !               Et la sponge layer (Runs Stratospheriques)

    ok_strato_omp=.FALSE.
    CALL getin('ok_strato',ok_strato_omp)

    !Config  key = ok_hines
    !Config  Desc = activation de la parametrisation de hines
    !Config  Def  = .FALSE.
    !Config  Help = Clefs controlant la parametrization de Hines

    ok_hines_omp=.FALSE.
    CALL getin('ok_hines',ok_hines_omp)

    !  Parametres pour les ondes de gravite
    !  
    !  Subgrid Scale Orography (Lott Miller (1997), Lott (1999))

    sso_gkdrag_omp = merge(0.1875, 0.2, ok_strato_omp)
    CALL getin('sso_gkdrag', sso_gkdrag_omp)

    sso_grahil_omp=merge(0.1,1.,ok_strato_omp)
    CALL getin('sso_grahil', sso_grahil_omp)

    sso_grcrit_omp =merge(1.,0.01,ok_strato_omp)
    CALL getin('sso_grcrit', sso_grcrit_omp)

    sso_gfrcri_omp = 1.
    CALL getin('sso_gfrcri', sso_gfrcri_omp)

    sso_gkwake_omp = 0.50
    CALL getin('sso_gkwake', sso_gkwake_omp)

    sso_gklift_omp = merge(0.25,0.50,ok_strato_omp)
    CALL getin('sso_gklift', sso_gklift_omp)

    ! Random gravity waves:

    ok_gwd_rando_omp = .FALSE.
    IF ( klon_glo == 1 ) THEN
       print*,'La parametrisation des ondes de gravites non orographiques'
       print*,'ne fonctionne pas en 1D'
    ELSE
       CALL getin('ok_gwd_rando', ok_gwd_rando_omp)
    ENDIF

    gwd_rando_ruwmax_omp = 2.00
    CALL getin('gwd_rando_ruwmax', gwd_rando_ruwmax_omp)

    gwd_rando_sat_omp = 0.25
    CALL getin('gwd_rando_sat', gwd_rando_sat_omp)

    gwd_front_ruwmax_omp = 2.50
    CALL getin('gwd_front_ruwmax', gwd_front_ruwmax_omp)

    gwd_front_sat_omp = 0.60
    CALL getin('gwd_front_sat', gwd_front_sat_omp)


    !Config  key = ok_qch4
    !Config  Desc = activation de la parametrisation du methane
    !Config  Def  = .FALSE.
    !Config  Help = Clef controlant l'activation de la parametrisation
    !               de l'humidite due a oxydation+photolyse du methane strato

    ok_qch4_omp=.FALSE.
    CALL getin('ok_qch4',ok_qch4_omp)

    !Config Key  = OK_LES                                               
    !Config Desc = Pour des sorties LES                                 
    !Config Def  = .false.                                              
    !Config Help = Pour creer le fichier histLES contenant les sorties  
    !              LES                                                  
    !                                                                   
    ok_LES_omp = .false.                                              
    call getin('OK_LES', ok_LES_omp)                                  

    !Config Key  = callstats                                               
    !Config Desc = Pour des sorties callstats                                 
    !Config Def  = .false.                                              
    !Config Help = Pour creer le fichier stats contenant les sorties  
    !              stats                                                  
    !                                                                   
    callstats_omp = .false.                                              
    call getin('callstats', callstats_omp)                                  
    !
    !Config Key  = ecrit_LES
    !Config Desc = Frequence d'ecriture des resultats du LES en nombre de jours;
    !              par defaut 1., i.e. 1 jour
    !Config Def  = 1./8.
    !Config Help = ... 
    !
    !
    ecrit_LES_omp = 1./8.
    call getin('ecrit_LES', ecrit_LES_omp)
    !
    read_climoz = 0 ! default value
    call getin('read_climoz', read_climoz)

    carbon_cycle_tr_omp=.FALSE.
    CALL getin('carbon_cycle_tr',carbon_cycle_tr_omp)

    carbon_cycle_cpl_omp=.FALSE.
    CALL getin('carbon_cycle_cpl',carbon_cycle_cpl_omp)

    !$OMP END MASTER
    !$OMP BARRIER

    R_ecc = R_ecc_omp
    R_peri = R_peri_omp
    R_incl = R_incl_omp
    solaire = solaire_omp
    co2_ppm = co2_ppm_omp
    RCO2 = RCO2_omp
    CH4_ppb = CH4_ppb_omp
    RCH4 = RCH4_omp
    N2O_ppb = N2O_ppb_omp
    RN2O = RN2O_omp
    CFC11_ppt = CFC11_ppt_omp
    RCFC11 = RCFC11_omp
    CFC12_ppt = CFC12_ppt_omp
    RCFC12 = RCFC12_omp
    RCO2_act = RCO2
    RCH4_act = RCH4
    RN2O_act = RN2O
    RCFC11_act = RCFC11
    RCFC12_act = RCFC12
    ok_4xCO2atm = ok_4xCO2atm_omp
    RCO2_per = RCO2_per_omp
    RCH4_per = RCH4_per_omp
    RN2O_per = RN2O_per_omp
    RCFC11_per = RCFC11_per_omp
    RCFC12_per = RCFC12_per_omp

    cycle_diurne = cycle_diurne_omp
    soil_model = soil_model_omp
    new_oliq = new_oliq_omp
    ok_orodr = ok_orodr_omp
    ok_orolf = ok_orolf_omp
    ok_limitvrai = ok_limitvrai_omp
    nbapp_rad = nbapp_rad_omp
    iflag_con = iflag_con_omp
    iflag_ener_conserv = iflag_ener_conserv_omp
    ok_conserv_q = ok_conserv_q_omp
    iflag_fisrtilp_qsat = iflag_fisrtilp_qsat_omp
    iflag_bergeron = iflag_bergeron_omp

    epmax = epmax_omp
    coef_epmax_cape = coef_epmax_cape_omp
    ok_adj_ema = ok_adj_ema_omp
    iflag_clw = iflag_clw_omp
    cld_lc_lsc = cld_lc_lsc_omp
    cld_lc_con = cld_lc_con_omp
    cld_tau_lsc = cld_tau_lsc_omp
    cld_tau_con = cld_tau_con_omp
    ffallv_lsc = ffallv_lsc_omp
    ffallv_con = ffallv_con_omp
    coef_eva = coef_eva_omp
    reevap_ice = reevap_ice_omp
    iflag_pdf = iflag_pdf_omp
    solarlong0 = solarlong0_omp
    qsol0 = qsol0_omp
    evap0 = evap0_omp
    albsno0 = albsno0_omp
    inertie_sol = inertie_sol_omp
    inertie_ice = inertie_ice_omp
    inertie_sno = inertie_sno_omp
    rad_froid = rad_froid_omp
    rad_chau1 = rad_chau1_omp
    rad_chau2 = rad_chau2_omp
    t_glace_min = t_glace_min_omp
    t_glace_max = t_glace_max_omp
    exposant_glace = exposant_glace_omp
    iflag_t_glace = iflag_t_glace_omp
    iflag_ice_thermo = iflag_ice_thermo_omp
    rei_min = rei_min_omp
    rei_max = rei_max_omp
    top_height = top_height_omp
    overlap = overlap_omp
    cdmmax = cdmmax_omp
    cdhmax = cdhmax_omp
    ksta = ksta_omp
    ksta_ter = ksta_ter_omp
    f_ri_cd_min = f_ri_cd_min_omp
    ok_kzmin = ok_kzmin_omp
    fmagic = fmagic_omp
    pmagic = pmagic_omp
    iflag_pbl = iflag_pbl_omp
    iflag_pbl_split = iflag_pbl_split_omp
    iflag_order2_sollw = iflag_order2_sollw_omp
    lev_histhf = lev_histhf_omp
    lev_histday = lev_histday_omp
    lev_histmth = lev_histmth_omp
    lev_histins = lev_histins_omp
    lev_histLES = lev_histLES_omp
    lev_histdayNMC = lev_histdayNMC_omp
    levout_histNMC = levout_histNMC_omp
    ok_histNMC(:) = ok_histNMC_omp(:)
    freq_outNMC(:) = freq_outNMC_omp(:)
    freq_calNMC(:) = freq_calNMC_omp(:)

    type_ocean = type_ocean_omp
    version_ocean = version_ocean_omp
    t_coupl = t_coupl_omp

    ok_veget=.true.
    type_veget=type_veget_omp
    if (type_veget=='n' .or. type_veget=='bucket' .or. type_veget=='betaclim') &
         then
       ok_veget=.false.
    endif
    ! Martin
    ok_snow = ok_snow_omp
    ! Martin

    ok_all_xml = ok_all_xml_omp
    ok_newmicro = ok_newmicro_omp
    ok_journe = ok_journe_omp
    ok_hf = ok_hf_omp
    ok_mensuel = ok_mensuel_omp
    ok_instan = ok_instan_omp
    freq_ISCCP = freq_ISCCP_omp
    ecrit_ISCCP = ecrit_ISCCP_omp
    freq_COSP = freq_COSP_omp
    ok_ade = ok_ade_omp
    ok_aie = ok_aie_omp
    ok_cdnc = ok_cdnc_omp
    aerosol_couple = aerosol_couple_omp
    flag_aerosol=flag_aerosol_omp
    flag_aerosol_strat=flag_aerosol_strat_omp
    new_aod=new_aod_omp
    aer_type = aer_type_omp
    bl95_b0 = bl95_b0_omp
    bl95_b1 = bl95_b1_omp
    fact_cldcon = fact_cldcon_omp
    facttemps = facttemps_omp
    ratqsbas = ratqsbas_omp
    ratqshaut = ratqshaut_omp
    tau_ratqs = tau_ratqs_omp

    iflag_radia = iflag_radia_omp
    iflag_rrtm = iflag_rrtm_omp
    iflag_albedo = iflag_albedo_omp
    ok_chlorophyll = ok_chlorophyll_omp
    NSW = NSW_omp
    iflag_cld_th = iflag_cld_th_omp
    iflag_cld_cv = iflag_cld_cv_omp
    tau_cld_cv = tau_cld_cv_omp
    coefw_cld_cv = coefw_cld_cv_omp
    iflag_ratqs = iflag_ratqs_omp
    ip_ebil_phy = ip_ebil_phy_omp
    iflag_thermals = iflag_thermals_omp
    iflag_thermals_ed = iflag_thermals_ed_omp
    fact_thermals_ed_dz = fact_thermals_ed_dz_omp
    iflag_thermals_optflux = iflag_thermals_optflux_omp
    iflag_thermals_closure = iflag_thermals_closure_omp
    nsplit_thermals = nsplit_thermals_omp
    tau_thermals = tau_thermals_omp
    alp_bl_k = alp_bl_k_omp
    ! nrlmd le 10/04/2012
    iflag_trig_bl = iflag_trig_bl_omp
    s_trig = s_trig_omp
    tau_trig_shallow = tau_trig_shallow_omp
    tau_trig_deep = tau_trig_deep_omp
    iflag_clos_bl = iflag_clos_bl_omp
    ! fin nrlmd le 10/04/2012
    iflag_coupl = iflag_coupl_omp
    iflag_clos = iflag_clos_omp
    iflag_wake = iflag_wake_omp
    coef_clos_ls = coef_clos_ls_omp
    alp_offset = alp_offset_omp
    iflag_cvl_sigd = iflag_cvl_sigd_omp
    type_run = type_run_omp
    ok_cosp = ok_cosp_omp
    ok_mensuelCOSP = ok_mensuelCOSP_omp
    ok_journeCOSP = ok_journeCOSP_omp
    ok_hfCOSP = ok_hfCOSP_omp
    seuil_inversion=seuil_inversion_omp
    lonmin_ins = lonmin_ins_omp
    lonmax_ins = lonmax_ins_omp
    latmin_ins = latmin_ins_omp
    latmax_ins = latmax_ins_omp
    ecrit_hf   = ecrit_hf_omp
    ecrit_ins   = ecrit_ins_omp
    ecrit_day = ecrit_day_omp
    ecrit_mth = ecrit_mth_omp
    ecrit_tra = ecrit_tra_omp
    ecrit_reg = ecrit_reg_omp
    cvl_comp_threshold = cvl_comp_threshold_omp
    cvl_sig2feed = cvl_sig2feed_omp
    cvl_corr = cvl_corr_omp
    ok_lic_melt = ok_lic_melt_omp
    f_cdrag_ter=f_cdrag_ter_omp
    f_cdrag_oce=f_cdrag_oce_omp

    f_gust_wk=f_gust_wk_omp
    f_gust_bl=f_gust_bl_omp
    f_qsat_oce=f_qsat_oce_omp
    f_z0qh_oce=f_z0qh_oce_omp
    min_wind_speed=min_wind_speed_omp
    iflag_gusts=iflag_gusts_omp
    iflag_z0_oce=iflag_z0_oce_omp


    z0m_seaice=z0m_seaice_omp
    z0h_seaice=z0h_seaice_omp

    f_rugoro=f_rugoro_omp

    z0min=z0min_omp
    supcrit1 = supcrit1_omp
    supcrit2 = supcrit2_omp
    iflag_mix = iflag_mix_omp
    iflag_mix_adiab = iflag_mix_adiab_omp
    scut = scut_omp
    qqa1 = qqa1_omp
    qqa2 = qqa2_omp
    gammas = gammas_omp
    Fmax = Fmax_omp
    tmax_fonte_cv = tmax_fonte_cv_omp
    alphas = alphas_omp

    gkdrag=sso_gkdrag_omp
    grahilo=sso_grahil_omp
    grcrit=sso_grcrit_omp
    gfrcrit=sso_gfrcri_omp
    gkwake=sso_gkwake_omp 
    gklift=sso_gklift_omp 

    ok_strato = ok_strato_omp
    ok_hines = ok_hines_omp
    ok_gwd_rando = ok_gwd_rando_omp
    gwd_rando_ruwmax = gwd_rando_ruwmax_omp
    gwd_rando_sat = gwd_rando_sat_omp
    gwd_front_ruwmax = gwd_front_ruwmax_omp
    gwd_front_sat = gwd_front_sat_omp
    ok_qch4 = ok_qch4_omp
    ok_LES = ok_LES_omp
    callstats = callstats_omp
    ecrit_LES = ecrit_LES_omp
    carbon_cycle_tr = carbon_cycle_tr_omp
    carbon_cycle_cpl = carbon_cycle_cpl_omp

    ! Test of coherence between type_ocean and version_ocean
    IF (type_ocean=='couple' .AND. (version_ocean/='opa8' .AND. version_ocean/='nemo') ) THEN
       WRITE(lunout,*)' ERROR version_ocean=',version_ocean,' not valid in coupled configuration'
       CALL abort_physic('conf_phys','version_ocean not valid',1)
    END IF

    IF (type_ocean=='slab' .AND. version_ocean=='xxxxxx') THEN
       version_ocean='sicOBS'
    ELSE IF (type_ocean=='slab' .AND. version_ocean/='sicOBS' &
         .AND. version_ocean/='sicINT' .AND. version_ocean/='sicNO') THEN
       WRITE(lunout,*)' ERROR version_ocean=',version_ocean,' not valid with slab ocean'
       CALL abort_physic('conf_phys','version_ocean not valid',1)
    END IF

    !--test on radiative scheme 
    IF (iflag_rrtm .EQ. 0) THEN 
      IF (NSW.NE.2) THEN 
        WRITE(lunout,*) ' ERROR iflag_rrtm=0 and NSW<>2 not possible'
        CALL abort_physic('conf_phys','choice NSW not valid',1)
      ENDIF
    ELSE IF (iflag_rrtm .EQ. 1) THEN
      IF (NSW.NE.2.AND.NSW.NE.4.AND.NSW.NE.6) THEN
        WRITE(lunout,*) ' ERROR iflag_rrtm=1 and NSW<>2,4,6 not possible'
        CALL abort_physic('conf_phys','choice NSW not valid',1)
      ENDIF
    ELSE 
       WRITE(lunout,*) ' ERROR iflag_rrtm<>0,1'
       CALL abort_physic('conf_phys','choice iflag_rrtm not valid',1)
    ENDIF

    !--test on ocean surface albedo
    IF (iflag_albedo.LT.0.OR.iflag_albedo.GT.1) THEN
       WRITE(lunout,*) ' ERROR iflag_albedo<>0,1'
       CALL abort_physic('conf_phys','choice iflag_albedo not valid',1)
    ENDIF

    ! Test sur new_aod. Ce flag permet de retrouver les resultats de l'AR4
    ! il n'est utilisable que lors du couplage avec le SO4 seul 
    IF (ok_ade .OR. ok_aie) THEN 
       IF ( flag_aerosol .EQ. 0 ) THEN
          CALL abort_physic('conf_phys','flag_aerosol=0 not compatible avec ok_ade ou ok_aie=.TRUE.',1)
       END IF
       IF ( .NOT. new_aod .AND.  flag_aerosol .NE. 1) THEN
          CALL abort_physic('conf_phys','new_aod=.FALSE. not compatible avec flag_aerosol=1',1)
       END IF
    END IF

    ! Flag_aerosol cannot be to zero if we are in coupled mode for aerosol
    IF (aerosol_couple .AND. flag_aerosol .eq. 0 ) THEN
       CALL abort_physic('conf_phys', 'flag_aerosol cannot be to zero if aerosol_couple=y ', 1)
    ENDIF

    ! flag_aerosol need to be different to zero if ok_cdnc is activated
    IF (ok_cdnc .AND. flag_aerosol .eq. 0) THEN
       CALL abort_physic('conf_phys', 'flag_aerosol cannot be to zero if ok_cdnc is activated ', 1)
    ENDIF

    ! ok_cdnc must be set to y if ok_aie is activated
    IF (ok_aie .AND. .NOT. ok_cdnc) THEN
       CALL abort_physic('conf_phys', 'ok_cdnc must be set to y if ok_aie is activated',1)
    ENDIF

    !$OMP MASTER

    write(lunout,*)' ##############################################'
    write(lunout,*)' Configuration des parametres de la physique: '
    write(lunout,*)' Type ocean = ', type_ocean
    write(lunout,*)' Version ocean = ', version_ocean
    write(lunout,*)' Config veget = ', ok_veget,type_veget
    write(lunout,*)' Snow model SISVAT : ok_snow = ', ok_snow
    write(lunout,*)' Config xml pour XIOS : ok_all_xml = ', ok_all_xml
    write(lunout,*)' Sortie journaliere = ', ok_journe
    write(lunout,*)' Sortie haute frequence = ', ok_hf
    write(lunout,*)' Sortie mensuelle = ', ok_mensuel
    write(lunout,*)' Sortie instantanee = ', ok_instan
    write(lunout,*)' Frequence appel simulateur ISCCP, freq_ISCCP =', freq_ISCCP
    write(lunout,*)' Frequence appel simulateur ISCCP, ecrit_ISCCP =', ecrit_ISCCP
    write(lunout,*)' Frequence appel simulateur COSP, freq_COSP =', freq_COSP
    write(lunout,*)' Sortie bilan d''energie, ip_ebil_phy =', ip_ebil_phy
    write(lunout,*)' Excentricite = ',R_ecc
    write(lunout,*)' Equinoxe = ',R_peri
    write(lunout,*)' Inclinaison =',R_incl
    write(lunout,*)' Constante solaire =',solaire
    write(lunout,*)' co2_ppm =',co2_ppm
    write(lunout,*)' RCO2_act = ',RCO2_act
    write(lunout,*)' CH4_ppb =',CH4_ppb,' RCH4_act = ',RCH4_act
    write(lunout,*)' N2O_ppb =',N2O_ppb,' RN2O_act=  ',RN2O_act
    write(lunout,*)' CFC11_ppt=',CFC11_ppt,' RCFC11_act=  ',RCFC11_act
    write(lunout,*)' CFC12_ppt=',CFC12_ppt,' RCFC12_act=  ',RCFC12_act
    write(lunout,*)' ok_4xCO2atm=',ok_4xCO2atm
    write(lunout,*)' RCO2_per = ',RCO2_per,' RCH4_per = ', RCH4_per
    write(lunout,*)' RN2O_per = ',RN2O_per,' RCFC11_per = ', RCFC11_per
    write(lunout,*)' RCFC12_per = ',RCFC12_per
    write(lunout,*)' cvl_comp_threshold=', cvl_comp_threshold
    write(lunout,*)' cvl_sig2feed=', cvl_sig2feed
    write(lunout,*)' cvl_corr=', cvl_corr
    write(lunout,*)'ok_lic_melt=', ok_lic_melt
    write(lunout,*)'cycle_diurne=',cycle_diurne
    write(lunout,*)'soil_model=',soil_model
    write(lunout,*)'new_oliq=',new_oliq
    write(lunout,*)'ok_orodr=',ok_orodr
    write(lunout,*)'ok_orolf=',ok_orolf
    write(lunout,*)'ok_limitvrai=',ok_limitvrai
    write(lunout,*)'nbapp_rad=',nbapp_rad
    write(lunout,*)'iflag_con=',iflag_con
    write(lunout,*)'iflag_ener_conserv=',iflag_ener_conserv
    write(lunout,*)'ok_conserv_q=',ok_conserv_q
    write(lunout,*)'iflag_fisrtilp_qsat=',iflag_fisrtilp_qsat
    write(lunout,*)'iflag_bergeron=',iflag_bergeron
    write(lunout,*)' epmax = ', epmax
    write(lunout,*)' coef_epmax_cape = ', coef_epmax_cape
    write(lunout,*)' ok_adj_ema = ', ok_adj_ema
    write(lunout,*)' iflag_clw = ', iflag_clw
    write(lunout,*)' cld_lc_lsc = ', cld_lc_lsc
    write(lunout,*)' cld_lc_con = ', cld_lc_con
    write(lunout,*)' cld_tau_lsc = ', cld_tau_lsc
    write(lunout,*)' cld_tau_con = ', cld_tau_con
    write(lunout,*)' ffallv_lsc = ', ffallv_lsc
    write(lunout,*)' ffallv_con = ', ffallv_con
    write(lunout,*)' coef_eva = ', coef_eva
    write(lunout,*)' reevap_ice = ', reevap_ice
    write(lunout,*)' iflag_pdf = ', iflag_pdf
    write(lunout,*)' iflag_cld_th = ', iflag_cld_th
    write(lunout,*)' iflag_cld_cv = ', iflag_cld_cv
    write(lunout,*)' tau_cld_cv = ', tau_cld_cv
    write(lunout,*)' coefw_cld_cv = ', coefw_cld_cv
    write(lunout,*)' iflag_radia = ', iflag_radia
    write(lunout,*)' iflag_rrtm = ', iflag_rrtm
    write(lunout,*)' NSW = ', NSW
    write(lunout,*)' iflag_albedo = ', iflag_albedo !albedo SB
    write(lunout,*)' ok_chlorophyll =',ok_chlorophyll ! albedo SB
    write(lunout,*)' iflag_ratqs = ', iflag_ratqs
    write(lunout,*)' seuil_inversion = ', seuil_inversion
    write(lunout,*)' fact_cldcon = ', fact_cldcon
    write(lunout,*)' facttemps = ', facttemps
    write(lunout,*)' ok_newmicro = ',ok_newmicro 
    write(lunout,*)' ratqsbas = ',ratqsbas 
    write(lunout,*)' ratqshaut = ',ratqshaut 
    write(lunout,*)' tau_ratqs = ',tau_ratqs 
    write(lunout,*)' top_height = ',top_height 
    write(lunout,*)' rad_froid = ',rad_froid
    write(lunout,*)' rad_chau1 = ',rad_chau1
    write(lunout,*)' rad_chau2 = ',rad_chau2
    write(lunout,*)' t_glace_min = ',t_glace_min
    write(lunout,*)' t_glace_max = ',t_glace_max
    write(lunout,*)' exposant_glace = ',exposant_glace
    write(lunout,*)' iflag_t_glace = ',iflag_t_glace
    write(lunout,*)' iflag_ice_thermo = ',iflag_ice_thermo
    write(lunout,*)' rei_min = ',rei_min
    write(lunout,*)' rei_max = ',rei_max
    write(lunout,*)' overlap = ',overlap 
    write(lunout,*)' cdmmax = ',cdmmax 
    write(lunout,*)' cdhmax = ',cdhmax 
    write(lunout,*)' ksta = ',ksta 
    write(lunout,*)' ksta_ter = ',ksta_ter 
    write(lunout,*)' f_ri_cd_min = ',f_ri_cd_min 
    write(lunout,*)' ok_kzmin = ',ok_kzmin 
    write(lunout,*)' fmagic = ',fmagic
    write(lunout,*)' pmagic = ',pmagic
    write(lunout,*)' ok_ade = ',ok_ade
    write(lunout,*)' ok_aie = ',ok_aie
    write(lunout,*)' aerosol_couple = ', aerosol_couple
    write(lunout,*)' flag_aerosol = ', flag_aerosol
    write(lunout,*)' flag_aerosol_strat = ', flag_aerosol_strat
    write(lunout,*)' new_aod = ', new_aod
    write(lunout,*)' aer_type = ',aer_type
    write(lunout,*)' bl95_b0 = ',bl95_b0
    write(lunout,*)' bl95_b1 = ',bl95_b1
    write(lunout,*)' lev_histhf = ',lev_histhf 
    write(lunout,*)' lev_histday = ',lev_histday 
    write(lunout,*)' lev_histmth = ',lev_histmth 
    write(lunout,*)' lev_histins = ',lev_histins
    write(lunout,*)' lev_histLES = ',lev_histLES
    write(lunout,*)' lev_histdayNMC = ',lev_histdayNMC
    write(lunout,*)' levout_histNMC = ',levout_histNMC
    write(lunout,*)' ok_histNMC = ',ok_histNMC
    write(lunout,*)' freq_outNMC = ',freq_outNMC
    write(lunout,*)' freq_calNMC = ',freq_calNMC
    write(lunout,*)' iflag_pbl = ', iflag_pbl
    write(lunout,*)' iflag_pbl_split = ', iflag_pbl_split
    write(lunout,*)' iflag_order2_sollw = ', iflag_order2_sollw
    write(lunout,*)' iflag_thermals = ', iflag_thermals
    write(lunout,*)' iflag_thermals_ed = ', iflag_thermals_ed
    write(lunout,*)' fact_thermals_ed_dz = ', fact_thermals_ed_dz
    write(lunout,*)' iflag_thermals_optflux = ', iflag_thermals_optflux
    write(lunout,*)' iflag_thermals_closure = ', iflag_thermals_closure
    write(lunout,*)' iflag_clos = ', iflag_clos
    write(lunout,*)' coef_clos_ls = ', coef_clos_ls
    write(lunout,*)' type_run = ',type_run 
    write(lunout,*)' ok_cosp = ',ok_cosp
    write(lunout,*)' ok_mensuelCOSP = ',ok_mensuelCOSP
    write(lunout,*)' ok_journeCOSP = ',ok_journeCOSP
    write(lunout,*)' ok_hfCOSP =',ok_hfCOSP
    write(lunout,*)' solarlong0 = ', solarlong0
    write(lunout,*)' qsol0 = ', qsol0
    write(lunout,*)' evap0 = ', evap0
    write(lunout,*)' albsno0 = ', albsno0
    write(lunout,*)' inertie_sol = ', inertie_sol
    write(lunout,*)' inertie_ice = ', inertie_ice
    write(lunout,*)' inertie_sno = ', inertie_sno
    write(lunout,*)' f_cdrag_ter = ',f_cdrag_ter
    write(lunout,*)' f_cdrag_oce = ',f_cdrag_oce
    write(lunout,*)' f_rugoro = ',f_rugoro
    write(lunout,*)' z0min = ',z0min
    write(lunout,*)' supcrit1 = ', supcrit1
    write(lunout,*)' supcrit2 = ', supcrit2
    write(lunout,*)' iflag_mix = ', iflag_mix
    write(lunout,*)' iflag_mix_adiab = ', iflag_mix_adiab
    write(lunout,*)' scut = ', scut
    write(lunout,*)' qqa1 = ', qqa1
    write(lunout,*)' qqa2 = ', qqa2
    write(lunout,*)' gammas = ', gammas
    write(lunout,*)' Fmax = ', Fmax
    write(lunout,*)' tmax_fonte_cv = ', tmax_fonte_cv
    write(lunout,*)' alphas = ', alphas
    write(lunout,*)' iflag_wake = ', iflag_wake
    write(lunout,*)' alp_offset = ', alp_offset
    ! nrlmd le 10/04/2012
    write(lunout,*)' iflag_trig_bl = ', iflag_trig_bl
    write(lunout,*)' s_trig = ', s_trig
    write(lunout,*)' tau_trig_shallow = ', tau_trig_shallow
    write(lunout,*)' tau_trig_deep = ', tau_trig_deep
    write(lunout,*)' iflag_clos_bl = ', iflag_clos_bl
    ! fin nrlmd le 10/04/2012

    write(lunout,*)' lonmin lonmax latmin latmax bilKP_ins =',&
         lonmin_ins, lonmax_ins, latmin_ins, latmax_ins
    write(lunout,*)' ecrit_ hf, ins, day, mth, reg, tra, ISCCP, LES',&
         ecrit_hf, ecrit_ins, ecrit_day, ecrit_mth, ecrit_reg, ecrit_tra, ecrit_ISCCP, ecrit_LES

    write(lunout,*) 'ok_strato = ', ok_strato
    write(lunout,*) 'ok_hines = ',  ok_hines
    write(lunout,*) 'ok_gwd_rando = ',  ok_gwd_rando
    write(lunout,*) 'ok_qch4 = ',  ok_qch4
    write(lunout,*) 'gwd_rando_ruwmax = ', gwd_rando_ruwmax
    write(lunout,*) 'gwd_rando_sat = ', gwd_rando_sat
    write(lunout,*) 'gwd_front_ruwmax = ', gwd_front_ruwmax
    write(lunout,*) 'gwd_front_sat = ', gwd_front_sat
    write(lunout,*) 'SSO gkdrag =',gkdrag
    write(lunout,*) 'SSO grahilo=',grahilo
    write(lunout,*) 'SSO grcrit=',grcrit
    write(lunout,*) 'SSO gfrcrit=',gfrcrit
    write(lunout,*) 'SSO gkwake=',gkwake
    write(lunout,*) 'SSO gklift=',gklift
    write(lunout,*) 'read_climoz = ', read_climoz
    write(lunout,*) 'carbon_cycle_tr = ', carbon_cycle_tr
    write(lunout,*) 'carbon_cycle_cpl = ', carbon_cycle_cpl

    !$OMP END MASTER

    return

  end subroutine conf_phys

end module conf_phys_m
!
!#################################################################
!

subroutine conf_interface(tau_calv)

  use IOIPSL
  USE print_control_mod, ONLY: lunout
  implicit none
  ! Configuration de l'interace atm/surf
  !
  ! tau_calv:    temps de relaxation pour la fonte des glaciers

  REAL          :: tau_calv
  REAL,SAVE     :: tau_calv_omp

  !
  !Config Key  = tau_calv
  !Config Desc = temps de relaxation pour fonte des glaciers en jours
  !Config Def  = 1 an 
  !Config Help = 
  !
  tau_calv_omp = 360.*10.
  !$OMP MASTER
  call getin('tau_calv',tau_calv_omp)
  !$OMP END MASTER
  !$OMP BARRIER

  tau_calv=tau_calv_omp

  !$OMP MASTER
  write(lunout,*)' ##############################################'
  WRITE(lunout,*)' Configuration de l''interface atm/surfaces  : '
  WRITE(lunout,*)' tau_calv = ',tau_calv
  !$OMP END MASTER

  return

end subroutine conf_interface
