!
! $Id: $
!
MODULE time_phylmdz_mod

    IMPLICIT NONE
    REAL,SAVE    :: pdtphys     ! physics time step (s)
!$OMP THREADPRIVATE(pdtphys)
    INTEGER,SAVE :: day_step_phy    ! number of physical steps per day
!$OMP THREADPRIVATE(day_step_phy)
    INTEGER,SAVE :: ndays       ! number of days to run
!$OMP THREADPRIVATE(ndays)
    INTEGER,SAVE :: annee_ref   ! reference year from the origin
!$OMP THREADPRIVATE(annee_ref)
    INTEGER,SAVE :: day_ref     ! reference year of the origin
!$OMP THREADPRIVATE(day_ref)
    INTEGER,SAVE :: day_ini     ! initial day of the run starting from 1st january of annee_ref
!$OMP THREADPRIVATE(day_ini)
    INTEGER,SAVE :: day_end     ! final day of the run starting from 1st january of annee_ref
!$OMP THREADPRIVATE(day_end)
    REAL,SAVE    :: start_time  ! starting time from the begining of the initial day
!$OMP THREADPRIVATE(start_time)
    INTEGER,SAVE :: raz_date
!$OMP THREADPRIVATE(raz_date)

    INTEGER,SAVE :: itau_phy     ! number of physiq iteration from origin
!$OMP THREADPRIVATE(itau_phy)
    INTEGER,SAVE :: itaufin      ! final iteration 
!$OMP THREADPRIVATE(itaufin)
    REAL,SAVE    :: current_time ! current elapsed time (s) from the begining of the run
!$OMP THREADPRIVATE(current_time)
    

CONTAINS

  SUBROUTINE init_time(annee_ref_, day_ref_, day_ini_, start_time_, &
                       ndays_, pdtphys_)
  USE ioipsl_getin_p_mod, ONLY : getin_p
  IMPLICIT NONE
  INCLUDE 'YOMCST.h'
    INTEGER, INTENT(IN) :: annee_ref_  
    INTEGER, INTENT(IN) :: day_ref_    
    INTEGER, INTENT(IN) :: day_ini_    
    REAL,    INTENT(IN) :: start_time_ 
    INTEGER, INTENT(IN) :: ndays_      
    REAL,    INTENT(IN) :: pdtphys_    
    
    annee_ref    = annee_ref_
    day_ref      = day_ref_
    day_ini      = day_ini_
    start_time   = start_time_
    ndays        = ndays_
    pdtphys      = pdtphys_
    
    ! Initialize module variable not inherited from dynamics
    day_step_phy = NINT(rday/pdtphys)
    day_end  = day_ini + ndays
  
    raz_date = 0
    CALL getin_p('raz_date', raz_date)

    current_time=0
    
!    CALL phys_cal_init(annee_ref,day_ref)
    
  END SUBROUTINE init_time

END MODULE time_phylmdz_mod      

