!
! $Header$
!
MODULE icefrac_lsc_mod

CONTAINS
!*******************************************************************

SUBROUTINE icefrac_lsc(np,temp, sig, tmin, tmax, nexpo,icefrac)
  IMPLICIT NONE
  !
  ! Compute the ice fraction 1-xliq (see e.g.
  ! Doutriaux-Boucher & Quaas 2004, section 2.2.)
  !
  ! (JBM 3/14)
  INTEGER :: np
  REAL, DIMENSION(np), INTENT(IN) :: temp ! temperature
  REAL, DIMENSION(np), INTENT(IN) :: sig
  REAL, DIMENSION(np), INTENT(OUT) :: icefrac

  REAL :: tmin ! if T < Tmin, the cloud is only made of water ice
  REAL :: tmax ! if T > Tmax, the cloud is only made of liquid water
  REAL :: nexpo ! controls the sharpness of the transition
  REAL :: sig0,www,tmin_tmp,icefrac_tmp
  INTEGER :: ip

  sig0=0.8

  DO ip=1,np
     www=(max(sig(ip)-sig0,0.))/(1.-sig0) ! w=1 at the surface and 0 for sig < sig0
     tmin_tmp=www*tmax+(1.-www)*tmin
     icefrac_tmp= 1.0 - (temp(ip)-tmin_tmp) / (tmax-tmin_tmp)
     icefrac_tmp = MIN(MAX(icefrac_tmp,0.0),1.0)
     icefrac(ip) = icefrac_tmp**nexpo
  ENDDO

  RETURN
END SUBROUTINE icefrac_lsc

!*******************************************************************
!
END MODULE icefrac_lsc_mod
