!
! $Id: readaerosolstrato_rrtm.F90 2073 2014-06-25 15:43:19Z fairhead $
!
subroutine readaerosolstrato_rrtm(debut)

    use netcdf95, only: nf95_close, nf95_gw_var, nf95_inq_dimid, & 
                        nf95_inq_varid, nf95_open
    use netcdf, only: nf90_get_var, nf90_noerr, nf90_nowrite

    USE phys_cal_mod, ONLY : mth_cur
    USE mod_grid_phy_lmdz
    USE mod_phys_lmdz_mpi_data, ONLY :  is_mpi_root
    USE mod_phys_lmdz_para 
    USE phys_state_var_mod
    USE phys_local_var_mod
    USE aero_mod
    USE dimphy

    implicit none

    include "dimensions.h"

! Variable input
    logical debut

! Variables locales
    integer n_lat   ! number of latitudes in the input data
    integer n_lon   ! number of longitudes in the input data
    integer n_lev   ! number of levels in the input data
    integer n_month ! number of months in the input data
    real, pointer:: latitude(:)
    real, pointer:: longitude(:)
    real, pointer:: time(:)
    real, pointer:: lev(:)
    integer k, band, wave
    integer, save :: mth_pre

    real, allocatable, dimension(:,:), save :: tau_aer_strat
!$OMP THREADPRIVATE(tau_aer_strat)

! Champs reconstitues
    real, allocatable:: tauaerstrat(:, :, :, :)
    real, allocatable:: tauaerstrat_mois(:, :, :)
    real, allocatable:: tauaerstrat_mois_glo(:, :)
    real, allocatable:: tauaerstrat_mois_glo_bands(:,:,:)

! For NetCDF:
    integer ncid_in  ! IDs for input files
    integer varid, ncerr

! Stratospheric aerosols optical properties
! alpha_strat over the 2 bands is normalised by the 550 nm extinction coefficient
! alpha_strat_wave is *not* normalised by the 550 nm extinction coefficient
    real, dimension(nbands_rrtm) :: alpha_strat, piz_strat, cg_strat
    data alpha_strat/0.938538969, 0.990073204, 0.992904723, 0.829215884, 0.439313501, 0.156857833/
    data cg_strat   /0.699142992, 0.716326416, 0.735462785, 0.736726701, 0.712068975, 0.575097859/
    data piz_strat  /1.000000000, 1.000000000, 1.000000000, 1.000000000, 0.997781098, 0.452584684/
    real, dimension(nwave) :: alpha_strat_wave
    data alpha_strat_wave/3.36780953,3.34667683,3.20444202,3.0293026,2.82108808/

!--------------------------------------------------------

    IF (.not.ALLOCATED(tau_aer_strat)) ALLOCATE(tau_aer_strat(klon,klev))

    IF (is_mpi_root) THEN

    IF (debut.OR.mth_cur.NE.mth_pre) THEN

    IF (nbands_rrtm.NE.6) THEN 
        print *,'nbands_rrtm doit etre egal a 6 dans readaerosolstrat_rrtm'
        STOP
    ENDIF

    CALL nf95_open("taustrat.nc", nf90_nowrite, ncid_in)

    CALL nf95_inq_varid(ncid_in, "LEV", varid)
    CALL nf95_gw_var(ncid_in, varid, lev)
    n_lev = size(lev)
    IF (n_lev.NE.klev) THEN 
       print *,'Le nombre de niveaux n est pas egal a klev'
       STOP
    ENDIF

    CALL nf95_inq_varid(ncid_in, "LAT", varid)
    CALL nf95_gw_var(ncid_in, varid, latitude)
    n_lat = size(latitude)
    print *, 'LAT aerosol strato=', n_lat, latitude
    IF (n_lat.NE.jjm+1) THEN 
       print *,'Le nombre de lat n est pas egal a jjm+1'
       STOP
    ENDIF

    CALL nf95_inq_varid(ncid_in, "LON", varid)
    CALL nf95_gw_var(ncid_in, varid, longitude)
    n_lon = size(longitude)
    print *, 'LON aerosol strato=', n_lon, longitude
    IF (n_lon.NE.iim) THEN 
       print *,'Le nombre de lon n est pas egal a iim'
       STOP
    ENDIF

    CALL nf95_inq_varid(ncid_in, "TIME", varid)
    CALL nf95_gw_var(ncid_in, varid, time)
    n_month = size(time)
    print *, 'TIME aerosol strato=', n_month, time
    IF (n_month.NE.12) THEN 
       print *,'Le nombre de month n est pas egal a 12'
       STOP
    ENDIF

    ALLOCATE(tauaerstrat(n_lon, n_lat, n_lev, n_month))
    ALLOCATE(tauaerstrat_mois(n_lon, n_lat, n_lev))
    ALLOCATE(tauaerstrat_mois_glo(klon_glo, n_lev))
    ALLOCATE(tauaerstrat_mois_glo_bands(klon_glo, n_lev,nbands_rrtm))

!--reading stratospheric AOD at 550 nm
    CALL nf95_inq_varid(ncid_in, "TAUSTRAT", varid)
    ncerr = nf90_get_var(ncid_in, varid, tauaerstrat)
    print *,'code erreur readaerosolstrato=', ncerr, varid

    CALL nf95_close(ncid_in)

!---select the correct month
    IF (mth_cur.LT.1.OR.mth_cur.GT.12) THEN
      print *,'probleme avec le mois dans readaerosolstrat =', mth_cur
    ENDIF
    tauaerstrat_mois(:,:,:) = tauaerstrat(:,:,:,mth_cur)

!---reduce to a klon_glo grid 
    CALL grid2dTo1d_glo(tauaerstrat_mois,tauaerstrat_mois_glo)

!--scatter on all proc
    CALL scatter(tauaerstrat_mois_glo,tau_aer_strat)

    DEALLOCATE(tauaerstrat)
    DEALLOCATE(tauaerstrat_mois)
    DEALLOCATE(tauaerstrat_mois_glo)
  
    mth_pre=mth_cur

    ENDIF !--debut ou nouveau mois

    ENDIF !--is_mpi_root

!--total vertical aod at the 5 wavelengths
    DO wave=1, nwave
    DO k=1, klev
    tausum_aero(:,wave,id_strat)=tausum_aero(:,wave,id_strat)+tau_aer_strat(:,k)*alpha_strat_wave(wave)/alpha_strat_wave(2)
    ENDDO
    ENDDO

!--weighted average for cg, piz and tau, adding strat aerosols on top of tropospheric ones
    DO band=1, nbands_rrtm
!--anthropogenic aerosols bands 1 to nbands_rrtm 
    cg_aero_rrtm(:,:,2,band)  = ( cg_aero_rrtm(:,:,2,band)*piz_aero_rrtm(:,:,2,band)*tau_aero_rrtm(:,:,2,band) + &
                                  cg_strat(band)*piz_strat(band)*alpha_strat(band)*tau_aer_strat(:,:) ) /        &
                             MAX( piz_aero_rrtm(:,:,2,band)*tau_aero_rrtm(:,:,2,band) +                          &
                                  piz_strat(band)*alpha_strat(band)*tau_aer_strat(:,:), 1.e-15 )
    piz_aero_rrtm(:,:,2,band)  = ( piz_aero_rrtm(:,:,2,band)*tau_aero_rrtm(:,:,2,band) +                         &
                              piz_strat(band)*alpha_strat(band)*tau_aer_strat(:,:) ) /                           &
                              MAX( tau_aero_rrtm(:,:,2,band) + alpha_strat(band)*tau_aer_strat(:,:), 1.e-15 )
    tau_aero_rrtm(:,:,2,band)  = tau_aero_rrtm(:,:,2,band) + alpha_strat(band)*tau_aer_strat(:,:)
!--natural aerosols bands 1 to nbands_rrtm
    cg_aero_rrtm(:,:,1,band)  = ( cg_aero_rrtm(:,:,1,band)*piz_aero_rrtm(:,:,1,band)*tau_aero_rrtm(:,:,1,band) + &
                             cg_strat(band)*piz_strat(band)*alpha_strat(band)*tau_aer_strat(:,:) ) /             &
                             MAX( piz_aero_rrtm(:,:,1,band)*tau_aero_rrtm(:,:,1,band) +                          &
                                  piz_strat(band)*alpha_strat(band)*tau_aer_strat(:,:), 1.e-15 )
    piz_aero_rrtm(:,:,1,band)  = ( piz_aero_rrtm(:,:,1,band)*tau_aero_rrtm(:,:,1,band) +                         & 
                              piz_strat(band)*alpha_strat(band)*tau_aer_strat(:,:) ) /                           &
                              MAX( tau_aero_rrtm(:,:,1,band) + alpha_strat(band)*tau_aer_strat(:,:),1.e-15 )
    tau_aero_rrtm(:,:,1,band)  = tau_aero_rrtm(:,:,1,band) + alpha_strat(band)*tau_aer_strat(:,:)
    ENDDO

end subroutine readaerosolstrato_rrtm
