#!/bin/ksh

###############################################################################
# Script for installing a 1D version of LMDZ.
# LMDZ team. For questions : lmdz-svp@lmd.jussieu.fr
# valid for svn version from 21/12/2012 (end of the world) or svn 1700
#
# 1) Modifies the directory LMDZ.../modipsl/modeles/LMDZ5/libf/phy1d
# which  contains the single column version of the model.
# 2) installs a series of test cases on LMDZ.../1dcases/
# 3) compile the lmdz1.F with vertical resolution L39 and L40
# 4) runs a subset of the cases
###############################################################################

PATH=~/bin:$PATH

armcu=1
toga=1
twpice=1

# Check in ~lmdz/WWW/DistribG95 which 1d version to use
version1d=20140122
modele=""
if [ "$modele" = "" ] ; then
   if [ -f install.sh ] ; then
      version=`sed -n "s/^version=//p" install.sh | tail -1`
      echo $version
      modele=`pwd`/LMDZ${version}
   elif [ -d modipsl ] ; then
      modele=`pwd`
   else
      echo "You should run instal1d.sh either in the directory"
      echo "containing install.sh, or in that containing modipsl"
      echo "or specify the path of LMDZ. modele=LMDZ... in instal1d.sh"
      exit
   fi
fi

###############################################################################
# Paths of main directories
# Directories of simulations will be placed in
# $modele/1dcases
# Sources of physical routines in  $modele/modipsl/modeles/LMDZ5/libf/phy1d
###############################################################################
cd $modele
LMDGCM=`pwd`
LMDlibf=$LMDGCM/modipsl/modeles/LMDZ5/libf/

###############################################################################
# Check if the svn version is more recent than 1700
# If not, an  older script must be used
###############################################################################
cd $LMDGCM/modipsl/modeles
new1d=`svn info LMDZ5 | grep Revision | awk ' { fl = 0 ; if ( $2 > 1699 )  fl=1 ; print fl } '`
echo new1d $new1d
if [ $new1d = 0 ] ; then
   echo Your model verison is too old for this instal1d.sh script
   echo You should use instead
   echo http://www.lmd.jussieu.fr/~lmdz/Distrib/install_old_archive/instal1d.sh
   exit
fi

###############################################################################
# Downloading modified source files and input files
###############################################################################
cd $LMDGCM
interne=no # can be modified once the files have been downloaded
           # in order to take them directly on your computer
if [ $interne = no ] ; then
   wget http://www.lmd.jussieu.fr/~lmdz/DistribG95/lmdz1d_source_${version1d}.tar.gz
   tar xvfz lmdz1d_source_${version1d}.tar.gz
   rm -f lmdz1d_source_${version1d}.tar.gz
   source=${LMDGCM}/lmdz1d_source_${version1d}
else
   cp -a /home/jygz/LMDZ/SLMDZ/LMDZ5_source_20120112/lmdz1d_source_20120112 .
   source=${LMDGCM}/lmdz1d_source_20120112
fi

################################################################################
# Creating directory for 1d cases
################################################################################
if [ -d 1dcases ] ; then
  echo '1dcases existe deja'
  echo 'on continue'
else
  echo 'creation du directory 1dcases'
  mkdir 1dcases
fi
cd 1dcases

for cas in amma arm_cu ayotte case_e eq_rd_cv fire hapex92_init rico toga sanduref sandufast sanduslow twpice ; do
   if [ -d $cas ] ; then
      echo $cas existe deja
      echo 'on continue, mais il  faudra verifier qu il ne manque rien dans '$cas
   else
      echo 'creation du directory de simulation '$cas
      cp -a ${source}/$cas .
   fi
   dir $cas
done



################################################################################
# Installing source files and compiling
################################################################################
cd $LMDlibf
chmod +x ../tools/install_1d_src.sh 
../tools/install_1d_src.sh 

##   Nettoyage
\rm -r ${source}
#
cd ${LMDlibf}/..
\rm -f makefile
./makelmdz -d 39 -p 1d lmdz1d
if [ -f lmdz1d.e ] ; then
   mv lmdz1d.e lmdz1d_L39.e
 echo Compilation successfull
 for cas in amma ayotte case_e eq_rd_cv fire hapex92_init rico toga sanduref sandufast sanduslow twpice ; do
    rm -f ${LMDGCM}/1dcases/$cas/lmdz1d.e
    ln -s `pwd`/lmdz1d_L39.e ${LMDGCM}/1dcases/$cas/lmdz1d.e
 done
else
 echo Compilation aborted
 exit
fi

echo '#########################################################################'
echo '   1D test cases'
echo '#########################################################################'

if [ $toga = 1 ] ; then
echo ====================================
echo TEST CASE : toga' (1 month)'
echo ====================================
echo if the last line \"SIMULATION FINISHED\" is \"Everything is cool!\", the situation went to its end
cd ${LMDGCM}/1dcases/toga
./xqt.x NPv3.1
\rm tmp.jnl ; touch tmp.jnl
rm -f var.gif
cat <<eod>> tmp.jnl
use histhf_NPv3.1.nc
shade/title="cas toga: cloud fraction (-)" rneb
frame/file=var.gif
eod
ferret <<eod
go tmp.jnl
quit
eod
display var.gif :&
rm -f tmp.jnl
rm -f var.gif
cd ..
fi

if [ $twpice = 1 ] ; then
echo ====================================
echo TEST CASE : twpice
echo ====================================
echo if the last line \"SIMULATION FINISHED\" is \"Everything is cool!\", the situation went to its end
cd twpice
./xqt.x NPv3.1
\rm tmp.jnl ; touch tmp.jnl
rm -f var.gif
cat <<eod>> tmp.jnl
use histhf_NPv3.1.nc
shade/title="cas twpice: cloud fraction (-)" rneb
frame/file=var.gif
eod
ferret <<eod
go tmp.jnl
quit
eod
display -remote var.gif :&
rm -f tmp.jnl
rm -f var.gif
cd ..
fi

if [ $armcu = 1 ] ; then
echo ====================================
echo TEST CASE : arm_cu
echo ====================================
echo if the last line \"SIMULATION FINISHED\" is \"Everything is cool!\", the situation went to its end
cd arm_cu
./compile.x
ln -s lmdz1d.e lmdz1d_L40.e 
./xqt.x NPv3.1
\rm tmp.jnl ; touch tmp.jnl
rm -f var.gif
cat <<eod>> tmp.jnl
use histhf_NPv3.1.nc
shade/title="cas arm_cu: cloud fraction (-)" rneb
frame/file=var.gif
eod
ferret <<eod
go tmp.jnl
quit
eod
display -remote var.gif :&
rm -f tmp.jnl
rm -f var.gif
cd ..
fi

