MODULE YOESW

USE PARKIND1  ,ONLY : JPIM     ,JPRB

IMPLICIT NONE

SAVE

!     ------------------------------------------------------------------
!*    ** *YOESW* - COEFFICIENTS FOR SHORTWAVE RADIATION TRANSFER
!     ------------------------------------------------------------------

REAL(KIND=JPRB) :: APAD(6,3,7)
REAL(KIND=JPRB) :: BPAD(6,3,7)
REAL(KIND=JPRB) :: RRAY(6,6)
REAL(KIND=JPRB), ALLOCATABLE :: RSUN(:)
REAL(KIND=JPRB) :: RPDH1
REAL(KIND=JPRB) :: RPDU1
REAL(KIND=JPRB) :: RPNH
REAL(KIND=JPRB) :: RPNU
REAL(KIND=JPRB) :: RSWCE(6)
REAL(KIND=JPRB) :: RSWCP(6)
REAL(KIND=JPRB) :: RTDH2O
REAL(KIND=JPRB) :: RTDUMG
REAL(KIND=JPRB) :: RTH2O
REAL(KIND=JPRB) :: RTUMG
REAL(KIND=JPRB) :: D(6,3)
REAL(KIND=JPRB) :: REXPO3(6,2,7)
INTEGER(KIND=JPIM) :: NEXPO3(6)

REAL(KIND=JPRB) :: RYFWCA(6)
REAL(KIND=JPRB) :: RYFWCB(6)
REAL(KIND=JPRB) :: RYFWCC(6)
REAL(KIND=JPRB) :: RYFWCD(6)
REAL(KIND=JPRB) :: RYFWCE(6)
REAL(KIND=JPRB) :: RYFWCF(6)

REAL(KIND=JPRB) :: REBCUA(6)
REAL(KIND=JPRB) :: REBCUB(6)
REAL(KIND=JPRB) :: REBCUC(6)
REAL(KIND=JPRB) :: REBCUD(6)
REAL(KIND=JPRB) :: REBCUE(6)
REAL(KIND=JPRB) :: REBCUF(6)
REAL(KIND=JPRB) :: REBCUG(16)
REAL(KIND=JPRB) :: REBCUH(16)
REAL(KIND=JPRB) :: REBCUI(6)
REAL(KIND=JPRB) :: REBCUJ(6)

REAL(KIND=JPRB) :: RASWCA(6)
REAL(KIND=JPRB) :: RASWCB(6)
REAL(KIND=JPRB) :: RASWCC(6)
REAL(KIND=JPRB) :: RASWCD(6)
REAL(KIND=JPRB) :: RASWCE(6)
REAL(KIND=JPRB) :: RASWCF(6)

REAL(KIND=JPRB) :: RFUETA(16,3),RFUETB(16,4), RFUETC(16,4)
REAL(KIND=JPRB) :: RFULIO(16,3)
REAL(KIND=JPRB) :: RHSAVI(16,3)
REAL(KIND=JPRB) :: RLILIA(16,5),RLILIB(16,4)

REAL(KIND=JPRB) :: RFLAA0(6)
REAL(KIND=JPRB) :: RFLAA1(6)
REAL(KIND=JPRB) :: RFLBB0(6)
REAL(KIND=JPRB) :: RFLBB1(6)
REAL(KIND=JPRB) :: RFLBB2(6)
REAL(KIND=JPRB) :: RFLBB3(6)
REAL(KIND=JPRB) :: RFLCC0(6)
REAL(KIND=JPRB) :: RFLCC1(6)
REAL(KIND=JPRB) :: RFLCC2(6)
REAL(KIND=JPRB) :: RFLCC3(6)

REAL(KIND=JPRB) :: RFUAA0(6)
REAL(KIND=JPRB) :: RFUAA1(6)
REAL(KIND=JPRB) :: RFUBB0(6)
REAL(KIND=JPRB) :: RFUBB1(6)
REAL(KIND=JPRB) :: RFUBB2(6)
REAL(KIND=JPRB) :: RFUBB3(6)
REAL(KIND=JPRB) :: RFUCC0(6)
REAL(KIND=JPRB) :: RFUCC1(6)
REAL(KIND=JPRB) :: RFUCC2(6)
REAL(KIND=JPRB) :: RFUCC3(6)
REAL(KIND=JPRB) :: RFLDD0(6)
REAL(KIND=JPRB) :: RFLDD1(6)
REAL(KIND=JPRB) :: RFLDD2(6)
REAL(KIND=JPRB) :: RFLDD3(6)

REAL(KIND=JPRB) :: RSUSHE(6)
REAL(KIND=JPRB) :: RSUSHF(6)
REAL(KIND=JPRB) :: RSUSHH(6)
REAL(KIND=JPRB) :: RSUSHK(6)
REAL(KIND=JPRB) :: RSUSHA(6)
REAL(KIND=JPRB) :: RSUSHG(6)
REAL(KIND=JPRB) :: RSUSHFA(4)
REAL(KIND=JPRB) :: RSUSHC
REAL(KIND=JPRB) :: RSUSHD

REAL(KIND=JPRB) :: REFFIA
REAL(KIND=JPRB) :: REFFIB
REAL(KIND=JPRB) :: RTIW
REAL(KIND=JPRB) :: RRIW
REAL(KIND=JPRB) :: RROMA(6)
REAL(KIND=JPRB) :: RROMB(6)
REAL(KIND=JPRB) :: RRASY(6)

REAL(KIND=JPRB) :: RHSRA(6)
REAL(KIND=JPRB) :: RHSRB(6)
REAL(KIND=JPRB) :: RHSRC(6)
REAL(KIND=JPRB) :: RHSRD(6)
REAL(KIND=JPRB) :: RHSRE(6)
REAL(KIND=JPRB) :: RHSRF(6)
REAL(KIND=JPRB) :: RHSRTA
REAL(KIND=JPRB) :: RHSRTB

REAL(KIND=JPRB) :: RTAUA(6,6)
REAL(KIND=JPRB) :: RPIZA(6,6)
REAL(KIND=JPRB) :: RCGA(6,6)
REAL(KIND=JPRB) :: RAER(6,6)

REAL(KIND=JPRB) :: RTWEIGHT(8)
REAL(KIND=JPRB) :: RWEIGS(6)
REAL(KIND=JPRB) :: RWEIGV(6)

REAL(KIND=JPRB) :: RWEIGHT(6,8)
INTEGER(KIND=JPIM) :: NMPSRTM(14), NTYPS

REAL(KIND=JPRB) :: RADJUST

!        * E.C.M.W.F. PHYSICS PACKAGE *

!     J.-J. MORCRETTE       E.C.M.W.F.      89/07/14

!  NAME     TYPE     PURPOSE
!  ----  :  ----   : ---------------------------------------------------
!  APAD  :  REAL     PADE APPROXIMANTS NUMERATOR
!  BPAD  :  REAL     PADE APPROXIMANTS DENOMINATOR
!  D     :  REAL     TRANSMISSION LIMIT FOR INFINITE ABSORBER AMOUNT
!  RRAY  :  REAL     RAYLEIGH SCATTERING COEFFICIENTS
!  RSUN  :  REAL     SOLAR FRACTION IN SPECTRAL INTERVALS
!  RPDH1 :  1 + EXPONENT PRESSURE DEPENDENCE H2O
!  RPDU1 :  1 + EXPONENT PRESSURE DEPENDENCE UNIFORMLY MIXED GASES
!  RPNH  :  REFERENCE PRESSURE FACTOR FOR H2O
!  RPNU  :  REFERENCE PRESSURE FACTOR FOR UNIFORMLY MIXED GASES
!  RSWCE :  E-TYPE, H2O CONTINUUM ABSORPTION COEFFICIENT 
!  RSWCP :  P-TYPE, H2O CONTINUUM ABSORPTION COEFFICIENT 
!  RTDH2O:  EXPONENT TEMPERATURE DEPENDENCE H2O
!  RTDUMG:  EXPONENT TEMPERATURE DEPENDENCE UNIFORMLY MIXED GASES
!  RTH2O :  REFERENCE TEMPERATURE H2O
!  RTUMG :  REFERENCE TEMPERATURE UNIFORMLY MIXED GASES
!     -----------------------------------------------------------------

!        * E.C.M.W.F. PHYSICS PACKAGE *

!     J.-J. MORCRETTE       E.C.M.W.F.      89/07/14

!  NAME     TYPE     PURPOSE
!  ----  :  ----   : ---------------------------------------------------
!*    FOUQUART (1987) WATER CLOUD OPTICAL PROPERTIES

! RYFWCA :  REAL   : C1 IN OPTICAL THICKNESS FORMULA
! RYFWCB :  REAL   : C2 IN OPTICAL THICKNESS FORMULA
! RYFWCC :  REAL   : SINGLE SCATTERING ALBEDO PARAMETER
! RYFWCD :  REAL   : SINGLE SCATTERING ALBEDO PARAMETER
! RYFWCE :  REAL   : SINGLE SCATTERING ALBEDO PARAMETER
! RYFWCF :  REAL   : ASSYMETRY FACTOR

!*    SLINGO (1989) WATER CLOUD OPTICAL PROPERTIES

! RASWCA :  REAL   : C1 IN OPTICAL THICKNESS FORMULA
! RASWCB :  REAL   : C2 IN OPTICAL THICKNESS FORMULA
! RASWCC :  REAL   : SINGLE SCATTERING ALBEDO PARAMETER
! RASWCD :  REAL   : SINGLE SCATTERING ALBEDO PARAMETER
! RASWCE :  REAL   : SINGLE SCATTERING ALBEDO PARAMETER
! RASWCF :  REAL   : ASSYMETRY FACTOR

!*   SAVIJARVI (1998) WATER CLOUD OPTICAL PROPERTIES (RRTM)

! RHSAVI : REAL    : MASS ABSORPTION COEFFICIENTS (POLYNOMIAL DEVELOPM)

!*   LINDNER,LI (2000) WATER CLOUD OPTICAL PROPERTIES (RRTM)

! RLILIA : REAL    : MASS ABSORPTION COEFFICIENTS (POLYNOMIAL DEVELOPM)
! RLILIB : REAL    : 1-SSA COEFFICIENTS  (POLYNOMIAL DEVELOPM)

!*    ICE CLOUD OPTICAL PROPERTIES DERIVED FROM EBERT-CURRY (1992)

! REBCUA :  REAL   : C1 IN OPTICAL THICKNESS FORMULA
! REBCUB :  REAL   : C2 IN OPTICAL THICKNESS FORMULA
! REBCUC :  REAL   : 1-C3  IN SINGLE SCATTERING ALBEDO FORMULA
! REBCUD :  REAL   : C4 IN SINGLE SCATTERING ALBEDO FORMULA
! REBCUE :  REAL   : C5 IN ASSYMETRY FACTOR FORMULA
! REBCUF :  REAL   : C6 IN ASSYMETRY FACTOR FORMULA
! REBCUG :  REAL   : C7 IN MASS ABSORPTION COEFFICIENT FORMULA
! REBCUH :  REAL   : C8 IN MASS ABSORPTION COEFFICIENT FORMULA
! REBCUI :  REAL   : C7 IN MASS ABSORPTION COEFFICIENT SPECTRAL FORMULA
! REBCUJ :  REAL   : C8 IN MASS ABSORPTION COEFFICIENT SPECTRAL FORMULA

!*    ICE CLOUD OPTICAL PROPERTIES DERIVED FROM SUN-SHINE (1995)

! RSHSUE :  REAL   : E IN SINGLE SCATTERING ALBEDO FORMULA
! RSHSUF :  REAL   : F IN SINGLE SCATTERING ALBEDO FORMULA
! RSHSUH :  REAL   : H IN ASSYMETRY FACTOR FORMULA
! RSHSUK :  REAL   : K IN ASSYMETRY FACTOR FORMULA
! RSHSUA :  REAL   : ALPHA IN SSA CORRECTION FACTOR FORMULA
! RSHSUG :  REAL   : GAMMA IN ASSYMETRY CORRECTION FACTOR FORMULA
! RSHSUFA:  REAL   : COEFFICIENTS IN TEMPERATURE CORRECTION FACTOR

! REFFIA :  REAL   : C9  IN EFFECTIVE RADIUS FORMULA
! REFFIB :  REAL   : C10 IN EFFECTIVE RADIUS FORMULA

!*    ICE CLOUD OPTICAL PROPERTIES DERIVED FROM FU-LIOU (1993)

! RFULIO :  REAL   : COEFFICIENTS IN EXPRESSION FOR LW EXTINCTION COEFF.
! RFLAA  :  REAL   : COEFFICIENTS IN EXPRESSION FOR SW EXTINCTION COEFF.
! RFLBB  :  REAL   : COEFFICIENTS IN EXPRESSION FOR SW SINGLE SCATT.ALB.
! RFLCC  :  REAL   : COEFFICIENTS IN EXPRESSION FOR SW ASSYMETRY FACTOR
! RFLDD  :  REAL   : COEFFICIENTS IN EXPRESSION FOR SW ASSYMETRY FACTOR

!*    ICE CLOUD OPTICAL PROPERTIES DERIVED FROM FU (1996) & FU ET AL. (1998)

! RFUETA :  REAL   : COEFFICIENTS IN EXPRESSION FOR LW EXTINCTION COEFF.
! RFUAA  :  REAL   : COEFFICIENTS IN EXPRESSION FOR SW EXTINCTION COEFF.
! RFUBB  :  REAL   : COEFFICIENTS IN EXPRESSION FOR SW SINGLE SCATT.ALB.
! RFUCC  :  REAL   : COEFFICIENTS IN EXPRESSION FOR SW ASSYMETRY FACTOR

!*    TRANSITION BETWEEN LIQUID AND SOLID WATER

! RTIW   :  REAL   : TEMPERATURE THRESHOLD
! RRIW   :  REAL   : TRANSITION RANGE

!*    RAIN OPTICAL PROPERTIES FROM SAVIJARVI (1996)

! RROMA  :  REAL   : COEFFICIENTS FOR SINGLE SCATTERING ALBEDO
! RROMB  :  REAL   : COEFFICIENTS FOR SINGLE SCATTERING ALBEDO
! RRASY  :  REAL   : COEFFICIENTS FOR ASSYMETRY FACTOR
! RHSRA  :  REAL   : COEFFICIENTS FOR OPTICAL THICKNESS
! RHSRB  :  REAL   : COEFFICIENTS FOR OPTICAL THICKNESS
! RHSRC  :  REAL   : COEFFICIENTS FOR SINGLE SCATTERING ALBEDO
! RHSRD  :  REAL   : COEFFICIENTS FOR SINGLE SCATTERING ALBEDO
! RHSRE  :  REAL   : COEFFICIENTS FOR ASSYMETRY FACTOR 
! RHSRF  :  REAL   : COEFFICIENTS FOR ASSYMETRY FACTOR
! RHSRTA :  REAL   : COEFFICIENTS FOR OPTICAL THICKNESS
! RHSRTB :  REAL   : COEFFICIENTS FOR OPTICAL THICKNESS
!     -----------------------------------------------------------------

!        * E.C.M.W.F. PHYSICS PACKAGE *

!     J.-J. MORCRETTE       E.C.M.W.F.      89/07/14

!  NAME     TYPE     PURPOSE
!  ----  :  ----   : -------
!  RTAUA :  REAL     S.W. NORMALIZED OPTICAL THICKNESS AT 0.55 MICRON
!  RPIZA :  REAL     S.W. SINGLE SCATTERING ALBEDO
!  RCGA  :  REAL     S.W. ASSYMETRY FACTOR
!  RAER  :  REAL     L.W. ABSORPTION COEFFICIENTS
!     -----------------------------------------------------------------

!        * E.C.M.W.F. PHYSICS PACKAGE *

!     J.-J. MORCRETTE       E.C.M.W.F.      89/07/14

!  NAME     TYPE     PURPOSE
!  ----  :  ----   : -------
!RTWEIGHT:  REAL     S.W. INTEGRATED WEIGHT 
! NMPSRTM: INTEGER  : Indices for mapping SW[1:6] albedo into SRTM[1:14]  
!     -----------------------------------------------------------------
!$OMP THREADPRIVATE(apad,bpad,d,nexpo3,nmpsrtm,ntyps,radjust,raer,raswca)
!$OMP THREADPRIVATE(raswcb,raswcc,raswcd,raswce,raswcf,rcga,rebcua,rebcub)
!$OMP THREADPRIVATE(rebcuc,rebcud,rebcue,rebcuf,rebcug,rebcuh,rebcui,rebcuj)
!$OMP THREADPRIVATE(reffia,reffib,rexpo3,rflaa0,rflaa1,rflbb0,rflbb1,rflbb2)
!$OMP THREADPRIVATE(rflbb3,rflcc0,rflcc1,rflcc2,rflcc3,rfldd0,rfldd1,rfldd2)
!$OMP THREADPRIVATE(rfldd3,rfuaa0,rfuaa1,rfubb0,rfubb1,rfubb2,rfubb3,rfucc0)
!$OMP THREADPRIVATE(rfucc1,rfucc2,rfucc3,rfueta,rfuetb,rfuetc,rfulio,rhsavi)
!$OMP THREADPRIVATE(rhsra,rhsrb,rhsrc,rhsrd,rhsre,rhsrf,rhsrta,rhsrtb,rlilia)
!$OMP THREADPRIVATE(rlilib,rpdh1,rpdu1,rpiza,rpnh,rpnu,rrasy,rray,rriw,rroma)
!$OMP THREADPRIVATE(rromb,rsusha,rsushc,rsushd,rsushe,rsushf,rsushfa,rsushg)
!$OMP THREADPRIVATE(rsushh,rsushk,rswce,rswcp,rtaua,rtdh2o,rtdumg,rth2o,rtiw)
!$OMP THREADPRIVATE(rtumg,rtweight,rweight,rweigs,rweigv,ryfwca,ryfwcb,ryfwcc,ryfwcd,ryfwce,ryfwcf)
END MODULE YOESW
