      SUBROUTINE radiornpb(tr,dtime,tautr,d_tr) 
      IMPLICIT none
c======================================================================
c Auteur(s): AA + CG (LGGE/CNRS) Date 24-06-94
c Objet: Decroissance radioactive d'un traceur dans l'atmosphere
CG240694 : Pour un traceur, le radon
CG161294 : Plus un 2eme traceur, le 210Pb. Le radon decroit en plomb.
c======================================================================
c Arguments:
c======================================================================
#include "dimensions.h"
#include "dimphy.h"
c======================================================================
C
      INTEGER i , k , it
      REAL tr(klon,klev,nbtr) , d_tr(klon,klev,nbtr)
      REAL dtime
      REAL tautr(nbtr)
C
      WRITE(*,'(''PASSAGE radiornpb ... '',$)')
C Attention, pour un pas de temps beaucoup plus petit que la decroissance!!!

      DO it = 1,2
           IF ( tautr(it) .GT. 0. ) THEN
          	DO k = 1,klev
                DO i = 1,klon
                d_tr(i,k,it) = - tr(i,k,it) * dtime / tautr(it)
                END DO
                END DO
           ELSE
                DO k = 1,klev
                DO i = 1,klon
                d_tr(i,k,it) = 0.
                END DO
                END DO
           END IF
      END DO
C
CG161294 : Cas particulier radon 1 => plomb 2
c
      DO k = 1,klev
        DO i = 1,klon
          d_tr(i,k,2) = d_tr(i,k,2) - d_tr(i,k,1)
        ENDDO
      ENDDO
c
      WRITE(*,*) ' radiornpb OK'
c
      RETURN
      END
