       SUBROUTINE fyhyp ( yzoomdeg, grossism, dzoom,tau,deltay ,  
     ,  rrlatu,yyprimu,rrlatv,yyprimv,rlatu2,yprimu2,rlatu1,yprimu1 ) 


       IMPLICIT NONE
c
c    ...   Auteur :  P. Le Van  ... 
c
c    .......    d'apres  formulations  de R. Sadourny  .......
c
c     Calcule les latitudes et derivees dans la grille du GCM pour une
c     fonction f(y) a tangente  hyperbolique  .
c
c     grossism etant le grossissement ( = 2 si 2 fois, = 3 si 3 fois , etc)
c     dzoom  etant  la distance totale de la zone du zoom
c     tau  la transition ,   normalement  = 1  .

c  N.B :  on doit avoir :  grossism * dzoom  <   1 .
c         **************
c
c    Pour Indoex , on a pris :
c         *******
c    grossism = 2.5 , dzoom = 7/24  en x et  y  , pour iim = 128 et jjm=64
c    yzoomdeg = 0.  , tau = 1.  et delaty = 10.
c
c
#include "dimensions.h"
#include "paramet.h"

       INTEGER      nmax , nmax2
       PARAMETER (  nmax = 50000, nmax2 = 2*nmax )
c
c
c     .......  arguments  d'entree    .......
c
       REAL yzoomdeg, grossism,dzoom,tau , deltay

c     .......  arguments  de sortie   .......
c
       REAL rrlatu(jjp1), yyprimu(jjp1),rrlatv(jjm), yyprimv(jjm),
     , rlatu1(jjm), yprimu1(jjm), rlatu2(jjm), yprimu2(jjm)

c
c    ..... Champs  locaux    .....
c
     
       REAl ylat(jjp1), yprim(jjp1)
       REAL yuv
       REAL ytild(0:nmax2)
       REAL fhyp(0:nmax),ffdx(0:nmax),beta,Ytprim(0:nmax2)
       SAVE Ytprim, ytild,Yf
       REAL Yf(0:nmax2),yypr(0:nmax2)
       REAL yvrai(jjp1), yprimm(jjp1),ylatt(jjp1)
       REAL pi,depi,pis2,epsilon,yzoom
       REAL yo1,yi,ylon2,fxm,ymoy,yint,Yprimin
       REAL ypn,deply,y00
       SAVE y00, deply

       INTEGER i,j,it,ik,iter,jlat
       INTEGER jpn,jjpn
       SAVE jpn


       pi       = 2. * ASIN(1.)
       depi     = 2. * pi
       pis2     = pi/2.
       epsilon  = 1.e-6
       yzoom    = yzoomdeg * pi/180. 



       DO i = 0, nmax2 
        ytild(i) = FLOAT(i) /nmax2
       IF( ytild(i).EQ.0.5 )  ytild(i) = ytild(i) + 1.e-6
       ENDDO

       DO i = 1, nmax
        fhyp(i) = TANH ( ( ytild(i) - 0.5*(1.- dzoom) )          /
     ,                 ( tau * ytild(i) * ( 0.5 -ytild(i))) )
       ENDDO

       fhyp(   0  ) = - 1.
       fhyp( nmax ) =   1.

cc  ....  Calcul  de  beta  ....
c
       ffdx( 0 ) = 0.

       DO i = 1, nmax
        ymoy    = 0.5 * ( ytild(i-1) + ytild( i ) )
        fxm     = TANH ( ( ymoy - 0.5 * ( 1. - dzoom ) )    /
     ,                 ( tau * ymoy * ( 0.5 -ymoy)) )
        ffdx(i) = ffdx(i-1) + fxm * ( ytild(i) - ytild(i-1) )
       ENDDO

        beta  = ( grossism * ffdx(nmax) - 0.5 ) / ( ffdx(nmax) - 0.5 )
c
c   .....  calcul  de  Ytprim   .....
c
       
       DO i = 0, nmax
        Ytprim(i) = beta  + ( grossism - beta ) * fhyp(i)
       ENDDO
c   
       DO i = 0, nmax
        Ytprim( nmax2 - i ) = Ytprim( i )
       ENDDO
c

c   .....  Calcul  de  Yf     ........

        Yf(0) = 0.
       DO i = 1, nmax
        ymoy    = 0.5 * ( ytild(i-1) + ytild( i ) )
        fxm     = TANH ( ( ymoy - 0.5 * ( 1. - dzoom ) )    /
     ,                 ( tau * ymoy * ( 0.5 -ymoy)) )
        yypr(i)    = beta + ( grossism - beta ) * fxm
       ENDDO

       DO i = 1,nmax
         yypr(nmax2-i+1) = yypr(i)
       ENDDO

        DO i=1,nmax2
         Yf(i)   = Yf(i-1) + yypr(i) * ( ytild(i) - ytild(i-1) )
        ENDDO
c
c

c    ****************************************************************
c
c   .....   yuv  = 0.   si calcul des latitudes  aux pts.  U  .....
c   .....   yuv  = 0.5  si calcul des latitudes  aux pts.  V  .....
c
c
      DO 5000  ik = 1,4

       IF( ik.EQ.1 )  THEN
         yuv  = 0.
         jlat = jjm + 1
       ELSE IF ( ik.EQ.2 )  THEN
         yuv  = 0.5
         jlat = jjm 
       ELSE IF ( ik.EQ.3 )  THEN
         yuv  = 0.25
         jlat = jjm 
       ELSE IF ( ik.EQ.4 )  THEN
         yuv  = 0.75
         jlat = jjm 
       ENDIF
        
c
       DO 1500 j =  1,jlat

        ylon2 =  ( FLOAT(j)  + yuv  -1.) / FLOAT(jjm) 

        yo1   = 0.
        yi    = ylon2

c
       DO 500 iter = 1,300

       DO 250 it =  nmax2,0,-1
        IF( yi.GE.ytild(it))  GO TO 350
250    CONTINUE

       it = 0
       yi = ytild(it)

350    CONTINUE

       IF(it.EQ.nmax2)  THEN
        it       = nmax2 -1
        Yf(it+1) = 1.
       ENDIF
c  .................................................................
c  ....  Interpolation entre  yi(it) et yi(it+1)   pour avoir Y(yi)  
c      .....           et   Y'(yi)                             .....
c  .................................................................

       yint   = ( Yf(it+1)-Yf(it) ) / ( ytild(it+1)-ytild(it) )      * 
     +                    ( yi-ytild(it) )  +  Yf(it)
      Yprimin = ( Ytprim(it+1)-Ytprim(it) )/ ( ytild(it+1)-ytild(it) ) *
     +                    ( yi-ytild(it) )  +  Ytprim(it)
       yi = yi - (yint-ylon2)/Yprimin

      IF( ABS(yi-yo1).LE.epsilon) GO TO 550
      yo1 = yi
c
500   CONTINUE
      PRINT *,' ***   PAS DE SOLUTION  ****  ',j,ylon2,iter
        STOP 4
550   CONTINUE

       yprim(j)    = pi /( FLOAT(jjm) *  Yprimin)
       yvrai(j)    = pi *  (yi - 0.5) + yzoom

1500    CONTINUE

cc          print *,' LAT avant reorgan '
cc         print 68,(yyvrai(j),j=1,jlat)

       DO j = 1, jlat -1
        IF( yvrai(j+1). LT. yvrai(j) )  THEN
         PRINT *,' PBS.  avec  rlat(',j+1,' plus petit que rlat(',j,
     ,   ')'
         STOP
        ENDIF
       ENDDO

        PRINT 18
        PRINT *,'Reorganisation des latitudes pour avoir entre - pi/2 ',
     ,  ' et  pi/2 '
c
           
        IF( ik.EQ.1 )   THEN
           ypn = pis2 - deltay * pi/180.
          DO j = jlat,1,-1
           IF( yvrai(j).LE. ypn ) GO TO 1502
          ENDDO
1502     CONTINUE

         jpn   = j
         y00   = yvrai(jpn)
         deply = pis2 -  y00
        ENDIF

         DO  j = 1, jjm +1 - jpn
           ylatt (j)  = -pis2 - y00  + yvrai(jpn+j-1)
           yprimm(j)  = yprim(jpn+j-1)
         ENDDO

         jjpn  = jpn
         IF( jlat.EQ. jjm ) jjpn = jpn -1

         DO j = 1,jjpn 
          ylatt (j + jjm+1 -jpn) = yvrai(j) + deply
          yprimm(j + jjm+1 -jpn) = yprim(j)
         ENDDO



c      ***********   Fin de la reorganisation     *************
c
 1600   CONTINUE



       DO j = 1, jlat
          ylat(j) =  ylatt( jlat +1 -j )
         yprim(j) = yprimm( jlat +1 -j )
       ENDDO
  
        DO j = 1, jlat
         yvrai(j) = ylat(j)*180./pi
        ENDDO


        IF( ik.EQ.1 )  THEN
        PRINT 18
        PRINT *, ' YLAT  en U   apres ( en  deg. ) '
        PRINT 68,(yvrai(j),j=1,jlat)
        PRINT *,' YPRIM '
        PRINT 68,( yprim(j),j=1,jlat)
          DO j = 1, jlat
            rrlatu(j) =  ylat( j )
           yyprimu(j) = yprim( j )
          ENDDO
c
        ELSE IF ( ik.EQ. 2 )  THEN
        PRINT 18
        PRINT *, ' YLAT   en V  apres ( en  deg. ) '
        PRINT 68,(yvrai(j),j=1,jlat)
        PRINT *,' YPRIM '
        PRINT 68,( yprim(j),j=1,jlat)
          DO j = 1, jlat
            rrlatv(j) =  ylat( j )
           yyprimv(j) = yprim( j )
          ENDDO
c
        ELSE IF ( ik.EQ. 3 )  THEN
        PRINT 18
        PRINT *, ' YLAT  en U + 0.75  apres ( en  deg. ) '
        PRINT 68,(yvrai(j),j=1,jlat)
        PRINT *,' YPRIM '
        PRINT 68,( yprim(j),j=1,jlat)
          DO j = 1, jlat
            rlatu2(j) =  ylat( j )
           yprimu2(j) = yprim( j )
          ENDDO

        ELSE IF ( ik.EQ. 4 )  THEN
        PRINT 18
        PRINT *, ' YLAT en U + 0.25  apres ( en  deg. ) '
        PRINT 68,(yvrai(j),j=1,jlat)
        PRINT *,' YPRIM '
        PRINT 68,( yprim(j),j=1,jlat)
          DO j = 1, jlat
            rlatu1(j) =  ylat( j )
           yprimu1(j) = yprim( j )
          ENDDO
        ENDIF

5000   CONTINUE
c
c  .....     fin de la boucle  do 5000 .....

18      FORMAT(/)
68      FORMAT(1x,7f9.2)

        RETURN
        END
