       SUBROUTINE fxhyp ( xzoomdeg,grossism,dzoom,tau ,
     , rlonm025,xprimm025,rlonv,xprimv,rlonu,xprimu,rlonp025,xprimp025)

c      Auteur :  P. Le Van 

       IMPLICIT NONE

c    Calcule les longitudes et derivees dans la grille du GCM pour une
c     fonction f(x) a tangente  hyperbolique  .
c
c     grossism etant le grossissement ( = 2 si 2 fois, = 3 si 3 fois,etc.)
c     dzoom  etant  la distance totale de la zone du zoom
c     tau  la transition ,   normalement  = 1  .
c

       INTEGER nmax, nmax2
       PARAMETER (  nmax = 50000, nmax2 = 2*nmax )

#include "dimensions.h"
#include "paramet.h"
       
c     ......  arguments  d'entree   .......
c
       REAL xzoomdeg,dzoom,tau,grossism
       REAL rlonm025(iip1),xprimm025(iip1),rlonv(iip1),xprimv(iip1),
     ,  rlonu(iip1),xprimu(iip1),rlonp025(iip1),xprimp025(iip1)

c    ......   arguments  de  sortie  ......
c
       REAL xlon(iip1),xprimm(iip1),xuv
       REAL xtild(0:nmax2)
       REAL fhyp(0:nmax),ffdx(0:nmax),beta,Xprimt(0:nmax2)
       REAL Xf(0:nmax2),xxpr(0:nmax2)
       REAL xvrai(iip1),xxprim(iip1) 
       REAL pi,depi,epsilon,xzoom
       INTEGER i,it,ik,iter,ii,idif
       REAL xi,xo1,xint,xmoy,xlon2,fxm,Xprimin
       REAL champmin,champmax
       INTEGER is2
       SAVE is2
       REAL dlon1(iip1),dlon2(iip1),dlon3(iip1)

       pi       = 2. * ASIN(1.)
       depi     = 2. * pi
       epsilon  = 1.e-6
       xzoom    = xzoomdeg * pi/180. 



       DO i = 0, nmax2 
         xtild(i) = FLOAT(i) /nmax2
        IF( xtild(i).EQ. 0.5 )  xtild(i) = xtild(i) + 1.e-6
       ENDDO

       DO i = 1, nmax
        fhyp(i) = TANH ( ( xtild(i) - 0.5*(1.- dzoom) )          /
     ,                 ( tau * xtild(i) * ( 0.5 -xtild(i))) )
       ENDDO

        fhyp(   0  ) = - 1.
        fhyp( nmax ) =   1.

cc  ....  Calcul  de  beta  ....
c
       ffdx( 0 ) = 0.

       DO i = 1, nmax
        xmoy    = 0.5 * ( xtild(i-1) + xtild( i ) )
        fxm     = TANH ( ( xmoy - 0.5 * ( 1. - dzoom ) )    /
     ,                 ( tau * xmoy * ( 0.5 -xmoy)) )
        ffdx(i) = ffdx(i-1) + fxm * ( xtild(i) - xtild(i-1) )
       ENDDO

        beta  = ( grossism * ffdx(nmax) - 0.5 ) / ( ffdx(nmax) - 0.5 )
c
c   .....  calcul  de  Xprimt   .....
c
       
       DO i = 0, nmax
        Xprimt(i) = beta  + ( grossism - beta ) * fhyp(i)
       ENDDO
c   
       DO i = 0, nmax
        Xprimt( nmax2 - i ) = Xprimt( i )
       ENDDO
c

c   .....  Calcul  de  Xf     ........

        Xf(0) = 0.
       DO i = 1, nmax
        xmoy    = 0.5 * ( xtild(i-1) + xtild( i ) )
        fxm     = TANH ( ( xmoy - 0.5 * ( 1. - dzoom ) )    /
     ,                 ( tau * xmoy * ( 0.5 -xmoy)) )
        xxpr(i)    = beta + ( grossism - beta ) * fxm
       ENDDO

       DO i = 1,nmax
         xxpr(nmax2-i+1) = xxpr(i)
       ENDDO

        DO i=1,nmax2
         Xf(i)   = Xf(i-1) + xxpr(i) * ( xtild(i) - xtild(i-1) )
        ENDDO
        do i=1,nmax2
        xf(i)=xf(i)/xf(nmax2)
        enddo


       PRINT *,' XF ',xf(0),xf(nmax),xf(nmax2)


c    *****************************************************************
c

c     .....  xuv = 0.   si  calcul  aux pts   scalaires   ........
c     .....  xuv = 0.5  si  calcul  aux pts      U        ........
c
c
      DO 5000  ik = 1, 4

       IF( ik.EQ.1 )        THEN
         xuv = - 0.25
       ELSE IF ( ik.EQ.2 )  THEN
         xuv =   0.
       ELSE IF ( ik.EQ.3 )  THEN
         xuv =   0.5
       ELSE IF ( ik.EQ.4 )  THEN
         xuv =   0.25
       ENDIF


      DO 1500 i = 1, iim

      xlon2 = (  FLOAT(i) + xuv - 0.75) / FLOAT(iim) 

      xo1   = 0.
      xi    = xlon2
c
      DO 500 iter = 1,300

      DO 250 it =  nmax2,0,-1
      IF( xi.GE.xtild(it))  GO TO 350
250   CONTINUE

      it = 0
      xi = xtild(it)

350   CONTINUE
       IF(it.EQ.nmax2)  THEN
        it       = nmax2 -1
        xf(it+1) = 1.
       ENDIF
c  .................................................................
c  ....  Interpolation entre  xi(it) et xi(it+1)   pour avoir X(xi)  
c      .....           et   X'(xi)                             .....
c  .................................................................

       xint   = ( Xf(it+1)-Xf(it) ) / ( xtild(it+1)-xtild(it) )      * 
     +                    ( xi-xtild(it) )  +  Xf(it)
      Xprimin = ( Xprimt(it+1)-Xprimt(it) )/ ( xtild(it+1)-xtild(it) ) *
     +                    ( xi-xtild(it) )  +  Xprimt(it)

       xi = xi - (xint-xlon2)/Xprimin

      IF( ABS(xi-xo1).LE.epsilon) GO TO 550
      xo1 = xi
c
500   CONTINUE
      PRINT *,' ***   PAS DE SOLUTION  ****  ',i,xlon2
        STOP 4
550   CONTINUE

       xxprim(i)   = depi/( FLOAT(iim) * Xprimin)
       xvrai(i)    = depi *  (xi - 0.5) + xzoom


1500   CONTINUE

       DO i = 1 , iim
        xlon  (i)   = xvrai(i)
        xprimm(i)   = xxprim(i)
cc        xxlon(i) = xlon(i)*180./pi
       ENDDO
        
cc      PRINT *,' XLON avant '
cc      PRINT 68,(xxlon(i),i=1,iim)
       
       DO i = 1, iim -1
        IF( xvrai(i+1). LT. xvrai(i) )  THEN
         PRINT *,' PBS.  avec  rlonu(',i+1,' plus petit que rlonu(',i,
     ,   ')'
         STOP
        ENDIF
       ENDDO
c
c   ... Reorganisation  des  longitudes  pour les avoir  entre - pi et pi ..
c   ........................................................................

       champmin =  1.e12
       champmax = -1.e12
       DO i = 1, iim
        champmin = MIN( champmin,xvrai(i) )
        champmax = MAX( champmax,xvrai(i) )
       ENDDO

       PRINT *,' LONGITUDES  min max ',champmin,champmax

      IF(champmin .GE. - pi .AND. champmax.LE. pi )  THEN
                GO TO 1600
      ELSE
        PRINT 18
        PRINT *,'Reorganisation des longitudes pour avoir entre - pi ',
     ,  ' et  pi '
c
        IF( xzoom.LE.0.)  THEN
          IF( ik.EQ. 1 )  THEN
          DO i = 1, iim
           IF( xvrai(i).GE. - pi )  GO TO 80
          ENDDO
            PRINT *, ' PBS. 1 '
            STOP
 80       CONTINUE
          is2 = i
          ENDIF

          IF( is2.NE. 1 )  THEN
            DO ii = is2 , iim
             xlon  (ii-is2+1) = xvrai(ii)
             xprimm(ii-is2+1) = xxprim(ii)
            ENDDO
            DO ii = 1 , is2 -1
             xlon  (ii+iim-is2+1) = xvrai(ii) + depi
             xprimm(ii+iim-is2+1) = xxprim(ii) 
            ENDDO
          ENDIF
        ELSE 
          IF( ik.EQ.1 )  THEN
           DO i = iim,1,-1
            IF( xvrai(i).LE. pi )  GO TO 90
           ENDDO
             PRINT *,' PBS.  2 '
              STOP
 90        CONTINUE
            is2 = i
          ENDIF
cc           PRINT *,' IS2 ',is2
           idif = iim -is2
           DO ii = 1, is2
            xlon  (ii+idif) = xvrai(ii)
            xprimm(ii+idif) = xxprim(ii)
           ENDDO
           DO ii = 1, idif
            xlon (ii)  = xvrai (ii+is2) - depi
            xprimm(ii) = xxprim(ii+is2) 
           ENDDO
         ENDIF
      ENDIF
c
c     .........   Fin  de la reorganisation   ............................

 1600    CONTINUE


         xlon  ( iip1)  = xlon(1) + depi
         xprimm( iip1 ) = xprimm (1 )
       
         DO i = 1, iim+1
         xvrai(i) = xlon(i)*180./pi
         ENDDO


         IF( ik.EQ.1 )  THEN
         PRINT *, ' XLON aux pts. V-0.25   apres ( en  deg. ) '
         PRINT 18
         PRINT 68,xvrai
         PRINT *,' XPRIM '
         PRINT 68, xprimm
           DO i = 1,iim + 1
             rlonm025(i) = xlon( i )
            xprimm025(i) = xprimm(i)
           ENDDO
         ELSE IF( ik.EQ.2 )  THEN
         PRINT 18
         PRINT *, ' XLON aux pts. V   apres ( en  deg. ) '
         PRINT 68,xvrai
         PRINT *,' XPRIM '
         PRINT 68, xprimm
           DO i = 1,iim + 1
             rlonv(i) = xlon( i )
            xprimv(i) = xprimm(i)
           ENDDO
         ELSE IF( ik.EQ.3 )  THEN
         PRINT 18
         PRINT *, ' XLON aux pts. U   apres ( en  deg. ) '
         PRINT 68,xvrai
         PRINT *,' XPRIM '
         PRINT 68, xprimm
           DO i = 1,iim + 1
             rlonu(i) = xlon( i )
            xprimu(i) = xprimm(i)
           ENDDO
         ELSE IF( ik.EQ.4 )  THEN
         PRINT 18
         PRINT *, ' XLON aux pts. V+0.25   apres ( en  deg. ) '
         PRINT 68,xvrai
         PRINT *,' XPRIM '
         PRINT 68, xprimm
           DO i = 1,iim + 1
             rlonp025(i) = xlon( i )
            xprimp025(i) = xprimm(i)
           ENDDO
         ENDIF

5000    CONTINUE
c
c       ...........  fin  de la boucle  do 5000      ............

c
        DO i = 1, iim + 1
         dlon1(i) = rlonm025(i) - rlonv(i)
         dlon2(i) = rlonm025(i) - rlonp025(i)
         dlon3(i) = rlonm025(i) - rlonu(i)
        ENDDO

        DO i = 1, iim + 1
         rlonm025(i) = rlonm025(i) + dlon1(i)
        ENDDO

        DO i = 1, iim + 1
         rlonv(i)    = rlonm025(i) - dlon1(i)
         rlonp025(i) = rlonm025(i) - dlon2(i)
         rlonu(i)    = rlonm025(i) - dlon3(i)
        ENDDO

        DO i = 1, iim
         xprimu   (i) = rlonu(i+1) - rlonu(i)
         xprimv   (i) = rlonv(i+1) - rlonv(i)
         xprimm025(i) = rlonm025(i+1) - rlonm025(i)
         xprimp025(i) = rlonp025(i+1) - rlonp025(i)
        ENDDO
         xprimu   (iip1) = xprimu   (1)
         xprimv   (iip1) = xprimv   (1)
         xprimm025(iip1) = xprimm025(1)
         xprimp025(iip1) = xprimp025(1)


18       FORMAT(/)
68       FORMAT(1x,7f9.2)


         RETURN
         END
