SUBROUTINE add_pbl_tend(zdu, zdv, zdt, zdq, zdql, paprs, text)
  ! ======================================================================
  ! Ajoute les tendances de couche limite, soit determinees par la
  ! parametrisation
  ! physique, soit forcees,  aux variables d etat de la dynamique t_seri,
  ! q_seri ...
  ! ======================================================================


  ! ======================================================================
  ! Declarations
  ! ======================================================================

  USE dimphy
  USE phys_local_var_mod
  USE phys_state_var_mod
  IMPLICIT NONE
  include "dimensions.h"
  REAL hthturb_gcssold(llm)
  REAL hqturb_gcssold(llm)
  REAL dtime_frcg
  LOGICAL turb_fcg_gcssold
  COMMON /turb_forcing/dtime_frcg, hthturb_gcssold, hqturb_gcssold, &
    turb_fcg_gcssold

  ! Arguments :
  ! ------------
  REAL zdu(klon, klev), zdv(klon, klev)
  REAL zdt(klon, klev), zdq(klon, klev), zdql(klon, klev)
  CHARACTER *(*) text
  REAL paprs(klon,klev+1)

  ! Local :
  ! --------
  REAL zzdt(klon, klev), zzdq(klon, klev)
  INTEGER i, k

  IF (turb_fcg_gcssold) THEN
    DO k = 1, klev
      DO i = 1, klon
        zzdt(i, k) = hthturb_gcssold(k)*dtime_frcg
        zzdq(i, k) = hqturb_gcssold(k)*dtime_frcg
      END DO
    END DO
    PRINT *, ' add_pbl_tend, dtime_frcg ', dtime_frcg
    PRINT *, ' add_pbl_tend, zzdt ', zzdt
    PRINT *, ' add_pbl_tend, zzdq ', zzdq
    CALL add_phys_tend(zdu, zdv, zzdt, zzdq, zdql, paprs, text)
  ELSE
    CALL add_phys_tend(zdu, zdv, zdt, zdq, zdql, paprs, text)
  END IF


  RETURN
END SUBROUTINE add_pbl_tend
